/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.API.CrystalElementProxy;
import Reika.ChromatiCraft.API.Interfaces.CastingRecipeViewer;
import Reika.ChromatiCraft.Auxiliary.Interfaces.CoreRecipe;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Special.ConfigRecipe;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Magic.RuneShape;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityItemStand;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Instantiable.Recipe.RecipePattern;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class CastingRecipe
implements CastingRecipeViewer.APICastingRecipe {
    private final ItemStack out;
    public final RecipeType type;
    private IRecipe recipe;
    private ChromaResearch fragment;

    protected CastingRecipe(ItemStack out, IRecipe recipe) {
        this(out, RecipeType.CRAFTING, recipe);
    }

    @Override
    public final int getTier() {
        return this.type.ordinal();
    }

    private CastingRecipe(ItemStack out, RecipeType type, IRecipe recipe) {
        this.out = out;
        this.type = type;
        this.recipe = recipe;
    }

    public final void setFragment(ChromaResearch r) {
        if (r != this.fragment) {
            if (this.fragment == null) {
                this.fragment = r;
            } else {
                throw new IllegalStateException("Cannot change the research type of a recipe once initialized!");
            }
        }
    }

    public final ChromaResearch getFragment() {
        return this.fragment;
    }

    @Override
    public final ItemStack getOutput() {
        return ReikaItemHelper.getSizedItemStack((ItemStack)this.out, (int)Math.max(this.out.field_77994_a, this.getNumberProduced()));
    }

    protected int getNumberProduced() {
        return 1;
    }

    public void onRecipeTick(TileEntityCastingTable te) {
    }

    public ChromaSounds getSoundOverride(TileEntityCastingTable te, int craftSoundTimer) {
        return null;
    }

    @Override
    public int getExperience() {
        return this.type.experience;
    }

    @Override
    public int getDuration() {
        return 5;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack[] getArrayForDisplay() {
        return ReikaRecipeHelper.getPermutedRecipeArray((IRecipe)this.recipe);
    }

    protected final List<ItemStack>[] getRecipeArray() {
        return ReikaRecipeHelper.getRecipeArray((IRecipe)this.recipe);
    }

    public ItemStack[] getBasicRecipeArray() {
        List<ItemStack>[] lia = this.getRecipeArray();
        ItemStack[] out = new ItemStack[9];
        for (int i = 0; i < lia.length; ++i) {
            List<ItemStack> li = lia[i];
            out[i] = li.get(0).func_77946_l();
            if (out[i].func_77960_j() != Short.MAX_VALUE) continue;
            out[i].func_77964_b(0);
        }
        return out;
    }

    public Object[] getInputArray() {
        return ReikaRecipeHelper.getInputArrayCopy((IRecipe)this.recipe);
    }

    @Override
    public boolean usesItem(ItemStack is) {
        return ReikaItemHelper.listContainsItemStack((Collection)ReikaRecipeHelper.getAllItemsInRecipe((IRecipe)this.recipe), (ItemStack)is, (boolean)true);
    }

    public boolean crafts(ItemStack is) {
        return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.out) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)this.out);
    }

    protected static final ItemStack getShard(CrystalElement e) {
        return ChromaItems.SHARD.getStackOfMetadata(e.ordinal());
    }

    protected static final ItemStack getChargedShard(CrystalElement e) {
        return ChromaItems.SHARD.getStackOfMetadata(e.ordinal() + 16);
    }

    public boolean match(TileEntityCastingTable table) {
        if (this.recipe == null) {
            return true;
        }
        ItemStack[] items = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            items[i] = table.func_70301_a(i);
        }
        RecipePattern ic = new RecipePattern(items);
        return this.recipe.func_77569_a((InventoryCrafting)ic, null);
    }

    protected void getRequiredProgress(Collection<ProgressionManager.ProgressStage> c) {
        c.add(ProgressionManager.ProgressStage.CRYSTALS);
    }

    @Override
    public boolean canRunRecipe(EntityPlayer ep) {
        if (this.fragment != null && !ChromaResearchManager.instance.playerHasFragment(ep, this.fragment)) {
            return false;
        }
        ArrayList<ProgressionManager.ProgressStage> c = new ArrayList<ProgressionManager.ProgressStage>();
        this.getRequiredProgress(c);
        for (ProgressionManager.ProgressStage p : c) {
            if (p.isPlayerAtStage(ep)) continue;
            return false;
        }
        return true;
    }

    public void onCrafted(TileEntityCastingTable te, EntityPlayer ep, int amount) {
        ChromaResearchManager.instance.givePlayerRecipe(ep, this);
        te.giveRecipe(ep, this);
        ep.func_71023_q(this.getExperience() * amount / 4);
    }

    public String toString() {
        return super.toString() + " _ " + (Object)((Object)this.type) + " > " + this.out.func_82833_r();
    }

    @SideOnly(value=Side.CLIENT)
    public ItemHashMap<Integer> getItemCounts() {
        ItemHashMap map = new ItemHashMap();
        ItemStack[] items = this.getArrayForDisplay();
        for (int i = 0; i < 9; ++i) {
            ItemStack is = items[i];
            if (is == null) continue;
            Integer num = (Integer)map.get(is);
            int n = num != null ? num : 0;
            map.put(is, (Object)(n + 1));
        }
        return map;
    }

    public ElementTagCompound getInputElements() {
        ElementTagCompound tag = new ElementTagCompound();
        tag.addButMinimizeWith(ItemElementCalculator.instance.getIRecipeTotal(this.recipe));
        return tag;
    }

    public boolean isIndexed() {
        return true;
    }

    public Collection<ItemStack> getAllInputs() {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        List<ItemStack>[] o = this.getRecipeArray();
        for (int i = 0; i < 9; ++i) {
            if (o[i] == null) continue;
            c.addAll(o[i]);
        }
        return c;
    }

    @Override
    public int getTypicalCraftedAmount() {
        return this instanceof CoreRecipe ? Integer.MAX_VALUE : 1;
    }

    public int getPenaltyThreshold() {
        return this instanceof CoreRecipe ? Integer.MAX_VALUE : Math.max(1, this.getTypicalCraftedAmount() * 3 / 4);
    }

    public float getPenaltyMultiplier() {
        return 0.75f;
    }

    public final int getIDCode() {
        int flag = this.getClass().getName().hashCode();
        flag ^= this.out.func_77973_b().getClass().getName().hashCode();
        flag ^= Math.max(this.out.field_77994_a, this.getNumberProduced());
        flag ^= this.out.func_77960_j();
        return flag ^= this.out.field_77990_d != null ? this.out.field_77990_d.hashCode() : 0;
    }

    @Override
    public NBTTagCompound getOutputTag(NBTTagCompound input) {
        return null;
    }

    public NBTTagCompound handleNBTResult(TileEntityCastingTable te, EntityPlayer ep, NBTTagCompound tag) {
        return tag;
    }

    public ItemStack getCentralLeftover(ItemStack is) {
        return null;
    }

    public float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
        return 1.0f;
    }

    public int getEnhancedTableAccelerationFactor() {
        return 4;
    }

    public boolean canBeStacked() {
        return true;
    }

    public final float getRecipeStackedTimeFactor(TileEntityCastingTable te, int stack) {
        float f = this.getConsecutiveStackingTimeFactor(te);
        double t = 0.0;
        for (int i = 0; i < stack; ++i) {
            t += Math.pow(f, i);
        }
        return (float)t;
    }

    protected float getConsecutiveStackingTimeFactor(TileEntityCastingTable te) {
        return 0.9375f;
    }

    public static class RecipeNameComparator
    implements Comparator<CastingRecipe> {
        @Override
        public int compare(CastingRecipe o1, CastingRecipe o2) {
            return o1.getOutput().func_82833_r().compareToIgnoreCase(o2.getOutput().func_82833_r());
        }
    }

    public static class RecipeComparator
    implements Comparator<CastingRecipe> {
        @Override
        public int compare(CastingRecipe o1, CastingRecipe o2) {
            return this.getIndex(o1) - this.getIndex(o2);
        }

        private int getIndex(CastingRecipe r) {
            int flags = 0;
            if (r.fragment != null) {
                flags += 10000000 * r.fragment.sectionIndex();
                flags += 1000000 * ((CastingRecipe)r).fragment.level.ordinal();
                flags += 10000 * r.fragment.ordinal();
            }
            flags += 1000 * r.type.ordinal();
            flags += 100 * r.getOutput().func_77960_j();
            return flags += 1 * r.getNumberProduced();
        }
    }

    public static enum RecipeType {
        CRAFTING(5, 250),
        TEMPLE(40, 2000),
        MULTIBLOCK(200, 15000),
        PYLON(500, Integer.MAX_VALUE);

        public final int experience;
        public final int levelUp;
        public static final RecipeType[] typeList;

        private RecipeType(int xp, int lvl) {
            this.experience = xp;
            this.levelUp = lvl;
        }

        public int getRequiredXP() {
            return this == CRAFTING ? 0 : RecipeType.typeList[this.ordinal() - 1].levelUp;
        }

        public RecipeType next() {
            return this == PYLON ? this : typeList[this.ordinal() + 1];
        }

        public boolean isAtLeast(RecipeType r) {
            return this.ordinal() >= r.ordinal();
        }

        public boolean isMoreThan(RecipeType r) {
            return this.ordinal() > r.ordinal();
        }

        static {
            typeList = RecipeType.values();
        }
    }

    public static class PylonCastingRecipe
    extends MultiBlockCastingRecipe
    implements CastingRecipeViewer.LumenRecipe {
        private final ElementTagCompound elements = new ElementTagCompound();

        public PylonCastingRecipe(ItemStack out, ItemStack main) {
            super(out, main, RecipeType.PYLON);
        }

        public ElementTagCompound getRequiredAura() {
            return this.elements.copy();
        }

        protected CastingRecipe addAuraRequirement(CrystalElementProxy e, int amt) {
            return this.addAuraRequirement(CrystalElement.getFromAPI(e), amt);
        }

        protected CastingRecipe addAuraRequirement(CrystalElement e, int amt) {
            this.elements.addValueToColor(e, amt);
            return this;
        }

        protected CastingRecipe addAuraRequirement(ElementTagCompound e) {
            this.elements.add(e);
            return this;
        }

        @Override
        public boolean match(TileEntityCastingTable table) {
            return super.match(table);
        }

        @Override
        public int getDuration() {
            return 400;
        }

        @Override
        protected void getRequiredProgress(Collection<ProgressionManager.ProgressStage> c) {
            super.getRequiredProgress(c);
            c.add(ProgressionManager.ProgressStage.PYLON);
            c.add(ProgressionManager.ProgressStage.REPEATER);
        }

        @Override
        public ElementTagCompound getInputElements() {
            ElementTagCompound tag = super.getInputElements();
            for (CrystalElement e : this.elements.elementSet()) {
                tag.addValueToColor(e, Math.max(2, this.elements.getValue(e) / 10000));
            }
            return tag;
        }

        @Override
        public int getEnergyCost(CrystalElementProxy e) {
            return this.elements.getValue(CrystalElement.getFromAPI(e));
        }

        @Override
        public boolean canBeStacked() {
            return false;
        }
    }

    public static class MultiBlockCastingRecipe
    extends TempleCastingRecipe
    implements CastingRecipeViewer.MultiRecipe {
        private final HashMap<List<Integer>, ItemMatch> inputs = new HashMap();
        private final ItemStack main;

        public MultiBlockCastingRecipe(ItemStack out, ItemStack main) {
            this(out, main, RecipeType.MULTIBLOCK);
        }

        private MultiBlockCastingRecipe(ItemStack out, ItemStack main, RecipeType type) {
            super(out, type, null);
            this.main = main;
        }

        @Override
        public final ItemStack getMainInput() {
            return this.main.func_77946_l();
        }

        protected final MultiBlockCastingRecipe addAuxItem(Block b, int dx, int dz) {
            return this.addAuxItem(new ItemStack(b), dx, dz);
        }

        protected final MultiBlockCastingRecipe addAuxItem(Item i, int dx, int dz) {
            return this.addAuxItem(new ItemStack(i), dx, dz);
        }

        protected final MultiBlockCastingRecipe addAuxItem(ItemStack is, int dx, int dz) {
            return this.addAuxItem(new ItemMatch(is), dx, dz);
        }

        protected final MultiBlockCastingRecipe addAuxItem(Fluid f, int dx, int dz) {
            return this.addAuxItem(new ItemMatch(f), dx, dz);
        }

        protected final MultiBlockCastingRecipe addAuxItem(String s, int dx, int dz) {
            return this.addAuxItem(new ItemMatch(s), dx, dz);
        }

        private MultiBlockCastingRecipe addAuxItem(ItemMatch is, int dx, int dz) {
            if (dx == 0 && dz == 0) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Tried adding an item to the center of a recipe " + this + ": " + is);
            }
            this.inputs.put(Arrays.asList(dx, dz), is);
            return this;
        }

        public Map<List<Integer>, ItemMatch> getAuxItems() {
            return Collections.unmodifiableMap(this.inputs);
        }

        @Override
        public final Map<List<Integer>, Set<KeyedItemStack>> getInputItems() {
            HashMap<List<Integer>, Set<KeyedItemStack>> map = new HashMap<List<Integer>, Set<KeyedItemStack>>();
            for (List<Integer> li : this.inputs.keySet()) {
                map.put(li, this.inputs.get(li).getItemList());
            }
            return map;
        }

        public HashMap<WorldLocation, ItemMatch> getOtherInputs(World world, int x, int y, int z) {
            HashMap<WorldLocation, ItemMatch> map = new HashMap<WorldLocation, ItemMatch>();
            for (List<Integer> li : this.inputs.keySet()) {
                ItemMatch is = this.inputs.get(li).copy();
                int dx = li.get(0);
                int dz = li.get(1);
                int dy = y + (Math.abs(dx) != 4 && Math.abs(dz) != 4 ? 0 : 1);
                WorldLocation loc = new WorldLocation(world, x + dx, dy, z + dz);
                map.put(loc, is);
            }
            return map;
        }

        @Override
        public boolean match(TileEntityCastingTable table) {
            ItemStack main = table.func_70301_a(4);
            for (int i = 0; i < 9; ++i) {
                if (i == 4 || table.func_70301_a(i) == null) continue;
                return false;
            }
            ItemStack ctr = this.getMainInput();
            if (ReikaItemHelper.matchStacks((ItemStack)main, (ItemStack)ctr) && this.isValidCentralNBT(main)) {
                HashMap<List<Integer>, TileEntityItemStand> stands = table.getOtherStands();
                if (stands.size() != 24) {
                    return false;
                }
                for (List<Integer> key : stands.keySet()) {
                    ItemStack at = stands.get(key).func_70301_a(0);
                    ItemMatch is = this.inputs.get(key);
                    if (is == null && at != null) {
                        return false;
                    }
                    if (is == null || is.match(at)) continue;
                    return false;
                }
                if (this.matchRunes(table.field_145850_b, table.field_145851_c, table.field_145848_d, table.field_145849_e)) {
                    return true;
                }
            }
            return false;
        }

        protected boolean isValidCentralNBT(ItemStack is) {
            return this.getMainInput().field_77990_d == null || ItemStack.func_77970_a((ItemStack)this.getMainInput(), (ItemStack)is);
        }

        @Override
        public int getDuration() {
            return 100;
        }

        @Override
        public boolean usesItem(ItemStack is) {
            if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.main) && this.isValidCentralNBT(is)) {
                return true;
            }
            for (List<Integer> key : this.inputs.keySet()) {
                ItemMatch item = this.inputs.get(key);
                if (!item.match(is)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ItemStack[] getArrayForDisplay() {
            ItemStack[] iss = new ItemStack[9];
            iss[4] = this.main;
            return iss;
        }

        @Override
        protected void getRequiredProgress(Collection<ProgressionManager.ProgressStage> c) {
            super.getRequiredProgress(c);
            c.add(ProgressionManager.ProgressStage.MULTIBLOCK);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemHashMap<Integer> getItemCounts() {
            ItemHashMap map = new ItemHashMap();
            ItemStack[] items = this.getArrayForDisplay();
            map.put(items[4], (Object)1);
            ArrayList<ItemStack> c = new ArrayList<ItemStack>();
            for (ItemMatch m : this.inputs.values()) {
                c.add(m.getCycledItem());
            }
            for (ItemStack is : c) {
                Integer num = (Integer)map.get(is);
                int n = num != null ? num : 0;
                map.put(is, (Object)(n + 1));
            }
            return map;
        }

        @Override
        public ElementTagCompound getInputElements() {
            ElementTagCompound tag = super.getInputElements();
            for (ItemMatch is : this.inputs.values()) {
                for (KeyedItemStack ks : is.getItemList()) {
                    tag.addButMinimizeWith(ItemElementCalculator.instance.getValueForItem(ks.getItemStack()));
                }
            }
            return tag;
        }

        @Override
        public Collection<ItemStack> getAllInputs() {
            ArrayList<ItemStack> c = new ArrayList<ItemStack>();
            c.add(this.main);
            for (ItemMatch m : this.inputs.values()) {
                for (KeyedItemStack ks : m.getItemList()) {
                    c.add(ks.getItemStack());
                }
            }
            return c;
        }
    }

    public static class TempleCastingRecipe
    extends CastingRecipe
    implements CastingRecipeViewer.RuneRecipe {
        private static final ArrayList<Coordinate> runeRing = new ArrayList();
        private static final HashMap<Coordinate, CrystalElement> allRunes = new HashMap();
        private final RuneShape runes = new RuneShape();

        public TempleCastingRecipe(ItemStack out, IRecipe recipe) {
            this(out, RecipeType.TEMPLE, recipe);
        }

        private TempleCastingRecipe(ItemStack out, RecipeType type, IRecipe recipe) {
            super(out, type, recipe);
        }

        protected boolean matchRunes(World world, int x, int y, int z) {
            return this.runes.matchAt(world, x, y, z, 0, 0, 0);
        }

        protected TempleCastingRecipe addRuneRingRune(CrystalElement e) {
            Coordinate c = runeRing.get(e.ordinal());
            return this.addRune(e, c.xCoord, c.yCoord, c.zCoord);
        }

        protected TempleCastingRecipe addRune(int color, int rx, int ry, int rz) {
            return this.addRune(CrystalElement.elements[color], rx, ry, rz);
        }

        protected TempleCastingRecipe addRune(CrystalElementProxy color, int rx, int ry, int rz) {
            return this.addRune(CrystalElement.getFromAPI(color), rx, ry, rz);
        }

        protected TempleCastingRecipe addRune(CrystalElement color, int rx, int ry, int rz) {
            this.verifyRune(color, rx, ry, rz);
            this.runes.addRune(color, rx, ry, rz);
            return this;
        }

        private void verifyRune(CrystalElement color, int x, int y, int z) {
            Coordinate c = new Coordinate(x, y, z);
            CrystalElement e = allRunes.get(c);
            if (e != null && e != color) {
                if (this instanceof ConfigRecipe.Rune || this instanceof ConfigRecipe.Multi || this instanceof ConfigRecipe.Pylon) {
                    throw new IllegalArgumentException("Rune conflict @ " + x + ", " + y + ", " + z + ": " + (Object)((Object)color) + "(" + color.ordinal() + ") over " + (Object)((Object)e) + "(" + e.ordinal() + ");");
                }
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Rune conflict @ " + x + ", " + y + ", " + z + ": " + (Object)((Object)color) + "(" + color.ordinal() + ") over " + (Object)((Object)e) + "(" + e.ordinal() + "); map:=\n" + this.getRuneMap(y));
            }
            allRunes.put(c, color);
        }

        private String getRuneMap(int y) {
            StringBuilder sb = new StringBuilder();
            for (int i = -5; i <= 5; ++i) {
                for (int k = -5; k <= 5; ++k) {
                    Coordinate c = new Coordinate(k, y, i);
                    CrystalElement e = allRunes.get(c);
                    if (e == null && runeRing.contains(c)) {
                        e = CrystalElement.elements[runeRing.indexOf(c)];
                    }
                    sb.append("[");
                    sb.append(e != null ? e.ordinal() + (e.ordinal() < 10 ? " " : "") : (i == 0 && k == 0 ? (y == 0 ? "TB" : "CT") : "XX"));
                    sb.append("]");
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        protected CastingRecipe addRunes(RuneShape.RuneViewer view) {
            Map<Coordinate, CrystalElement> map = view.getRunes();
            for (Coordinate c : map.keySet()) {
                this.runes.addRune(map.get(c), c.xCoord, c.yCoord, c.zCoord);
            }
            return this;
        }

        public RuneShape.RuneViewer getRunes() {
            return this.runes.getView();
        }

        @Override
        public final Map<List<Integer>, CrystalElementProxy> getRunePositions() {
            HashMap<List<Integer>, CrystalElementProxy> map = new HashMap<List<Integer>, CrystalElementProxy>();
            Map<Coordinate, CrystalElement> rv = this.getRunes().getRunes();
            for (Coordinate c : rv.keySet()) {
                map.put(c.asIntList(), rv.get(c).getAPIProxy());
            }
            return map;
        }

        @Override
        public boolean match(TileEntityCastingTable table) {
            return super.match(table) && this.matchRunes(table.field_145850_b, table.field_145851_c, table.field_145848_d, table.field_145849_e);
        }

        @Override
        public int getDuration() {
            return 20;
        }

        @Override
        protected void getRequiredProgress(Collection<ProgressionManager.ProgressStage> c) {
            super.getRequiredProgress(c);
            c.add(ProgressionManager.ProgressStage.RUNEUSE);
        }

        @Override
        public ElementTagCompound getInputElements() {
            ElementTagCompound tag = super.getInputElements();
            for (CrystalElement e : this.runes.getView().getRunes().values()) {
                tag.addValueToColor(e, 1);
            }
            return tag;
        }

        public static RuneShape.RuneViewer getAllRegisteredRunes() {
            return new RuneShape(allRunes).getView();
        }

        static {
            runeRing.add(new Coordinate(-2, -1, -2));
            runeRing.add(new Coordinate(-1, -1, -2));
            runeRing.add(new Coordinate(0, -1, -2));
            runeRing.add(new Coordinate(1, -1, -2));
            runeRing.add(new Coordinate(2, -1, -2));
            runeRing.add(new Coordinate(2, -1, -1));
            runeRing.add(new Coordinate(2, -1, 0));
            runeRing.add(new Coordinate(2, -1, 1));
            runeRing.add(new Coordinate(2, -1, 2));
            runeRing.add(new Coordinate(1, -1, 2));
            runeRing.add(new Coordinate(0, -1, 2));
            runeRing.add(new Coordinate(-1, -1, 2));
            runeRing.add(new Coordinate(-2, -1, 2));
            runeRing.add(new Coordinate(-2, -1, 1));
            runeRing.add(new Coordinate(-2, -1, 0));
            runeRing.add(new Coordinate(-2, -1, -1));
        }
    }
}

