/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class Recharger {
    private int stepDuration;
    private int nsteps;
    private int step;
    private int stepTick;
    private int stepInterval;
    private RechargeWaiter notify;

    public Recharger(int d, int n) {
        this(d, n, null);
    }

    public Recharger(int d, int n, RechargeWaiter r) {
        this.stepDuration = d;
        this.verifySteps(n);
        this.nsteps = n;
        this.notify = r;
        this.stepInterval = 16 / n;
    }

    private void verifySteps(int n) {
        if (n < 1 || n > 16 || !ReikaMathLibrary.isInteger((double)(16.0 / (double)n))) {
            throw new IllegalArgumentException("You must have some even divisor of 16 steps!");
        }
    }

    public final void tick() {
        ++this.stepTick;
        if (this.stepTick >= this.stepDuration) {
            this.onStepComplete();
        }
    }

    protected void onStepComplete() {
        this.stepTick = 0;
        ++this.step;
        if (this.step > this.nsteps) {
            this.onComplete();
        } else if (this.notify != null) {
            this.notify.onSegmentComplete();
        }
    }

    protected void onComplete() {
        this.step = 0;
        if (this.notify != null) {
            this.notify.onChargingComplete();
        }
    }

    public final int getTotalDuration() {
        return this.nsteps * this.stepDuration;
    }

    public final int getTotalTick() {
        return this.step * this.stepDuration + this.stepTick;
    }

    @SideOnly(value=Side.CLIENT)
    public final void render(double s, float ptick) {
        Tessellator v5 = Tessellator.field_78398_a;
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/recharge-tile.png");
        double u = (double)(this.step * this.stepInterval % 5) / 5.0;
        double v = (double)(this.step * this.stepInterval / 5) / 4.0;
        double du = u + 0.2;
        double dv = v + 0.25;
        GL11.glPushMatrix();
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        v5.func_78382_b();
        v5.func_78378_d(0xFFFFFF);
        v5.func_78380_c(240);
        v5.func_78374_a(-s, s, 0.0, u, dv);
        v5.func_78374_a(s, s, 0.0, du, dv);
        v5.func_78374_a(s, -s, 0.0, du, v);
        v5.func_78374_a(-s, -s, 0.0, u, v);
        v5.func_78381_a();
        double a = this.stepDuration == 0 ? 0.0 : 360.0 * ((double)((float)this.stepTick + ptick) / (double)this.stepDuration) - 90.0;
        GL11.glRotated((double)a, (double)0.0, (double)0.0, (double)1.0);
        dv = 1.0;
        du = 1.0;
        u = du - 0.2;
        v = dv - 0.25;
        v5.func_78382_b();
        v5.func_78378_d(0xFFFFFF);
        v5.func_78380_c(240);
        v5.func_78374_a(-s, s, 0.0, u, dv);
        v5.func_78374_a(s, s, 0.0, du, dv);
        v5.func_78374_a(s, -s, 0.0, du, v);
        v5.func_78374_a(-s, -s, 0.0, u, v);
        v5.func_78381_a();
        GL11.glPopMatrix();
    }

    public void readFromNBT(NBTTagCompound tag, RechargeWaiter r) {
        this.nsteps = tag.func_74762_e("steps");
        this.stepDuration = tag.func_74762_e("dur");
        this.step = tag.func_74762_e("step");
        this.stepTick = tag.func_74762_e("tick");
        this.stepInterval = tag.func_74762_e("interval");
        this.notify = r;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("steps", this.nsteps);
        tag.func_74768_a("dur", this.stepDuration);
        tag.func_74768_a("step", this.step);
        tag.func_74768_a("tick", this.stepTick);
        tag.func_74768_a("interval", this.stepInterval);
    }

    public static interface RechargeWaiter {
        public void onSegmentComplete();

        public void onChargingComplete();
    }
}

