/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.TileEntity.Plants.TileEntityBiomeReverter;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.World.ReikaChunkHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumIDHandler;
import Reika.DragonAPI.ModList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class RainbowTreeEffects {
    public static void doRainbowTreeEffects(World world, int x, int y, int z, float chanceFactor, double rangeFactor, Random r, boolean spreadForest) {
        if (!world.field_72995_K) {
            if (ModList.THAUMCRAFT.isLoaded()) {
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 25.0f))) {
                    RainbowTreeEffects.fightTaint(world, x, y, z, rangeFactor);
                }
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 20.0f))) {
                    RainbowTreeEffects.fightEerie(world, x, y, z, rangeFactor);
                }
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 10.0f))) {
                    RainbowTreeEffects.convertPureNodeMagic(world, x, y, z, rangeFactor);
                }
            }
            if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world)) {
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 20.0f))) {
                    RainbowTreeEffects.fightInstability(world, x, y, z);
                }
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 10.0f))) {
                    RainbowTreeEffects.fightDecay(world, x, y, z, rangeFactor);
                }
            }
            if (spreadForest && ChromaOptions.RAINBOWSPREAD.getState() && ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 50.0f)) && world.func_72807_a(x, z) == ChromatiCraft.rainbowforest) {
                RainbowTreeEffects.convertToRainbowForest(world, x, y, z, rangeFactor);
            }
        }
    }

    public static void fightDecay(World world, int x, int y, int z, double rangeFactor) {
        if (MystCraftHandler.getInstance().decayID != null) {
            int r = (int)(64.0 * rangeFactor);
            int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
            int rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r);
            ReikaChunkHelper.removeBlocksFromChunk((World)world, (int)rx, (int)rz, (Block)MystCraftHandler.getInstance().decayID, (int)-1);
        }
    }

    public static void fightInstability(World world, int x, int y, int z) {
        if (ModList.MYSTCRAFT.isLoaded()) {
            ReikaMystcraftHelper.decrInstabilityForAge((World)world, (int)1);
        }
    }

    public static void addInstability(World world, int x, int y, int z) {
        if (ModList.MYSTCRAFT.isLoaded()) {
            ReikaMystcraftHelper.addInstabilityForAge((World)world, (short)1);
        }
    }

    public static void convertPureNodeMagic(World world, int x, int y, int z, double rangeFactor) {
        int rz;
        int dr = (int)(64.0 * rangeFactor);
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
        if (world.func_72904_c(rx, 0, rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr), rx, 255, rz)) {
            int r = 3;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    BiomeGenBase natural;
                    int dx = rx + i;
                    int dz = rz + k;
                    BiomeGenBase biome = world.func_72807_a(dx, dz);
                    int id = biome.field_76756_M;
                    if (id != ThaumIDHandler.Biomes.MAGICFOREST.getID() || (natural = ReikaWorldHelper.getNaturalGennedBiomeAt((World)world, (int)dx, (int)dz)) == null || !ChromatiCraft.isRainbowForest(natural)) continue;
                    ReikaWorldHelper.setBiomeForXZ((World)world, (int)dx, (int)dz, (BiomeGenBase)natural);
                }
            }
        }
    }

    public static void fightEerie(World world, int x, int y, int z, double rangeFactor) {
        int rz;
        int dr = (int)(32.0 * rangeFactor);
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
        if (world.func_72904_c(rx, 0, rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr), rx, 255, rz)) {
            int r = 3;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    BiomeGenBase natural;
                    int dx = rx + i;
                    int dz = rz + k;
                    BiomeGenBase biome = world.func_72807_a(dx, dz);
                    int id = biome.field_76756_M;
                    if (id != ThaumIDHandler.Biomes.EERIE.getID() || (natural = ReikaWorldHelper.getNaturalGennedBiomeAt((World)world, (int)dx, (int)dz)) == null) continue;
                    ReikaWorldHelper.setBiomeForXZ((World)world, (int)dx, (int)dz, (BiomeGenBase)natural);
                }
            }
        }
    }

    public static void fightTaint(World world, int x, int y, int z, double rangeFactor) {
        int rz;
        int dr = (int)(32.0 * rangeFactor);
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
        if (world.func_72904_c(rx, 0, rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr), rx, 255, rz)) {
            int r = 3;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    BiomeGenBase natural;
                    int dx = rx + i;
                    int dz = rz + k;
                    BiomeGenBase biome = world.func_72807_a(dx, dz);
                    int id = biome.field_76756_M;
                    if (id != ThaumIDHandler.Biomes.TAINT.getID() || (natural = ReikaWorldHelper.getNaturalGennedBiomeAt((World)world, (int)dx, (int)dz)) == null) continue;
                    if (natural.field_76756_M == id) {
                        natural = BiomeGenBase.field_76767_f;
                    }
                    ReikaWorldHelper.setBiomeForXZ((World)world, (int)dx, (int)dz, (BiomeGenBase)natural);
                }
            }
        }
    }

    public static void convertToRainbowForest(World world, int x, int y, int z, double rangeFactor) {
        int rz;
        int dr = (int)(32.0 * rangeFactor);
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
        if (world.func_72904_c(rx, 0, rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr), rx, 255, rz)) {
            int r = 3;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    BiomeGenBase biome;
                    int dx = rx + i;
                    int dz = rz + k;
                    if (TileEntityBiomeReverter.stopConversion(world, dx, dz) || (biome = world.func_72807_a(dx, dz)) == ChromatiCraft.rainbowforest || BiomeGlowingCliffs.isGlowingCliffs(biome)) continue;
                    ReikaWorldHelper.setBiomeForXZ((World)world, (int)dx, (int)dz, (BiomeGenBase)ChromatiCraft.rainbowforest);
                }
            }
        }
    }
}

