/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.AOE.Defence.TileEntityGuardianStone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public final class ProtectionZone {
    public final String creator;
    public final int dimensionID;
    public final int originX;
    public final int originY;
    public final int originZ;
    public final int range;

    public ProtectionZone(World world, EntityPlayer ep, int x, int y, int z, int r) {
        this.creator = ep.func_70005_c_();
        this.dimensionID = world.field_73011_w.field_76574_g;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.range = r;
    }

    public boolean hasTile(World world) {
        return ChromaTiles.getTile((IBlockAccess)world, this.originX, this.originY, this.originZ) == ChromaTiles.GUARDIAN;
    }

    public boolean canPlayerEditIn(EntityPlayer ep) {
        if (ep.func_70005_c_().equals(this.creator)) {
            return true;
        }
        return this.isPlayerOnAuxList(ep);
    }

    private boolean isPlayerOnAuxList(EntityPlayer ep) {
        TileEntityGuardianStone te = this.getControllingGuardianStone();
        return te != null ? te.isPlayerInList(ep) : false;
    }

    private ProtectionZone(String player, int id, int x, int y, int z, int r) {
        this.creator = player;
        this.dimensionID = id;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.range = r;
    }

    public boolean isBlockInZone(int x, int y, int z) {
        return Math.abs(x - this.originX) <= this.range && Math.abs(z - this.originZ) <= this.range && (ChromaOptions.GUARDCHUNK.getState() || Math.abs(y - this.originY) <= this.range);
    }

    public String toString() {
        return "Zone by " + this.creator + " in world " + this.dimensionID + " at " + this.originX + ", " + this.originY + ", " + this.originZ + " (Radius " + this.range + ")";
    }

    public TileEntityGuardianStone getControllingGuardianStone() {
        int z;
        int y;
        int x;
        WorldServer world = DimensionManager.getWorld((int)this.dimensionID);
        ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, x = this.originX, y = this.originY, z = this.originZ);
        if (c != ChromaTiles.GUARDIAN) {
            return null;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        return (TileEntityGuardianStone)te;
    }

    public String getSerialString() {
        StringBuilder sb = new StringBuilder();
        sb.append("P:");
        sb.append(this.creator);
        sb.append(";");
        sb.append("W:");
        sb.append(String.valueOf(this.dimensionID));
        sb.append(";");
        sb.append("X:");
        sb.append(String.valueOf(this.originX));
        sb.append(";");
        sb.append("Y:");
        sb.append(String.valueOf(this.originY));
        sb.append(";");
        sb.append("Z:");
        sb.append(String.valueOf(this.originZ));
        sb.append(";");
        sb.append("R:");
        sb.append(String.valueOf(this.range));
        return sb.toString();
    }

    protected static ProtectionZone getFromSerialString(String sg) {
        try {
            String[] s = sg.split(";");
            if (s == null || s.length != 6) {
                return null;
            }
            for (int i = 0; i < 6; ++i) {
                s[i] = s[i].substring(2);
            }
            int w = Integer.parseInt(s[1]);
            int x = Integer.parseInt(s[2]);
            int y = Integer.parseInt(s[3]);
            int z = Integer.parseInt(s[4]);
            int r = Integer.parseInt(s[5]);
            return new ProtectionZone(s[0], w, x, y, z, r);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ProtectionZone) {
            ProtectionZone p = (ProtectionZone)o;
            if (!this.creator.equals(p.creator)) {
                return false;
            }
            if (p.dimensionID != this.dimensionID) {
                return false;
            }
            if (p.range != this.range) {
                return false;
            }
            if (p.originX != this.originX) {
                return false;
            }
            if (p.originY != this.originY) {
                return false;
            }
            return p.originZ == this.originZ;
        }
        return false;
    }
}

