/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.API.CrystalElementProxy;
import Reika.ChromatiCraft.API.Event.ProgressionEvent;
import Reika.ChromatiCraft.API.ResearchFetcher;
import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.ProgressionCacher;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemUnknownArtefact;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.SequenceMap;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ProgressionManager
implements ResearchFetcher.ProgressRegistry {
    public static final ProgressionManager instance = new ProgressionManager();
    private static final String MAIN_NBT_TAG = "Chroma_Progression";
    private static final String COLOR_NBT_TAG = "Chroma_Element_Discovery";
    private static final String STRUCTURE_NBT_TAG = "Structure_Color_Completion";
    private static final String COOPERATE_NBT_TAG = "Chroma_Cooperation";
    private final SequenceMap<ProgressStage> progressMap = new SequenceMap();
    private final MultiMap<String, ProgressStage> playerMap = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());
    private final EnumMap<CrystalElement, ColorDiscovery> colorDiscoveries = new EnumMap(CrystalElement.class);
    private final EnumMap<CrystalElement, StructureComplete> structureFlags = new EnumMap(CrystalElement.class);
    private final EnumMap<ProgressStage, ChromaResearch> auxiliaryReference = new EnumMap(ProgressStage.class);

    private ProgressionManager() {
        ResearchFetcher.progressManager = this;
        this.load();
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            ColorDiscovery c = new ColorDiscovery(e);
            StructureComplete s = new StructureComplete(e);
            this.colorDiscoveries.put(e, c);
            this.structureFlags.put(e, s);
            ChromaResearchManager.instance.register(c);
            ChromaResearchManager.instance.register(s);
        }
    }

    public void reload() {
        this.progressMap.clear();
        this.load();
    }

    private void load() {
        this.progressMap.addParent((Object)ProgressStage.CASTING, (Object)ProgressStage.CRYSTALS);
        this.progressMap.addParent((Object)ProgressStage.ALLCOLORS, (Object)ProgressStage.PYLON);
        this.progressMap.addParent((Object)ProgressStage.RUNEUSE, (Object)ProgressStage.ALLCOLORS);
        this.progressMap.addParent((Object)ProgressStage.RUNEUSE, (Object)ProgressStage.CASTING);
        this.progressMap.addParent((Object)ProgressStage.MULTIBLOCK, (Object)ProgressStage.RUNEUSE);
        this.progressMap.addParent((Object)ProgressStage.LINK, (Object)ProgressStage.PYLON);
        this.progressMap.addParent((Object)ProgressStage.LINK, (Object)ProgressStage.REPEATER);
        this.progressMap.addParent((Object)ProgressStage.USEENERGY, (Object)ProgressStage.PYLON);
        this.progressMap.addParent((Object)ProgressStage.USEENERGY, (Object)ProgressStage.RUNEUSE);
        this.progressMap.addParent((Object)ProgressStage.CHARGE, (Object)ProgressStage.PYLON);
        this.progressMap.addParent((Object)ProgressStage.CHARGE, (Object)ProgressStage.CRYSTALS);
        this.progressMap.addParent((Object)ProgressStage.ABILITY, (Object)ProgressStage.CHARGE);
        this.progressMap.addParent((Object)ProgressStage.ABILITY, (Object)ProgressStage.LINK);
        this.progressMap.addParent((Object)ProgressStage.SHOCK, (Object)ProgressStage.PYLON);
        this.progressMap.addParent((Object)ProgressStage.MAKECHROMA, (Object)ProgressStage.CASTING);
        this.progressMap.addParent((Object)ProgressStage.SHARDCHARGE, (Object)ProgressStage.MAKECHROMA);
        this.progressMap.addParent((Object)ProgressStage.SHARDCHARGE, (Object)ProgressStage.RUNEUSE);
        this.progressMap.addParent((Object)ProgressStage.SHARDCHARGE, (Object)ProgressStage.DYETREE);
        this.progressMap.addParent((Object)ProgressStage.CHROMA, (Object)ProgressStage.MAKECHROMA);
        this.progressMap.addParent((Object)ProgressStage.ALLOY, (Object)ProgressStage.SHARDCHARGE);
        this.progressMap.addParent((Object)ProgressStage.ALLOY, (Object)ProgressStage.MULTIBLOCK);
        this.progressMap.addParent((Object)ProgressStage.ALLOY, (Object)ProgressStage.CHROMA);
        this.progressMap.addParent((Object)ProgressStage.NETHER, (Object)ProgressStage.BEDROCK);
        this.progressMap.addParent((Object)ProgressStage.NETHERROOF, (Object)ProgressStage.NETHER);
        this.progressMap.addParent((Object)ProgressStage.NETHERSTRUCT, (Object)ProgressStage.NETHERROOF);
        this.progressMap.addParent((Object)ProgressStage.END, (Object)ProgressStage.NETHER);
        this.progressMap.addParent((Object)ProgressStage.BLOWREPEATER, (Object)ProgressStage.USEENERGY);
        this.progressMap.addParent((Object)ProgressStage.REPEATER, (Object)ProgressStage.MULTIBLOCK);
        this.progressMap.addParent((Object)ProgressStage.REPEATER, (Object)ProgressStage.BLOWREPEATER);
        this.progressMap.addParent((Object)ProgressStage.REPEATER, (Object)ProgressStage.VILLAGECASTING);
        this.progressMap.addParent((Object)ProgressStage.STORAGE, (Object)ProgressStage.MULTIBLOCK);
        this.progressMap.addParent((Object)ProgressStage.CHARGECRYSTAL, (Object)ProgressStage.STORAGE);
        this.progressMap.addParent((Object)ProgressStage.POWERCRYSTAL, (Object)ProgressStage.LINK);
        this.progressMap.addParent((Object)ProgressStage.POWERCRYSTAL, (Object)ProgressStage.STORAGE);
        this.progressMap.addParent((Object)ProgressStage.POWERCRYSTAL, (Object)ProgressStage.CHARGE);
        this.progressMap.addParent((Object)ProgressStage.POWERCRYSTAL, (Object)ProgressStage.ALLOY);
        this.progressMap.addParent((Object)ProgressStage.DIE, (Object)ProgressStage.CHARGE);
        this.progressMap.addParent((Object)ProgressStage.KILLDRAGON, (Object)ProgressStage.END);
        this.progressMap.addParent((Object)ProgressStage.KILLWITHER, (Object)ProgressStage.NETHER);
        this.progressMap.addParent((Object)ProgressStage.KILLDRAGON, (Object)ProgressStage.KILLMOB);
        this.progressMap.addParent((Object)ProgressStage.KILLWITHER, (Object)ProgressStage.KILLMOB);
        this.progressMap.addParent((Object)ProgressStage.DIMENSION, (Object)ProgressStage.ALLCOLORS);
        this.progressMap.addParent((Object)ProgressStage.DIMENSION, (Object)ProgressStage.END);
        this.progressMap.addParent((Object)ProgressStage.DIMENSION, (Object)ProgressStage.NETHERSTRUCT);
        this.progressMap.addParent((Object)ProgressStage.DIMENSION, (Object)ProgressStage.POWERCRYSTAL);
        this.progressMap.addParent((Object)ProgressStage.DIMENSION, (Object)ProgressStage.RAINBOWFOREST);
        this.progressMap.addParent((Object)ProgressStage.DIMENSION, (Object)ProgressStage.CAVERN);
        this.progressMap.addParent((Object)ProgressStage.DIMENSION, (Object)ProgressStage.BURROW);
        this.progressMap.addParent((Object)ProgressStage.DIMENSION, (Object)ProgressStage.OCEAN);
        this.progressMap.addParent((Object)ProgressStage.DIMENSION, (Object)ProgressStage.DESERTSTRUCT);
        this.progressMap.addParent((Object)ProgressStage.TURBOCHARGE, (Object)ProgressStage.DIMENSION);
        this.progressMap.addParent((Object)ProgressStage.TURBOCHARGE, (Object)ProgressStage.STRUCTCOMPLETE);
        this.progressMap.addParent((Object)ProgressStage.STRUCTCOMPLETE, (Object)ProgressStage.ABILITY);
        this.progressMap.addParent((Object)ProgressStage.STRUCTCOMPLETE, (Object)ProgressStage.DIMENSION);
        this.progressMap.addParent((Object)ProgressStage.ALLCORES, (Object)ProgressStage.STRUCTCOMPLETE);
        this.progressMap.addParent((Object)ProgressStage.CTM, (Object)ProgressStage.ALLCORES);
        for (int i = 0; i < ProgressStage.list.length; ++i) {
            ProgressStage p = ProgressStage.list[i];
            if (!p.active || this.progressMap.hasElement((Object)p) || this.progressMap.hasElementAsChild((Object)p)) continue;
            this.progressMap.addChildless((Object)p);
        }
        this.auxiliaryReference.put(ProgressStage.CRYSTALS, ChromaResearch.CRYSTALS);
        this.auxiliaryReference.put(ProgressStage.PYLON, ChromaResearch.PYLONS);
        this.auxiliaryReference.put(ProgressStage.BURROW, ChromaResearch.BURROW);
        this.auxiliaryReference.put(ProgressStage.CAVERN, ChromaResearch.CAVERN);
        this.auxiliaryReference.put(ProgressStage.OCEAN, ChromaResearch.OCEAN);
        this.auxiliaryReference.put(ProgressStage.RAINBOWLEAF, ChromaResearch.RAINBOWLEAVES);
        this.auxiliaryReference.put(ProgressStage.DYETREE, ChromaResearch.DYELEAVES);
        this.auxiliaryReference.put(ProgressStage.BALLLIGHTNING, ChromaResearch.BALLLIGHTNING);
        this.auxiliaryReference.put(ProgressStage.ALLCOLORS, ChromaResearch.RUNES);
    }

    public SequenceMap.Topology getTopology() {
        return this.progressMap.getTopology();
    }

    private Collection<ProgressStage> getPlayerData(EntityPlayer ep) {
        return this.loadFromNBT(ep);
    }

    private Collection<ProgressStage> loadFromNBT(EntityPlayer ep) {
        NBTTagList li = this.getNBTList(ep);
        HashSet<ProgressStage> c = new HashSet<ProgressStage>();
        Iterator it = li.field_74747_a.iterator();
        while (it.hasNext()) {
            String val = ((NBTTagString)it.next()).func_150285_a_();
            try {
                c.add(ProgressStage.valueOf(val));
            }
            catch (IllegalArgumentException e) {
                ChromatiCraft.logger.logError((Object)("Could not load progress stage from NBT String " + val + "; was it removed?"));
                it.remove();
            }
        }
        this.playerMap.put((Object)ep.func_70005_c_(), c);
        return c;
    }

    private void verify(EntityPlayer ep) {
        boolean changed = false;
        String s = ep.func_70005_c_();
        do {
            Collection c = this.playerMap.get((Object)s);
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ProgressStage p = (ProgressStage)it.next();
                if (this.playerHasPrerequisites(ep, p)) continue;
                it.remove();
                changed = true;
                ChromatiCraft.logger.logError((Object)("Player " + s + " had progress element " + p + " without its prereqs! Removing!"));
            }
        } while (changed);
    }

    private NBTTagList getNBTList(EntityPlayer ep) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        if (!nbt.func_74764_b(MAIN_NBT_TAG)) {
            nbt.func_74782_a(MAIN_NBT_TAG, (NBTBase)new NBTTagList());
        }
        NBTTagList li = nbt.func_150295_c(MAIN_NBT_TAG, ReikaNBTHelper.NBTTypes.STRING.ID);
        return li;
    }

    private boolean isPlayerAtStage(EntityPlayer ep, ProgressStage s) {
        return this.getPlayerData(ep).contains(s);
    }

    public Collection<ProgressStage> getStagesFor(EntityPlayer ep) {
        Collection<ProgressStage> c = this.getPlayerData(ep);
        return c != null ? Collections.unmodifiableCollection(c) : new ArrayList<ProgressStage>();
    }

    public Collection<ProgressStage> getStagesForFromNBT(EntityPlayer ep) {
        Collection<ProgressStage> c = this.getPlayerData(ep);
        return c != null ? Collections.unmodifiableCollection(c) : new ArrayList<ProgressStage>();
    }

    public Collection<UUID> getSlavedIDs(EntityPlayer ep) {
        HashSet<UUID> c = new HashSet<UUID>();
        for (NBTTagString s : this.getCooperatorList((EntityPlayer)ep).field_74747_a) {
            try {
                c.add(UUID.fromString(s.func_150285_a_()));
            }
            catch (IllegalArgumentException e) {
                ChromatiCraft.logger.logError((Object)("Could not load cooperator UUID " + s.func_150285_a_() + "' as a cooperator with " + ep.func_70005_c_()));
            }
        }
        return c;
    }

    public boolean linkProgression(EntityPlayer ep1, EntityPlayer ep2, boolean link) {
        if (!this.canLinkProgression(ep1, ep2)) {
            return false;
        }
        NBTTagString s1 = new NBTTagString(ep2.func_110124_au().toString());
        NBTTagString s2 = new NBTTagString(ep1.func_110124_au().toString());
        NBTTagList li1 = this.getCooperatorList(ep1);
        NBTTagList li2 = this.getCooperatorList(ep2);
        if (link) {
            li1.func_74742_a((NBTBase)s1);
            li2.func_74742_a((NBTBase)s2);
        } else {
            li1.field_74747_a.remove(s1);
            li2.field_74747_a.remove(s2);
        }
        ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep1).func_74782_a(COOPERATE_NBT_TAG, (NBTBase)li1);
        ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep2).func_74782_a(COOPERATE_NBT_TAG, (NBTBase)li2);
        return true;
    }

    private boolean canLinkProgression(EntityPlayer ep1, EntityPlayer ep2) {
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep1) || ReikaPlayerAPI.isFake((EntityPlayer)ep2)) {
            return false;
        }
        return this.isProgressionEqual(ep1, ep2) && ChromaResearchManager.instance.getPlayerResearchLevel(ep1) == ChromaResearchManager.instance.getPlayerResearchLevel(ep2);
    }

    public boolean isProgressionEqual(EntityPlayer ep1, EntityPlayer ep2) {
        Collection<ProgressStage> c1 = this.getStagesFor(ep1);
        Collection<ProgressStage> c2 = this.getStagesFor(ep2);
        return c1.equals(c2);
    }

    private boolean playerCanReceiveProgressWith(EntityPlayer e, EntityPlayer ep) {
        return e.func_70032_d((Entity)ep) <= 12.0f;
    }

    private NBTTagList getCooperatorList(EntityPlayer ep) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        if (!nbt.func_74764_b(COOPERATE_NBT_TAG)) {
            nbt.func_74782_a(COOPERATE_NBT_TAG, (NBTBase)new NBTTagList());
        }
        NBTTagList li = nbt.func_150295_c(COOPERATE_NBT_TAG, ReikaNBTHelper.NBTTypes.STRING.ID);
        return li;
    }

    private boolean stepPlayerTo(EntityPlayer ep, ProgressStage s) {
        if (ep == null) {
            ChromatiCraft.logger.logError((Object)("Tried to give progress '" + s + "' to null player???"));
            return false;
        }
        if (!this.canStepPlayerTo(ep, s)) {
            return false;
        }
        this.setPlayerStage(ep, s, true, true);
        return true;
    }

    private boolean canStepPlayerTo(EntityPlayer ep, ProgressStage s) {
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return false;
        }
        if (this.isPlayerAtStage(ep, s)) {
            return false;
        }
        return this.playerHasPrerequisites(ep, s);
    }

    public boolean playerHasPrerequisites(EntityPlayer ep, ProgressStage s) {
        Collection c = this.progressMap.getParents((Object)s);
        if (c == null || c.isEmpty()) {
            return true;
        }
        for (ProgressStage s2 : c) {
            if (this.isPlayerAtStage(ep, s2)) continue;
            return false;
        }
        return true;
    }

    public Collection<ProgressStage> getPrereqs(ProgressStage s) {
        return Collections.unmodifiableCollection(this.progressMap.getParents((Object)s));
    }

    public ProgressStage[] getPrereqsArray(ProgressStage s) {
        Collection c = this.progressMap.getParents((Object)s);
        return c != null ? c.toArray(new ProgressStage[c.size()]) : new ProgressStage[]{};
    }

    private boolean isOneStepAway(EntityPlayer ep, ProgressStage s) {
        if (this.isPlayerAtStage(ep, s)) {
            return false;
        }
        Collection c = this.progressMap.getParents((Object)s);
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (ProgressStage par : c) {
            if (this.isPlayerAtStage(ep, par)) {
                return false;
            }
            Collection c2 = this.progressMap.getParents((Object)par);
            for (ProgressStage par2 : c2) {
                if (this.isPlayerAtStage(ep, par)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean setPlayerStage(EntityPlayer ep, int val, boolean set, boolean notify) {
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return false;
        }
        if (val < 0 || val >= ProgressStage.values().length) {
            return false;
        }
        this.setPlayerStage(ep, ProgressStage.values()[val], set, notify);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPlayerStageClient(EntityPlayer ep, ProgressStage s, boolean set, boolean notify) {
        this.setPlayerStage(ep, s, set, true, notify);
    }

    public void setPlayerStage(EntityPlayer ep, ProgressStage s, boolean set, boolean notify) {
        this.setPlayerStage(ep, s, set, false, notify);
    }

    private void setPlayerStage(EntityPlayer ep, ProgressStage s, boolean set, boolean allowClient, boolean notify) {
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return;
        }
        if (ep.field_70170_p.field_72995_K && !allowClient) {
            return;
        }
        Collection<UUID> coop = this.getSlavedIDs(ep);
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (UUID u : coop) {
            EntityPlayer e = ep.field_70170_p.func_152378_a(u);
            if (e == null || ReikaPlayerAPI.isFake((EntityPlayer)e)) {
                return;
            }
            if (!this.playerCanReceiveProgressWith(e, ep)) {
                return;
            }
            players.add(e);
        }
        for (EntityPlayer e : players) {
            this.setPlayerStage(ep, s, set, allowClient, notify);
        }
        if (notify && ep instanceof EntityPlayerMP) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.GIVEPROGRESS.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{s.ordinal(), set ? 1 : 0});
        }
        NBTTagList li = this.getNBTList(ep);
        NBTTagString tag = new NBTTagString(s.name());
        boolean flag = false;
        if (set) {
            if (!li.field_74747_a.contains(tag)) {
                flag = true;
                li.func_74742_a((NBTBase)tag);
                Collection c = this.progressMap.getRecursiveParents((Object)s);
                for (ProgressStage s2 : c) {
                    NBTTagString tag2 = new NBTTagString(s2.name());
                    li.field_74747_a.add(tag2);
                }
            }
        } else if (li.field_74747_a.contains(tag)) {
            flag = true;
            li.field_74747_a.remove(tag);
            Collection c = this.progressMap.getRecursiveChildren((Object)s);
            for (ProgressStage s2 : c) {
                NBTTagString tag2 = new NBTTagString(s2.name());
                li.field_74747_a.remove(tag2);
            }
        }
        if (flag) {
            ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep).func_74782_a(MAIN_NBT_TAG, (NBTBase)li);
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            if (set) {
                this.playerMap.addValue((Object)ep.func_70005_c_(), (Object)s);
                if (notify) {
                    ChromaResearchManager.instance.notifyPlayerOfProgression(ep, s);
                }
                this.giveAuxiliaryResearch(ep, s);
                MinecraftForge.EVENT_BUS.post((Event)new ProgressionEvent(ep, s.name(), ProgressionEvent.ResearchType.PROGRESS));
            } else {
                this.playerMap.remove((Object)ep.func_70005_c_(), (Object)s);
            }
            if (notify) {
                this.updateChunks(ep);
            }
            ProgressionCacher.instance.updateProgressCache(ep);
        }
    }

    public void resetPlayerProgression(EntityPlayer ep, boolean notify) {
        NBTTagList li = this.getNBTList(ep);
        li.field_74747_a.clear();
        Collection c = this.playerMap.remove((Object)ep.func_70005_c_());
        if (notify && ep instanceof EntityPlayerMP) {
            EntityPlayerMP emp = (EntityPlayerMP)ep;
            for (ProgressStage p : c) {
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.GIVEPROGRESS.ordinal(), (EntityPlayerMP)emp, (int[])new int[]{p.ordinal(), 0});
            }
        }
        ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep).func_74782_a(MAIN_NBT_TAG, (NBTBase)li);
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            this.setPlayerDiscoveredColor(ep, CrystalElement.elements[i], false, notify);
            this.markPlayerCompletedStructureColor(ep, CrystalElement.elements[i], false, notify);
        }
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
        if (notify) {
            this.updateChunks(ep);
        }
        ProgressionCacher.instance.updateProgressCache(ep);
    }

    public void maxPlayerProgression(EntityPlayer ep, boolean notify) {
        int i;
        for (i = 0; i < ProgressStage.list.length; ++i) {
            if (!ProgressStage.list[i].active) continue;
            this.setPlayerStage(ep, ProgressStage.list[i], true, notify);
        }
        for (i = 0; i < CrystalElement.elements.length; ++i) {
            this.setPlayerDiscoveredColor(ep, CrystalElement.elements[i], true, notify);
            this.markPlayerCompletedStructureColor(ep, CrystalElement.elements[i], true, notify);
        }
        for (i = 0; i < CastingRecipe.RecipeType.typeList.length; ++i) {
            CastingRecipe.RecipeType r = CastingRecipe.RecipeType.typeList[i];
            RecipesCastingTable.setPlayerHasCrafted(ep, r);
        }
    }

    public boolean setPlayerDiscoveredColor(EntityPlayer ep, CrystalElement e, boolean disc, boolean notify) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound tag = nbt.func_74775_l(COLOR_NBT_TAG);
        boolean had = tag.func_74767_n(e.name());
        tag.func_74757_a(e.name(), disc);
        if (had != disc) {
            nbt.func_74782_a(COLOR_NBT_TAG, (NBTBase)tag);
            if (disc) {
                this.checkPlayerColors(ep);
            }
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            if (notify) {
                this.updateChunks(ep);
            }
            if (disc && notify) {
                ChromaResearchManager.instance.notifyPlayerOfProgression(ep, this.colorDiscoveries.get((Object)e));
            }
            if (disc) {
                MinecraftForge.EVENT_BUS.post((Event)new ProgressionEvent(ep, e.name(), ProgressionEvent.ResearchType.COLOR));
            }
            ProgressionCacher.instance.updateProgressCache(ep);
            return true;
        }
        return false;
    }

    private void checkPlayerColors(EntityPlayer ep) {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            if (this.hasPlayerDiscoveredColor(ep, CrystalElement.elements[i])) continue;
            return;
        }
        ProgressStage.ALLCOLORS.stepPlayerTo(ep);
    }

    public void updateChunks(EntityPlayer ep) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ReikaRenderHelper.rerenderAllChunksLazily();
        } else {
            ReikaPacketHelper.sendUpdatePacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.RERENDER.ordinal(), (int)0, (int)0, (int)0, (PacketTarget)new PacketTarget.PlayerTarget((EntityPlayerMP)ep));
        }
    }

    public boolean hasPlayerDiscoveredColor(EntityPlayer ep, CrystalElement e) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep).func_74775_l(COLOR_NBT_TAG);
        return nbt.func_74767_n(e.name());
    }

    public Collection<CrystalElement> getColorsFor(EntityPlayer ep) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep).func_74775_l(COLOR_NBT_TAG);
        ArrayList<CrystalElement> c = new ArrayList<CrystalElement>();
        for (Object o : nbt.func_150296_c()) {
            String tag = (String)o;
            if (!nbt.func_74767_n(tag)) continue;
            c.add(CrystalElement.valueOf(tag));
        }
        return c;
    }

    public void giveAuxiliaryResearch(EntityPlayer ep, ProgressStage p) {
        ChromaResearch r;
        if (ChromaOptions.EASYFRAG.getState() && (r = this.auxiliaryReference.get(p)) != null) {
            ChromaResearchManager.instance.givePlayerFragment(ep, r, true);
        }
    }

    @Override
    public boolean playerHasResearch(EntityPlayer ep, String key) {
        try {
            ProgressStage p = ProgressStage.valueOf(key.toUpperCase());
            return p.isPlayerAtStage(ep);
        }
        catch (IllegalArgumentException e) {
            ChromatiCraft.logger.logError((Object)("A mod tried to fetch an invalid progress stage '" + key + "'!"));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public HashSet<String> getAllResearches() {
        HashSet<String> c = new HashSet<String>();
        for (int i = 0; i < ProgressStage.list.length; ++i) {
            c.add(ProgressStage.list[i].name());
        }
        return c;
    }

    @Override
    public HashSet<String> getPrerequisites(String key) {
        try {
            ProgressStage p = ProgressStage.valueOf(key.toUpperCase());
            Collection<ProgressStage> c = this.getPrereqs(p);
            HashSet<String> h = new HashSet<String>();
            for (ProgressStage req : c) {
                h.add(req.name());
            }
            return h;
        }
        catch (IllegalArgumentException e) {
            ChromatiCraft.logger.logError((Object)("A mod tried to fetch the state of an invalid progress stage '" + key + "'!"));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean canPlayerStepTo(EntityPlayer ep, String key) {
        try {
            ProgressStage p = ProgressStage.valueOf(key.toUpperCase());
            return this.canStepPlayerTo(ep, p);
        }
        catch (IllegalArgumentException e) {
            ChromatiCraft.logger.logError((Object)("A mod tried to fetch the state of an invalid progress stage '" + key + "'!"));
            e.printStackTrace();
            return false;
        }
    }

    public boolean hasPlayerDiscoveredAGeneratedStructure(EntityPlayer ep) {
        return ProgressStage.BURROW.isPlayerAtStage(ep) || ProgressStage.CAVERN.isPlayerAtStage(ep) || ProgressStage.OCEAN.isPlayerAtStage(ep) || ProgressStage.DESERTSTRUCT.isPlayerAtStage(ep);
    }

    @Override
    public boolean playerDiscoveredElement(EntityPlayer ep, CrystalElementProxy e) {
        return this.hasPlayerDiscoveredColor(ep, CrystalElement.getFromAPI(e));
    }

    public boolean hasPlayerCompletedStructureColor(EntityPlayer ep, CrystalElement e) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep).func_74775_l(STRUCTURE_NBT_TAG);
        return nbt.func_74767_n(e.name());
    }

    public boolean markPlayerCompletedStructureColor(EntityPlayer ep, CrystalElement e, boolean set, boolean notify) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound tag = nbt.func_74775_l(STRUCTURE_NBT_TAG);
        boolean had = tag.func_74767_n(e.name());
        tag.func_74757_a(e.name(), set);
        if (had != set) {
            nbt.func_74782_a(STRUCTURE_NBT_TAG, (NBTBase)tag);
            if (set) {
                ProgressStage.STRUCTCOMPLETE.stepPlayerTo(ep);
                this.checkPlayerStructures(ep);
            } else {
                this.setPlayerStage(ep, ProgressStage.ALLCORES, false, notify);
            }
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            if (notify) {
                this.updateChunks(ep);
            }
            if (set && notify) {
                ChromaResearchManager.instance.notifyPlayerOfProgression(ep, this.structureFlags.get((Object)e));
            }
            if (set) {
                MinecraftForge.EVENT_BUS.post((Event)new ProgressionEvent(ep, e.name(), ProgressionEvent.ResearchType.DIMSTRUCT));
            }
            ProgressionCacher.instance.updateProgressCache(ep);
            return true;
        }
        return false;
    }

    private void checkPlayerStructures(EntityPlayer ep) {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            if (this.hasPlayerCompletedStructureColor(ep, CrystalElement.elements[i])) continue;
            return;
        }
        ProgressStage.ALLCORES.stepPlayerTo(ep);
    }

    public Collection<CrystalElement> getStructuresFor(EntityPlayer ep) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep).func_74775_l(STRUCTURE_NBT_TAG);
        ArrayList<CrystalElement> c = new ArrayList<CrystalElement>();
        for (Object o : nbt.func_150296_c()) {
            String tag = (String)o;
            if (!nbt.func_74767_n(tag)) continue;
            c.add(CrystalElement.valueOf(tag));
        }
        return c;
    }

    private static class AlphabeticProgressComparator
    implements Comparator<ProgressStage> {
        private AlphabeticProgressComparator() {
        }

        @Override
        public int compare(ProgressStage o1, ProgressStage o2) {
            return o1.getTitleString().compareToIgnoreCase(o2.getTitleString());
        }
    }

    public static class StructureComplete
    implements ChromaResearchManager.ProgressElement {
        public final CrystalElement color;

        private StructureComplete(CrystalElement e) {
            this.color = e;
        }

        @Override
        public String getTitle() {
            return this.color.displayName + " Core";
        }

        @Override
        public String getShortDesc() {
            return "Another piece of the puzzle";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderIcon(RenderItem ri, FontRenderer fr, int x, int y) {
            ItemStack is = ChromaTiles.DIMENSIONCORE.getCraftedProduct();
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("color", this.color.ordinal());
            ReikaGuiAPI.instance.drawItemStack(ri, fr, is, x, y);
        }

        public String toString() {
            return "Structure_" + this.color.name();
        }

        public int hashCode() {
            return this.color.ordinal();
        }

        public boolean equals(Object o) {
            return o instanceof StructureComplete && ((StructureComplete)o).color == this.color;
        }

        @Override
        public String getFormatting() {
            return this.color.getChatColorString();
        }

        @Override
        public boolean giveToPlayer(EntityPlayer ep, boolean notify) {
            return instance.markPlayerCompletedStructureColor(ep, this.color, true, notify);
        }
    }

    public static class ColorDiscovery
    implements ChromaResearchManager.ProgressElement {
        public final CrystalElement color;

        private ColorDiscovery(CrystalElement e) {
            this.color = e;
        }

        @Override
        public String getTitle() {
            return this.color.displayName;
        }

        @Override
        public String getShortDesc() {
            return "A new form of crystal energy";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderIcon(RenderItem ri, FontRenderer fr, int x, int y) {
            ReikaGuiAPI.instance.drawItemStack(ri, fr, ChromaBlocks.RUNE.getStackOfMetadata(this.color.ordinal()), x, y);
        }

        public String toString() {
            return "Discover_" + this.color.name();
        }

        public int hashCode() {
            return this.color.ordinal();
        }

        public boolean equals(Object o) {
            return o instanceof ColorDiscovery && ((ColorDiscovery)o).color == this.color;
        }

        @Override
        public String getFormatting() {
            return this.color.getChatColorString();
        }

        @Override
        public boolean giveToPlayer(EntityPlayer ep, boolean notify) {
            return instance.setPlayerDiscoveredColor(ep, this.color, true, notify);
        }
    }

    public static enum ProgressStage implements ChromaResearchManager.ProgressElement
    {
        CASTING(ChromaTiles.TABLE.getCraftedProduct(), new boolean[0]),
        CRYSTALS(ChromaBlocks.CRYSTAL.getStackOfMetadata(CrystalElement.RED.ordinal()), new boolean[0]),
        DYETREE(ChromaBlocks.DYELEAF.getStackOfMetadata(CrystalElement.YELLOW.ordinal()), new boolean[0]),
        MULTIBLOCK(ChromaTiles.STAND.getCraftedProduct(), new boolean[0]),
        RUNEUSE(ChromaBlocks.RUNE.getStackOfMetadata(CrystalElement.ORANGE.ordinal()), new boolean[0]),
        PYLON(ChromaTiles.PYLON.getCraftedProduct(), new boolean[0]),
        LINK(ChromaTiles.COMPOUND.getCraftedProduct(), new boolean[0]),
        CHARGE(ChromaItems.TOOL.getStackOf(), new boolean[0]),
        ABILITY(ChromaTiles.RITUAL.getCraftedProduct(), new boolean[0]),
        RAINBOWLEAF(ChromaBlocks.RAINBOWLEAF.getStackOfMetadata(3), new boolean[0]),
        MAKECHROMA(ChromaTiles.COLLECTOR.getCraftedProduct(), new boolean[0]),
        SHARDCHARGE(ChromaStacks.chargedRedShard, new boolean[0]),
        ALLOY(ChromaStacks.chromaIngot, new boolean[0]),
        CHROMA(ChromaBlocks.CHROMA.getBlockInstance(), new boolean[0]),
        SHOCK(ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(5), new boolean[0]),
        HIVE(ChromaBlocks.HIVE.getBlockInstance(), ModList.FORESTRY.isLoaded()),
        NETHER((Block)Blocks.field_150427_aO, new boolean[0]),
        END(Blocks.field_150378_br, new boolean[0]),
        TWILIGHT(ModList.TWILIGHT.isLoaded() ? ModWoodList.CANOPY.getItem() : null, ModList.TWILIGHT.isLoaded()),
        BEDROCK(Blocks.field_150357_h, new boolean[0]),
        CAVERN(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CLOAK.metadata), new boolean[0]),
        BURROW(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.MOSS.metadata), new boolean[0]),
        OCEAN(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.GLASS.metadata), new boolean[0]),
        DESERTSTRUCT(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.COBBLE.metadata), new boolean[0]),
        DIE(Items.field_151144_bL, new boolean[0]),
        ALLCOLORS(ChromaItems.ELEMENTAL.getStackOf(CrystalElement.CYAN), new boolean[0]),
        REPEATER(ChromaTiles.REPEATER.getCraftedProduct(), new boolean[0]),
        RAINBOWFOREST(ChromaBlocks.RAINBOWSAPLING.getBlockInstance(), new boolean[0]),
        DIMENSION(ChromaBlocks.PORTAL.getBlockInstance(), new boolean[0]),
        CTM(ChromaTiles.AURAPOINT.getCraftedProduct(), new boolean[0]),
        STORAGE(ChromaItems.STORAGE.getStackOf(), new boolean[0]),
        CHARGECRYSTAL(ChromaTiles.CHARGER.getCraftedProduct(), new boolean[0]),
        BALLLIGHTNING(ChromaStacks.auraDust, new boolean[0]),
        POWERCRYSTAL(ChromaTiles.CRYSTAL.getCraftedProduct(), new boolean[0]),
        TURBOCHARGE(ChromaTiles.PYLONTURBO.getCraftedProduct(), new boolean[0]),
        BREAKSPAWNER(Blocks.field_150474_ac, new boolean[0]),
        KILLDRAGON(Blocks.field_150380_bt, new boolean[0]),
        KILLWITHER(Items.field_151156_bN, new boolean[0]),
        KILLMOB(new ItemStack(Items.field_151144_bL, 1, 4), new boolean[0]),
        ALLCORES(ChromaTiles.DIMENSIONCORE.getCraftedNBTProduct("color", CrystalElement.RED.ordinal()), new boolean[0]),
        USEENERGY(ChromaTiles.WEAKREPEATER.getCraftedProduct(), new boolean[0]),
        BLOWREPEATER(ChromaStacks.crystalPowder, new boolean[0]),
        STRUCTCOMPLETE(ChromaBlocks.DIMDATA.getStackOf(), new boolean[0]),
        NETHERROOF(Blocks.field_150424_aL, new boolean[0]),
        NETHERSTRUCT(Blocks.field_150385_bj, new boolean[0]),
        VILLAGECASTING(Blocks.field_150347_e, new boolean[0]),
        FOCUSCRYSTAL(Items.field_151166_bC, new boolean[0]),
        ANYSTRUCT(ChromaTiles.STRUCTCONTROL.getCraftedProduct(), new boolean[0]),
        ARTEFACT(ChromaItems.ARTEFACT.getStackOfMetadata(ItemUnknownArtefact.ArtefactTypes.FRAGMENT.ordinal()), new boolean[0]),
        TOWER(ChromaTiles.DATANODE.getCraftedProduct(), new boolean[0]),
        NEVER(Blocks.field_150348_b, false);

        private final ItemStack icon;
        public final boolean active;
        public static final ProgressStage[] list;

        private ProgressStage(Block b, boolean ... cond) {
            this(new ItemStack(b), cond);
        }

        private ProgressStage(Item b, boolean ... cond) {
            this(new ItemStack(b), cond);
        }

        private ProgressStage(ItemStack is, boolean ... cond) {
            this.icon = is;
            boolean flag = true;
            for (int i = 0; i < cond.length; ++i) {
                flag = flag && cond[i];
            }
            this.active = flag;
            ChromaResearchManager.instance.register(this);
        }

        public boolean stepPlayerTo(EntityPlayer ep) {
            return instance.stepPlayerTo(ep, this);
        }

        public boolean isPlayerAtStage(EntityPlayer ep) {
            return instance.isPlayerAtStage(ep, this);
        }

        public boolean playerHasPrerequisites(EntityPlayer ep) {
            return instance.playerHasPrerequisites(ep, this);
        }

        public boolean isOneStepAway(EntityPlayer ep) {
            return instance.isOneStepAway(ep, this);
        }

        @Override
        public String getTitle() {
            return this.getTitleString();
        }

        @Override
        public String getShortDesc() {
            return ChromaDescriptions.getProgressText((ProgressStage)this).desc;
        }

        public String getTitleString() {
            return ChromaDescriptions.getProgressText((ProgressStage)this).title;
        }

        public String getHintString() {
            return ChromaDescriptions.getProgressText((ProgressStage)this).hint;
        }

        public String getRevealedString() {
            return ChromaDescriptions.getProgressText((ProgressStage)this).reveal;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderIcon(RenderItem ri, FontRenderer fr, int x, int y) {
            if (this == ANYSTRUCT) {
                ReikaTextureHelper.bindTerrainTexture();
                GL11.glPushAttrib((int)1048575);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
                ReikaGuiAPI.instance.func_94065_a(x, y, ChromaIcons.SPINFLARE.getIcon(), 16, 16);
                GL11.glPopAttrib();
                return;
            }
            ReikaGuiAPI.instance.drawItemStack(ri, fr, this.icon, x, y);
        }

        public boolean isGatedAfter(ProgressStage p) {
            return instance.progressMap.getRecursiveParents((Object)this).contains(p);
        }

        @Override
        public String getFormatting() {
            return EnumChatFormatting.UNDERLINE.toString();
        }

        @Override
        public boolean giveToPlayer(EntityPlayer ep, boolean notify) {
            return this.stepPlayerTo(ep);
        }

        public void forceOnPlayer(EntityPlayer ep, boolean notify) {
        }

        static {
            list = ProgressStage.values();
        }
    }
}

