/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Auxiliary.Render.AngleColorController;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFlareFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityDimensionCore;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionTicker;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.ChromatiCraft.World.Dimension.Structure.MonumentGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.ParticleController.SpiralMotionController;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MonumentCompletionRitual {
    private static final Random rand = new Random();
    private int count;
    private int tick;
    private int totalTick = 0;
    private long lastTick;
    private boolean running;
    private boolean complete;
    private final World world;
    private final int x;
    private final int y;
    private final int z;
    private final EntityPlayer ep;
    private final PacketTarget packetTarget;
    public static final int RITUAL_STEPS = 32;
    public static final int COMPLETION_EXTRA = 10;
    private static final int EFFECT_RANGE = 256;
    private static int runningRituals;
    private static boolean reShowGui;
    private static boolean reBobView;

    public static boolean areRitualsRunning() {
        return runningRituals > 0;
    }

    public MonumentCompletionRitual(World world, int x, int y, int z, EntityPlayer ep) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.ep = ep;
        this.packetTarget = new PacketTarget.RadiusTarget(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 256);
    }

    private void disableCores(World world, int x, int y, int z) {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            Coordinate c = TileEntityDimensionCore.getLocation(e).offset(x, y, z);
            ((TileEntityDimensionCore)c.getTileEntity(world)).prime(false);
        }
    }

    public void start() {
        this.disableCores(this.world, this.x, this.y, this.z);
        this.tick = 5;
        this.running = true;
        ++runningRituals;
        if (this.world.field_72995_K) {
            this.startClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void startClient() {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.MONUMENT, (double)((double)this.x + 0.5), (double)((double)this.y + 0.5), (double)((double)this.z + 0.5), (float)1.0f, (float)0.7717803f, (boolean)false);
        ISound s = ChromaDimensionTicker.instance.getCurrentMusic();
        if (s != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(s);
        }
        reBobView = Minecraft.func_71410_x().field_71474_y.field_74336_f;
        reShowGui = !Minecraft.func_71410_x().field_71474_y.field_74319_N;
    }

    public void tick() {
        if (this.running) {
            if (!this.world.field_72995_K) {
                long time = System.currentTimeMillis();
                long dur = time - this.lastTick;
                this.lastTick = time;
                if (this.tick > 0) {
                    this.tick = (int)((long)this.tick - Math.min((long)this.tick, Math.max(1L, dur / 50L)));
                    if (this.tick == 0) {
                        this.doChecks(true);
                    }
                }
                if (!this.complete) {
                    double n = 1.0 + 4.0 * (double)(this.count / 32);
                    for (int i = 0; i < EventType.list.length; ++i) {
                        EventType evt = EventType.list[i];
                        if (!(evt.tickChance > 0.0) || !ReikaRandomHelper.doWithChance((double)(evt.tickChance * Math.pow(n, evt.powerFactor)))) continue;
                        this.triggerEvent(evt);
                    }
                }
            }
            if (this.world.field_72995_K) {
                this.manipulateCamera();
            }
            ++this.totalTick;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manipulateCamera() {
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        Minecraft.func_71410_x().field_71474_y.field_74336_f = false;
        Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
        double ang = (double)(this.world.func_82737_E() + (long)(this.ep.func_110124_au().hashCode() % 8000)) / 2.0;
        double angPrev = (double)(this.world.func_82737_E() + (long)(this.ep.func_110124_au().hashCode() % 8000) - 1L) / 2.0;
        double r = 32.5;
        double R = 40.0;
        double d = 12.1875;
        double cx = (double)this.x + 0.5 + (R - r) * Math.cos(Math.toRadians(ang)) + d * Math.cos(Math.toRadians((R - r) / r * ang));
        double cz = (double)this.z + 0.5 + (R - r) * Math.sin(Math.toRadians(ang)) - d * Math.sin(Math.toRadians((R - r) / r * ang));
        double cxPrev = (double)this.x + 0.5 + (R - r) * Math.cos(Math.toRadians(angPrev)) + d * Math.cos(Math.toRadians((R - r) / r * angPrev));
        double czPrev = (double)this.z + 0.5 + (R - r) * Math.sin(Math.toRadians(angPrev)) - d * Math.sin(Math.toRadians((R - r) / r * angPrev));
        double dd = ReikaMathLibrary.py3d((double)(cx - (double)this.x - 0.5), (double)0.0, (double)(cz - (double)this.z - 0.5));
        double ddPrev = ReikaMathLibrary.py3d((double)(cxPrev - (double)this.x - 0.5), (double)0.0, (double)(czPrev - (double)this.z - 0.5));
        double cy = (double)(this.y + 15 + 4 + 4) - 0.25 * dd + 4.0 * Math.sin(Math.toRadians(ang / 4.0)) - 2.0;
        double cyPrev = (double)(this.y + 15 + 4 + 4) - 0.25 * ddPrev + 4.0 * Math.sin(Math.toRadians(angPrev / 4.0)) - 2.0;
        double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(cx - (double)this.x - 0.5), (double)(cy - (double)this.y - 0.5), (double)(cz - (double)this.z - 0.5));
        double[] angsPrev = ReikaPhysicsHelper.cartesianToPolar((double)(cxPrev - (double)this.x - 0.5), (double)(cyPrev - (double)this.y - 0.5), (double)(czPrev - (double)this.z - 0.5));
        double pitch = 90.0 - angs[1];
        double pitchPrev = 90.0 - angsPrev[1];
        double yaw = -angs[2];
        double yawPrev = -angsPrev[2];
        ReikaRenderHelper.setCameraPosition((EntityPlayer)this.ep, (double)cx, (double)cy, (double)cz, (double)cxPrev, (double)cyPrev, (double)czPrev, (double)yaw, (double)yawPrev, (double)pitch, (double)pitchPrev, (boolean)true, (boolean)true);
    }

    public boolean doChecks(boolean tick) {
        EntityPlayer ep = null;
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            Coordinate c = TileEntityDimensionCore.getLocation(e).offset(this.x, this.y, this.z);
            ChromaTiles t = ChromaTiles.getTileFromIDandMetadata(c.getBlock(this.world), c.getBlockMetadata(this.world));
            if (t != ChromaTiles.DIMENSIONCORE) {
                this.endRitual();
                return false;
            }
            TileEntityDimensionCore te = (TileEntityDimensionCore)c.getTileEntity(this.world);
            if (te.getColor() != e) {
                this.endRitual();
                return false;
            }
            EntityPlayer own = te.getPlacer();
            if (own == null || ReikaPlayerAPI.isFake((EntityPlayer)own)) continue;
            if (ep == null || own == ep) {
                ep = own;
                continue;
            }
            this.endRitual();
            return false;
        }
        if (ep == null) {
            this.endRitual();
            return false;
        }
        if (!this.doMineralChecks()) {
            this.endRitual();
            return false;
        }
        if (tick) {
            if (this.count < 32) {
                this.triggerEvent(EventType.FLARES);
            }
            this.scheduleNextCheck();
            ++this.count;
            if (this.count >= 32) {
                this.completeRitual();
            }
        }
        return true;
    }

    private boolean doMineralChecks() {
        if (this.world.field_72995_K) {
            return true;
        }
        MonumentGenerator gen = ChunkProviderChroma.getMonumentGenerator();
        Map<Coordinate, Block> map = gen.getMineralBlocks();
        for (Coordinate c : map.keySet()) {
            Block b = c.getBlock(this.world);
            if (b == map.get(c)) continue;
            return false;
        }
        return true;
    }

    private void completeRitual() {
        if (this.count == 32) {
            this.complete = true;
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.MONUMENTCOMPLETE.ordinal(), (PacketTarget)this.packetTarget, (int[])new int[]{this.x, this.y, this.z});
            double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(this.ep.field_70165_t - (double)this.x - 0.5), (double)(this.ep.field_70163_u - (double)this.y - 0.5), (double)(this.ep.field_70161_v - (double)this.z - 0.5));
            double pitch = 90.0 - angs[1];
            double yaw = -angs[2];
            this.ep.field_70758_at = this.ep.field_70126_B = (float)yaw;
            this.ep.field_70759_as = this.ep.field_70126_B;
            this.ep.field_70177_z = this.ep.field_70126_B;
            this.ep.field_70125_A = this.ep.field_70127_C = (float)pitch;
        } else if (this.count == 42) {
            this.count = 0;
            this.tick = 0;
            this.world.func_147465_d(this.x, this.y, this.z, ChromaTiles.AURAPOINT.getBlock(), ChromaTiles.AURAPOINT.getBlockMetadata(), 3);
            TileEntityAuraPoint te = (TileEntityAuraPoint)this.world.func_147438_o(this.x, this.y, this.z);
            te.setPlacer(this.ep);
            ProgressionManager.ProgressStage.CTM.stepPlayerTo(this.ep);
            if (!this.world.field_72995_K) {
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.RESETMONUMENT.ordinal(), (PacketTarget)this.packetTarget, (int[])new int[]{this.x, this.y, this.z});
            }
            this.running = false;
        }
    }

    private void scheduleNextCheck() {
        this.tick = Math.max(4, 128 - this.count * 4);
    }

    private void triggerEvent(EventType evt) {
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.MONUMENTEVENT.ordinal(), (PacketTarget)this.packetTarget, (int[])new int[]{this.x, this.y, this.z, evt.ordinal(), this.count, this.tick});
    }

    public void endRitual() {
        this.count = 0;
        this.tick = 50;
        this.running = false;
        if (this.running) {
            --runningRituals;
        }
        ((TileEntityStructControl)this.world.func_147438_o(this.x, this.y, this.z)).endMonumentRitual();
        ChromaSounds.ERROR.playSoundAtBlockNoAttenuation(this.world, this.x, this.y, this.z, 1.0f, 0.75f, Integer.MAX_VALUE);
        if (!this.world.field_72995_K) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.RESETMONUMENT.ordinal(), (PacketTarget)this.packetTarget, (int[])new int[]{this.x, this.y, this.z});
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerMonumentEventClient(World world, int x, int y, int z, int type, int count, int tick) {
        EventType.list[type].doEventClient(world, x, y, z, count, tick);
    }

    @SideOnly(value=Side.CLIENT)
    public static void completeMonumentClient(World world, int x, int y, int z) {
        int i;
        int n = 32 + rand.nextInt(64);
        for (i = 0; i < n; ++i) {
            double phi = rand.nextDouble() * 360.0;
            double theta = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)90.0);
            double v = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.5);
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)v, (double)theta, (double)phi);
            int c = CrystalElement.randomElement().getColor();
            int l = 30 + rand.nextInt(40);
            EntityFloatingSeedsFX fx = (EntityFloatingSeedsFX)new EntityFloatingSeedsFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, phi, theta).setColor(c).setScale(6.0f).setLife(l);
            fx.particleVelocity *= 3.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            Coordinate c = TileEntityDimensionCore.getLocation(e).offset(x, y, z);
            TileEntityDimensionCore.createBeamLine(world, x, y, z, c.xCoord, c.yCoord, c.zCoord, CrystalElement.WHITE, e);
        }
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.MONUMENTCOMPLETE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)0.9439f, (boolean)false);
        Minecraft.func_71410_x().field_71474_y.field_74319_N = !reShowGui;
        Minecraft.func_71410_x().field_71474_y.field_74336_f = reBobView;
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetSettings(World world, int x, int y, int z) {
        Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
        Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(ep.field_70165_t - (double)x - 0.5), (double)(ep.field_70163_u - (double)y - 0.5), (double)(ep.field_70161_v - (double)z - 0.5));
        double pitch = 90.0 - angs[1];
        double yaw = -angs[2];
        ReikaRenderHelper.setCameraPosition((EntityPlayer)ep, (double)ep.field_70165_t, (double)ep.field_70163_u, (double)ep.field_70161_v, (double)ep.field_70165_t, (double)ep.field_70163_u, (double)ep.field_70161_v, (double)yaw, (double)yaw, (double)pitch, (double)pitch, (boolean)false, (boolean)true);
    }

    private static enum EventType {
        FLARES(0.0, 0.0),
        RAY(12.5, 2.0),
        PARTICLECLOUD(1.5625, 1.0),
        PARTICLERING(4.17, 1.5),
        TWIRL(3.125, 1.0);

        private static final EventType[] list;
        public final double tickChance;
        public final double powerFactor;

        private EventType(double c, double f) {
            this.tickChance = c;
            this.powerFactor = f;
        }

        @SideOnly(value=Side.CLIENT)
        public void doEventClient(World world, int x, int y, int z, int count, int tick) {
            switch (this) {
                case FLARES: {
                    ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.USE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)2.0f, (boolean)false);
                    int n = 32 + rand.nextInt(48);
                    for (int i = 0; i < n; ++i) {
                        double phi = rand.nextDouble() * 360.0;
                        double theta = rand.nextDouble() * 360.0;
                        double v = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.5);
                        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)v, (double)theta, (double)phi);
                        EntityFlareFX fx = new EntityFlareFX(CrystalElement.elements[count % 16], world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, xyz[0], xyz[1], xyz[2]).setScale(6.0f);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    break;
                }
                case RAY: {
                    CrystalElement e = CrystalElement.randomElement();
                    float p = (float)CrystalMusicManager.instance.getDingPitchScale(e);
                    ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.MONUMENTRAY, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)p, (boolean)false);
                    Coordinate c = TileEntityDimensionCore.getLocation(e).offset(x, y, z);
                    DecimalPosition end = new DecimalPosition((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
                    LightningBolt b = new LightningBolt(new DecimalPosition((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), end, 8);
                    b.variance = 0.675;
                    b.update();
                    int l = 5 + rand.nextInt(20);
                    for (int i = 0; i < b.nsteps; ++i) {
                        DecimalPosition pos1 = b.getPosition(i);
                        DecimalPosition pos2 = b.getPosition(i + 1);
                        for (double r = 0.0; r <= 1.0; r += 0.03125) {
                            float s = 5.0f;
                            int clr = e.getColor();
                            DecimalPosition dd = DecimalPosition.interpolate((DecimalPosition)pos1, (DecimalPosition)pos2, (double)r);
                            EntityBlurFX fx = new EntityBlurFX(world, dd.xCoord, dd.yCoord, dd.zCoord).setScale(s).setColor(clr).setLife(l).setRapidExpand();
                            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                            EntityBlurFX fx2 = new EntityBlurFX(world, dd.xCoord, dd.yCoord, dd.zCoord).setScale(s / 2.5f).setColor(0xFFFFFF).setLife(l).setRapidExpand();
                            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
                        }
                    }
                    break;
                }
                case PARTICLECLOUD: {
                    ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.CAST, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)0.5f, (boolean)false);
                    int n = 64 + rand.nextInt(256);
                    for (int i = 0; i < n; ++i) {
                        double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)20.0);
                        double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)20.0);
                        double dy = 1 + world.func_72825_h(MathHelper.func_76128_c((double)dx), MathHelper.func_76128_c((double)dz)) + rand.nextInt(12);
                        int l = 20 + rand.nextInt(40);
                        float s = 2.0f + rand.nextFloat() * 12.0f;
                        double hue = ReikaPhysicsHelper.cartesianToPolar((double)(dx - (double)x - 0.5), (double)(dy - (double)y - 0.5), (double)(dz - (double)z - 0.5))[2];
                        int c = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)((int)hue));
                        EntityBlurFX fx = new EntityBlurFX(world, dx, dy, dz).setScale(s).setColor(c).setLife(l).setRapidExpand().setIcon(ChromaIcons.BIGFLARE);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    break;
                }
                case PARTICLERING: {
                    ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.USE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)0.5f, (boolean)false);
                    double r = 33.0;
                    for (double a = 0.0; a < 360.0; a += 1.0) {
                        double dx = (double)x + 0.5 * r * Math.cos(Math.toRadians(a));
                        double dz = (double)z + 0.5 * r * Math.sin(Math.toRadians(a));
                        double dy = (double)y + 0.5 + 6.0;
                        float s = (1.0f + rand.nextFloat()) * 4.0f;
                        int c = CrystalElement.getBlendedColor((int)((a + 180.0 - 12.25) * 2.0), 45);
                        int l = 60 + rand.nextInt(40);
                        float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
                        EntityBlurFX fx = new EntityBlurFX(world, dx, dy, dz).setScale(s).setColor(c).setLife(l).setRapidExpand().setGravity(g).setIcon(ChromaIcons.CENTER);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    break;
                }
                case TWIRL: {
                    for (int i = 0; i <= 8; i += 4) {
                        for (double a = 0.0; a < 360.0; a += (double)(60 / (1 + i / 4))) {
                            double r = 2 + i;
                            double ang = a + (double)i * 22.5;
                            double dx = (double)x + 0.5 * r * Math.cos(Math.toRadians(ang));
                            double dz = (double)z + 0.5 * r * Math.sin(Math.toRadians(ang));
                            double dy = (double)y + 0.5 - 4.0;
                            float s = (float)((4.0 - r / 8.0) * 2.0) / 2.0f;
                            int c = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)((int)ang));
                            int l = 120 + rand.nextInt(120);
                            SpiralMotionController m = new SpiralMotionController((double)x + 0.5, (double)z + 0.5, 5.0 - (double)i / 4.0, 0.25 * (1.0 + (double)i / 4.0) / 4.0, r, 0.0625, ang);
                            AngleColorController clr = new AngleColorController((double)x + 0.5, (double)z + 0.5, 5.0 - (double)i / 4.0, 0.25 * (1.0 + (double)i / 4.0) / 4.0, r, 0.0625, ang);
                            EntityBlurFX fx = new EntityBlurFX(world, dx, dy, dz).setScale(s).setColor(c).setLife(l).setRapidExpand().setMotionController((MotionController)m).setPositionController((PositionController)m).setColorController(clr);
                            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                        }
                    }
                    break;
                }
            }
        }

        static {
            list = EventType.values();
        }
    }
}

