/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.TileEntity.Transport.TileEntityFluidRelay;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class FluidNetwork {
    private static final PushSorter pushSorter = new PushSorter();
    private static final SuckSorter suckSorter = new SuckSorter();
    private final ArrayList<PressureData> relays = new ArrayList();
    private final ArrayList<PressureData> pushers = new ArrayList();
    private final ArrayList<PressureData> suckers = new ArrayList();
    private long lastUpdate;

    public void merge(FluidNetwork net, World world) {
        if (net != null && net != this) {
            for (PressureData p : net.relays) {
                TileEntityFluidRelay te = p.getTile(world);
                this.add(te);
                te.assignNetwork(this);
            }
            net.clear();
        }
    }

    private void clear() {
        this.relays.clear();
        this.pushers.clear();
        this.suckers.clear();
    }

    public void add(TileEntityFluidRelay te) {
        PressureData p = new PressureData(te);
        if (this.relays.contains(p)) {
            return;
        }
        this.relays.add(p);
        Collections.sort(this.relays, suckSorter);
        if (p.pressure > 0) {
            this.pushers.add(p);
            Collections.sort(this.pushers, pushSorter);
        } else if (p.pressure < 0) {
            this.suckers.add(p);
            Collections.sort(this.suckers, suckSorter);
        }
    }

    public void remove(TileEntityFluidRelay te) {
        PressureData p = new PressureData(te);
        this.relays.remove(p);
        this.pushers.remove(p);
        this.suckers.remove(p);
    }

    public void updateState(TileEntityFluidRelay te) {
        this.remove(te);
        this.add(te);
    }

    public void update(World world) {
        if (this.lastUpdate != world.func_82737_E()) {
            this.doUpdate(world);
        }
        this.lastUpdate = world.func_82737_E();
    }

    private void doUpdate(World world) {
        TileEntityFluidRelay te;
        PressureData p;
        Iterator<PressureData> it = this.pushers.iterator();
        while (it.hasNext()) {
            p = it.next();
            te = p.getTile(world);
            if (te == null) {
                it.remove();
                continue;
            }
            this.tryPush(te);
        }
        it = this.suckers.iterator();
        while (it.hasNext()) {
            p = it.next();
            te = p.getTile(world);
            if (te == null) {
                it.remove();
                continue;
            }
            this.trySuck(te);
        }
    }

    private void tryPush(TileEntityFluidRelay te) {
        te.pushFluids();
    }

    private void trySuck(TileEntityFluidRelay te) {
        te.suckFluids();
    }

    public int suck(World world, Fluid f, int max) {
        int ret = 0;
        Iterator<PressureData> it = this.relays.iterator();
        while (it.hasNext()) {
            PressureData p = it.next();
            if (p.pressure < 0) continue;
            TileEntityFluidRelay te = p.getTile(world);
            if (te == null) {
                it.remove();
                continue;
            }
            int amt = te.suckFluid(f, max);
            if (amt <= 0) continue;
            ret += amt;
            if ((max -= amt) != 0) continue;
            break;
        }
        return ret;
    }

    public int push(World world, Fluid f, int max) {
        int ret = 0;
        Iterator<PressureData> it = this.relays.iterator();
        while (it.hasNext()) {
            PressureData p = it.next();
            if (p.pressure > 0) continue;
            TileEntityFluidRelay te = p.getTile(world);
            if (te == null) {
                it.remove();
                continue;
            }
            int amt = te.pushFluid(f, max);
            if (amt <= 0) continue;
            ret += amt;
            if ((max -= amt) != 0) continue;
            break;
        }
        return ret;
    }

    private static class PushSorter
    implements Comparator<PressureData> {
        private PushSorter() {
        }

        @Override
        public int compare(PressureData o1, PressureData o2) {
            return -Integer.compare(o1.pressure, o2.pressure);
        }
    }

    private static class SuckSorter
    implements Comparator<PressureData> {
        private SuckSorter() {
        }

        @Override
        public int compare(PressureData o1, PressureData o2) {
            return Integer.compare(o1.pressure, o2.pressure);
        }
    }

    private static class PressureData {
        private final Coordinate location;
        private final int pressure;

        private PressureData(TileEntityFluidRelay te) {
            this.location = new Coordinate((TileEntity)te);
            this.pressure = te.getPressure();
        }

        private TileEntityFluidRelay getTile(World world) {
            return (TileEntityFluidRelay)this.location.getTileEntity(world);
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof PressureData && ((PressureData)o).location.equals((Object)this.location);
        }

        public String toString() {
            return this.location.toString() + ": " + this.pressure;
        }
    }
}

