/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ProgressionTrigger;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ExplorationMonitor
implements TickRegistry.TickHandler {
    public static final ExplorationMonitor instance = new ExplorationMonitor();

    private ExplorationMonitor() {
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        EntityPlayer ep = (EntityPlayer)tickData[0];
        World world = ep.field_70170_p;
        if (!world.field_72995_K) {
            MovingObjectPosition mov = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)4.0, (boolean)true);
            if (mov != null) {
                Block b;
                TileEntityCrystalPylon te;
                int x = mov.field_72311_b;
                int y = mov.field_72312_c;
                int z = mov.field_72309_d;
                if (ChromaTiles.getTile((IBlockAccess)world, x, y, z) == ChromaTiles.PYLON && (te = (TileEntityCrystalPylon)world.func_147438_o(x, y, z)).hasStructure()) {
                    ProgressionManager.instance.setPlayerDiscoveredColor(ep, te.getColor(), true, true);
                }
                if ((b = world.func_147439_a(x, y, z)) instanceof ProgressionTrigger) {
                    ProgressionManager.ProgressStage[] ps = ((ProgressionTrigger)b).getTriggers(ep, world, x, y, z);
                    if (ps != null) {
                        for (int i = 0; i < ps.length; ++i) {
                            ProgressionManager.ProgressStage p = ps[i];
                            p.stepPlayerTo(ep);
                        }
                    }
                } else if (b == Blocks.field_150357_h && y < 6) {
                    ProgressionManager.ProgressStage.BEDROCK.stepPlayerTo(ep);
                }
            }
            if (ep.field_70170_p.field_73011_w.field_76574_g == -1 && ep.field_70163_u > 128.0) {
                ProgressionManager.ProgressStage.NETHERROOF.stepPlayerTo(ep);
            }
        }
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.PLAYER);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.START;
    }

    public String getLabel() {
        return "ChromatiCraft Exploration Monitor";
    }
}

