/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Command;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;

public class ChromabilityCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        ArrayList ac;
        EntityPlayerMP ep = ChromabilityCommand.func_71521_c((ICommandSender)ics);
        String player = args[0];
        String id = args[1];
        String act = args[2];
        EntityPlayer target = ep.field_70170_p.func_72924_a(player);
        if (target == null) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)(EnumChatFormatting.RED + "No such player '" + player + "'"));
            return;
        }
        boolean all = id.equals("all");
        ArrayList arrayList = ac = all ? Chromabilities.getAbilities() : ReikaJavaLibrary.makeListFrom((Object)Chromabilities.getAbility(id));
        if (!all && ac.get(0) == null) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)(EnumChatFormatting.RED + "No such ability id '" + id + "'"));
            return;
        }
        try {
            Action action = Action.valueOf(act.toUpperCase());
            for (AbilityAPI.Ability a : ac) {
                action.perform(target, (EntityPlayer)ep, a);
            }
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Action '" + act + "' with ability '" + id + "' performed on player '" + player + "'"));
        }
        catch (IllegalArgumentException e) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)(EnumChatFormatting.RED + "No such action '" + act + "'"));
        }
    }

    public String getCommandString() {
        return "setability";
    }

    protected boolean isAdminOnly() {
        return true;
    }

    private static enum Action {
        GIVE,
        REMOVE,
        GET;


        private void perform(EntityPlayer ep, EntityPlayer sender, AbilityAPI.Ability a) {
            switch (this) {
                case GIVE: {
                    Chromabilities.give(ep, a);
                    break;
                }
                case REMOVE: {
                    Chromabilities.removeFromPlayer(ep, a);
                    break;
                }
                case GET: {
                    HashMap<AbilityAPI.Ability, Boolean> c = Chromabilities.getAbilitiesOn(ep);
                    ReikaChatHelper.sendChatToPlayer((EntityPlayer)sender, (String)("Abilities for " + ep + ":\n" + c.toString()));
                }
            }
        }
    }
}

