/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Block.BlockSelectiveGlass;
import Reika.ChromatiCraft.Block.Worldgen.BlockCliffStone;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.ChromaGuiHandler;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityBallLightning;
import Reika.ChromatiCraft.Magic.CrystalTarget;
import Reika.ChromatiCraft.Magic.Interfaces.ChargingPoint;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.TargetData;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaEntities;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.ChromatiCraft.World.BiomeRainbowForest;
import Reika.ChromatiCraft.World.Dimension.WorldProviderChroma;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Worldgen.GenerationInterceptWorld;
import Reika.DragonAPI.Interfaces.Entity.CustomProjectile;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import Reika.DragonAPI.Libraries.World.ReikaChunkHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BloodMagicHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ChiselBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.Fluid;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public class ChromaAux {
    public static final Color[] sideColors = new Color[]{Color.CYAN, Color.BLUE, Color.YELLOW, Color.BLACK, new Color(255, 120, 0), Color.MAGENTA};
    public static final String[] sideColorNames = new String[]{"CYAN", "BLUE", "YELLOW", "BLACK", "ORANGE", "MAGENTA"};
    private static final GenerationInterceptWorld cliffRelayWorld = new GenerationInterceptWorld();
    private static final GenerationInterceptWorld rainbowRelayWorld = new GenerationInterceptWorld();

    public static void interceptChunkPopulation(int cx, int cz, World world, IChunkProvider generator, IChunkProvider loader) {
        if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            ((WorldProviderChroma)world.field_73011_w).getChunkGenerator().onPopulationHook(generator, loader, cx, cz);
        } else if (ReikaChunkHelper.chunkContainsBiomeType((World)world, (int)cx, (int)cz, BiomeGlowingCliffs.class)) {
            cliffRelayWorld.link(world);
            BiomeGlowingCliffs.runIWGs(cx, cz, (World)cliffRelayWorld, generator, loader);
            cliffRelayWorld.runHooks();
        } else if (ReikaChunkHelper.chunkContainsBiomeType((World)world, (int)cx, (int)cz, BiomeRainbowForest.class)) {
            rainbowRelayWorld.link(world);
            GameRegistry.generateWorld((int)cx, (int)cz, (World)rainbowRelayWorld, (IChunkProvider)generator, (IChunkProvider)loader);
            rainbowRelayWorld.runHooks();
        } else {
            GameRegistry.generateWorld((int)cx, (int)cz, (World)world, (IChunkProvider)generator, (IChunkProvider)loader);
        }
    }

    public static final boolean hasGui(World world, int x, int y, int z, EntityPlayer ep) {
        Object GUI;
        ChromaTiles m = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (GUI = ChromaGuiHandler.instance.getClientGuiElement(0, ep, world, x, y, z)) != null) {
            return true;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && (GUI = ChromaGuiHandler.instance.getServerGuiElement(0, ep, world, x, y, z)) != null;
    }

    public static int get4SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        int i;
        for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
        }
        while (i < 0) {
            i += 4;
        }
        switch (i) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    public static int get6SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        if (MathHelper.func_76135_e((float)ep.field_70125_A) < 60.0f) {
            int i;
            for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
            }
            while (i < 0) {
                i += 4;
            }
            switch (i) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 0;
                }
            }
        } else {
            if (ep.field_70125_A > 0.0f) {
                return 4;
            }
            return 5;
        }
        return -1;
    }

    public static int get2SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        int i;
        for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
        }
        while (i < 0) {
            i += 4;
        }
        switch (i) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public static boolean shouldSetFlipped(World world, int x, int y, int z) {
        boolean softBelow = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
        boolean softAbove = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y + 1), (int)z);
        return !softAbove && softBelow;
    }

    public static String getMessage(String tag) {
        return StatCollector.func_74838_a((String)("message." + tag));
    }

    public static void writeMessage(String tag) {
        ReikaChatHelper.writeString((String)ChromaAux.getMessage(tag));
    }

    public static void spawnInteractionBallLightning(World world, int x, int y, int z, CrystalElement e) {
        if (!world.field_72995_K && ChromaOptions.BALLLIGHTNING.getState()) {
            int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)16);
            int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)16);
            double dy = world.func_72825_h(dx, dz) + ReikaRandomHelper.getSafeRandomInt((int)8);
            world.func_72838_d((Entity)new EntityBallLightning(world, e, (double)dx + 0.5, dy + 0.5, (double)dz + 0.5).setNoDrops());
        }
    }

    public static boolean requiresSpecialSpawnEnforcement(EntityLiving e) {
        String name = e.getClass().getName().toLowerCase(Locale.ENGLISH);
        return name.contains("lycanite");
    }

    public static void doPylonAttack(CrystalElement color, EntityLivingBase e, float amt, boolean taperNew) {
        ChromaSounds.DISCHARGE.playSound(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, 1.0f, 1.0f);
        float originalAmt = amt;
        if (e instanceof EntityPlayer) {
            EntityPlayer ep = (EntityPlayer)e;
            ProgressionManager.ProgressStage.SHOCK.stepPlayerTo(ep);
            if (ModList.BLOODMAGIC.isLoaded()) {
                int drain = 5000;
                if (BloodMagicHandler.getInstance().isPlayerWearingFullBoundArmor(ep)) {
                    amt *= 10.0f;
                    drain = 50000;
                }
                SoulNetworkHandler.syphonFromNetwork((String)ep.func_70005_c_(), (int)drain);
            }
            if (taperNew) {
                if (e.field_70173_aa < 600) {
                    amt = 1.0f;
                } else if (e.field_70173_aa <= 1000) {
                    amt = 1 + (e.field_70173_aa - 600) / 100;
                }
            }
        }
        float last = e.func_110143_aJ();
        e.func_70097_a((DamageSource)ChromatiCraft.pylonDamage[color.ordinal()], amt);
        if (e.func_110143_aJ() > Math.max(0.0f, last - originalAmt)) {
            if (originalAmt >= last) {
                e.func_70606_j(0.1f);
                e.func_70097_a((DamageSource)ChromatiCraft.pylonDamage[color.ordinal()], Float.MAX_VALUE);
            } else {
                e.func_70606_j(last - originalAmt);
            }
        }
    }

    public static float getIslandBias(float originalBias, float dx, float dz) {
        float dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        return 50.0f + 50.0f * MathHelper.func_76126_a((float)(dist * 0.0625f));
    }

    public static MultiMap<TargetData, CrystalElement> getBeamColorMixes(Collection<CrystalTarget> c) {
        MultiMap map = new MultiMap((MultiMap.CollectionFactory)new MultiMap.ListFactory());
        for (CrystalTarget t : c) {
            map.addValue((Object)new TargetData(t), (Object)t.color);
        }
        return map;
    }

    public static void changePylonColor(World world, TileEntityCrystalPylon te, CrystalElement e) {
        try {
            ChunkCoordIntPair ch = new Coordinate((TileEntity)te).asChunkPair();
            world.func_72863_F().func_73154_d(ch.field_77276_a, ch.field_77275_b);
            TileEntityCrystalPylon old = te;
            te = (TileEntityCrystalPylon)world.func_147438_o(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            CrystalNetworker.instance.removeTile(old);
            PylonGenerator.instance.removeCachedPylon(old);
            te.setColor(e);
            BlockArray runes = te.getRuneLocations(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
            for (int i = 0; i < runes.getSize(); ++i) {
                Coordinate c = runes.getNthBlock(i);
                if (c.getBlock(te.field_145850_b) != ChromaBlocks.RUNE.getBlockInstance()) continue;
                te.field_145850_b.func_72921_c(c.xCoord, c.yCoord, c.zCoord, te.getColor().ordinal(), 3);
            }
            CrystalNetworker.instance.addTile(te);
            PylonGenerator.instance.cachePylon(te);
        }
        catch (Exception ex) {
            ChromatiCraft.logger.logError((Object)("Could not change pylon color @ " + te));
            ex.printStackTrace();
        }
    }

    public static void notifyServerPlayersExcept(EntityPlayer ep, ChromaResearchManager.ProgressElement p) {
        String sg = EnumChatFormatting.GOLD + ep.func_70005_c_() + EnumChatFormatting.RESET + " has learned something new: " + p.getFormatting() + p.getTitle();
        WorldServer[] ws = DimensionManager.getWorlds();
        for (int i = 0; i < ws.length; ++i) {
            for (EntityPlayer ep2 : ws[i].field_73010_i) {
                if (ep2 == ep) continue;
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep2, (String)sg);
            }
        }
    }

    public static void notifyServerPlayers(EntityPlayer ep, ChromaResearchManager.ProgressElement p) {
        String sg = EnumChatFormatting.GOLD + ep.func_70005_c_() + EnumChatFormatting.RESET + " has learned something new: " + p.getFormatting() + p.getTitle();
        WorldServer[] ws = DimensionManager.getWorlds();
        for (int i = 0; i < ws.length; ++i) {
            for (EntityPlayer ep2 : ws[i].field_73010_i) {
                if (ep2 != ep) {
                    ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep2, (String)sg);
                    continue;
                }
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep2, (String)("You have learned something new: " + p.getFormatting() + p.getTitle()));
            }
        }
    }

    @Deprecated
    public static void permuteRunes(HashMap<Coordinate, CrystalElement> map, World world, EntityPlayer ep) {
    }

    public static CrystalElement getRune(Fluid fluid) {
        ArrayList<CrystalElement> li = new ArrayList<CrystalElement>();
        li.add(CrystalElement.CYAN);
        if (fluid.getTemperature() > 900) {
            li.add(CrystalElement.ORANGE);
        }
        if (fluid.getTemperature() < 270) {
            li.add(CrystalElement.WHITE);
        }
        if (fluid.isGaseous()) {
            li.add(CrystalElement.LIME);
        }
        if (fluid.getLuminosity() > 0) {
            li.add(CrystalElement.BLUE);
        }
        if (fluid.getDensity() > 4000) {
            li.add(CrystalElement.RED);
        }
        if (fluid.getName().toLowerCase(Locale.ENGLISH).contains("oil")) {
            li.add(CrystalElement.BROWN);
        }
        if (fluid.getName().toLowerCase(Locale.ENGLISH).contains("fuel")) {
            li.add(CrystalElement.YELLOW);
        }
        if (fluid.getName().toLowerCase(Locale.ENGLISH).contains("xp") || fluid == ChromatiCraft.chroma) {
            li.add(CrystalElement.PURPLE);
        }
        if (fluid.getName().toLowerCase(Locale.ENGLISH).contains("bio") || fluid.getName().toLowerCase(Locale.ENGLISH).contains("honey")) {
            li.add(CrystalElement.GREEN);
        }
        return (CrystalElement)((Object)li.get(ReikaRandomHelper.getSafeRandomInt((int)li.size())));
    }

    public static boolean chargePlayerFromPylon(EntityPlayer player, ChargingPoint te, CrystalElement e, int count) {
        int energy;
        int n;
        int add = Math.max(1, (int)((float)PlayerElementBuffer.instance.getChargeSpeed(player) * te.getChargeRateMultiplier(player, e)));
        int drain = add * (n = PlayerElementBuffer.instance.getChargeInefficiency(player));
        if (drain > (energy = te.getEnergy(e))) {
            drain = energy;
            add = drain / n;
        }
        if (te.canConduct() && te.allowCharging(player, e) && add > 0 && PlayerElementBuffer.instance.canPlayerAccept(player, e, add)) {
            te.onUsedBy(player, e);
            if (PlayerElementBuffer.instance.addToPlayer(player, e, add, true)) {
                te.drain(e, drain);
            }
            ProgressionManager.ProgressStage.CHARGE.stepPlayerTo(player);
            if (te instanceof TileEntityCrystalPylon) {
                ProgressionManager.instance.setPlayerDiscoveredColor(player, ((TileEntityCrystalPylon)te).getColor(), true, true);
            }
            if (player.field_70170_p.field_72995_K) {
                ChromaFX.createPylonChargeBeam(te, player, (double)(count % 20) / 20.0, e);
            }
            return true;
        }
        return false;
    }

    public static List<AxisAlignedBB> interceptEntityCollision(World world, Entity e, AxisAlignedBB box) {
        if (e instanceof EntityPlayer && Chromabilities.ORECLIP.enabledOn((EntityPlayer)e)) {
            return AbilityHelper.instance.getNoclipBlockBoxes((EntityPlayer)e);
        }
        return ChromaAux.getSurrogateCollidingAABBs(world, e, box);
    }

    public static List<AxisAlignedBB> getSurrogateCollidingAABBs(World world, Entity ep, AxisAlignedBB box) {
        ArrayList<AxisAlignedBB> li = new ArrayList<AxisAlignedBB>();
        int i = MathHelper.func_76128_c((double)box.field_72340_a);
        int j = MathHelper.func_76128_c((double)(box.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)box.field_72338_b);
        int l = MathHelper.func_76128_c((double)(box.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)box.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(box.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!world.func_72899_e(k1, 64, l1)) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = k1 >= -30000000 && k1 < 30000000 && l1 >= -30000000 && l1 < 30000000 ? world.func_147439_a(k1, i2, l1) : Blocks.field_150348_b;
                    block.func_149743_a(world, k1, i2, l1, box, li, ep);
                }
            }
        }
        double d0 = 0.25;
        List list = world.func_72839_b(ep, box.func_72314_b(d0, d0, d0));
        for (Entity e : list) {
            AxisAlignedBB box2 = e.func_70046_E();
            if (box2 != null && box2.func_72326_a(box)) {
                li.add(box2);
            }
            if ((box2 = ep.func_70114_g(e)) == null || !box2.func_72326_a(box)) continue;
            li.add(box2);
        }
        return li;
    }

    public static boolean applyNoclipPhase(EntityPlayer ep) {
        return ep.field_70145_X || Chromabilities.ORECLIP.enabledOn(ep);
    }

    public static AxisAlignedBB getInterceptedCollisionBox(Entity e, World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == ChromaBlocks.SELECTIVEGLASS.getBlockInstance() && (e instanceof IProjectile || e instanceof EntityFireball || e instanceof CustomProjectile) ? BlockSelectiveGlass.canEntityPass(world, x, y, z, e) : (e instanceof IProjectile || e instanceof EntityFireball || e instanceof CustomProjectile) && AbilityHelper.instance.canProjectilePenetrateBlock(world, x, y, z, b, e)) {
            return null;
        }
        return b.func_149668_a(world, x, y, z);
    }

    public static MovingObjectPosition getInterceptedRaytrace(Entity e, Vec3 vec1, Vec3 vec2) {
        return ChromaAux.getInterceptedRaytrace(e, vec1, vec2, false, false, false);
    }

    public static MovingObjectPosition getInterceptedRaytrace(Entity e, Vec3 vec1, Vec3 vec2, boolean b1, boolean b2, boolean b3) {
        if ((e instanceof IProjectile || e instanceof EntityFireball || e instanceof CustomProjectile) && AbilityHelper.instance.canProjectilePenetrateBlocks(e)) {
            return AbilityHelper.instance.getProjectileRayTrace(e, vec1, vec2, b1, b2, b3);
        }
        return e.field_70170_p.func_147447_a(vec1, vec2, b1, b2, b3);
    }

    public static BlockLootChest.TileEntityLootChest generateLootChest(World world, int x, int y, int z, int m, String s, int bonus) {
        world.func_147465_d(x, y, z, ChromaBlocks.LOOTCHEST.getBlockInstance(), m, 3);
        BlockLootChest.TileEntityLootChest te = (BlockLootChest.TileEntityLootChest)world.func_147438_o(x, y, z);
        te.populateChest(s, null, bonus, world.field_73012_v);
        return te;
    }

    public static int groundOpacity(IBlockAccess iba, int x, int y, int z, Block b) {
        World w;
        if (iba instanceof World && !ReikaWorldHelper.isChunkPastNoiseGen((World)(w = (World)iba), (int)(x >> 4), (int)(z >> 4))) {
            return 255;
        }
        Block b2 = b;
        while (y >= 0 && (b2 == b || b2 == Blocks.field_150346_d)) {
            b2 = iba.func_147439_a(x, --y, z);
        }
        return b2 == ChromaBlocks.CLIFFSTONE.getBlockInstance() && BlockCliffStone.isTransparent(iba, x, y, z) ? 0 : 255;
    }

    static {
        if (ModList.THAUMCRAFT.isLoaded()) {
            cliffRelayWorld.addHook((GenerationInterceptWorld.TileHook)new NodeHook());
            cliffRelayWorld.addHook((GenerationInterceptWorld.TileHook)new WispSpawnerHook());
            rainbowRelayWorld.addHook((GenerationInterceptWorld.TileHook)new NodeHook2());
            rainbowRelayWorld.disallowBlock(ThaumItemHelper.BlockEntry.TOTEM.getBlock());
        }
        rainbowRelayWorld.addHook((GenerationInterceptWorld.TileHook)new WeakSpawnerHook());
        if (ModList.CHISEL.isLoaded()) {
            cliffRelayWorld.disallowBlockChange(ChromaBlocks.CLIFFSTONE.getBlockInstance(), ChiselBlockHandler.BlockEntry.DIORITE.getBlock());
            cliffRelayWorld.disallowBlockChange(ChromaBlocks.CLIFFSTONE.getBlockInstance(), ChiselBlockHandler.BlockEntry.ANDESITE.getBlock());
            cliffRelayWorld.disallowBlockChange(ChromaBlocks.CLIFFSTONE.getBlockInstance(), ChiselBlockHandler.BlockEntry.GRANITE.getBlock());
            cliffRelayWorld.disallowBlockChange(ChromaBlocks.CLIFFSTONE.getBlockInstance(), ChiselBlockHandler.BlockEntry.MARBLE.getBlock());
            cliffRelayWorld.disallowBlockChange(ChromaBlocks.CLIFFSTONE.getBlockInstance(), ChiselBlockHandler.BlockEntry.SANDSTONE.getBlock());
            cliffRelayWorld.disallowBlockChange(ChromaBlocks.CLIFFSTONE.getBlockInstance(), ChiselBlockHandler.BlockEntry.LIMESTONE.getBlock());
        }
    }

    private static class WeakSpawnerHook
    implements GenerationInterceptWorld.TileHook {
        private WeakSpawnerHook() {
        }

        public void onTileChanged(TileEntity te) {
            if (te instanceof TileEntityMobSpawner) {
                TileEntityMobSpawner tm = (TileEntityMobSpawner)te;
                MobSpawnerBaseLogic lgc = tm.func_145881_a();
                lgc.field_98289_l = 6;
                lgc.field_98283_g *= 2;
                lgc.field_98293_h *= 4;
            }
        }

        public boolean shouldRun(World world, int x, int y, int z) {
            return ChromatiCraft.isRainbowForest(world.func_72807_a(x, z));
        }
    }

    private static class NodeHook2
    implements GenerationInterceptWorld.TileHook {
        private NodeHook2() {
        }

        public void onTileChanged(TileEntity te) {
            if (InterfaceCache.NODE.instanceOf((Object)te)) {
                INode n = (INode)te;
                n.setNodeType(NodeType.NORMAL);
                n.setNodeModifier(NodeModifier.BRIGHT);
                if (te.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    float f = 2.0f + te.field_145850_b.field_73012_v.nextFloat() * 4.0f;
                    AspectList al = n.getAspects();
                    for (Aspect a : new HashSet(al.aspects.keySet())) {
                        al.aspects.put(a, (int)(f * (float)al.getAmount(a)));
                    }
                }
            }
        }

        public boolean shouldRun(World world, int x, int y, int z) {
            return ChromatiCraft.isRainbowForest(world.func_72807_a(x, z));
        }
    }

    private static class NodeHook
    implements GenerationInterceptWorld.TileHook {
        private NodeHook() {
        }

        public void onTileChanged(TileEntity te) {
            if (InterfaceCache.NODE.instanceOf((Object)te)) {
                INode n = (INode)te;
                n.setNodeType(NodeType.NORMAL);
                n.setNodeModifier(NodeModifier.BRIGHT);
                if (te.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    float f = 1.0f + te.field_145850_b.field_73012_v.nextFloat() * 2.0f;
                    AspectList al = n.getAspects();
                    for (Aspect a : new HashSet(al.aspects.keySet())) {
                        al.aspects.put(a, (int)(f * (float)al.getAmount(a)));
                    }
                }
            }
        }

        public boolean shouldRun(World world, int x, int y, int z) {
            return BiomeGlowingCliffs.isGlowingCliffs(world.func_72807_a(x, z));
        }
    }

    private static class WispSpawnerHook
    implements GenerationInterceptWorld.TileHook {
        private WispSpawnerHook() {
        }

        public void onTileChanged(TileEntity te) {
            TileEntityMobSpawner tm;
            if (te instanceof TileEntityMobSpawner && ReikaSpawnerHelper.getMobSpawnerMobName((TileEntityMobSpawner)(tm = (TileEntityMobSpawner)te)).toLowerCase(Locale.ENGLISH).contains("wisp")) {
                ReikaSpawnerHelper.setMobSpawnerMob((TileEntityMobSpawner)tm, (String)ChromaEntities.GLOWCLOUD.entityName);
            }
        }

        public boolean shouldRun(World world, int x, int y, int z) {
            return BiomeGlowingCliffs.isGlowingCliffs(world.func_72807_a(x, z));
        }
    }
}

