/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Ability;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

class LossCache {
    private static final Random rand = new Random();
    private final Collection<AbilityAPI.Ability> savedAbilities = new ArrayList<AbilityAPI.Ability>();
    private final ElementTagCompound savedEnergy = new ElementTagCompound();
    private int cap;
    private static final double INIT_CHANCE = 10.0;
    private static final double INC_CHANCE = 5.0;
    private static final double MAX_CHANCE = 80.0;
    static final String NBT_TAG = "bufferDeathChance";

    LossCache(EntityPlayer ep) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        double chance = nbt.func_74769_h(NBT_TAG);
        if (!nbt.func_74764_b(NBT_TAG)) {
            chance = 10.0;
        } else if ((chance += 5.0) > 80.0) {
            chance = 80.0;
        }
        nbt.func_74780_a(NBT_TAG, chance);
        for (AbilityAPI.Ability a : Chromabilities.getAvailableFrom(ep)) {
            if (a != Chromabilities.DEATHPROOF && !ReikaRandomHelper.doWithChance((double)chance)) continue;
            this.savedAbilities.add(a);
        }
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            int max = PlayerElementBuffer.instance.getPlayerContent(ep, e);
            if (max <= 0) continue;
            double ratio = 1.0 / (double)(2 + rand.nextInt(3));
            double nrat = 1.0 - ratio;
            int random = (int)((double)max * nrat);
            int save = (int)((double)max * ratio) + rand.nextInt(random);
            save = (int)((double)save * (chance / 100.0));
            this.savedEnergy.addTag(e, save);
        }
        this.cap = 24;
        int max = this.savedEnergy.getMaximumValue();
        while (this.cap < max) {
            this.cap *= 4;
        }
    }

    void applyToPlayer(EntityPlayer player) {
        PlayerElementBuffer.instance.setElementCap(player, this.cap, false);
        for (CrystalElement e : this.savedEnergy.elementSet()) {
            PlayerElementBuffer.instance.addToPlayer(player, e, this.savedEnergy.getValue(e), false);
        }
        for (AbilityAPI.Ability a : this.savedAbilities) {
            Chromabilities.give(player, a);
        }
    }
}

