/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.util;

import me.modmuss50.fr.repack.kotlin.jvm.functions.Function1;
import me.modmuss50.fr.repack.kotlin.jvm.internal.DefaultConstructorMarker;
import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.util.Check;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public abstract class ReturnsCheck
implements Check {
    @NotNull
    private final String description;
    @NotNull
    private final String name;
    @NotNull
    private final Function1<KotlinBuiltIns, KotlinType> type;

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        return Intrinsics.areEqual(functionDescriptor.getReturnType(), this.type.invoke(DescriptorUtilsKt.getBuiltIns(functionDescriptor)));
    }

    private ReturnsCheck(String name, Function1<? super KotlinBuiltIns, ? extends KotlinType> type2) {
        this.name = name;
        this.type = type2;
        this.description = "must return " + this.name;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }

    public /* synthetic */ ReturnsCheck(@NotNull String name, @NotNull Function1 type2, DefaultConstructorMarker $constructor_marker) {
        this(name, type2);
    }

    public static final class ReturnsBoolean
    extends ReturnsCheck {
        public static final ReturnsBoolean INSTANCE;

        private ReturnsBoolean() {
            super("Boolean", 1.INSTANCE, null);
            INSTANCE = this;
        }

        static {
            new ReturnsBoolean();
        }
    }

    public static final class ReturnsInt
    extends ReturnsCheck {
        public static final ReturnsInt INSTANCE;

        private ReturnsInt() {
            super("Int", 1.INSTANCE, null);
            INSTANCE = this;
        }

        static {
            new ReturnsInt();
        }
    }

    public static final class ReturnsUnit
    extends ReturnsCheck {
        public static final ReturnsUnit INSTANCE;

        private ReturnsUnit() {
            super("Unit", 1.INSTANCE, null);
            INSTANCE = this;
        }

        static {
            new ReturnsUnit();
        }
    }
}

