/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.kotlin;

import me.modmuss50.fr.repack.kotlin._Assertions;
import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public final class JavaClassDataFinder
implements ClassDataFinder {
    @NotNull
    private final KotlinClassFinder kotlinClassFinder;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinClass2 = kotlinJvmBinaryClass;
        boolean bl = Intrinsics.areEqual(kotlinClass2.getClassId(), classId);
        if (_Assertions.ENABLED && !bl) {
            String string = "Class with incorrect id found: expected " + classId + ", actual " + kotlinClass2.getClassId();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.deserializedDescriptorResolver.readClassData$kotlin_core(kotlinClass2);
    }

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkParameterIsNotNull(kotlinClassFinder, "me.modmuss50.fr.repack.kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull(deserializedDescriptorResolver, "deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }
}

