/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.world;

import com.miningmark48.pearcelmod.handler.ConfigurationHandler;
import com.miningmark48.pearcelmod.utility.WorldTools;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.IWorldGenerator;

public class StructureGenPearcel3
implements IWorldGenerator {
    public static final ResourceLocation STRUCTURE = new ResourceLocation("pearcelmod", "Pearcel3");
    public static final ResourceLocation LOOT2 = new ResourceLocation("pearcelmod", "pearcel1_loot2");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        if (!(world instanceof WorldServer)) {
            return;
        }
        if (!ConfigurationHandler.enableStructure3) {
            return;
        }
        WorldServer serverworld = (WorldServer)world;
        int x = chunkX * 16 + random.nextInt(16);
        BlockPos xzPos = new BlockPos(x, 1, z = chunkZ * 16 + random.nextInt(16));
        Biome biome = world.getBiomeForCoordsBody(xzPos);
        if ((biome == Biomes.field_76772_c || biome == Biomes.field_76769_d || biome == Biomes.field_76770_e || biome == Biomes.field_76767_f || biome == Biomes.field_76785_t) && random.nextInt(ConfigurationHandler.structureRarity1) == 2) {
            BlockPos pos = new BlockPos(x, WorldTools.findEmptySpot(world, x, z) + 1, z);
            StructureGenPearcel3.generateStructure(serverworld, pos, random);
        }
    }

    public static void generateStructure(WorldServer world, BlockPos pos, Random random) {
        MinecraftServer server = world.func_73046_m();
        Template template = world.func_184163_y().func_186237_a(server, STRUCTURE);
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(Rotation.NONE);
        template.func_186253_b((World)world, pos, settings);
        Map dataBlocks = template.func_186258_a(pos, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            String[] tokens = ((String)entry.getValue()).split(" ");
            if (tokens.length == 0) {
                return;
            }
            BlockPos dataPos = (BlockPos)entry.getKey();
            String s = tokens[0].toLowerCase();
            if (!s.equals("lootchest2")) continue;
            String chestOrientation = tokens[1];
            EnumFacing chestFacing = settings.func_186215_c().func_185831_a(EnumFacing.func_176739_a((String)chestOrientation));
            IBlockState chestState = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)chestFacing);
            world.func_175656_a(dataPos, chestState);
            TileEntity tile = world.func_175625_s(dataPos);
            if (tile == null || !(tile instanceof TileEntityLockableLoot)) continue;
            ((TileEntityLockableLoot)tile).func_189404_a(LOOT2, random.nextLong());
        }
    }
}

