/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.init;

import com.google.common.base.Predicate;
import com.miningmark48.pearcelmod.handler.ConfigurationHandler;
import com.miningmark48.pearcelmod.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, random, chunkX, chunkZ);
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX, chunkZ);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX, chunkZ);
            }
        }
    }

    private void generateNether(World world, Random rand, int x, int z) {
        if (ConfigurationHandler.doWorldGen) {
            this.generateOre(ModBlocks.nether_pearcel_ore, world, rand, x, z, 3, 6, 15, 10, 60, Blocks.field_150424_aL);
        }
    }

    private void generateSurface(World world, Random rand, int x, int z) {
        if (ConfigurationHandler.doWorldGen) {
            this.generateOre(ModBlocks.pearcel_ore, world, rand, x, z, 2, 6, 10, 10, 70, Blocks.field_150348_b);
            this.generateOre(ModBlocks.fools_pearcel_ore, world, rand, x, z, 2, 6, 15, 35, 65, Blocks.field_150348_b);
            this.generateOre(ModBlocks.pearcel_matter_ore, world, rand, x, z, 2, 4, 5, 10, 40, Blocks.field_150348_b);
            this.generateOre(ModBlocks.dense_pearcel_ore, world, rand, x, z, 2, 6, 10, 10, 30, Blocks.field_150348_b);
            this.generateOre(ModBlocks.dense_pearcel_matter_ore, world, rand, x, z, 1, 3, 5, 5, 15, Blocks.field_150348_b);
        }
        if (ConfigurationHandler.doSpecialWorldGen) {
            this.generateOre(ModBlocks.pearcel_stone, world, rand, x, z, 1, 15, 20, 10, 64, Blocks.field_150348_b);
            this.generateOre(ModBlocks.pearcel_sand, world, rand, x, z, 1, 50, 30, 10, 64, (Block)Blocks.field_150354_m);
        }
    }

    private void generateEnd(World world, Random rand, int x, int z) {
        if (ConfigurationHandler.doWorldGen) {
            this.generateOre(ModBlocks.ender_pearcel_ore, world, rand, x, z, 3, 12, 10, 10, 60, Blocks.field_150377_bs);
        }
    }

    public void generateOre(Block block, World world, Random random, int chunkX, int chunkZ, int minVeinSize, int maxVeinSize, int chance, int minY, int maxY, Block generateIn) {
        int veinSize = minVeinSize + random.nextInt(maxVeinSize - minVeinSize);
        int heightRange = maxY - minY;
        WorldGenMinable gen = new WorldGenMinable(block.func_176223_P(), veinSize, (Predicate)BlockMatcher.func_177642_a((Block)generateIn));
        for (int i = 0; i < chance; ++i) {
            int xRand = chunkX * 16 + random.nextInt(16);
            int yRand = random.nextInt(heightRange) + minY;
            int zRand = chunkZ * 16 + random.nextInt(16);
            gen.func_180709_b(world, random, new BlockPos(xRand, yRand, zRand));
        }
    }
}

