/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.entity;

import com.miningmark48.pearcelmod.item.ItemThrowPearcel;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityThrowPearcel
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public ItemThrowPearcel.TYPE type;
    private BlockPos originPos;
    private EntityLivingBase thrower;

    public EntityThrowPearcel(World worldIn) {
        super(worldIn);
    }

    public EntityThrowPearcel(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityThrowPearcel(World worldIn, EntityLivingBase throwerIn, ItemThrowPearcel.TYPE type) {
        super(worldIn, throwerIn);
        this.type = type;
        this.originPos = throwerIn.func_180425_c();
        this.thrower = throwerIn;
    }

    protected void func_70184_a(@Nonnull RayTraceResult result) {
        if (this.type != null) {
            switch (this.type) {
                case EXPLOSIVE: {
                    this.doExplosion(6.0f);
                    break;
                }
                case ENTITY_TP: {
                    this.doTP(result);
                    break;
                }
                case ENTITY_LAUNCH: {
                    this.doLaunch(result, 2.25);
                    break;
                }
                case ENTITY_MOUNT: {
                    this.doMount(result);
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.func_70106_y();
        }
    }

    private void doExplosion(float strength) {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true);
        }
    }

    private void doTP(RayTraceResult result) {
        if (!this.func_130014_f_().field_72995_K && result.field_72308_g != null) {
            result.field_72308_g.func_70107_b((double)this.originPos.func_177958_n(), (double)this.originPos.func_177956_o(), (double)this.originPos.func_177952_p());
        }
    }

    private void doLaunch(RayTraceResult result, double velocity) {
        if (!this.func_130014_f_().field_72995_K && result.field_72308_g != null) {
            result.field_72308_g.func_70024_g(0.0, velocity, 0.0);
        }
    }

    private void doMount(RayTraceResult result) {
        if (!this.func_130014_f_().field_72995_K && result.field_72308_g != null) {
            this.thrower.func_184220_m(result.field_72308_g);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.ensureType();
        compound.func_74768_a("type", this.type.ordinal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.type = ItemThrowPearcel.TYPE.values()[compound.func_74762_e("type")];
        this.ensureType();
    }

    public void writeSpawnData(ByteBuf buffer) {
        this.ensureType();
        buffer.writeInt(this.type.ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.type = ItemThrowPearcel.TYPE.values()[additionalData.readInt()];
        this.ensureType();
    }

    private void ensureType() {
        if (this.type == null) {
            this.type = ItemThrowPearcel.TYPE.EXPLOSIVE;
        }
    }
}

