/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.block;

import com.miningmark48.pearcelmod.block.BlockPearcelMod;
import com.miningmark48.pearcelmod.init.ModBlocks;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class BlockPearcelSpike
extends BlockPearcelMod
implements IWailaDataProvider {
    private FakePlayer fakePlayer;
    private float spike_damage;

    public BlockPearcelSpike(Float damage) {
        this.func_149752_b(2.5f);
        this.func_149711_c(1.5f);
        this.func_149675_a(true);
        this.spike_damage = damage.floatValue();
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            if (this.fakePlayer == null && !worldIn.field_72995_K) {
                this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)worldIn), (GameProfile)new GameProfile(UUID.randomUUID(), ModBlocks.pearcel_spike.func_149732_F()));
            }
            if (!(entityIn instanceof EntityPlayer)) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 1));
                entityIn.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.fakePlayer), this.spike_damage);
            }
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this.fakePlayer != null) {
            this.fakePlayer.func_70106_y();
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public float getSpikeDamage() {
        return this.spike_damage;
    }

    @Nullable
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return new ItemStack(accessor.getBlock());
    }

    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock() instanceof BlockPearcelSpike) {
            BlockPearcelSpike spike = (BlockPearcelSpike)accessor.getBlock();
            float dmg = spike.getSpikeDamage();
            if (dmg == Float.MAX_VALUE) {
                currenttip.add("Damage: \u00e2\u02c6\u017e");
            } else {
                currenttip.add("Damage: " + Math.round(dmg / 2.0f) + (Math.round(dmg / 2.0f) == 1 ? " heart" : " hearts"));
            }
        }
        return currenttip;
    }

    @Nonnull
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }
}

