/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.grue.common.handlers;

import com.shinoow.grue.Grue;
import com.shinoow.grue.common.entity.EntityDaylightGrue;
import com.shinoow.grue.common.entity.EntityGrue;
import com.shinoow.grue.common.entity.cap.GrueCapabilityProvider;
import com.shinoow.grue.common.entity.cap.IGrueTimerCapability;
import com.shinoow.grue.common.network.PacketDispatcher;
import com.shinoow.grue.common.network.client.GrueTimerMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GrueEventHandler {
    @SubscribeEvent
    public void spawnGrue(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityMob grue;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            if (player.func_175149_v()) {
                return;
            }
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            IGrueTimerCapability cap = (IGrueTimerCapability)player.getCapability(GrueCapabilityProvider.GRUE_TIMER, null);
            if (Grue.useWhitelist && this.isWhitelisted(player.field_71093_bK) || !Grue.useWhitelist || Grue.whitelist_override.contains(player.field_71093_bK)) {
                if (player.func_70013_c(1.0f) <= 0.05f && player.field_70170_p.func_175642_b(EnumSkyBlock.SKY, player.func_180425_c()) < 2) {
                    if ((player.func_70090_H() && player.func_70086_ai() == 300 && player.field_70170_p.func_180495_p(player.func_180425_c().func_177984_a()) == Blocks.field_150350_a.func_176223_P() || !player.func_70090_H()) && (Grue.dynamicLightsMode && (cap.hasDynamicLights() && this.isNotLightSource(player.func_184614_ca()) && this.isNotLightSource(player.func_184592_cb()) || !cap.hasDynamicLights()) || !Grue.dynamicLightsMode)) {
                        cap.incrementTimer();
                        if (cap.getTimer() % 40 == 0) {
                            player.field_70170_p.func_184133_a(null, player.func_180425_c(), Grue.grue_whisper, SoundCategory.HOSTILE, 2.0f, 1.0f);
                        }
                        if (cap.getTimer() % 40 == 0) {
                            PacketDispatcher.sendTo(new GrueTimerMessage(player), (EntityPlayerMP)player);
                        }
                        if (cap.getTimer() >= Grue.spawnTimer * 20 - 40 && this.flyingCloseEnough(player)) {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 10));
                            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 200, 10));
                            if (cap.getTimer() % 2 == 0) {
                                player.field_70170_p.func_184133_a(null, player.func_180425_c(), Grue.grue_spawn, SoundCategory.HOSTILE, 2.0f, 1.0f);
                            }
                        }
                        if (cap.getTimer() >= Grue.spawnTimer * 20 && this.flyingCloseEnough(player)) {
                            if (cap.getTimer() - 20 >= Grue.spawnTimer * 20) {
                                for (int i = 0; i < 2; ++i) {
                                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), Grue.grue_spawn, SoundCategory.HOSTILE, 2.0f, 1.0f);
                                }
                            }
                            cap.resetTimer();
                            grue = new EntityGrue(player.field_70170_p);
                            grue.func_82149_j((Entity)player);
                            grue.func_70107_b(this.stuff(player.field_70165_t, MathHelper.func_76128_c((double)player.field_70165_t)), player.field_70163_u, this.stuff(player.field_70161_v, MathHelper.func_76128_c((double)player.field_70161_v)));
                            player.field_70170_p.func_72838_d((Entity)grue);
                        }
                    }
                } else if (player.func_70013_c(1.0f) >= 0.5f && cap.getTimer() > 0) {
                    cap.decrementTimer();
                    if (cap.getTimer() % 10 == 0 || cap.getTimer() == 1) {
                        PacketDispatcher.sendTo(new GrueTimerMessage(player), (EntityPlayerMP)player);
                    }
                }
            }
            if (Grue.daylightGrue && (Grue.useWhitelist && this.isWhitelisted(player.field_71093_bK) || !Grue.useWhitelist || Grue.whitelist_override.contains(player.field_71093_bK))) {
                cap.incrementDaylightTimer();
                if (player.func_70013_c(1.0f) >= 0.75f) {
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), Grue.grue_spawn, SoundCategory.HOSTILE, 2.0f, 1.0f);
                    if (cap.getDaylightTimer() >= 1200 && this.flyingCloseEnough(player)) {
                        cap.resetDaylightTimer();
                        grue = new EntityDaylightGrue(player.field_70170_p);
                        grue.func_82149_j((Entity)player);
                        grue.func_70107_b(this.stuff(player.field_70165_t, MathHelper.func_76128_c((double)player.field_70165_t)), player.field_70163_u, this.stuff(player.field_70161_v, MathHelper.func_76128_c((double)player.field_70161_v)));
                        event.getEntityLiving().field_70170_p.func_72838_d((Entity)grue);
                    }
                }
            }
        }
    }

    private boolean flyingCloseEnough(EntityPlayer player) {
        if (Grue.flyHeight <= 0) {
            return true;
        }
        if (player.field_71075_bZ.field_75100_b || !player.field_70122_E) {
            Vec3d v = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            RayTraceResult mop = player.field_70170_p.func_72901_a(v, new Vec3d(player.field_70165_t, player.field_70163_u - 3.0, player.field_70161_v), true);
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                return v.field_72448_b - mop.field_72307_f.field_72448_b <= (double)Grue.flyHeight;
            }
            return false;
        }
        return true;
    }

    private double stuff(double d0, double d1) {
        if (d1 > d0) {
            return d1 - 0.5;
        }
        return d1 + 0.5;
    }

    private boolean isNotLightSource(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        for (ItemStack stack1 : Grue.dynamic_lights_list) {
            if (stack1.func_77973_b() != stack.func_77973_b() || stack1.func_77952_i() != Short.MAX_VALUE && stack1.func_77952_i() != stack.func_77952_i()) continue;
            return false;
        }
        return true;
    }

    private boolean isWhitelisted(int dim) {
        for (int id : Grue.dimWhitelist) {
            if (id != dim) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("grue", "gruetimer"), (ICapabilityProvider)new GrueCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        ((IGrueTimerCapability)event.getEntityPlayer().getCapability(GrueCapabilityProvider.GRUE_TIMER, null)).copy((IGrueTimerCapability)event.getOriginal().getCapability(GrueCapabilityProvider.GRUE_TIMER, null));
    }
}

