/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.grue.client.handlers;

import com.shinoow.grue.Grue;
import com.shinoow.grue.client.model.player.ModelStarSpawnPlayer;
import com.shinoow.grue.common.entity.props.GrueTimerProp;
import com.shinoow.grue.common.network.PacketDispatcher;
import com.shinoow.grue.common.network.server.DynamicLightsMessage;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.lwjgl.opengl.GL11;

public class GrueClientEventHandler {
    String warning = StatCollector.func_74838_a((String)"text.warning.grue");
    private ModelStarSpawnPlayer model = new ModelStarSpawnPlayer();
    Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void warning(RenderGameOverlayEvent.Text event) {
        if (!Grue.displayWarningText) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (Grue.useWhitelist && !this.isWhitelisted(player.field_71093_bK) && !Grue.whitelist_override.contains(player.field_71093_bK)) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        GrueTimerProp prop = GrueTimerProp.get((EntityPlayer)player);
        if (prop == null) {
            return;
        }
        if (prop.getTimer() == 0) {
            return;
        }
        if (player.func_70013_c(1.0f) > 0.05f) {
            event.left.remove(this.warning);
            return;
        }
        event.left.remove(this.warning);
        if (prop.getTimer() % 80 == 0) {
            event.left.add(this.warning);
            return;
        }
    }

    private boolean isWhitelisted(int dim) {
        for (int id : Grue.dimWhitelist) {
            if (id != dim) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            if (!Grue.dynamicLightsMode) {
                return;
            }
            PacketDispatcher.sendToServer(new DynamicLightsMessage(Loader.isModLoaded((String)"DynamicLights")));
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.SetArmorModel event) {
        if (!Loader.isModLoaded((String)"abyssalcraft") && this.checkPlayer(event.entityPlayer) && !event.entityPlayer.func_82150_aj()) {
            this.renderStarSpawnPlayer(event.entityPlayer, event.partialRenderTick);
        }
    }

    private boolean checkPlayer(EntityPlayer player) {
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            return player.func_70005_c_().equals("shinoow") || player.func_70005_c_().equals("Oblivionaire");
        }
        return player.func_110124_au().equals(UUID.fromString("a5d8abca-0979-4bb0-825a-f1ccda0b350b")) || player.func_110124_au().equals(UUID.fromString("08f3211c-d425-47fd-afd8-f0e7f94152c4"));
    }

    private void renderStarSpawnPlayer(EntityPlayer player, float partialTicks) {
        this.mc.field_71446_o.func_110577_a(new ResourceLocation("grue:textures/model/tentacles.png"));
        for (int j = 0; j < 1; ++j) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f10 = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks - (player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks);
            float f2 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            GL11.glPushMatrix();
            GL11.glFrontFace((int)2304);
            GL11.glRotatef((float)f10, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)f2, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.22f, (float)0.0f);
            this.model.renderTentacles(0.0625f, (Entity)player);
            GL11.glFrontFace((int)2305);
            GL11.glPopMatrix();
        }
    }
}

