/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.worldgen.homeworld;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class ChunkProviderHomeworld
implements IChunkGenerator {
    private final World worldObj;
    private final Random rand;
    private MapGenBase ravineGenerator = new MapGenRavine();
    private MapGenBase caveGenerator = new MapGenCaves();
    public WorldGenerator graniteGen;
    public WorldGenerator dioriteGen;
    public WorldGenerator andesiteGen;
    public WorldGenerator coalGen;
    public WorldGenerator ironGen;
    public WorldGenerator goldGen;
    public WorldGenerator redstoneGen;
    public WorldGenerator diamondGen;
    public WorldGenerator lapisGen;

    public ChunkProviderHomeworld(World world, boolean doMapFeatures, long seed) {
        this.worldObj = world;
        this.rand = new Random(seed);
        this.graniteGen = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), 33);
        this.dioriteGen = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), 33);
        this.andesiteGen = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), 33);
        this.coalGen = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), 13);
        this.ironGen = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), 33);
        this.goldGen = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), 25);
        this.redstoneGen = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), 13);
        this.diamondGen = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), 25);
        this.lapisGen = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), 13);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        int x;
        int z;
        int y;
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        for (y = 0; y < 256; ++y) {
            for (z = 0; z < 16; ++z) {
                for (x = 0; x < 16; ++x) {
                    int i;
                    int height;
                    IBlockState state;
                    if (y < 24) {
                        state = Blocks.field_150353_l.func_176223_P();
                        if (y < 6 && (y < 1 || this.rand.nextInt(y) == 0)) {
                            state = Blocks.field_150357_h.func_176223_P();
                        } else if (y > 18 && this.rand.nextInt(Math.max(Math.abs(25 - y), 1)) == 0) {
                            state = Blocks.field_150348_b.func_176223_P();
                        }
                        chunkPrimer.func_177855_a(x, y, z, state);
                        continue;
                    }
                    if (y < 40) {
                        state = Blocks.field_150348_b.func_176223_P();
                        if (y > 32 && this.rand.nextInt(Math.max(Math.abs(40 - y), 1)) == 0) {
                            state = Blocks.field_150355_j.func_176223_P();
                        }
                        if (chunkPrimer.func_177856_a(x, y - 1, z).func_177230_c() == Blocks.field_150348_b && this.rand.nextInt(8) == 0) {
                            height = this.rand.nextInt(12) + 6;
                            for (i = 0; i <= height; ++i) {
                                chunkPrimer.func_177855_a(x, y + i, z, state);
                            }
                        }
                        chunkPrimer.func_177855_a(x, y, z, state);
                        continue;
                    }
                    if (y < 64) {
                        state = Blocks.field_150355_j.func_176223_P();
                        if (y > 60 && this.rand.nextInt(Math.max(Math.abs(64 - y), 1)) == 0) {
                            state = Blocks.field_150432_aD.func_176223_P();
                        }
                        if (chunkPrimer.func_177856_a(x, y, z).func_177230_c() == Blocks.field_150348_b) continue;
                        chunkPrimer.func_177855_a(x, y, z, state);
                        continue;
                    }
                    if (y < 72) {
                        state = Blocks.field_150432_aD.func_176223_P();
                        if (this.rand.nextInt(Math.max(Math.abs(72 + this.rand.nextInt(2) - y), 1)) == 0) {
                            state = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
                        }
                        if (state.func_177230_c() == Blocks.field_150432_aD && this.rand.nextInt(32) == 0) {
                            height = this.rand.nextInt(4) + 4;
                            for (i = 1; i <= height; ++i) {
                                chunkPrimer.func_177855_a(x, y - i, z, state);
                            }
                        }
                        chunkPrimer.func_177855_a(x, y, z, state);
                        continue;
                    }
                    if (y >= 78 || this.rand.nextInt(8) != 0) continue;
                    state = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
                    if (chunkPrimer.func_177856_a(x, y - 1, z).func_177230_c() != Blocks.field_150354_m) continue;
                    chunkPrimer.func_177855_a(x, y, z, state);
                }
            }
        }
        this.caveGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkPrimer);
        this.ravineGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkPrimer);
        for (y = 0; y < 256; ++y) {
            for (z = 0; z < 16; ++z) {
                for (x = 0; x < 16; ++x) {
                    if (y >= 12 || chunkPrimer.func_177856_a(x, y, z).func_177230_c() != Blocks.field_150350_a) continue;
                    chunkPrimer.func_177855_a(x, y, z, Blocks.field_150353_l.func_176223_P());
                }
            }
        }
        Chunk chunk = new Chunk(this.worldObj, chunkPrimer, chunkX, chunkZ);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        this.genOres(x, z, this.worldObj, this.rand, 33, this.dioriteGen, 0, 72);
        this.genOres(x, z, this.worldObj, this.rand, 33, this.graniteGen, 0, 72);
        this.genOres(x, z, this.worldObj, this.rand, 33, this.andesiteGen, 0, 72);
        this.genOres(x, z, this.worldObj, this.rand, 13, this.coalGen, 0, 72);
        this.genOres(x, z, this.worldObj, this.rand, 33, this.ironGen, 0, 72);
        this.genOres(x, z, this.worldObj, this.rand, 25, this.goldGen, 0, 72);
        this.genOres(x, z, this.worldObj, this.rand, 13, this.redstoneGen, 0, 72);
        this.genOres(x, z, this.worldObj, this.rand, 25, this.diamondGen, 0, 72);
        this.genOres(x, z, this.worldObj, this.rand, 13, this.lapisGen, 0, 72);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return null;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    private void genOres(int chunkX, int chunkZ, World worldIn, Random random, int blockCount, WorldGenerator generator, int minHeight, int maxHeight) {
        int i;
        if (maxHeight < minHeight) {
            i = minHeight;
            minHeight = maxHeight;
            maxHeight = i;
        } else if (maxHeight == minHeight) {
            if (minHeight < 255) {
                ++maxHeight;
            } else {
                --minHeight;
            }
        }
        for (i = 0; i < blockCount; ++i) {
            BlockPos blockpos = new ChunkPos(chunkX, chunkZ).func_180331_a(random.nextInt(16), random.nextInt(maxHeight - minHeight) + minHeight, random.nextInt(16));
            generator.func_180709_b(worldIn, random, blockpos);
        }
    }
}

