/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.init;

import com.google.common.base.Predicate;
import java.io.IOException;
import mod.akrivus.kagic.entity.EntityAgate;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.EntityRuby;
import mod.akrivus.kagic.entity.EntitySpecimen;
import mod.akrivus.kagic.init.Config;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.akrivus.kagic.server.SpaceStuff;
import mod.akrivus.kagic.updater.Updater;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ModEvents {
    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof EntityMob) {
            EntityMob mob = (EntityMob)e.getEntity();
            if (!(e.getEntity() instanceof EntityEnderman)) {
                mob.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, EntitySpecimen.class, true, true));
                mob.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, EntityGem.class, 1, true, true, (Predicate)new Predicate<EntityGem>(){

                    public boolean apply(EntityGem input) {
                        return !(input instanceof EntityAgate);
                    }
                }));
            }
            mob.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)mob, EntityAgate.class, 6.0f, 1.0, 1.2));
        } else if (e.getEntity() instanceof EntityGolem) {
            EntityGolem golem = (EntityGolem)e.getEntity();
            golem.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)golem, EntityGem.class, 1, true, true, (Predicate)new Predicate<EntityGem>(){

                public boolean apply(EntityGem input) {
                    return input.getServitude() > 1;
                }
            }));
        } else if (e.getWorld().field_72995_K && e.getEntity() instanceof EntityPlayer && Config.notifyOnUpdates) {
            new Updater((EntityPlayer)e.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (Config.spawnMeteorRubies && !event.player.field_70170_p.field_72995_K && event.player.field_71093_bK == 0 && !event.player.field_70170_p.func_72935_r() && event.player.field_70170_p.func_82737_E() - SpaceStuff.get().getLastRubyImpactTime() > 120000L && event.player.field_70170_p.field_73012_v.nextInt(12000) == 0) {
            EntityRuby ruby = new EntityRuby(event.player.field_70170_p);
            double newX = event.player.field_70165_t + (double)(event.player.field_70170_p.field_73012_v.nextInt(32) - 16);
            double newZ = event.player.field_70161_v + (double)(event.player.field_70170_p.field_73012_v.nextInt(32) - 16);
            double newY = event.player.field_70170_p.func_175672_r(new BlockPos(newX, 0.0, newZ)).func_177956_o();
            ruby.func_70107_b(newX, 256.0, newZ);
            ruby.isSpaceBorn = true;
            event.player.field_70170_p.func_72838_d((Entity)ruby);
            event.player.field_70170_p.func_184133_a(null, new BlockPos(newX, newY, newZ), ModSounds.RUBY_EXPLODE, SoundCategory.WEATHER, 1.0f, 1.0f);
            SpaceStuff.get().setLastRubyImpactTime(event.player.field_70170_p.func_82737_E());
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        EntityGem gem;
        EntityVillager villager;
        if (!e.getEntity().field_70170_p.field_72995_K && e.getEntity() instanceof EntityVillager && (villager = (EntityVillager)e.getEntity()).func_94060_bK() instanceof EntityGem && (gem = (EntityGem)villager.func_94060_bK()).getServitude() > 1) {
            EntitySpecimen specimen = new EntitySpecimen(villager.field_70170_p);
            specimen.func_70107_b(villager.field_70165_t, villager.field_70163_u, villager.field_70161_v);
            specimen.func_70606_j(specimen.func_110138_aP());
            villager.field_70170_p.func_72838_d((Entity)specimen);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent e) {
        if (e.getName().equals((Object)LootTableList.field_186424_f) || e.getName().equals((Object)LootTableList.field_186423_e)) {
            e.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryItem((Item)ModItems.BISMUTH_GEM, 2, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.PERIDOT_GEM, 6, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.PEARL_GEM, 6, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.INACTIVE_GEM_BASE, 3, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(4.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.ACTIVATED_GEM_BASE, 4, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(2.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.INJECTOR, 2, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.GEM_DRILL, 4, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(3.0f))}, new LootCondition[0], "kagic")}, new LootCondition[0], new RandomValueRange(2.0f), new RandomValueRange(4.0f), "kagic"));
        } else if (e.getName().equals((Object)LootTableList.field_186429_k) || e.getName().equals((Object)LootTableList.field_186421_c) || e.getName().equals((Object)LootTableList.field_186430_l) || e.getName().equals((Object)LootTableList.field_186425_g)) {
            e.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryItem((Item)ModItems.RUBY_GEM, 8, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.PERIDOT_GEM, 6, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.PEARL_GEM, 12, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.SAPPHIRE_GEM, 10, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.LAPIS_LAZULI_GEM, 8, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.AMETHYST_GEM, 8, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.JASPER_GEM, 8, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.CARNELIAN_GEM, 8, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.ROSE_QUARTZ_GEM, 2, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic")}, new LootCondition[0], new RandomValueRange(3.0f), new RandomValueRange(7.0f), "kagic"));
        } else if (e.getName().equals((Object)LootTableList.field_186431_m) || e.getName().equals((Object)LootTableList.field_186422_d) || e.getName().equals((Object)LootTableList.field_186428_j)) {
            e.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryItem((Item)ModItems.RUBY_GEM, 12, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.PEARL_GEM, 8, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.INACTIVE_GEM_BASE, 8, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(4.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.ACTIVATED_GEM_BASE, 10, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(2.0f))}, new LootCondition[0], "kagic")}, new LootCondition[0], new RandomValueRange(3.0f), new RandomValueRange(7.0f), "kagic"));
        } else if (e.getName().equals((Object)LootTableList.field_186420_b)) {
            e.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryItem((Item)ModItems.RUBY_GEM, 12, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.PERIDOT_GEM, 12, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.PEARL_GEM, 12, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic")}, new LootCondition[0], new RandomValueRange(3.0f), new RandomValueRange(5.0f), "kagic"));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        Config.syncConfiguration();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!e.getWorld().field_72995_K) {
            try {
                KAGIC.spaceStuff = new SpaceStuff(e.getWorld());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save e) {
        if (!e.getWorld().field_72995_K) {
            if (KAGIC.spaceStuff == null) {
                try {
                    KAGIC.spaceStuff = new SpaceStuff(e.getWorld());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                KAGIC.spaceStuff.save();
            }
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new ModEvents());
    }
}

