/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity;

import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import mod.akrivus.kagic.blocks.BlockGemSeed;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIAlignGems;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIHarvestFarmland;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityPeridot
extends EntityGem {
    public AnimalChest gemStorage;
    public AnimalChest snapshotInventory;
    private int harvestTimer = 0;
    private int dropTimer = 100;

    public EntityPeridot(World worldIn) {
        this(worldIn, null);
    }

    public EntityPeridot(World worldIn, UUID ownerId) {
        super(worldIn, ownerId);
        this.func_70105_a(0.7f, 1.9f);
        this.setMaxPlacement(2);
        this.initGemStorage();
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAlignGems(this, 0.9));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIHarvestFarmland(this, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        NBTTagCompound nbttagcompound;
        ItemStack itemstack;
        int i;
        super.func_70014_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
            itemstack = this.gemStorage.func_70301_a(i);
            if (itemstack == null) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("items", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
            itemstack = this.gemStorage.func_70301_a(i);
            if (itemstack == null) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("snapshot_items", (NBTBase)nbttaglist);
        compound.func_74768_a("harvestTimer", this.harvestTimer);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        int j;
        NBTTagCompound nbttagcompound;
        int i;
        super.func_70037_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("items", 10);
        this.initGemStorage();
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound = nbttaglist.func_150305_b(i);
            j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.gemStorage.func_70302_i_()) continue;
            this.gemStorage.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
        }
        nbttaglist = compound.func_150295_c("snapshot_items", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound = nbttaglist.func_150305_b(i);
            j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.snapshotInventory.func_70302_i_()) continue;
            this.snapshotInventory.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
        }
        this.harvestTimer = compound.func_74762_e("harvestTimer");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (this.field_70170_p.field_72995_K) return super.func_184645_a(player, hand, stack);
        if (hand != EnumHand.MAIN_HAND) return super.func_184645_a(player, hand, stack);
        if (!this.isTamed()) return super.func_184645_a(player, hand, stack);
        if (!this.isOwner((EntityLivingBase)player)) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.does_not_serve_you", (Object[])new Object[]{this.func_70005_c_()})));
            return true;
        }
        if (this.isCoreItem(stack)) {
            return super.func_184645_a(player, hand, stack);
        }
        if (stack != null && stack.func_77973_b() instanceof ItemHoe) {
            boolean toolChanged = true;
            if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null) {
                if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_185136_b(stack)) {
                    this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND), 0.0f);
                } else {
                    toolChanged = false;
                }
            }
            if (!toolChanged) return true;
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            ItemStack heldItem = ItemStack.func_77944_b((ItemStack)stack);
            heldItem.field_77994_a = 1;
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
            this.playObeySound();
            return true;
        }
        if (!this.isFarmer()) {
            this.checkSurroundings(this.field_70170_p, this.func_180425_c());
            this.playObeySound();
            return true;
        }
        if (!this.inventoryChanged() || this.harvestTimer <= 3600) {
            player.func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + I18n.func_74838_a((String)"command.kagic.peridot_no_harvest")));
            return super.func_184645_a(player, hand, stack);
        }
        player.func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + I18n.func_74838_a((String)"command.kagic.peridot_harvest")));
        int i = 0;
        while (true) {
            if (i >= this.gemStorage.func_70302_i_()) {
                this.harvestTimer = 0;
                this.createSnapshotInventory();
                this.playObeySound();
                return true;
            }
            ItemStack itemstack = this.gemStorage.func_70301_a(i);
            if (itemstack != null) {
                this.func_98053_h(false);
                this.dropTimer = 0;
                if (itemstack.func_77973_b() == Items.field_151015_O || itemstack.func_77973_b() == Items.field_185164_cV) {
                    this.func_145779_a(itemstack.func_77973_b(), itemstack.field_77994_a);
                    this.gemStorage.func_70299_a(i, null);
                } else {
                    ItemStack newstack = itemstack.func_77946_l();
                    newstack.field_77994_a = (int)((double)newstack.field_77994_a / 1.5);
                    this.func_145779_a(newstack.func_77973_b(), newstack.field_77994_a);
                    this.gemStorage.func_70299_a(i, newstack);
                }
            }
            ++i;
        }
    }

    public void checkSurroundings(World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            Object[] gems = new String[]{I18n.func_74838_a((String)"entity.kagic.ruby.name"), I18n.func_74838_a((String)"entity.kagic.sapphire.name"), I18n.func_74838_a((String)"entity.kagic.jasper.name"), I18n.func_74838_a((String)"entity.kagic.amethyst.name"), I18n.func_74838_a((String)"entity.kagic.rose_quartz.name"), I18n.func_74838_a((String)"entity.kagic.peridot.name"), I18n.func_74838_a((String)"entity.kagic.pearl.name"), I18n.func_74838_a((String)"entity.kagic.bismuth.name"), I18n.func_74838_a((String)"entity.kagic.lapis_lazuli.name"), I18n.func_74838_a((String)"entity.kagic.carnelian.name"), I18n.func_74838_a((String)"entity.kagic.agate.name")};
            this.getOwner().func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + I18n.func_74837_a((String)"command.kagic.peridot_find_gem", (Object[])new Object[]{BlockGemSeed.checkSurroundings(worldIn, pos, gems, false)})));
        }
    }

    public void func_70636_d() {
        if (!this.func_98052_bS() && this.dropTimer > 40 && this.isFarmer()) {
            this.func_98053_h(this.isTamed());
        }
        if (this.isFarmer()) {
            ++this.harvestTimer;
        }
        if (this.dropTimer < 100) {
            ++this.dropTimer;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.func_98053_h(false);
        super.func_70645_a(cause);
    }

    private void initGemStorage() {
        ItemStack itemstack;
        int i;
        AnimalChest gemstorage = this.gemStorage;
        this.gemStorage = new AnimalChest("gemStorage", 36);
        if (gemstorage != null) {
            for (i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                itemstack = gemstorage.func_70301_a(i);
                if (itemstack == null) continue;
                this.gemStorage.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        new InvWrapper((IInventory)this.gemStorage);
        this.snapshotInventory = new AnimalChest("snapshotInventory", 36);
        if (this.gemStorage != null) {
            for (i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                itemstack = this.gemStorage.func_70301_a(i);
                if (itemstack == null) continue;
                this.gemStorage.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        this.func_98053_h(this.isTamed());
    }

    private boolean inventoryChanged() {
        if (this.gemStorage != null && this.snapshotInventory != null) {
            for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                ItemStack itemstack1 = this.gemStorage.func_70301_a(i);
                ItemStack itemstack2 = this.snapshotInventory.func_70301_a(i);
                if (itemstack1 == null && itemstack2 == null) continue;
                if (itemstack1 == null || itemstack2 == null) {
                    return true;
                }
                if (itemstack1.func_185136_b(itemstack2)) {
                    if (itemstack1.field_77994_a == itemstack2.field_77994_a) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private void createSnapshotInventory() {
        this.snapshotInventory = new AnimalChest("snapshotInventory", 36);
        if (this.gemStorage != null) {
            for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                ItemStack itemstack = this.gemStorage.func_70301_a(i);
                if (itemstack == null) continue;
                this.gemStorage.func_70299_a(i, itemstack.func_77946_l());
            }
        }
    }

    protected void func_175445_a(EntityItem itementity) {
        ItemStack itemstack = itementity.func_92059_d();
        if (this.canPickupItem(itemstack.func_77973_b()) && this.isFarmer()) {
            ItemStack itemstack1 = this.gemStorage.func_174894_a(itemstack);
            if (itemstack1 == null) {
                itementity.func_70106_y();
            } else {
                itemstack.field_77994_a = itemstack1.field_77994_a;
            }
        }
    }

    private boolean canPickupItem(Item itemIn) {
        return itemIn == Items.field_151174_bG || itemIn == Items.field_151172_bF || itemIn == Items.field_151015_O || itemIn == Items.field_151014_N || itemIn == Items.field_185164_cV || itemIn == Items.field_185163_cU;
    }

    public boolean isFarmer() {
        return this.isTamed() && this.func_184586_b(EnumHand.MAIN_HAND) != null && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemHoe;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_145779_a((Item)ModItems.RECORD_LITTLE_PERIDOT, 1);
        }
    }

    public SoundEvent func_184639_G() {
        return ModSounds.PERIDOT_LIVING;
    }

    public SoundEvent func_184601_bQ() {
        return ModSounds.PERIDOT_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.PERIDOT_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.PERIDOT_DEATH;
    }
}

