/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity;

import com.google.common.base.Predicate;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAISitStill;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityPearl
extends EntityGem
implements IInventoryChangedListener {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HAIR = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187192_b);
    public AnimalChest gemStorage;

    public EntityPearl(World worldIn) {
        this(worldIn, null);
    }

    public EntityPearl(World worldIn, UUID ownerId) {
        super(worldIn, ownerId);
        this.func_70105_a(0.6f, 1.9f);
        this.setMaxPlacement(3);
        this.initGemStorage();
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAISitStill(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.field_70180_af.func_187214_a(COLOR, (Object)new Random().nextInt(15));
        this.field_70180_af.func_187214_a(HAIR, (Object)new Random().nextInt(5));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("color", ((Integer)this.field_70180_af.func_187225_a(COLOR)).intValue());
        compound.func_74768_a("hair", ((Integer)this.field_70180_af.func_187225_a(HAIR)).intValue());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
            ItemStack itemstack = this.gemStorage.func_70301_a(i);
            if (itemstack == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("items", (NBTBase)nbttaglist);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74762_e("color"));
        this.field_70180_af.func_187227_b(HAIR, (Object)compound.func_74762_e("hair"));
        NBTTagList nbttaglist = compound.func_150295_c("items", 10);
        this.initGemStorage();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.gemStorage.func_70302_i_()) continue;
            this.gemStorage.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && this.isTamed() && this.isOwner((EntityLivingBase)player)) {
            if (stack != null && stack.func_77973_b() == Items.field_151097_aZ) {
                int hair = (Integer)this.field_70180_af.func_187225_a(HAIR) + 1;
                if (hair > 5 || hair < 0) {
                    hair = 0;
                }
                this.field_70180_af.func_187227_b(HAIR, (Object)hair);
                this.func_184185_a(SoundEvents.field_187763_eJ, this.func_70599_aP(), this.func_70647_i());
                stack.func_77972_a(1, (EntityLivingBase)this);
                return true;
            }
            if (stack != null && stack.func_77973_b() == Items.field_151100_aR) {
                int oldColor = this.getColor();
                this.field_70180_af.func_187227_b(COLOR, (Object)(15 - stack.func_77952_i()));
                if (!player.field_71075_bZ.field_75098_d && oldColor != this.getColor()) {
                    --stack.field_77994_a;
                }
                return true;
            }
            if (this.isCoreItem(stack)) {
                return super.func_184645_a(player, hand, stack);
            }
            this.openGUI(player);
            this.playObeySound();
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    public void func_76316_a(InventoryBasic invbasic) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.gemStorage.func_70301_a(0));
    }

    protected void func_175445_a(EntityItem itementity) {
        ItemStack itemstack = itementity.func_92059_d();
        ItemStack itemstack1 = this.gemStorage.func_174894_a(itemstack);
        if (itemstack1 == null) {
            itementity.func_70106_y();
        } else {
            itemstack.field_77994_a = itemstack1.field_77994_a;
        }
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public int getHairStyle() {
        return (Integer)this.field_70180_af.func_187225_a(HAIR);
    }

    public AnimalChest getInventory() {
        return this.gemStorage;
    }

    public void func_70636_d() {
        if (!this.func_98052_bS()) {
            this.func_98053_h(this.isTamed());
        }
        super.func_70636_d();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.func_98053_h(false);
        super.func_70645_a(cause);
    }

    private void initGemStorage() {
        AnimalChest gemstorage = this.gemStorage;
        this.gemStorage = new AnimalChest("gemStorage", 36);
        if (gemstorage != null) {
            gemstorage.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(gemstorage.func_70302_i_(), this.gemStorage.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = gemstorage.func_70301_a(j);
                if (itemstack == null) continue;
                this.gemStorage.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.gemStorage.func_110134_a((IInventoryChangedListener)this);
        new InvWrapper((IInventory)this.gemStorage);
        this.func_98053_h(this.isTamed());
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            this.gemStorage.func_110133_a(this.func_70005_c_());
            playerEntity.func_71007_a((IInventory)this.gemStorage);
        }
    }

    public SoundEvent func_184639_G() {
        return ModSounds.PEARL_LIVING;
    }

    public SoundEvent func_184601_bQ() {
        return ModSounds.PEARL_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.PEARL_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.PEARL_DEATH;
    }
}

