/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity;

import com.google.common.base.Optional;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import mod.akrivus.kagic.entity.EntityAgate;
import mod.akrivus.kagic.entity.EntityAmethyst;
import mod.akrivus.kagic.entity.EntityBismuth;
import mod.akrivus.kagic.entity.EntityBlueDiamond;
import mod.akrivus.kagic.entity.EntityCarnelian;
import mod.akrivus.kagic.entity.EntityJasper;
import mod.akrivus.kagic.entity.EntityLapisLazuli;
import mod.akrivus.kagic.entity.EntityPearl;
import mod.akrivus.kagic.entity.EntityPeridot;
import mod.akrivus.kagic.entity.EntityRoseQuartz;
import mod.akrivus.kagic.entity.EntityRuby;
import mod.akrivus.kagic.entity.EntitySapphire;
import mod.akrivus.kagic.entity.EntityYellowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIAttackRangedBow;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.init.Config;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.init.ModEnchantments;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.items.ItemGem;
import mod.akrivus.kagic.items.ItemJointContract;
import mod.akrivus.kagic.items.ItemTransferContract;
import mod.akrivus.kagic.util.PoofDamage;
import mod.akrivus.kagic.util.ShatterDamage;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGem
extends EntityCreature
implements IEntityOwnable,
IRangedAttackMob {
    public static final int SERVE_NONE = 0;
    public static final int SERVE_HUMAN = 1;
    public static final int SERVE_YELLOW_DIAMOND = 2;
    public static final int SERVE_BLUE_DIAMOND = 3;
    public static final int SERVE_WHITE_DIAMOND = 4;
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GEM_PLACEMENT = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> VISOR = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIBase rangedAttack = new EntityAIAttackRangedBow(this, 0.6, 20, 16.0f);
    private final EntityAIBase meleeAttack = new EntityAIAttackMelee((EntityCreature)this, 1.2, true);
    private final EntityAITarget killVillagers = new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true, true);
    protected EntityAIStay stayAI;
    private BlockPos restPosition;
    private ItemGem droppedGemItem;
    private ItemGem droppedCrackedGemItem;
    private int maxPlacements = 0;
    private int servitude = 0;
    public ArrayList<UUID> jointOwners = new ArrayList();
    public UUID leader = null;
    public boolean isAttacking;
    public boolean isSitting;
    public boolean isDiamond;
    public boolean isSpaceBorn;
    public boolean isPeaceful;

    public EntityGem(World worldIn) {
        this(worldIn, null);
    }

    public EntityGem(World worldIn, @Nullable UUID ownerId) {
        super(worldIn);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70138_W = 1.0f;
        this.isDiamond = false;
        if (this instanceof EntityRuby) {
            this.droppedGemItem = ModItems.RUBY_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_RUBY_GEM;
        } else if (this instanceof EntitySapphire) {
            this.droppedGemItem = ModItems.SAPPHIRE_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_SAPPHIRE_GEM;
        } else if (this instanceof EntityPeridot) {
            this.droppedGemItem = ModItems.PERIDOT_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_PERIDOT_GEM;
        } else if (this instanceof EntityPearl) {
            this.droppedGemItem = ModItems.PEARL_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_PEARL_GEM;
        } else if (this instanceof EntityBismuth) {
            this.droppedGemItem = ModItems.BISMUTH_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_BISMUTH_GEM;
        } else if (this instanceof EntityJasper) {
            this.droppedGemItem = ModItems.JASPER_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_JASPER_GEM;
        } else if (this instanceof EntityAmethyst) {
            this.droppedGemItem = ModItems.AMETHYST_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_AMETHYST_GEM;
        } else if (this instanceof EntityRoseQuartz) {
            this.droppedGemItem = ModItems.ROSE_QUARTZ_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_ROSE_QUARTZ_GEM;
        } else if (this instanceof EntityLapisLazuli) {
            this.droppedGemItem = ModItems.LAPIS_LAZULI_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_LAPIS_LAZULI_GEM;
        } else if (this instanceof EntityCarnelian) {
            this.droppedGemItem = ModItems.CARNELIAN_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_CARNELIAN_GEM;
        } else if (this instanceof EntityAgate) {
            this.droppedGemItem = ModItems.AGATE_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_AGATE_GEM;
        } else if (this instanceof EntityYellowDiamond) {
            this.droppedGemItem = ModItems.YELLOW_DIAMOND_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_YELLOW_DIAMOND_GEM;
        } else if (this instanceof EntityBlueDiamond) {
            this.droppedGemItem = ModItems.BLUE_DIAMOND_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_DIAMOND_GEM;
        }
        if (ownerId != null) {
            this.setOwnerId(ownerId);
        }
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(GEM_PLACEMENT, (Object)0);
        this.field_70180_af.func_187214_a(VISOR, (Object)false);
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("gemPlacement", this.getGemPlacement());
        compound.func_74757_a("hasVisor", this.hasVisor());
        if (this.func_184753_b() == null) {
            compound.func_74778_a("ownerId", "");
        } else {
            compound.func_74778_a("ownerId", this.func_184753_b().toString());
        }
        if (this.getLeader() == null) {
            compound.func_74778_a("leaderId", "");
        } else {
            compound.func_74778_a("leaderId", this.leader.toString());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.jointOwners.size(); ++i) {
            UUID ownerId = this.jointOwners.get(i);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("ownerId", ownerId.toString());
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (this.restPosition != null) {
            compound.func_74780_a("restX", (double)this.restPosition.func_177958_n());
            compound.func_74780_a("restY", (double)this.restPosition.func_177956_o());
            compound.func_74780_a("restZ", (double)this.restPosition.func_177952_p());
        }
        compound.func_74782_a("jointOwners", (NBTBase)nbttaglist);
        compound.func_74757_a("sitting", this.isSitting());
        compound.func_74768_a("servitude", this.servitude);
    }

    public void func_70037_a(NBTTagCompound compound) {
        String leaderId;
        String ownerId;
        super.func_70037_a(compound);
        if (compound.func_150297_b("ownerId", 8)) {
            ownerId = compound.func_74779_i("ownerId");
        } else {
            String tempId = compound.func_74779_i("ownerId");
            ownerId = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)tempId);
        }
        if (!ownerId.isEmpty()) {
            this.setOwnerId(UUID.fromString(ownerId));
        }
        if (compound.func_150297_b("leaderId", 8)) {
            leaderId = compound.func_74779_i("leaderId");
        } else {
            String tempId = compound.func_74779_i("leaderId");
            leaderId = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)tempId);
        }
        if (!leaderId.isEmpty()) {
            this.setLeader(UUID.fromString(leaderId));
        }
        NBTTagList nbttaglist = compound.func_150295_c("jointOwners", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String jointId;
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            if (nbttagcompound.func_150297_b("ownerId", 8)) {
                jointId = nbttagcompound.func_74779_i("ownerId");
            } else {
                String tempId = nbttagcompound.func_74779_i("ownerId");
                jointId = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)tempId);
            }
            if (jointId.isEmpty()) continue;
            this.jointOwners.add(UUID.fromString(jointId));
        }
        if (compound.func_74764_b("restX") && compound.func_74764_b("restY") && compound.func_74764_b("restZ")) {
            this.restPosition = new BlockPos(compound.func_74769_h("restX"), compound.func_74769_h("restY"), compound.func_74769_h("restZ"));
        }
        if (this.stayAI != null) {
            this.stayAI.setSitting(compound.func_74767_n("sitting"));
        }
        this.setGemPlacement(compound.func_74762_e("gemPlacement"));
        this.setHasVisor(compound.func_74767_n("hasVisor"));
        this.isSitting = compound.func_74767_n("sitting");
        this.servitude = compound.func_74762_e("servitude");
        this.setAttackAI();
    }

    public NBTTagCompound getTagCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_70014_b(compound);
        return compound;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_70606_j(this.func_110138_aP());
        this.setGemPlacement(Math.max(this.field_70146_Z.nextInt(this.getMaxPlacements()), 0));
        this.setHasVisor(this.field_70146_Z.nextInt(3) == 0);
        this.setAttackAI();
        return livingdata;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70692_ba() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (this.field_70170_p.field_72995_K || hand != EnumHand.MAIN_HAND) return super.func_184645_a(player, hand, stack);
        if (stack != null && stack.func_77973_b() == ModItems.GEM_STAFF) {
            if (this.isTamed()) {
                if (this.isOwner((EntityLivingBase)player)) {
                    this.setSitting(player);
                    this.playObeySound();
                    return super.func_184645_a(player, hand, stack);
                }
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.does_not_serve_you", (Object[])new Object[]{this.func_70005_c_()})));
                return true;
            }
            this.setOwnerId(player.func_110124_au());
            this.setLeader(player);
            this.setServitude(1);
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            this.func_70606_j(this.func_110138_aP());
            this.playTameEffect();
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            this.playObeySound();
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.now_serves_you", (Object[])new Object[]{this.func_70005_c_()})));
            return true;
        }
        if (stack.func_77973_b() == ModItems.CRACKED_BLUE_DIAMOND_GEM || stack.func_77973_b() == ModItems.CRACKED_YELLOW_DIAMOND_GEM || stack.func_77973_b() == ModItems.BLUE_DIAMOND_GEM || stack.func_77973_b() == ModItems.YELLOW_DIAMOND_GEM) {
            if (this.getServitude() == 1) return super.func_184645_a(player, hand, stack);
            this.setOwnerId(player.func_110124_au());
            this.setLeader(player);
            this.setServitude(1);
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            this.func_70606_j(this.func_110138_aP());
            this.playTameEffect();
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            this.playObeySound();
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.now_serves_you", (Object[])new Object[]{this.func_70005_c_()})));
            return true;
        }
        if (stack != null && stack.func_77973_b() == ModItems.TRANSFER_CONTRACT) {
            if (!this.isTamed()) return super.func_184645_a(player, hand, stack);
            if (this.isOwner((EntityLivingBase)player)) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.already_serves_you", (Object[])new Object[]{this.func_70005_c_()})));
                return true;
            }
            ItemTransferContract contract = (ItemTransferContract)stack.func_77973_b();
            if (this.isOwnerId(contract.getOwner(stack))) {
                if (contract.getOwner(stack).equals(this.func_184753_b())) {
                    if (this.leader.equals(this.func_184753_b())) {
                        this.setLeader(player);
                    }
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.ownership_transfered", (Object[])new Object[]{this.func_70005_c_(), player.func_70005_c_()})));
                    this.setOwnerId(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
                } else {
                    for (UUID ownerId : this.jointOwners) {
                        if (!contract.getOwner(stack).equals(ownerId)) continue;
                        if (this.leader.equals(this.func_184753_b())) {
                            this.setLeader(player);
                        }
                        try {
                            this.field_70170_p.func_152378_a(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH())).func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.ownership_transfered", (Object[])new Object[]{this.func_70005_c_(), player.func_70005_c_()})));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ownerId = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
                    }
                }
                this.playObeySound();
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.now_serves_you", (Object[])new Object[]{this.func_70005_c_()})));
                if (player.field_71075_bZ.field_75098_d) return true;
                --stack.field_77994_a;
                return true;
            }
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.does_not_serve_signee", (Object[])new Object[]{this.func_70005_c_()})));
            return true;
        }
        if (stack == null || stack.func_77973_b() != ModItems.JOINT_CONTRACT || !this.isTamed()) return super.func_184645_a(player, hand, stack);
        if (this.isOwner((EntityLivingBase)player)) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.already_serves_you", (Object[])new Object[]{this.func_70005_c_()})));
            return true;
        }
        ItemJointContract contract = (ItemJointContract)stack.func_77973_b();
        if (this.isOwnerId(contract.getOwner(stack))) {
            this.getOwner().func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.joint_ownership_added", (Object[])new Object[]{this.func_70005_c_(), player.func_70005_c_()})));
            for (UUID ownerId : this.jointOwners) {
                try {
                    this.field_70170_p.func_152378_a(ownerId).func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.joint_ownership_added", (Object[])new Object[]{this.func_70005_c_(), player.func_70005_c_()})));
                }
                catch (Exception exception) {}
            }
            this.jointOwners.add(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
            this.playObeySound();
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.now_serves_you", (Object[])new Object[]{this.func_70005_c_()})));
            if (player.field_71075_bZ.field_75098_d) return true;
            --stack.field_77994_a;
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.does_not_serve_signee", (Object[])new Object[]{this.func_70005_c_()})));
        return true;
    }

    public boolean setAttackWeapon(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (this.isTamed() && this.isOwner((EntityLivingBase)player)) {
            boolean toolChanged = true;
            if (!this.isCoreItem(stack) && (stack == null || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemBow)) {
                if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null) {
                    if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_185136_b(stack)) {
                        this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND), 0.0f);
                    } else {
                        toolChanged = false;
                    }
                }
                if (toolChanged) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    ItemStack heldItem = ItemStack.func_77944_b((ItemStack)stack);
                    heldItem.field_77994_a = 1;
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                    this.playObeySound();
                    this.setAttackAI();
                }
                return true;
            }
            if (stack.func_77973_b() instanceof ItemArrow || stack.func_77973_b() instanceof ItemShield) {
                if (this.func_184582_a(EntityEquipmentSlot.OFFHAND) != null) {
                    if (!this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_185136_b(stack)) {
                        this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.OFFHAND), 0.0f);
                    } else {
                        toolChanged = false;
                    }
                }
                if (toolChanged) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    ItemStack heldItem = ItemStack.func_77944_b((ItemStack)stack);
                    heldItem.field_77994_a = 1;
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, heldItem);
                    this.playObeySound();
                    this.setAttackAI();
                }
            }
        }
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.isTamed() && this.isOwner((EntityLivingBase)player);
    }

    public boolean isCoreItem(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() == ModItems.GEM_STAFF) {
                return true;
            }
            if (stack.func_77973_b() == ModItems.TRANSFER_CONTRACT) {
                return true;
            }
            if (stack.func_77973_b() == ModItems.JOINT_CONTRACT) {
                return true;
            }
            if (stack.func_77973_b() == Items.field_151057_cb) {
                return true;
            }
            if (stack.func_77973_b() == Items.field_151058_ca) {
                return true;
            }
            return stack.func_77973_b() == ModItems.CRACKED_BLUE_DIAMOND_GEM || stack.func_77973_b() == ModItems.CRACKED_YELLOW_DIAMOND_GEM || stack.func_77973_b() == ModItems.BLUE_DIAMOND_GEM || stack.func_77973_b() == ModItems.YELLOW_DIAMOND_GEM;
        }
        return false;
    }

    public int getGemPlacement() {
        return (Integer)this.field_70180_af.func_187225_a(GEM_PLACEMENT);
    }

    public void setGemPlacement(int gemPlacement) {
        this.field_70180_af.func_187227_b(GEM_PLACEMENT, (Object)gemPlacement);
    }

    public boolean hasVisor() {
        return (Boolean)this.field_70180_af.func_187225_a(VISOR);
    }

    public void setHasVisor(boolean hasVisor) {
        this.field_70180_af.func_187227_b(VISOR, (Object)hasVisor);
    }

    public int getMaxPlacements() {
        return this.maxPlacements;
    }

    public void setMaxPlacement(int maxPlacements) {
        this.maxPlacements = maxPlacements;
    }

    public boolean isTamed() {
        return this.func_184753_b() != null || this.servitude > 1 || this.isDiamond;
    }

    public boolean isSitting() {
        return this.isSitting;
    }

    public void setSitting(EntityPlayer player) {
        if (player != null) {
            if (this.isSitting()) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.will_follow_you", (Object[])new Object[]{this.func_70005_c_()})));
                this.isSitting = false;
                this.isSitting = false;
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.will_not_follow_you", (Object[])new Object[]{this.func_70005_c_()})));
                this.isSitting = true;
                this.restPosition = this.func_180425_c();
                this.setLeader(player);
            }
        }
    }

    public void setOwnerId(@Nullable UUID ownerId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)ownerId));
    }

    public void setOwnerId(@Nullable String ownerId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)UUID.fromString(ownerId)));
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public EntityPlayer getOwner() {
        EntityPlayer owner = null;
        double distance = Double.MAX_VALUE;
        for (EntityPlayer playerIn : this.field_70170_p.field_73010_i) {
            if (EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(this.func_184753_b())) {
                if (!(this.func_174818_b(playerIn.func_180425_c()) <= distance)) continue;
                distance = this.func_174818_b(playerIn.func_180425_c());
                owner = playerIn;
                continue;
            }
            for (UUID ownerId : this.jointOwners) {
                if (!EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(ownerId) || !(this.func_174818_b(playerIn.func_180425_c()) <= distance)) continue;
                distance = this.func_174818_b(playerIn.func_180425_c());
                owner = playerIn;
            }
        }
        return owner;
    }

    public UUID getLeader() {
        return this.leader;
    }

    public EntityPlayer getLeaderEntity() {
        try {
            return this.field_70170_p.func_152378_a(this.leader);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setLeader(EntityPlayer newLeader) {
        try {
            if (this.leader != null && !this.leader.equals(EntityPlayer.func_146094_a((GameProfile)newLeader.func_146103_bH()))) {
                EntityPlayer oldLeader = this.field_70170_p.func_152378_a(this.leader);
                oldLeader.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"command.kagic.following_someone_else", (Object[])new Object[]{this.func_70005_c_(), newLeader.func_70005_c_()})));
            }
            this.leader = EntityPlayer.func_146094_a((GameProfile)newLeader.func_146103_bH());
        }
        catch (Exception e) {
            this.leader = null;
        }
    }

    public void setLeader(UUID newLeader) {
        this.leader = newLeader;
    }

    public BlockPos getRestPosition() {
        return this.restPosition;
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        if (entityIn instanceof EntityPlayer) {
            EntityPlayer playerIn = (EntityPlayer)entityIn;
            if (EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(this.func_184753_b())) {
                return true;
            }
            for (UUID ownerId : this.jointOwners) {
                if (!EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(ownerId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOwnerId(UUID uuid) {
        if (uuid.equals(this.func_184753_b())) {
            return true;
        }
        for (UUID ownerId : this.jointOwners) {
            if (!uuid.equals(ownerId)) continue;
            return true;
        }
        return false;
    }

    public EntityAIStay getAIStay() {
        return this.stayAI;
    }

    public boolean shouldAttackEntity(EntityLivingBase attacker, EntityLivingBase victim) {
        if (attacker instanceof EntityGem && victim instanceof EntityGem) {
            EntityGem gemAttacker = (EntityGem)attacker;
            EntityGem gemVictim = (EntityGem)victim;
            if (gemAttacker.getServitude() == gemVictim.getServitude()) {
                if (gemAttacker.getServitude() == 1) {
                    return !gemAttacker.func_184753_b().equals(gemVictim.func_184753_b());
                }
                return false;
            }
        }
        return true;
    }

    public void setAttackAI() {
        if (this.func_184586_b(EnumHand.MAIN_HAND) != null) {
            if (this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151031_f) {
                this.field_70714_bg.func_75776_a(1, this.rangedAttack);
                this.field_70714_bg.func_85156_a(this.meleeAttack);
            } else {
                this.field_70714_bg.func_75776_a(1, this.meleeAttack);
                this.field_70714_bg.func_85156_a(this.rangedAttack);
            }
        } else {
            this.field_70714_bg.func_75776_a(1, this.meleeAttack);
            this.field_70714_bg.func_85156_a(this.rangedAttack);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase attacker;
            ItemStack heldItem;
            if (KAGIC.isFireworksDay()) {
                this.createFireworks();
            }
            if (this.field_70128_L || this.func_110143_aJ() <= 0.0f) {
                return false;
            }
            if (this.isSpaceBorn) {
                return false;
            }
            if (this.isPeaceful) {
                this.isPeaceful = false;
                return false;
            }
            if (source == DamageSource.field_76368_d && !this.field_70170_p.field_72995_K) {
                int i = 0;
                while ((float)i < this.field_70131_O) {
                    this.field_70170_p.func_175655_b(this.func_180425_c().func_177981_b(i), true);
                    ++i;
                }
                return false;
            }
            if (source.func_76346_g() instanceof EntityLivingBase && (heldItem = (attacker = (EntityLivingBase)source.func_76346_g()).func_184614_ca()) != null) {
                if (heldItem.func_77948_v()) {
                    NBTTagList enchantments = heldItem.func_77986_q();
                    for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                        if (enchantments.func_150305_b(i).func_74762_e("id") != Enchantment.func_185258_b((Enchantment)ModEnchantments.BREAKING_POINT) && enchantments.func_150305_b(i).func_74762_e("id") != Enchantment.func_185258_b((Enchantment)ModEnchantments.FAIR_FIGHT)) continue;
                        this.func_70606_j(0.0f);
                        this.func_70645_a(source);
                    }
                } else if (heldItem.func_77973_b().equals((Object)ModItems.GEM_STAFF) && source.func_76346_g() instanceof EntityLivingBase && this.isOwner(attacker)) {
                    this.func_70606_j(0.0f);
                    this.func_70645_a(source);
                }
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        this.func_184609_a(EnumHand.MAIN_HAND);
        if (flag) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                if (itemstack != null && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        ItemStack itemstack;
        boolean flame;
        EntityTippedArrow arrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double distanceFromTargetX = target.field_70165_t - this.field_70165_t;
        double distanceFromTargetY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow.field_70163_u;
        double distanceFromTargetZ = target.field_70161_v - this.field_70161_v;
        double distanceFromTargetS = MathHelper.func_76133_a((double)(distanceFromTargetX * distanceFromTargetX + distanceFromTargetY * distanceFromTargetY));
        arrow.func_70186_c(distanceFromTargetX, distanceFromTargetY + distanceFromTargetS * (double)0.2f, distanceFromTargetZ, 1.6f, 2.0f);
        arrow.func_70239_b((double)(distanceFactor * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        int power = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
        int punch = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        boolean bl = flame = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this) > 0;
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            arrow.func_70240_a(punch);
        }
        if (flame) {
            arrow.func_70015_d(100);
        }
        if ((itemstack = this.func_184586_b(EnumHand.OFF_HAND)) != null && itemstack.func_77973_b() == Items.field_185167_i) {
            arrow.func_184555_a(itemstack);
        }
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.isSpaceBorn) {
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (this.field_70131_O + this.field_70130_N) * 2.0f, true, true);
            this.isSpaceBorn = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public Team func_96124_cp() {
        EntityPlayer entitylivingbase;
        if (this.isTamed() && (entitylivingbase = this.getOwner()) != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.isTamed()) {
            EntityPlayer entitylivingbase = this.getOwner();
            if (entityIn == entitylivingbase) {
                return true;
            }
            if (entitylivingbase != null) {
                return entitylivingbase.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public int getServitude() {
        return this.servitude;
    }

    public void setServitude(int servitude) {
        this.servitude = servitude;
        if (this.servitude > 1) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.killVillagers);
        } else {
            this.field_70715_bh.func_85156_a((EntityAIBase)this.killVillagers);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack heldItem;
            ItemStack stack = new ItemStack((Item)this.droppedGemItem);
            boolean shattered = false;
            boolean enchanted = false;
            if (cause.func_76346_g() instanceof EntityLivingBase && (heldItem = ((EntityLivingBase)cause.func_76346_g()).func_184614_ca()) != null) {
                if (heldItem.func_77948_v()) {
                    NBTTagList enchantments = heldItem.func_77986_q();
                    for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                        if (enchantments.func_150305_b(i).func_74762_e("id") == Enchantment.func_185258_b((Enchantment)ModEnchantments.BREAKING_POINT)) {
                            stack = new ItemStack((Item)this.droppedCrackedGemItem);
                            enchanted = true;
                            shattered = true;
                            continue;
                        }
                        if (enchantments.func_150305_b(i).func_74762_e("id") != Enchantment.func_185258_b((Enchantment)ModEnchantments.FAIR_FIGHT)) continue;
                        stack = new ItemStack((Item)this.droppedGemItem);
                        enchanted = true;
                    }
                } else if (heldItem.func_77973_b() == ModItems.GEM_STAFF) {
                    stack = new ItemStack((Item)this.droppedGemItem);
                    enchanted = true;
                }
            }
            if (!enchanted) {
                if (this.field_70146_Z.nextInt(40) == 1 || cause.func_94541_c() && !(this instanceof EntityCarnelian)) {
                    stack = new ItemStack((Item)this.droppedCrackedGemItem);
                    shattered = true;
                } else {
                    stack = new ItemStack((Item)this.droppedGemItem);
                }
            }
            cause = shattered ? new ShatterDamage() : new PoofDamage();
            if (this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages")) {
                for (EntityPlayer playerIn : this.field_70170_p.field_73010_i) {
                    if (EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(this.func_184753_b())) {
                        playerIn.func_145747_a(cause.func_151519_b((EntityLivingBase)this));
                        continue;
                    }
                    for (UUID ownerId : this.jointOwners) {
                        if (!EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(ownerId)) continue;
                        playerIn.func_145747_a(cause.func_151519_b((EntityLivingBase)this));
                    }
                }
            }
            ((ItemGem)stack.func_77973_b()).setData(this, stack);
            this.func_70099_a(stack, 0.0f);
        }
        super.func_70645_a(cause);
    }

    public void func_70074_a(EntityLivingBase victim) {
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.playTameEffect();
        } else {
            super.func_70103_a(id);
        }
    }

    public void playTameEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.VILLAGER_HAPPY;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void createFireworks() {
        NBTTagList explosions = new NBTTagList();
        NBTTagCompound explosion = new NBTTagCompound();
        explosion.func_74783_a("Colors", new int[]{this.field_70170_p.field_73012_v.nextInt(0xFFFFFF)});
        explosion.func_74783_a("FadeColors", new int[]{this.field_70170_p.field_73012_v.nextInt(0xFFFFFF)});
        explosion.func_74757_a("Trail", this.field_70170_p.field_73012_v.nextBoolean());
        explosion.func_74757_a("Flicker", this.field_70170_p.field_73012_v.nextBoolean());
        explosions.func_74742_a((NBTBase)explosion);
        ItemStack stack = new ItemStack(Items.field_151152_bP);
        stack.func_179543_a("Fireworks", true).func_74774_a("Flight", (byte)this.field_70146_Z.nextInt(3));
        stack.func_179543_a("Fireworks", true).func_74782_a("Explosions", (NBTBase)explosions);
        EntityFireworkRocket firework = new EntityFireworkRocket(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
        this.field_70170_p.func_72838_d((Entity)firework);
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public SoundEvent getObeySound() {
        return null;
    }

    public void playObeySound() {
        if (this.getObeySound() != null) {
            this.func_184185_a(this.getObeySound(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_70642_aH() {
        if (Config.canGemsMakeSounds) {
            super.func_70642_aH();
        }
    }

    public void func_184581_c(DamageSource source) {
        if (Config.canGemsMakeSounds) {
            super.func_184581_c(source);
        } else {
            this.func_184185_a(SoundEvents.field_187543_bD, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return this.isSpaceBorn ? 0xF000F0 : super.func_70070_b(partialTicks);
    }

    public float func_70013_c(float partialTicks) {
        return this.isSpaceBorn ? 1.0f : super.func_70013_c(partialTicks);
    }

    public EntityAgeable createChild(EntityAgeable ageable) {
        return null;
    }
}

