/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCarnelian
extends EntityGem {
    private static final DataParameter<Boolean> CHARGED = EntityDataManager.func_187226_a(EntityCarnelian.class, (DataSerializer)DataSerializers.field_187198_h);
    private int charge_ticks = 0;
    private int hit_count = 0;

    public EntityCarnelian(World worldIn) {
        this(worldIn, null);
    }

    public EntityCarnelian(World worldIn, UUID ownerId) {
        super(worldIn, ownerId);
        this.func_70105_a(0.9f, 2.3f);
        this.setMaxPlacement(3);
        this.field_70178_ae = true;
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(EntityLiving input) {
                return input != null && IMob.field_175450_e.apply((Object)input);
            }
        }));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.field_70180_af.func_187214_a(CHARGED, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("charged", ((Boolean)this.field_70180_af.func_187225_a(CHARGED)).booleanValue());
        compound.func_74768_a("charge_ticks", this.charge_ticks);
        compound.func_74768_a("hit_count", this.hit_count);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(CHARGED, (Object)compound.func_74767_n("charged"));
        this.charge_ticks = compound.func_74762_e("charge_ticks");
        this.hit_count = compound.func_74762_e("hit_count");
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (hand == EnumHand.MAIN_HAND && !this.field_70170_p.field_72995_K) {
            return super.func_184645_a(player, hand, stack) || super.setAttackWeapon(player, hand, stack);
        }
        return super.func_184645_a(player, hand, stack);
    }

    public boolean isCharged() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.field_70180_af.func_187227_b(CHARGED, (Object)charged);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_94541_c()) {
            return false;
        }
        if (!this.isOwner((EntityLivingBase)source.func_76346_g())) {
            this.charge_ticks += 20;
            ++this.hit_count;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            boolean smite;
            boolean bl = smite = this.field_70146_Z.nextInt(7) == 1;
            if (this.isCharged()) {
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(12.0).func_72321_a(0.0, (double)this.field_70170_p.func_72800_K(), 0.0);
                List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
                for (EntityLivingBase entity : list) {
                    if (this.isOwner(entity) || !smite) continue;
                    boolean shouldAttack = false;
                    if (entity instanceof EntityGem) {
                        try {
                            shouldAttack = !this.isOwnerId(EntityPlayer.func_146094_a((GameProfile)((EntityGem)entity).getOwner().func_146103_bH()));
                        }
                        catch (Exception e) {
                            shouldAttack = false;
                        }
                    }
                    if (shouldAttack) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 80));
                    }
                    shouldAttack = true;
                    if (entity instanceof EntityGem) {
                        try {
                            shouldAttack = this.isOwnerId(EntityPlayer.func_146094_a((GameProfile)((EntityGem)entity).getOwner().func_146103_bH()));
                        }
                        catch (Exception e) {
                            shouldAttack = true;
                        }
                    }
                    if (!shouldAttack) continue;
                    Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0f, true, true);
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                }
            } else if (smite) {
                Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, 1.0f, true, true);
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70652_k((Entity)target);
        }
        super.func_82196_d(target, distanceFactor);
    }

    public void func_70636_d() {
        if (this.hit_count > 7) {
            --this.charge_ticks;
            this.setCharged(true);
            if (this.charge_ticks < 7) {
                this.hit_count = 0;
                this.setCharged(false);
            }
        }
        super.func_70636_d();
    }

    public SoundEvent func_184639_G() {
        return ModSounds.AMETHYST_LIVING;
    }

    public SoundEvent func_184601_bQ() {
        return ModSounds.AMETHYST_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.AMETHYST_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.AMETHYST_DEATH;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return this.isCharged() ? 0xF000F0 : super.func_70070_b(partialTicks);
    }

    @Override
    public float func_70013_c(float partialTicks) {
        return this.isCharged() ? 1.0f : super.func_70013_c(partialTicks);
    }
}

