/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.blocks;

import java.util.ArrayList;
import java.util.Random;
import mod.akrivus.kagic.entity.EntityAgate;
import mod.akrivus.kagic.entity.EntityAmethyst;
import mod.akrivus.kagic.entity.EntityBismuth;
import mod.akrivus.kagic.entity.EntityCarnelian;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.EntityJasper;
import mod.akrivus.kagic.entity.EntityLapisLazuli;
import mod.akrivus.kagic.entity.EntityPearl;
import mod.akrivus.kagic.entity.EntityPeridot;
import mod.akrivus.kagic.entity.EntityRoseQuartz;
import mod.akrivus.kagic.entity.EntityRuby;
import mod.akrivus.kagic.entity.EntitySapphire;
import mod.akrivus.kagic.worldgen.WorldGenGemTunnel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockGemSeed
extends Block {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);

    public BlockGemSeed() {
        super(Material.field_151576_e, MapColor.field_151645_D);
        this.func_149663_c("gem_seed");
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149752_b(1000.0f);
        this.func_149722_s();
        this.func_149675_a(true);
        this.func_149715_a(9.0f);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        super.func_180645_a(worldIn, pos, state, random);
        if (!worldIn.field_72995_K) {
            this.age(worldIn, pos, state, random);
        }
    }

    public void age(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)AGE) < 3) {
            worldIn.func_175656_a(pos, state.func_177231_a((IProperty)AGE));
        } else {
            EntityGem[] gems = new EntityGem[]{new EntityRuby(worldIn), new EntitySapphire(worldIn), new EntityJasper(worldIn), new EntityAmethyst(worldIn), new EntityRoseQuartz(worldIn), new EntityPeridot(worldIn), new EntityPearl(worldIn), new EntityBismuth(worldIn), new EntityLapisLazuli(worldIn), new EntityCarnelian(worldIn), new EntityAgate(worldIn)};
            EntityGem newGem = (EntityGem)((Object)BlockGemSeed.checkSurroundings(worldIn, pos, (Object[])gems, true));
            BlockGemSeed.spawnGemInGround(worldIn, pos, newGem);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public static Object checkSurroundings(World worldIn, BlockPos pos, Object[] array, boolean succ) {
        double ruby = 0.0;
        double quartz = 0.0;
        double pearl = 0.0;
        double peridot = 0.0;
        double bismuth = 0.0;
        double lapis_lazuli = 0.0;
        double agate = 0.0;
        for (int x = -8; x <= 8; ++x) {
            for (int y = -8; y <= 8; ++y) {
                for (int z = -8; z <= 8; ++z) {
                    BlockPos blockpos = pos.func_177982_a(x, y, z);
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150348_b) {
                        if (worldIn.func_180495_p(blockpos).func_177229_b((IProperty)BlockStone.field_176247_a) == BlockStone.EnumType.DIORITE) {
                            agate += 0.33;
                            quartz += 0.31;
                            peridot += 0.3;
                            ruby += 0.06;
                            continue;
                        }
                        if (worldIn.func_180495_p(blockpos).func_177229_b((IProperty)BlockStone.field_176247_a) == BlockStone.EnumType.ANDESITE) {
                            ruby += 0.53;
                            peridot += 0.36;
                            quartz += 0.11;
                            continue;
                        }
                        if (worldIn.func_180495_p(blockpos).func_177229_b((IProperty)BlockStone.field_176247_a) != BlockStone.EnumType.GRANITE) continue;
                        ruby += 0.72;
                        quartz += 0.16;
                        peridot += 0.12;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150365_q) {
                        if (succ) {
                            worldIn.func_175656_a(blockpos, Blocks.field_150348_b.func_176223_P());
                        }
                        pearl += 0.99;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150366_p) {
                        if (succ) {
                            worldIn.func_175656_a(blockpos, Blocks.field_150348_b.func_176223_P());
                        }
                        peridot += 0.78;
                        ruby += 0.22;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150450_ax) {
                        if (succ) {
                            worldIn.func_175656_a(blockpos, Blocks.field_150348_b.func_176223_P());
                        }
                        ruby += 0.78;
                        peridot += 0.22;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150352_o) {
                        if (succ) {
                            worldIn.func_175656_a(blockpos, Blocks.field_150348_b.func_176223_P());
                        }
                        bismuth += 0.82;
                        peridot += 0.18;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150482_ag) {
                        if (succ) {
                            worldIn.func_175656_a(blockpos, Blocks.field_150348_b.func_176223_P());
                        }
                        bismuth += 0.82;
                        pearl += 0.18;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150369_x) {
                        if (succ) {
                            worldIn.func_175656_a(blockpos, Blocks.field_150348_b.func_176223_P());
                        }
                        lapis_lazuli += 0.99;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150322_A) {
                        quartz += 0.4;
                        agate += 0.32;
                        pearl += 0.28;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_180395_cM) {
                        quartz += 0.71;
                        pearl += 0.12;
                        ruby += 0.11;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150405_ch) {
                        quartz += 0.66;
                        ruby += 0.33;
                        pearl += 0.01;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150406_ce) {
                        quartz += 0.66;
                        ruby += 0.22;
                        pearl += 0.12;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150435_aG) {
                        pearl += 0.55;
                        quartz += 0.44;
                        ruby += 0.11;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150355_j) {
                        pearl += 0.55;
                        lapis_lazuli += 0.45;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150358_i) {
                        if (succ) {
                            worldIn.func_175698_g(blockpos);
                        }
                        lapis_lazuli += 0.55;
                        pearl += 0.45;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150353_l) {
                        peridot += 0.5;
                        agate += 0.25;
                        ruby += 0.25;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150356_k) {
                        if (succ) {
                            worldIn.func_175698_g(blockpos);
                        }
                        ruby += 0.55;
                        peridot += 0.3;
                        agate += 0.15;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150425_aM) {
                        agate += 0.81;
                        pearl += 0.18;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150424_aL) {
                        ruby += 0.48;
                        agate += 0.2;
                        peridot += 0.11;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150449_bY) {
                        if (succ) {
                            worldIn.func_175656_a(blockpos, Blocks.field_150424_aL.func_176223_P());
                        }
                        quartz += 0.99;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_189877_df) {
                        peridot += 0.66;
                        agate += 0.22;
                        ruby += 0.12;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_189880_di) {
                        pearl += 0.99;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150377_bs) {
                        pearl += 0.88;
                        bismuth += 0.11;
                        continue;
                    }
                    if (worldIn.func_180495_p(blockpos).func_177230_c() != Blocks.field_150343_Z) continue;
                    bismuth += 0.22;
                    pearl += 0.44;
                    agate += 0.33;
                }
            }
        }
        double[] chances = new double[]{ruby, ruby / 6.0, quartz, quartz / 2.0, quartz / 5.0, peridot, pearl, bismuth, lapis_lazuli, quartz / 3.0, agate};
        ArrayList<Object> spawnlist = new ArrayList<Object>();
        for (int i = 0; i < chances.length; ++i) {
            int multiples = (int)(chances[i] * 100.0);
            for (int j = 0; j < multiples; ++j) {
                spawnlist.add(array[i]);
            }
        }
        if (spawnlist.size() > 0) {
            return spawnlist.get(worldIn.field_73012_v.nextInt(spawnlist.size() - 1));
        }
        return array[0];
    }

    public static void spawnGemInGround(World worldIn, BlockPos pos, EntityGem newGem) {
        BlockPos temp;
        int z;
        BlockPos temp2;
        int x;
        int xlength = Integer.MAX_VALUE;
        int east = 0;
        for (x = 1; x <= 24; ++x) {
            temp2 = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p());
            if (!worldIn.func_175623_d(temp2) || !worldIn.func_175678_i(temp2) || Math.abs(x) >= xlength) continue;
            east = 1;
            xlength = Math.abs(x);
            break;
        }
        for (x = -1; x >= -24; --x) {
            temp2 = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p());
            if (!worldIn.func_175623_d(temp2) || !worldIn.func_175678_i(temp2) || Math.abs(x) >= xlength) continue;
            east = -1;
            xlength = Math.abs(x);
            break;
        }
        int zlength = Integer.MAX_VALUE;
        int north = 0;
        for (z = 1; z <= 24; ++z) {
            temp = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + z);
            if (!worldIn.func_175623_d(temp) || !worldIn.func_175678_i(temp) || Math.abs(z) >= zlength) continue;
            north = -1;
            zlength = Math.abs(z);
            break;
        }
        for (z = -1; z >= -24; --z) {
            temp = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + z);
            if (!worldIn.func_175623_d(temp) || !worldIn.func_175678_i(temp) || Math.abs(z) >= zlength) continue;
            north = 1;
            zlength = Math.abs(z);
            break;
        }
        int length = Math.min(xlength, zlength);
        WorldGenGemTunnel genTunnel = new WorldGenGemTunnel(Math.ceil(newGem.field_70131_O), Math.ceil(newGem.field_70130_N), north, east, length);
        genTunnel.func_180709_b(worldIn, worldIn.field_73012_v, pos);
        worldIn.func_175698_g(pos);
        newGem.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        newGem.field_98038_p = true;
        worldIn.func_72838_d((Entity)newGem);
        newGem.func_180482_a(worldIn.func_175649_E(newGem.func_180425_c()), null);
    }
}

