/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.witherskulls;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.entity.wither.EntityRichWither;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMettalicSkull
extends EntityWitherSkull {
    public EntityMettalicSkull(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityMettalicSkull(World worldIn, EntityLivingBase p_i1794_2_, double p_i1794_3_, double p_i1794_5_, double p_i1794_7_) {
        super(worldIn, p_i1794_2_, p_i1794_3_, p_i1794_5_, p_i1794_7_);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected float func_82341_c() {
        return 0.95f;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityMettalicSkull(World worldIn, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double p_i1795_8_, double p_i1795_10_, double p_i1795_12_) {
        super(worldIn, p_i1795_2_, p_i1795_4_, p_i1795_6_, p_i1795_8_, p_i1795_10_, p_i1795_12_);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public int getSkullType() {
        return Math.max(this.field_70180_af.func_75679_c(20) % 7, 0);
    }

    public void setSkullType(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    protected void func_70227_a(MovingObjectPosition movingObject) {
        if (!this.field_70170_p.field_72995_K) {
            if (movingObject.field_72308_g != null) {
                if (this.field_70235_a != null) {
                    movingObject.field_72308_g.field_70172_ad = 0;
                    BlockPos blockpos = new BlockPos(movingObject.field_72308_g.field_70165_t, movingObject.field_72308_g.field_70163_u + (double)movingObject.field_72308_g.func_70047_e(), movingObject.field_72308_g.field_70161_v);
                    Block block = this.field_70170_p.func_180495_p(new BlockPos((Vec3i)blockpos)).func_177230_c();
                    if (block.func_176195_g(this.field_70170_p, blockpos) != -1.0f && !block.func_149662_c() && block != Blocks.field_150339_S && block != Blocks.field_150340_R && block != Blocks.field_150475_bE && block != Blocks.field_150484_ah) {
                        this.setMettalic(this.field_70170_p, blockpos);
                    }
                    float damage = 60.0f;
                    switch (this.getSkullType()) {
                        case 0: {
                            damage = 20.0f;
                            break;
                        }
                        case 1: {
                            damage = 30.0f;
                            break;
                        }
                        case 2: {
                            damage = 45.0f;
                            break;
                        }
                        case 3: {
                            damage = 60.0f;
                            break;
                        }
                        case 4: {
                            damage = 10.0f;
                            break;
                        }
                        case 5: {
                            damage = 15.0f;
                            break;
                        }
                        case 6: {
                            damage = 25.0f;
                            break;
                        }
                        default: {
                            damage = 20.0f;
                        }
                    }
                    if (movingObject.field_72308_g.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.field_70235_a), this.field_70235_a instanceof EntityRichWither ? 30.0f : damage)) {
                        if (!movingObject.field_72308_g.func_70089_S()) {
                            this.field_70235_a.func_70691_i(10.0f);
                            int j = 0;
                            while ((float)j < 9.0f + movingObject.field_72308_g.field_70131_O + movingObject.field_72308_g.field_70130_N) {
                                if (this.field_70235_a instanceof EntityRichWither) {
                                    ((EntityRichWither)this.field_70235_a).earnMoney(1);
                                }
                                this.setMettalicItem(this.field_70170_p, movingObject.field_72308_g);
                                ++j;
                            }
                            if (this.field_70235_a instanceof EntityRichWither) {
                                this.field_70170_p.func_72908_a(this.field_70235_a.field_70165_t, this.field_70235_a.field_70163_u, this.field_70235_a.field_70161_v, "mowithers:WeHaveLosers", 4.0f, 1.0f);
                            }
                        } else {
                            this.func_174815_a(this.field_70235_a, movingObject.field_72308_g);
                        }
                    }
                } else {
                    movingObject.field_72308_g.func_70097_a(DamageSource.field_76376_m, 20.0f);
                }
                if (movingObject.field_72308_g instanceof EntityLivingBase) {
                    int b0 = 0;
                    if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                        b0 = 10;
                    } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        b0 = 40;
                    }
                    if (b0 > 0) {
                        ((EntityLivingBase)movingObject.field_72308_g).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 20 * b0, 1));
                    }
                }
            } else {
                BlockPos blockpos = movingObject.func_178782_a().func_177972_a(movingObject.field_178784_b);
                Block block = this.field_70170_p.func_180495_p(new BlockPos((Vec3i)blockpos)).func_177230_c();
                if (block.func_176195_g(this.field_70170_p, blockpos) != -1.0f && !block.func_149662_c() && block != Blocks.field_150339_S && block != Blocks.field_150340_R && block != Blocks.field_150475_bE && block != Blocks.field_150484_ah) {
                    this.setMettalic(this.field_70170_p, blockpos);
                }
            }
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            this.func_70106_y();
        }
    }

    protected int setMettalicItem(World world, Entity entity) {
        switch (this.getSkullType()) {
            case 0: {
                entity.func_145779_a(Items.field_151042_j, 1);
                return 0;
            }
            case 1: {
                entity.func_145779_a(Items.field_151043_k, 1);
                return 1;
            }
            case 2: {
                entity.func_145779_a(Items.field_151045_i, 1);
                return 2;
            }
            case 3: {
                entity.func_145779_a(Items.field_151166_bC, 1);
                return 3;
            }
            case 4: {
                entity.func_145779_a(Items.field_151044_h, 1);
                return 4;
            }
            case 5: {
                entity.func_145779_a(Items.field_151137_ax, 1);
                return 5;
            }
            case 6: {
                entity.func_70099_a(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), 0.0f);
                return 6;
            }
        }
        entity.func_145779_a(Items.field_151042_j, 1);
        return 0;
    }

    protected int setMettalic(World world, BlockPos pos) {
        switch (this.getSkullType()) {
            case 0: {
                world.func_175656_a(pos, Blocks.field_150339_S.func_176223_P());
                return 0;
            }
            case 1: {
                world.func_175656_a(pos, Blocks.field_150340_R.func_176223_P());
                return 1;
            }
            case 2: {
                world.func_175656_a(pos, Blocks.field_150484_ah.func_176223_P());
                return 2;
            }
            case 3: {
                world.func_175656_a(pos, Blocks.field_150475_bE.func_176223_P());
                return 3;
            }
            case 4: {
                world.func_175656_a(pos, Blocks.field_150402_ci.func_176223_P());
                return 4;
            }
            case 5: {
                world.func_175656_a(pos, Blocks.field_150451_bX.func_176223_P());
                return 5;
            }
            case 6: {
                world.func_175656_a(pos, Blocks.field_150368_y.func_176223_P());
                return 6;
            }
        }
        world.func_175656_a(pos, Blocks.field_150339_S.func_176223_P());
        return 0;
    }
}

