/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.witherskulls;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLightningShot
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private boolean inGround;
    public EntityLivingBase shootingEntity;
    private int ticksAlive;
    private int ticksInAir;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;

    public EntityLightningShot(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 2.0f);
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public EntityLightningShot(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        this(worldIn);
        this.func_70105_a(2.0f, 2.0f);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        double d6 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.accelerationX = accelX / d6 * 0.1;
        this.accelerationY = accelY / d6 * 0.1;
        this.accelerationZ = accelZ / d6 * 0.1;
    }

    public EntityLightningShot(World worldIn, EntityPlayer shooter, double accelX, double accelY, double accelZ) {
        this(worldIn);
        this.shootingEntity = shooter;
        this.func_70105_a(2.0f, 2.0f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        double d3 = MathHelper.func_76133_a((double)((accelX += this.field_70146_Z.nextGaussian() * 0.4) * accelX + (accelY += this.field_70146_Z.nextGaussian() * 0.4) * accelY + (accelZ += this.field_70146_Z.nextGaussian() * 0.4) * accelZ));
        this.accelerationX = accelX / d3 * 0.1;
        this.accelerationY = accelY / d3 * 0.1;
        this.accelerationZ = accelZ / d3 * 0.1;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v));
        }
        if (this.shootingEntity == null || this.shootingEntity != null && this.func_70068_e((Entity)this.shootingEntity) > 14400.0) {
            List list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
            if (list111 != null && !list111.isEmpty()) {
                for (int i111 = 0; i111 < list111.size(); ++i111) {
                    Entity entity1 = (Entity)list111.get(i111);
                    if (entity1 == null || !(entity1 instanceof EntityLiving)) continue;
                    if (entity1 instanceof EntityCreeper) {
                        ((EntityCreeper)entity1).func_146079_cb();
                    }
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    if (this.shootingEntity != null) {
                        if (entity1 instanceof EntityEnderman) {
                            entity1.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.shootingEntity)), 10.0f);
                            continue;
                        }
                        entity1.func_70097_a(DamageSource.func_76354_b((Entity)((EntityPlayer)this.shootingEntity), (Entity)this), 10.0f);
                        continue;
                    }
                    entity1.func_70097_a(DamageSource.func_94539_a(null), 10.0f);
                }
            }
            if (this.shootingEntity != null) {
                this.field_70170_p.func_72885_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, true, false);
            }
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && (this.shootingEntity != null && this.shootingEntity.field_70128_L || !this.field_70170_p.func_175667_e(new BlockPos((Entity)this)))) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
            if (this.inGround) {
                if (this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile)).func_177230_c() == this.inTile) {
                    ++this.ticksAlive;
                    if (this.ticksAlive == 600) {
                        this.func_70106_y();
                    }
                    return;
                }
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksAlive = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
            }
            Vec3 vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3 vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
            vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec31 = new Vec3(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.shootingEntity) && this.ticksInAir < 25) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                MovingObjectPosition movingobjectposition1 = axisalignedbb.func_72327_a(vec3, vec31);
                if (movingobjectposition1 == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null) {
                this.onImpact(movingobjectposition);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
            this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f2 = this.getMotionFactor();
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
            this.field_70159_w += this.accelerationX;
            this.field_70181_x += this.accelerationY;
            this.field_70179_y += this.accelerationZ;
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.DRIP_WATER, this.field_70165_t + (this.field_70146_Z.nextDouble() * 10.0 - 5.0), this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v + (this.field_70146_Z.nextDouble() * 10.0 - 5.0), 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected void onImpact(MovingObjectPosition movingObject) {
        if (!this.field_70170_p.field_72995_K) {
            List list111;
            if (movingObject.field_72308_g != null) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, movingObject.field_72308_g.field_70165_t, movingObject.field_72308_g.field_70163_u, movingObject.field_72308_g.field_70161_v));
                if (this.shootingEntity != null) {
                    if (movingObject.field_72308_g instanceof EntityEnderman) {
                        movingObject.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.shootingEntity)), 12.0f);
                        this.func_174815_a(this.shootingEntity, movingObject.field_72308_g);
                    } else {
                        movingObject.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)((EntityPlayer)this.shootingEntity), (Entity)this), 12.0f);
                        this.func_174815_a(this.shootingEntity, movingObject.field_72308_g);
                    }
                } else {
                    movingObject.field_72308_g.func_70097_a(DamageSource.field_76376_m, 12.0f);
                }
            }
            if ((list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(12.0, 12.0, 12.0))) != null && !list111.isEmpty()) {
                for (int i111 = 0; i111 < list111.size(); ++i111) {
                    Entity entity1 = (Entity)list111.get(i111);
                    if (entity1 == null || !(entity1 instanceof EntityLiving)) continue;
                    if (entity1 instanceof EntityCreeper) {
                        ((EntityCreeper)entity1).func_146079_cb();
                    }
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    if (this.shootingEntity != null) {
                        entity1.func_70097_a(DamageSource.func_76354_b((Entity)((EntityPlayer)this.shootingEntity), (Entity)this), 8.0f);
                        continue;
                    }
                    entity1.func_70097_a(DamageSource.func_94539_a(null), 8.0f);
                }
            }
            if (this.shootingEntity != null) {
                this.field_70170_p.func_72885_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, true, false);
            }
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.xTile);
        tagCompound.func_74777_a("yTile", (short)this.yTile);
        tagCompound.func_74777_a("zTile", (short)this.zTile);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        tagCompound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        tagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        tagCompound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        this.xTile = tagCompund.func_74765_d("xTile");
        this.yTile = tagCompund.func_74765_d("yTile");
        this.zTile = tagCompund.func_74765_d("zTile");
        this.inTile = tagCompund.func_150297_b("inTile", 8) ? Block.func_149684_b((String)tagCompund.func_74779_i("inTile")) : Block.func_149729_e((int)(tagCompund.func_74771_c("inTile") & 0xFF));
        boolean bl = this.inGround = tagCompund.func_74771_c("inGround") == 1;
        if (tagCompund.func_150297_b("direction", 9)) {
            NBTTagList nbttaglist = tagCompund.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150309_d(0);
            this.field_70181_x = nbttaglist.func_150309_d(1);
            this.field_70179_y = nbttaglist.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }
}

