/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.witherskulls;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlockSkull
extends EntityWitherSkull {
    public EntityBlockSkull(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityBlockSkull(World worldIn, EntityLivingBase p_i1794_2_, double p_i1794_3_, double p_i1794_5_, double p_i1794_7_) {
        super(worldIn, p_i1794_2_, p_i1794_3_, p_i1794_5_, p_i1794_7_);
        this.func_70105_a(1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityBlockSkull(World worldIn, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double p_i1795_8_, double p_i1795_10_, double p_i1795_12_) {
        super(worldIn, p_i1795_2_, p_i1795_4_, p_i1795_6_, p_i1795_8_, p_i1795_10_, p_i1795_12_);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70227_a(MovingObjectPosition movingObject) {
        if (!this.field_70170_p.field_72995_K) {
            if (movingObject.field_72308_g != null) {
                if (this.field_70235_a != null) {
                    movingObject.field_72308_g.field_70172_ad = 0;
                    BlockPos blockpos = new BlockPos(movingObject.field_72308_g.field_70165_t, movingObject.field_72308_g.field_70163_u + (double)movingObject.field_72308_g.func_70047_e(), movingObject.field_72308_g.field_70161_v);
                    Block block = this.field_70170_p.func_180495_p(new BlockPos((Vec3i)blockpos)).func_177230_c();
                    if (block.func_176195_g(this.field_70170_p, blockpos) != -1.0f && !block.func_149662_c()) {
                        this.setDownBlock(this.field_70170_p, blockpos);
                    }
                    float damage = 2500.0f;
                    switch (this.getSkullType()) {
                        case 0: {
                            damage = 12.0f;
                            break;
                        }
                        case 1: {
                            damage = 16.0f;
                            break;
                        }
                        case 2: {
                            damage = 60.0f;
                            break;
                        }
                        case 3: {
                            damage = 200.0f;
                            break;
                        }
                        case 4: {
                            damage = 2500.0f;
                            break;
                        }
                        default: {
                            damage = 12.0f;
                        }
                    }
                    if (movingObject.field_72308_g.func_70097_a(this.field_70146_Z.nextFloat() > 0.6f ? DamageSource.field_76377_j : DamageSource.func_76358_a((EntityLivingBase)this.field_70235_a), damage)) {
                        if (!movingObject.field_72308_g.func_70089_S()) {
                            this.field_70235_a.func_70691_i(5.0f);
                        } else {
                            this.func_174815_a(this.field_70235_a, movingObject.field_72308_g);
                        }
                    }
                } else {
                    movingObject.field_72308_g.func_70097_a(DamageSource.field_76376_m, 20.0f);
                }
                if (movingObject.field_72308_g instanceof EntityLivingBase) {
                    int b0 = 0;
                    if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                        b0 = 10;
                    } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        b0 = 40;
                    }
                    if (b0 > 0) {
                        ((EntityLivingBase)movingObject.field_72308_g).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 20 * b0, 1));
                    }
                }
            } else {
                BlockPos blockpos = movingObject.func_178782_a().func_177972_a(movingObject.field_178784_b);
                Block block = this.field_70170_p.func_180495_p(new BlockPos((Vec3i)blockpos)).func_177230_c();
                if (block.func_176195_g(this.field_70170_p, blockpos) != -1.0f && !block.func_149662_c()) {
                    this.setDownBlock(this.field_70170_p, blockpos);
                }
            }
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public int getSkullType() {
        return Math.max(this.field_70180_af.func_75679_c(20) % 5, 0);
    }

    public void setSkullType(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    protected int setDownBlock(World world, BlockPos pos) {
        switch (this.getSkullType()) {
            case 0: {
                world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
                return 0;
            }
            case 1: {
                world.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
                return 1;
            }
            case 2: {
                world.func_175656_a(pos, Blocks.field_150359_w.func_176223_P());
                return 2;
            }
            case 3: {
                world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
                return 3;
            }
            case 4: {
                world.func_175656_a(pos, Blocks.field_150357_h.func_176223_P());
                return 4;
            }
        }
        world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
        return 0;
    }
}

