/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.witherskulls;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.entity.wither.EntityAvatarWither;
import net.minecraft.entity.wither.EntityVoidWither;
import net.minecraft.entity.wither.EntityWitherGirl;
import net.minecraft.entity.wither.EntityWitherGirlPink;
import net.minecraft.entity.wither.EntityWitherGirlVoid;
import net.minecraft.entity.witherskulls.EntityVoidSkull;
import net.minecraft.entity.witherskulls.EntityWitherSkullAvatar;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlackHole
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private boolean inGround;
    public EntityLivingBase shootingEntity;
    private int ticksAlive;
    private int ticksInAir;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;

    public EntityBlackHole(World worldIn) {
        super(worldIn);
        this.func_70105_a(8.0f, 8.0f);
        this.func_85030_a("mowithers:BlackHole", Float.MAX_VALUE, 1.0f);
        this.func_85030_a("mowithers:Wind", 1.0f, 0.5f);
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return distance < (d1 *= 256.0) * d1;
    }

    public EntityBlackHole(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        this(worldIn);
        this.func_70105_a(8.0f, 8.0f);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        double d6 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.accelerationX = accelX / d6 * 0.1;
        this.accelerationY = accelY / d6 * 0.1;
        this.accelerationZ = accelZ / d6 * 0.1;
    }

    public EntityBlackHole(World worldIn, EntityPlayer shooter, double accelX, double accelY, double accelZ) {
        this(worldIn);
        this.shootingEntity = shooter;
        this.func_70105_a(8.0f, 8.0f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        double d3 = MathHelper.func_76133_a((double)((accelX += this.field_70146_Z.nextGaussian() * 0.4) * accelX + (accelY += this.field_70146_Z.nextGaussian() * 0.4) * accelY + (accelZ += this.field_70146_Z.nextGaussian() * 0.4) * accelZ));
        this.accelerationX = accelX / d3 * 0.1;
        this.accelerationY = accelY / d3 * 0.1;
        this.accelerationZ = accelZ / d3 * 0.1;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.shootingEntity != null && this.shootingEntity.field_70128_L || !this.field_70170_p.func_175667_e(new BlockPos((Entity)this)))) {
            this.func_70106_y();
        } else {
            List list111;
            super.func_70071_h_();
            if (this.inGround) {
                if (this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile)).func_177230_c() == this.inTile) {
                    ++this.ticksAlive;
                    if (this.ticksAlive == 600) {
                        this.func_70106_y();
                    }
                    return;
                }
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksAlive = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
            }
            Vec3 vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3 vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
            vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec31 = new Vec3(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            if (this.shootingEntity == null || movingobjectposition != null || this.shootingEntity != null && this.func_70068_e((Entity)this.shootingEntity) > 20000.0) {
                List list1111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0));
                if (list1111 != null && !list1111.isEmpty()) {
                    for (int i111 = 0; i111 < list1111.size(); ++i111) {
                        Entity entity1 = (Entity)list1111.get(i111);
                        if (entity1 == null || !(entity1 instanceof EntityLiving)) continue;
                        if (this.shootingEntity != null && this.shootingEntity instanceof EntityPlayer) {
                            if (entity1 instanceof EntityEnderman) {
                                entity1.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.shootingEntity)), 10000.0f);
                                continue;
                            }
                            entity1.func_70097_a(DamageSource.func_76354_b((Entity)((EntityPlayer)this.shootingEntity), (Entity)this), 10000.0f);
                            continue;
                        }
                        entity1.func_70097_a(DamageSource.func_94539_a(null), 10000.0f);
                    }
                }
                if (this.shootingEntity != null && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72885_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, false, false);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
            this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f2 = this.getMotionFactor();
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
            if (this.field_70173_aa % 200 == 0) {
                this.func_85030_a("mowithers:BlackHole", Float.MAX_VALUE, 1.0f);
                this.func_85030_a("mowithers:Wind", 1.0f, 0.75f);
            }
            if ((list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(72.0, 72.0, 72.0))) != null && !list111.isEmpty()) {
                for (int i111 = 0; i111 < list111.size(); ++i111) {
                    double d5;
                    double d4;
                    double d3;
                    double d2;
                    double d1;
                    Entity entity = (Entity)list111.get(i111);
                    if (!(entity == null || entity.func_70028_i((Entity)this.shootingEntity) || !(entity instanceof EntityLivingBase) || entity instanceof EntityVoidWither || entity instanceof EntityWitherGirl || entity instanceof EntityWitherGirlPink || entity instanceof EntityWitherGirlVoid)) {
                        if (entity.field_70163_u < this.field_70163_u) {
                            entity.field_70181_x += (double)0.025f;
                        }
                        d1 = 4.0;
                        d2 = this.field_70165_t - entity.field_70165_t;
                        d3 = this.field_70163_u - entity.field_70163_u;
                        d4 = this.field_70161_v - entity.field_70161_v;
                        d5 = d2 * d2 + d3 * d3 + d4 * d4;
                        entity.func_70024_g(d2 / d5 * d1, d3 / d5 * d1, d4 / d5 * d1);
                        BlockPos blockPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        if (entity.func_174831_c(blockPos) <= 12.0) {
                            if (entity instanceof EntityAvatarWither) {
                                this.shootingEntity = null;
                            }
                            entity.func_70097_a(DamageSource.field_76377_j, 100.0f);
                            entity.func_70097_a(DamageSource.field_76380_i, 100.0f);
                        }
                    }
                    if (entity == null || !(entity instanceof EntityItem) && !(entity instanceof EntityThrowable) && !(entity instanceof EntityFireball) && !(entity instanceof EntityFallingBlock) && !(entity instanceof EntityFishHook) && !(entity instanceof EntityArrow) && !(entity instanceof EntityXPOrb) && !(entity instanceof EntityTNTPrimed) && !(entity instanceof EntityMinecart) && !(entity instanceof EntityBoat) || entity instanceof EntityVoidSkull) continue;
                    d1 = 7.0;
                    d2 = this.field_70165_t - entity.field_70165_t;
                    d3 = this.field_70163_u - entity.field_70163_u;
                    d4 = this.field_70161_v - entity.field_70161_v;
                    d5 = d2 * d2 + d3 * d3 + d4 * d4;
                    entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.func_70024_g(d2 / d5 * d1, d3 / d5 * d1, d4 / d5 * d1);
                    BlockPos blockPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    if (!(entity.func_174831_c(blockPos) <= 12.0)) continue;
                    if (entity instanceof EntityWitherSkullAvatar) {
                        this.shootingEntity = null;
                    }
                    if (this.field_70146_Z.nextInt(10) != 0) continue;
                    entity.func_70106_y();
                }
            }
            int i = MathHelper.func_76128_c((double)(this.field_70163_u + 4.0));
            int i1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int j1 = MathHelper.func_76128_c((double)this.field_70161_v);
            for (int l1 = -12; l1 <= 12; ++l1) {
                for (int i2 = -12; i2 <= 12; ++i2) {
                    for (int j = -12; j <= 12; ++j) {
                        int j2 = i1 + l1;
                        int k = i + j;
                        int l = j1 + i2;
                        Block block = this.field_70170_p.func_180495_p(new BlockPos(j2, k, l)).func_177230_c();
                        if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l)) || block.func_176195_g(this.field_70170_p, new BlockPos(j2, k, l)) == -1.0f) continue;
                        this.field_70170_p.func_72838_d((Entity)new EntityFallingBlock(this.field_70170_p, (double)j2, (double)k, (double)l, this.field_70170_p.func_180495_p(new BlockPos(j2, k, l))));
                        if (this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_175698_g(new BlockPos(j2, k, l));
                    }
                }
            }
            this.field_70159_w += this.accelerationX;
            this.field_70181_x += this.accelerationY;
            this.field_70179_y += this.accelerationZ;
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            block10: for (int k = 0; k < 3; ++k) {
                int j = 6;
                while (true) {
                    float f = j;
                    float f3 = this.field_70173_aa <= 256 ? (float)this.field_70173_aa * 0.25f : 64.0f;
                    if (!(f < f3)) continue block10;
                    float f6 = (float)this.field_70173_aa * (float)Math.PI * 0.00125f + (float)j;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (this.field_70146_Z.nextGaussian() - 0.5) + (double)(MathHelper.func_76134_b((float)f6) * (float)j), this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (this.field_70146_Z.nextGaussian() - 0.5) + (double)(MathHelper.func_76126_a((float)f6) * (float)j), this.field_70159_w + this.accelerationX, this.field_70181_x + this.accelerationY, this.field_70179_y + this.accelerationZ, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextGaussian() - 0.5) + (double)(MathHelper.func_76134_b((float)f6) * (float)j), this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (this.field_70146_Z.nextGaussian() - 0.5) + (double)(MathHelper.func_76126_a((float)f6) * (float)j), this.field_70159_w + this.accelerationX, this.field_70181_x + this.accelerationY, this.field_70179_y + this.accelerationZ, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (this.field_70146_Z.nextGaussian() - 0.5) - (double)(MathHelper.func_76134_b((float)f6) * (float)j), this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (this.field_70146_Z.nextGaussian() - 0.5) - (double)(MathHelper.func_76126_a((float)f6) * (float)j), this.field_70159_w + this.accelerationX, this.field_70181_x + this.accelerationY, this.field_70179_y + this.accelerationZ, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextGaussian() - 0.5) - (double)(MathHelper.func_76134_b((float)f6) * (float)j), this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (this.field_70146_Z.nextGaussian() - 0.5) - (double)(MathHelper.func_76126_a((float)f6) * (float)j), this.field_70159_w + this.accelerationX, this.field_70181_x + this.accelerationY, this.field_70179_y + this.accelerationZ, new int[0]);
                    ++j;
                }
            }
        }
    }

    protected float getMotionFactor() {
        return 0.6f;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.xTile);
        tagCompound.func_74777_a("yTile", (short)this.yTile);
        tagCompound.func_74777_a("zTile", (short)this.zTile);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        tagCompound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        tagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        tagCompound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        this.xTile = tagCompund.func_74765_d("xTile");
        this.yTile = tagCompund.func_74765_d("yTile");
        this.zTile = tagCompund.func_74765_d("zTile");
        this.inTile = tagCompund.func_150297_b("inTile", 8) ? Block.func_149684_b((String)tagCompund.func_74779_i("inTile")) : Block.func_149729_e((int)(tagCompund.func_74771_c("inTile") & 0xFF));
        boolean bl = this.inGround = tagCompund.func_74771_c("inGround") == 1;
        if (tagCompund.func_150297_b("direction", 9)) {
            NBTTagList nbttaglist = tagCompund.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150309_d(0);
            this.field_70181_x = nbttaglist.func_150309_d(1);
            this.field_70179_y = nbttaglist.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }
}

