/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.wither;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.MoWithers.MoWithers;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.entity.wither.EntityAINearestWitherAttackTarget;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWitherSpider
extends EntityMob {
    private static final Predicate attackEntitySelector = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityLivingBase && !(p_180027_1_ instanceof EntityArmorStand) && ((EntityLivingBase)p_180027_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD;
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };
    private int skullShotTime;

    public EntityWitherSpider(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.35f, 0.8f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, attackEntitySelector, 3.0f, 1.0, 2.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestWitherAttackTarget((EntityCreature)this, EntityLivingBase.class, 2, false, false, attackEntitySelector));
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return MoWithers.isntACultist(p_70686_1_);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        ++this.skullShotTime;
        if (this.field_70173_aa % 40 == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.field_70153_n != null && this.func_70638_az() != null && this.field_70153_n instanceof EntitySkeleton) {
            ((EntitySkeleton)this.field_70153_n).func_70625_a((Entity)this.func_70638_az(), 10.0f, 30.0f);
            ((EntitySkeleton)this.field_70153_n).func_70624_b(this.func_70638_az());
            ((EntitySkeleton)this.field_70153_n).field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)((EntitySkeleton)this.field_70153_n), 1.2, false));
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.skullShotTime >= 100 && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
            this.attackEntityWithRangedAttack(this.func_70638_az(), 0.0f);
            this.skullShotTime = 0;
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 6.0) {
            this.func_70638_az().field_70172_ad = 0;
            if (this.func_70638_az() instanceof EntityLiving && ((EntityLiving)this.func_70638_az()).func_70638_az() == this) {
                ((EntityLiving)this.func_70638_az()).func_70624_b(null);
            }
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.field_70170_p.func_175710_j(this.func_180425_c()) && this.field_70122_E && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(2) == 0 && this.func_70068_e((Entity)this.func_70638_az()) < 400.0 && this.func_70068_e((Entity)this.func_70638_az()) > 10.0) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w += d0 / (double)f * 0.8 * 0.8 + this.field_70159_w * 0.5;
            this.field_70179_y += d1 / (double)f * 0.8 * 0.8 + this.field_70179_y * 0.5;
            this.field_70181_x += 1.0;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
    }

    protected String func_70639_aQ() {
        this.func_85030_a("mob.wither.idle", 0.4f, this.func_70647_i() + 0.1f);
        return "mob.spider.say";
    }

    protected String func_70621_aR() {
        this.func_85030_a("mowithers:Ehh", 0.4f, this.func_70647_i() + 0.1f);
        this.func_85030_a("mob.wither.hurt", 0.4f, this.func_70647_i() + 0.1f);
        return "mob.spider.say";
    }

    protected String func_70673_aS() {
        this.func_85030_a("mowithers:Ehh", 0.4f, 0.8f);
        this.func_85030_a("mob.wither.death", 0.4f, this.func_70647_i() + 0.1f);
        return "mob.spider.death";
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        super.func_70628_a(p_70628_1_, p_70628_2_);
        int j = this.field_70146_Z.nextInt(3 + p_70628_2_);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151075_bm, 1);
        }
        if (p_70628_1_ && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    protected int func_70682_h(int p_70682_1_) {
        return p_70682_1_;
    }

    protected void func_82167_n(Entity p_82167_1_) {
        if (p_82167_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_82167_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD && this.func_70681_au().nextInt(10) == 0) {
            this.func_70624_b((EntityLivingBase)p_82167_1_);
        }
        super.func_82167_n(p_82167_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public int func_70658_aO() {
        return 4;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70687_e(PotionEffect p_70687_1_) {
        int i = p_70687_1_.func_76456_a();
        return i == 1 || i == 5 || i == 10 || i == 14;
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean p_70839_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance p_180482_1_, IEntityLivingData p_180482_2_) {
        int i;
        IEntityLivingData p_180482_2_1 = super.func_180482_a(p_180482_1_, p_180482_2_);
        if (this.field_70170_p.field_73012_v.nextInt(20) == 0) {
            EntitySkeleton entityskeleton = new EntitySkeleton(this.field_70170_p);
            entityskeleton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityskeleton.func_180482_a(p_180482_1_, (IEntityLivingData)null);
            entityskeleton.func_82201_a(1);
            entityskeleton.func_70062_b(0, new ItemStack(Items.field_151052_q));
            entityskeleton.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
            this.field_70170_p.func_72838_d((Entity)entityskeleton);
            entityskeleton.func_70078_a((Entity)this);
        }
        if (p_180482_2_1 == null) {
            p_180482_2_1 = new GroupData();
            if (this.field_70170_p.field_73012_v.nextFloat() < 0.2f * p_180482_1_.func_180170_c()) {
                ((GroupData)p_180482_2_1).func_111104_a(this.field_70170_p.field_73012_v);
            }
        }
        if (p_180482_2_1 instanceof GroupData && (i = ((GroupData)p_180482_2_1).field_111105_a) > 0 && Potion.field_76425_a[i] != null) {
            this.func_70690_d(new PotionEffect(i, Integer.MAX_VALUE));
        }
        return p_180482_2_1;
    }

    public float func_70047_e() {
        return 0.55f;
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        if (super.func_70652_k(p_70652_1_)) {
            if (p_70652_1_ instanceof EntityLivingBase) {
                ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 200));
            }
            return true;
        }
        return false;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase entitylivingbase, float p_82196_2_) {
        entitylivingbase.field_70172_ad = 0;
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1014, new BlockPos((Entity)this), 0);
        double d1 = 1.5;
        Vec3 vec3 = this.func_70676_i(1.0f);
        double d2 = entitylivingbase.field_70165_t - (this.field_70165_t + vec3.field_72450_a * d1);
        double d3 = entitylivingbase.field_70163_u + 0.3 - (this.field_70163_u + 0.6);
        double d4 = entitylivingbase.field_70161_v - (this.field_70161_v + vec3.field_72449_c * d1);
        EntityWitherSkull entitylargefireball = new EntityWitherSkull(this.field_70170_p, (EntityLivingBase)this, d2, d3, d4);
        entitylargefireball.field_70165_t = this.field_70165_t + vec3.field_72450_a * d1;
        entitylargefireball.field_70163_u = this.field_70163_u + 0.6;
        entitylargefireball.field_70161_v = this.field_70161_v + vec3.field_72449_c * d1;
        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
    }

    public static class GroupData
    implements IEntityLivingData {
        public int field_111105_a;

        public void func_111104_a(Random p_111104_1_) {
            int i = p_111104_1_.nextInt(5);
            if (i <= 1) {
                this.field_111105_a = Potion.field_76424_c.field_76415_H;
            } else if (i <= 2) {
                this.field_111105_a = Potion.field_76420_g.field_76415_H;
            } else if (i <= 3) {
                this.field_111105_a = Potion.field_76428_l.field_76415_H;
            } else if (i <= 4) {
                this.field_111105_a = Potion.field_76441_p.field_76415_H;
            }
        }
    }
}

