/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.wither;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.MoWithers.MoWithers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.wither.EntityAINearestWitherAttackTarget;
import net.minecraft.entity.wither.EntityAIWitherCreeperSwell;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWitherCreeper
extends EntityMob {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 6;
    private int field_175494_bm = 0;
    private static final Predicate attackEntitySelector = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityLivingBase && !(p_180027_1_ instanceof EntityArmorStand) && ((EntityLivingBase)p_180027_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD;
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };

    public EntityWitherCreeper(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 1.65f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWitherCreeperSwell(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, new Predicate(){

            public boolean func_179958_a(Entity p_179958_1_) {
                return p_179958_1_ instanceof EntityOcelot;
            }

            public boolean apply(Object p_apply_1_) {
                return this.func_179958_a((Entity)p_apply_1_);
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestWitherAttackTarget((EntityCreature)this, EntityLivingBase.class, 2, true, true, attackEntitySelector));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return MoWithers.isntACultist(p_70686_1_);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            tagCompound.func_74757_a("powered", true);
        }
        tagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        tagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        tagCompound.func_74757_a("ignited", this.func_146078_ca());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(tagCompund.func_74767_n("powered") ? 1 : 0)));
        if (tagCompund.func_150297_b("Fuse", 99)) {
            this.fuseTime = tagCompund.func_74765_d("Fuse");
        }
        if (tagCompund.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = tagCompund.func_74771_c("ExplosionRadius");
        }
        if (tagCompund.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            List list111;
            if (this.field_70173_aa % 30 == 0) {
                this.func_70691_i(1.0f);
            }
            if ((list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b((double)this.explosionRadius, (double)this.explosionRadius, (double)this.explosionRadius))) != null && !list111.isEmpty()) {
                for (int i111 = 0; i111 < list111.size(); ++i111) {
                    Entity entity = (Entity)list111.get(i111);
                    if (entity == null || !(entity instanceof EntityLivingBase) || entity.field_70173_aa % 20 != 0 || ((EntityLivingBase)entity).func_70668_bt() == this.func_70668_bt()) continue;
                    this.func_70652_k(entity);
                }
            }
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.func_110143_aJ() > this.func_110138_aP() / 3.0f) {
                this.setCreeperState(0);
            }
            if (this.func_146078_ca()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("creeper.primed", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        super.func_70071_h_();
    }

    protected String func_70639_aQ() {
        this.func_85030_a("mob.wither.idle", 0.5f, this.func_70647_i() + 0.2f);
        return "mob.creeper.say";
    }

    protected String func_70621_aR() {
        this.func_85030_a("mowithers:Ehh", 0.5f, this.func_70647_i());
        this.func_85030_a("mob.wither.hurt", 0.5f, this.func_70647_i() + 0.2f);
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        this.func_85030_a("mowithers:Ehh", 0.5f, 0.7f);
        this.func_85030_a("mob.wither.death", 0.5f, this.func_70647_i() + 0.2f);
        return "mob.creeper.death";
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntitySkeleton) {
            int i = Item.func_150891_b((Item)Items.field_151096_cd);
            int j = Item.func_150891_b((Item)Items.field_151084_co);
            int k = i + this.field_70146_Z.nextInt(j - i + 1);
            this.func_145779_a(Item.func_150899_d((int)k), 1);
        }
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        this.func_174815_a((EntityLivingBase)this, p_70652_1_);
        if (p_70652_1_ instanceof EntityLivingBase) {
            ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 100, 3));
        }
        return true;
    }

    public boolean getPowered() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        super.func_70628_a(p_70628_1_, p_70628_2_);
        int j = this.field_70146_Z.nextInt(3 + p_70628_2_);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151075_bm, 1);
        }
        this.func_145779_a(Items.field_151016_H, 1);
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int p_70829_1_) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)p_70829_1_));
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public void func_70110_aj() {
    }

    public int func_70658_aO() {
        return this.getPowered() ? 15 : 5;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.getPowered() ? 2.0f : 1.0f;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * f, flag);
            List list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b((double)((float)this.explosionRadius * f), (double)((float)this.explosionRadius * f), (double)((float)this.explosionRadius * f)));
            if (list111 != null && !list111.isEmpty()) {
                for (int i111 = 0; i111 < list111.size(); ++i111) {
                    Entity entity = (Entity)list111.get(i111);
                    if (entity == null || !(entity instanceof EntityLivingBase)) continue;
                    this.func_70652_k(entity);
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 800, 3));
                }
            }
            this.func_70106_y();
        }
    }

    public boolean func_146078_ca() {
        return this.field_70180_af.func_75683_a(18) != 0;
    }

    public void func_146079_cb() {
        this.field_70180_af.func_75692_b(18, (Object)1);
    }

    public void func_175493_co() {
        ++this.field_175494_bm;
    }
}

