/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.wither;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.entity.wither.EntityAINearestWitherAttackTarget;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpawnerWither
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob {
    private float[] field_82220_d = new float[2];
    private float[] field_82221_e = new float[2];
    private float[] field_82217_f = new float[2];
    private float[] field_82218_g = new float[2];
    private int[] field_82223_h = new int[2];
    private int[] field_82224_i = new int[2];
    private int blockBreakCounter;
    private String mobID = "WitherCultist";
    private int spawnDelay = 20;
    private int minSpawnDelay = 100;
    private int maxSpawnDelay = 200;
    private int spawnCount = 4;
    public double mobRotation;
    public double prevMobRotation;
    private Entity cachedEntity;
    private static final Predicate attackEntitySelector = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_180027_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD;
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };

    public EntitySpawnerWither(World worldIn) {
        super(worldIn);
        this.func_70062_b(0, new ItemStack(Items.field_151063_bx, 1, EntityList.func_180122_a((String)this.mobID)));
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(0.9f, 3.5f);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestWitherAttackTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, attackEntitySelector));
        this.field_70728_aV = 750;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public String getEntityNameToSpawn() {
        if (this.mobID == null) {
            this.mobID = "WitherCultist";
        }
        return this.mobID;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
        tagCompound.func_74778_a("EntityId", this.getEntityNameToSpawn());
        tagCompound.func_74777_a("Delay", (short)this.spawnDelay);
        tagCompound.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        tagCompound.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        tagCompound.func_74777_a("SpawnCount", (short)this.spawnCount);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
        this.mobID = tagCompund.func_74779_i("EntityId");
        this.spawnDelay = tagCompund.func_74765_d("Delay");
        if (tagCompund.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = tagCompund.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = tagCompund.func_74765_d("MaxSpawnDelay");
            this.spawnCount = tagCompund.func_74765_d("SpawnCount");
        }
        if (this.field_70170_p != null) {
            this.cachedEntity = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Entity func_180612_a(World worldIn) {
        return EntityList.func_75620_a((String)EntityList.func_75617_a((int)this.func_70694_bm().func_77952_i()), (World)worldIn);
    }

    private Entity func_180613_a(Entity p_180613_1_, boolean p_180613_2_) {
        if (p_180613_1_ instanceof EntityLivingBase && p_180613_1_.field_70170_p != null && p_180613_2_) {
            ((EntityLiving)p_180613_1_).func_180482_a(p_180613_1_.field_70170_p.func_175649_E(new BlockPos(p_180613_1_)), (IEntityLivingData)null);
            p_180613_1_.field_70170_p.func_72838_d(p_180613_1_);
        }
        return p_180613_1_;
    }

    protected String func_70639_aQ() {
        return "mob.wither.idle";
    }

    protected String func_70621_aR() {
        return "mob.wither.hurt";
    }

    protected String func_70673_aS() {
        return "mob.wither.death";
    }

    public void func_70636_d() {
        int j;
        int i;
        double d5;
        double d1;
        double d3;
        Entity entity;
        this.field_70181_x *= (double)0.6f;
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            double d0;
            if (this.field_70163_u < entity.field_70163_u || !this.isArmored() && this.field_70163_u < entity.field_70163_u + 5.0) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.5 - this.field_70181_x) * (double)0.6f;
            }
            if ((d3 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70161_v - this.field_70161_v) * d1) > 9.0) {
                d5 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += (d0 / d5 * 0.5 - this.field_70159_w) * (double)0.6f;
                this.field_70179_y += (d1 / d5 * 0.5 - this.field_70179_y) * (double)0.6f;
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > (double)0.05f) {
            this.field_70177_z = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (i = 0; i < 2; ++i) {
            int j2 = this.getWatchedTargetId(i + 1);
            Entity entity1 = null;
            if (j2 > 0) {
                entity1 = this.field_70170_p.func_73045_a(j2);
            }
            if (entity1 != null) {
                d1 = this.func_82214_u(i + 1);
                d3 = this.func_82208_v(i + 1);
                d5 = this.func_82213_w(i + 1);
                double d6 = entity1.field_70165_t - d1;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d3;
                double d8 = entity1.field_70161_v - d5;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d7, d9) * 180.0 / Math.PI));
                this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], f1, 40.0f);
                this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], f, 10.0f);
                continue;
            }
            this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], this.field_70761_aq, 10.0f);
        }
        boolean flag = this.isArmored();
        for (j = 0; j < 3; ++j) {
            double d10 = this.func_82214_u(j);
            double d2 = this.func_82208_v(j);
            double d4 = this.func_82213_w(j);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0, new int[0]);
            if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5, new int[0]);
        }
        if (this.getInvulTime() > 0) {
            for (j = 0; j < 3; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 1.0, (double)0.7f, (double)0.7f, (double)0.9f, new int[0]);
            }
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
        }
        BlockPos blockpos = this.func_180425_c().func_177981_b(4);
        if (this.field_70170_p.field_72995_K) {
            double d0 = this.field_70165_t - 0.5 + (double)this.field_70146_Z.nextFloat();
            double d11 = (double)(MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.02f)) * 0.1f) + (this.field_70163_u + 4.0 + (double)this.field_70146_Z.nextFloat());
            double d2 = this.field_70161_v - 0.5 + (double)this.field_70146_Z.nextFloat();
            for (j = 0; j < 3; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d11, d2, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, d0, d11, d2, 0.0, 0.0, 0.0, new int[0]);
            }
            this.prevMobRotation = this.mobRotation;
            this.mobRotation += 1.0;
        } else {
            boolean flag1 = false;
            if (this.spawnDelay <= 0) {
                if (this.mobID == null) {
                    this.mobID = "WitherCultist";
                }
                for (i = 0; i < this.spawnCount; ++i) {
                    Entity entity2 = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)this.field_70170_p);
                    double d2 = (double)blockpos.func_177958_n() + (double)this.field_70146_Z.nextInt(12) - 6.0;
                    double d31 = blockpos.func_177956_o() + this.field_70146_Z.nextInt(12) - 6;
                    double d4 = (double)blockpos.func_177952_p() + (double)this.field_70146_Z.nextInt(12) - 6.0;
                    EntityLiving entityliving = entity2 instanceof EntityLiving ? (EntityLiving)entity2 : null;
                    entity2.func_70012_b(d2, d31, d4, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    if (entityliving != null && (!entityliving.func_70601_bi() || !entityliving.func_70058_J())) continue;
                    entityliving.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), (IEntityLivingData)null);
                    this.field_70170_p.func_175718_b(2004, blockpos, 0);
                    if (entityliving != null) {
                        entityliving.func_70656_aK();
                        this.field_70170_p.func_72838_d((Entity)entityliving);
                    }
                    flag1 = true;
                }
                if (flag1) {
                    this.spawnDelay = this.minSpawnDelay + this.field_70146_Z.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
                }
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.func_70694_bm();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151063_bx) {
            if (!this.field_70170_p.field_72995_K) {
                this.spawnDelay = 1;
                this.mobID = EntityList.func_75617_a((int)itemstack.func_77960_j());
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + 4.5, this.field_70161_v, 0.0f, false, false);
                this.func_70062_b(0, itemstack);
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                if (itemstack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
            player.func_71038_i();
            return true;
        }
        return super.func_70085_c(player);
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.field_70170_p.field_73012_v.nextInt(i);
        }
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(10.0f);
            }
        } else {
            int i1;
            int i;
            super.func_70619_bc();
            block0: for (i = 1; i < 3; ++i) {
                if (this.field_70173_aa < this.field_82223_h[i - 1]) continue;
                this.field_82223_h[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int k2 = i - 1;
                    int l2 = this.field_82224_i[i - 1];
                    this.field_82224_i[k2] = this.field_82224_i[i - 1] + 1;
                    if (l2 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.field_82224_i[i - 1] = 0;
                    }
                }
                if ((i1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(i1);
                    if (entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 900.0 && this.func_70685_l(entity)) {
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.field_82223_h[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                        this.field_82224_i[i - 1] = 0;
                        continue;
                    }
                    this.func_82211_c(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), Predicates.and((Predicate)attackEntitySelector, (Predicate)IEntitySelector.field_180132_d));
                for (int k1 = 0; k1 < 10 && !list.isEmpty(); ++k1) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase)) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue block0;
                            this.func_82211_c(i, entitylivingbase.func_145782_y());
                            continue block0;
                        }
                        this.func_82211_c(i, entitylivingbase.func_145782_y());
                        continue block0;
                    }
                    list.remove(entitylivingbase);
                }
            }
            if (this.func_70638_az() != null) {
                this.func_82211_c(0, this.func_70638_az().func_145782_y());
            } else {
                this.func_82211_c(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    i = MathHelper.func_76128_c((double)this.field_70163_u);
                    i1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int j1 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        for (int i2 = -1; i2 <= 1; ++i2) {
                            for (int j = 0; j <= 3; ++j) {
                                int j2 = i1 + l1;
                                int k = i + j;
                                int l = j1 + i2;
                                Block block = this.field_70170_p.func_180495_p(new BlockPos(j2, k, l)).func_177230_c();
                                if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l)) || !this.canEntityDestroy(block, (IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l), (Entity)this)) continue;
                                flag = this.field_70170_p.func_175655_b(new BlockPos(j2, k, l), true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1012, new BlockPos((Entity)this), 0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    public boolean canEntityDestroy(Block block, IBlockAccess world, BlockPos pos, Entity entity) {
        return block != Blocks.field_150474_ac && block != Blocks.field_180401_cv && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI;
    }

    public void func_82206_m() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    public int func_70658_aO() {
        return 4;
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 3.0 : this.field_70163_u + 2.2;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1014, new BlockPos((Entity)this), 0);
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3;
        double d7 = p_82209_4_ - d4;
        double d8 = p_82209_6_ - d5;
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
        if (p_82209_8_) {
            entitywitherskull.func_82343_e(true);
        }
        entitywitherskull.field_70163_u = d4;
        entitywitherskull.field_70165_t = d3;
        entitywitherskull.field_70161_v = d5;
        this.field_70170_p.func_72838_d((Entity)entitywitherskull);
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.launchWitherSkullToEntity(0, p_82196_1_);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof EntitySpawnerWither)) {
            Entity entity;
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.isArmored() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            entity = source.func_76346_g();
            if (entity != null && !(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.field_82224_i.length) {
                int n = i++;
                this.field_82224_i[n] = this.field_82224_i[n] + 3;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        this.func_70099_a(new ItemStack(Items.field_151063_bx, 1, EntityList.func_180122_a((String)this.mobID)), 0.0f);
        EntityItem entityitem = this.func_145779_a(Items.field_151156_bN, 1);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_150964_J);
            }
        }
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(900.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return this.field_70180_af.func_75679_c(17 + p_82203_1_);
    }

    public void func_82211_c(int p_82211_1_, int p_82211_2_) {
        this.field_70180_af.func_75692_b(17 + p_82211_1_, (Object)p_82211_2_);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70078_a(Entity entityIn) {
        this.field_70154_o = null;
    }

    protected float func_70599_aP() {
        return 3.0f;
    }
}

