/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.wither;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.witherskulls.EntityPinkSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPinkWither
extends EntityGolem
implements IBossDisplayData,
IRangedAttackMob {
    private float[] field_82220_d = new float[2];
    private float[] field_82221_e = new float[2];
    private float[] field_82217_f = new float[2];
    private float[] field_82218_g = new float[2];
    private int[] field_82223_h = new int[2];
    private int[] field_82224_i = new int[2];
    private int blockBreakCounter;
    public boolean isFed;

    public EntityPinkWither(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(0.9f, 3.5f);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, new Predicate(){

            public boolean func_179958_a(Entity p_179958_1_) {
                return p_179958_1_ instanceof EntityPlayer && p_179958_1_.func_70005_c_() == "SuperGirlyGamer";
            }

            public boolean apply(Object p_apply_1_) {
                return this.func_179958_a((Entity)p_apply_1_);
            }
        }, 2.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 40, 64.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151102_aT, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWither.class, true));
        this.field_70728_aV = 50;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
    }

    protected String func_70639_aQ() {
        return "mob.wither.idle";
    }

    protected String func_70621_aR() {
        return "mob.wither.hurt";
    }

    protected String func_70673_aS() {
        return "mob.wither.death";
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 2.0f;
    }

    public float func_180484_a(BlockPos p_180484_1_) {
        return this.field_70170_p.func_180495_p(p_180484_1_.func_177977_b()).func_177230_c() == Blocks.field_150349_c ? 10.0f : this.field_70170_p.func_175724_o(p_180484_1_) - 0.5f;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(5) == 0 && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.func_71045_bC();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151102_aT) {
            if (this.isFed) {
                this.func_82196_d((EntityLivingBase)player, 1.0f);
            } else {
                this.isFed = true;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            if (itemstack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
            return true;
        }
        return false;
    }

    public void spreadBonemealEffect(double posX, double posY, double posZ, World world) {
        IGrowable igrowable;
        BlockPos blockpos = new BlockPos(posX, posY, posZ);
        IBlockState iblockstate = world.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (block != null && block.func_149688_o() == Material.field_151578_c && block != Blocks.field_150458_ak) {
            if (this.field_70170_p.func_180494_b(new BlockPos(posX, posY, posZ)) == BiomeGenBase.field_76789_p || this.field_70170_p.func_180494_b(new BlockPos(posX, posY, posZ)) == BiomeGenBase.field_76788_q) {
                world.func_175656_a(blockpos, Blocks.field_150391_bh.func_176223_P());
            } else {
                world.func_175656_a(blockpos, Blocks.field_150349_c.func_176223_P());
            }
        }
        if (block != null && block instanceof IGrowable && (igrowable = (IGrowable)block).func_176473_a(world, blockpos, iblockstate, this.field_70170_p.field_72995_K) && !world.field_72995_K && (igrowable instanceof BlockCocoa || igrowable instanceof BlockCrops || igrowable instanceof BlockGrass || igrowable instanceof BlockMushroom || igrowable instanceof BlockSapling || igrowable instanceof BlockStem || igrowable instanceof BlockTallGrass)) {
            igrowable.func_176474_b(world, world.field_73012_v, blockpos, iblockstate);
        }
    }

    public void func_70636_d() {
        int j;
        int i;
        double d5;
        double d1;
        double d0;
        double d3;
        Entity entity;
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.5;
        }
        if (this.field_70146_Z.nextInt(120) == 0) {
            this.spreadBonemealEffect(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
            this.spreadBonemealEffect(this.field_70165_t, this.field_70163_u - 0.25, this.field_70161_v, this.field_70170_p);
        }
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null && (d3 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70161_v - this.field_70161_v) * d1) > 1.0) {
            d5 = MathHelper.func_76133_a((double)d3);
            this.field_70159_w += (d0 / d5 * 0.5 - this.field_70159_w) * 0.5;
            this.field_70179_y += (d1 / d5 * 0.5 - this.field_70179_y) * 0.5;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > (double)0.05f) {
            this.field_70177_z = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (i = 0; i < 2; ++i) {
            int j2 = this.getWatchedTargetId(i + 1);
            Entity entity1 = null;
            if (j2 > 0) {
                entity1 = this.field_70170_p.func_73045_a(j2);
            }
            if (entity1 != null) {
                d1 = this.func_82214_u(i + 1);
                d3 = this.func_82208_v(i + 1);
                d5 = this.func_82213_w(i + 1);
                double d6 = entity1.field_70165_t - d1;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d3;
                double d8 = entity1.field_70161_v - d5;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d7, d9) * 180.0 / Math.PI));
                this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], f1, 40.0f);
                this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], f, 10.0f);
                continue;
            }
            this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], this.field_70761_aq, 10.0f);
        }
        boolean flag = this.isArmored();
        for (j = 0; j < 3; ++j) {
            double d10 = this.func_82214_u(j);
            double d2 = this.func_82208_v(j);
            double d4 = this.func_82213_w(j);
            this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.3, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            if (!flag && (this.field_70170_p.field_73012_v.nextInt(5) != 0 || !this.isFed)) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.getInvulTime() > 0) {
            for (j = 0; j < 15; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(10.0f);
            }
        } else {
            List list111;
            int i;
            super.func_70619_bc();
            for (i = 1; i < 3; ++i) {
                if (this.field_70173_aa < this.field_82223_h[i - 1] || !this.isFed) continue;
                this.field_82223_h[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(120);
                int k2 = i - 1;
                int l2 = this.field_82224_i[i - 1];
                this.field_82224_i[k2] = this.field_82224_i[i - 1] + 1;
                if (l2 > 15) {
                    float f = 20.0f;
                    float f1 = 1.0f;
                    double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                    double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                    double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                    this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                    this.field_82224_i[i - 1] = 0;
                }
                i = this.getWatchedTargetId(i);
            }
            if (this.func_70638_az() != null) {
                this.func_82211_c(0, this.func_70638_az().func_145782_y());
            } else {
                this.func_82211_c(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    i = MathHelper.func_76128_c((double)this.field_70163_u);
                    int i1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int j1 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        for (int i2 = -1; i2 <= 1; ++i2) {
                            for (int j = 0; j <= 3; ++j) {
                                int j2 = i1 + l1;
                                int k = i + j;
                                int l = j1 + i2;
                                Block block = this.field_70170_p.func_180495_p(new BlockPos(j2, k, l)).func_177230_c();
                                if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l)) || !this.canEntityDestroy(block, (IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l), (Entity)this)) continue;
                                flag = this.field_70170_p.func_175655_b(new BlockPos(j2, k, l), true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1012, new BlockPos((Entity)this), 0);
                    }
                }
            }
            if ((list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0))) != null && !list111.isEmpty()) {
                for (int i111 = 0; i111 < list111.size(); ++i111) {
                    Entity entity = (Entity)list111.get(i111);
                    if (entity == null || !(entity instanceof EntityLivingBase) || this.field_70146_Z.nextInt(20) != 0 || this.func_142014_c((EntityLivingBase)entity)) continue;
                    if (entity instanceof IMob) {
                        ((EntityLivingBase)entity).func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.field_70170_p.func_72890_a(entity, -1.0)), 1.0f);
                        ((EntityLivingBase)entity).func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this), 8.0f);
                        continue;
                    }
                    ((EntityLivingBase)entity).func_70691_i(8.0f);
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    public boolean canEntityDestroy(Block block, IBlockAccess world, BlockPos pos, Entity entity) {
        return block != Blocks.field_150353_l && block != Blocks.field_150480_ab && block != Blocks.field_180401_cv && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI;
    }

    public void func_82206_m() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    public int func_70658_aO() {
        return 4;
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 3.0 : this.field_70163_u + 2.2;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1014, new BlockPos((Entity)this), 0);
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3;
        double d7 = p_82209_4_ - d4;
        double d8 = p_82209_6_ - d5;
        EntityPinkSkull entitywitherskull = new EntityPinkSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
        if (p_82209_8_) {
            entitywitherskull.func_82343_e(true);
        }
        entitywitherskull.field_70163_u = d4;
        entitywitherskull.field_70165_t = d3;
        entitywitherskull.field_70161_v = d5;
        this.field_70170_p.func_72838_d((Entity)entitywitherskull);
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.launchWitherSkullToEntity(0, p_82196_1_);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76376_m && !(source.func_76346_g() instanceof EntityPinkWither)) {
            Entity entity;
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.isArmored() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            entity = source.func_76346_g();
            if (entity != null && !(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.field_82224_i.length) {
                int n = i++;
                this.field_82224_i[n] = this.field_82224_i[n] + 20;
            }
            if (source.func_76346_g() instanceof EntityLivingBase) {
                this.func_82196_d((EntityLivingBase)source.func_76346_g(), 1.0f);
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        this.func_145779_a(Items.field_151102_aT, 1 + this.field_70146_Z.nextInt(2));
        EntityItem entityitem = this.func_145779_a(Items.field_151156_bN, 1);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_150964_J);
            }
        }
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return this.field_70180_af.func_75679_c(17 + p_82203_1_);
    }

    public void func_82211_c(int p_82211_1_, int p_82211_2_) {
        this.field_70180_af.func_75692_b(17 + p_82211_1_, (Object)p_82211_2_);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    protected float func_70599_aP() {
        return 2.0f;
    }
}

