/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.wither;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.wither.EntityAINearestWitherAttackTarget;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;

public class EntityLostSkull
extends EntityMob {
    private static final Predicate attackEntitySelector = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_180027_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD;
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };

    public EntityLostSkull(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70765_h = new LostSkullMoveHelper();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIRandomFly());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AILookAround());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestWitherAttackTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, attackEntitySelector));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)new Byte(0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        switch (this.getSkullType()) {
            case 0: {
                return "Skeleton Skull";
            }
            case 1: {
                return "Wither Skeleton Skull";
            }
            case 2: {
                return "Zombie Head";
            }
            case 3: {
                return "Player Head";
            }
            case 4: {
                return "Creeper Head";
            }
        }
        return "Skeleton Skull";
    }

    protected void func_82164_bB() {
        this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, this.getSkullType() > 4 ? 4 : this.getSkullType()), 0.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        if (super.func_70652_k(p_70652_1_)) {
            if (p_70652_1_ instanceof EntityLivingBase) {
                if (p_70652_1_ instanceof EntityLiving && this.field_70146_Z.nextInt(5) == 0) {
                    ((EntityLiving)p_70652_1_).func_70624_b(null);
                }
                if (this.getSkullType() == 1) {
                    ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 80));
                }
            }
            return true;
        }
        return false;
    }

    public int getSkullType() {
        return this.field_70180_af.func_75683_a(13);
    }

    public void setSkullType(int p_82201_1_) {
        if (p_82201_1_ < 0) {
            p_82201_1_ = 0;
        }
        if (p_82201_1_ > 4) {
            p_82201_1_ = 4;
        }
        this.field_70180_af.func_75692_b(13, (Object)((byte)p_82201_1_));
        this.field_70178_ae = p_82201_1_ == 1;
    }

    protected String func_70639_aQ() {
        switch (this.getSkullType()) {
            case 0: {
                return "mob.skeleton.say";
            }
            case 1: {
                return "mob.skeleton.say";
            }
            case 2: {
                return "mob.zombie.say";
            }
            case 3: {
                return null;
            }
            case 4: {
                return null;
            }
        }
        return "mob.skeleton.say";
    }

    protected String func_70621_aR() {
        switch (this.getSkullType()) {
            case 0: {
                return "mob.skeleton.hurt";
            }
            case 1: {
                return "mob.skeleton.hurt";
            }
            case 2: {
                return "mob.zombie.hurt";
            }
            case 3: {
                return super.func_70621_aR();
            }
            case 4: {
                return "mob.creeper.say";
            }
        }
        return "mob.skeleton.hurt";
    }

    protected String func_70673_aS() {
        switch (this.getSkullType()) {
            case 0: {
                return "mob.skeleton.death";
            }
            case 1: {
                return "mob.skeleton.death";
            }
            case 2: {
                return "mob.zombie.death";
            }
            case 3: {
                return super.func_70621_aR();
            }
            case 4: {
                return "mob.creeper.death";
            }
        }
        return "mob.skeleton.death";
    }

    protected Item func_146068_u() {
        switch (this.getSkullType()) {
            case 0: {
                return Items.field_151103_aS;
            }
            case 1: {
                return Items.field_151044_h;
            }
            case 2: {
                return Items.field_151078_bh;
            }
            case 3: {
                return Items.field_151034_e;
            }
            case 4: {
                return Items.field_151016_H;
            }
        }
        return Items.field_151103_aS;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        int j;
        Item item = this.func_146068_u();
        if (item != null) {
            j = this.field_70146_Z.nextInt(2 + p_70628_2_);
            for (k = 0; k < j; ++k) {
                this.func_145779_a(item, 1);
            }
        }
        if (this.getSkullType() == 1) {
            j = this.field_70146_Z.nextInt(2 + p_70628_2_);
            for (k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151103_aS, 1);
            }
        }
        if (this.field_70146_Z.nextInt(15) == 0) {
            this.func_82164_bB();
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74774_a("SkullType", (byte)this.getSkullType());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("SkullType", 99)) {
            byte b0 = tagCompund.func_74771_c("SkullType");
            this.setSkullType(b0);
        }
    }

    public float func_70047_e() {
        switch (this.getSkullType()) {
            case 4: {
                return 0.325f;
            }
        }
        return 0.225f;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance p_180482_1_, IEntityLivingData p_180482_2_) {
        if (this.field_70170_p.field_73011_w instanceof WorldProviderHell) {
            if (this.func_70681_au().nextInt(5) > 0) {
                this.setSkullType(1);
            } else {
                this.setSkullType(0);
            }
        } else {
            this.setSkullType(this.field_70146_Z.nextInt(5));
        }
        return super.func_180482_a(p_180482_1_, p_180482_2_);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getSkullType() == 1) {
            this.func_70105_a(0.6f, 0.6f);
        } else {
            this.func_70105_a(0.5f, 0.5f);
        }
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (this.getSkullType() == 0 || this.getSkullType() == 2)) {
            float f = this.func_70013_c(1.0f);
            BlockPos blockpos = new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 10.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                this.func_70015_d(8);
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            BlockPos blockPos = new BlockPos(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e(), this.func_70638_az().field_70161_v);
            if (this.func_174831_c(blockPos) <= (double)(this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 7.0) {
                if (this.field_70173_aa % 10 == 0) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
                if (this.getSkullType() == 4 && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    this.func_70106_y();
                }
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_180433_a(double p_180433_1_, boolean p_180433_3_, Block p_180433_4_, BlockPos p_180433_5_) {
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.func_70090_H()) {
            this.func_70060_a(p_70612_1_, p_70612_2_, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.9;
            this.field_70181_x *= 0.9;
            this.field_70179_y *= 0.9;
        } else if (this.func_180799_ab()) {
            this.func_70060_a(p_70612_1_, p_70612_2_, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.75;
            this.field_70181_x *= 0.75;
            this.field_70179_y *= 0.75;
        } else {
            float f2 = 0.99f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            this.func_70060_a(p_70612_1_, p_70612_2_, this.field_70122_E ? 0.2f * f3 : 0.1f);
            f2 = 0.99f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    class LostSkullMoveHelper
    extends EntityMoveHelper {
        private EntityLostSkull field_179927_g;
        private int field_179928_h;

        public LostSkullMoveHelper() {
            super((EntityLiving)EntityLostSkull.this);
            this.field_179927_g = EntityLostSkull.this;
        }

        public void func_75641_c() {
            if (this.field_75643_f) {
                double d0 = this.field_75646_b - this.field_179927_g.field_70165_t;
                double d1 = this.field_75647_c - this.field_179927_g.field_70163_u;
                double d2 = this.field_75644_d - this.field_179927_g.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.field_179928_h-- <= 0) {
                    this.field_179928_h += this.field_179927_g.func_70681_au().nextInt(2) + 4;
                    if (this.func_179926_b(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        if (this.field_179927_g.func_70638_az() != null && this.field_179927_g.func_70638_az().func_70068_e((Entity)this.field_179927_g) < 45.0) {
                            this.field_179927_g.field_70159_w += d0 / d3 * 0.3;
                            this.field_179927_g.field_70181_x += d1 / d3 * 0.3;
                            this.field_179927_g.field_70179_y += d2 / d3 * 0.3;
                        } else {
                            this.field_179927_g.field_70159_w += d0 / d3 * 0.1;
                            this.field_179927_g.field_70181_x += d1 / d3 * 0.1;
                            this.field_179927_g.field_70179_y += d2 / d3 * 0.1;
                        }
                    } else {
                        this.field_75643_f = false;
                    }
                }
            }
        }

        private boolean func_179926_b(double p_179926_1_, double p_179926_3_, double p_179926_5_, double p_179926_7_) {
            double d4 = (p_179926_1_ - this.field_179927_g.field_70165_t) / p_179926_7_;
            double d5 = (p_179926_3_ - this.field_179927_g.field_70163_u) / p_179926_7_;
            double d6 = (p_179926_5_ - this.field_179927_g.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.field_179927_g.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.field_179927_g.field_70170_p.func_72945_a((Entity)this.field_179927_g, axisalignedbb = axisalignedbb.func_72317_d(d4, d5, d6)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class AIRandomFly
    extends EntityAIBase {
        private EntityLostSkull field_179454_a;

        public AIRandomFly() {
            this.field_179454_a = EntityLostSkull.this;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.field_179454_a.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.field_179454_a.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.field_179454_a.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.field_179454_a.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.field_179454_a.func_70681_au();
            if (this.field_179454_a.func_70638_az() != null) {
                double d0 = this.field_179454_a.func_70638_az().field_70165_t + (double)(random.nextFloat() * 2.0f - 1.0f);
                double d1 = this.field_179454_a.func_70638_az().field_70163_u + (double)this.field_179454_a.func_70638_az().func_70047_e() + (double)(random.nextFloat() * 2.0f - 1.0f);
                double d2 = this.field_179454_a.func_70638_az().field_70161_v + (double)(random.nextFloat() * 2.0f - 1.0f);
                this.field_179454_a.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            } else {
                double d0 = this.field_179454_a.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d1 = this.field_179454_a.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d2 = this.field_179454_a.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                this.field_179454_a.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            }
        }
    }

    class AILookAround
    extends EntityAIBase {
        private EntityLostSkull field_179472_a;

        public AILookAround() {
            this.field_179472_a = EntityLostSkull.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.field_179472_a.func_70638_az() == null) {
                this.field_179472_a.field_70125_A = -((float)(this.field_179472_a.field_70181_x * 90.0));
                this.field_179472_a.field_70759_as = -((float)Math.atan2(this.field_179472_a.field_70159_w, this.field_179472_a.field_70179_y)) * 180.0f / (float)Math.PI;
            } else {
                EntityLivingBase entitylivingbase = this.field_179472_a.func_70638_az();
                double d0 = 32.0;
                if (entitylivingbase.func_70068_e((Entity)this.field_179472_a) < d0 * d0) {
                    this.field_179472_a.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, 180.0f);
                }
            }
        }
    }
}

