/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.wither;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.wither.EntityAINearestWitherAttackTarget;
import net.minecraft.entity.witherskulls.EntityGhastWitherFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGhastWither
extends EntityMob
implements IBossDisplayData {
    private float[] field_82220_d = new float[2];
    private float[] field_82221_e = new float[2];
    private float[] field_82217_f = new float[2];
    private float[] field_82218_g = new float[2];
    private int[] field_82223_h = new int[2];
    private int[] field_82224_i = new int[2];
    private int blockBreakCounter;
    private static final Predicate attackEntitySelector = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityLivingBase && !(p_180027_1_ instanceof EntityGhast) && !(p_180027_1_ instanceof EntityGhastWither);
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };

    public EntityGhastWither(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(3.0f, 3.0f);
        this.field_70178_ae = true;
        this.field_70765_h = new GhastMoveHelper();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIFireballAttack());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestWitherAttackTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, attackEntitySelector));
        this.field_70728_aV = 250;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_110182_bF() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public void func_175454_a(boolean p_175454_1_) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(p_175454_1_ ? 1 : 0)));
    }

    public float func_70047_e() {
        return 1.95f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
    }

    protected String func_70639_aQ() {
        this.func_85030_a("mob.wither.idle", 3.0f, this.func_70647_i() + 0.4f);
        return "mob.ghast.moan";
    }

    protected String func_70621_aR() {
        this.func_85030_a("mob.wither.hurt", 3.0f, this.func_70647_i() + 0.4f);
        return "mob.ghast.scream";
    }

    protected String func_70673_aS() {
        this.func_85030_a("mob.wither.death", 3.0f, this.func_70647_i() + 0.4f);
        return "mob.ghast.death";
    }

    public void func_70636_d() {
        int j;
        int i;
        List list111;
        Entity entity;
        if (this.field_70177_z < this.field_70759_as - 10.0f) {
            this.field_70177_z = this.field_70759_as - 10.0f;
        }
        if (this.field_70177_z > this.field_70759_as + 10.0f) {
            this.field_70177_z = this.field_70759_as + 10.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null && (list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0))) != null && !list111.isEmpty()) {
            for (int i111 = 0; i111 < list111.size(); ++i111) {
                Entity entity11 = (Entity)list111.get(i111);
                if (entity11 == null || !(entity11 instanceof EntityGhast) || !(entity instanceof EntityLivingBase)) continue;
                ((EntityGhast)entity11).func_70624_b((EntityLivingBase)entity);
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0) {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (i = 0; i < 2; ++i) {
            int j2 = this.getWatchedTargetId(i + 1);
            Entity entity1 = null;
            if (j2 > 0) {
                entity1 = this.field_70170_p.func_73045_a(j2);
            }
            if (entity1 != null) {
                double d1 = this.func_82214_u(i + 1);
                double d3 = this.func_82208_v(i + 1);
                double d5 = this.func_82213_w(i + 1);
                double d6 = entity1.field_70165_t - d1;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d3;
                double d8 = entity1.field_70161_v - d5;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d7, d9) * 180.0 / Math.PI));
                this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], f1, 40.0f);
                this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], f, 10.0f);
                continue;
            }
            this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], this.field_70761_aq, 10.0f);
        }
        boolean flag = this.isArmored();
        for (j = 0; j < 3; ++j) {
            double d10 = this.func_82214_u(j);
            double d2 = this.func_82208_v(j);
            double d4 = this.func_82213_w(j);
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.3, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            if (!flag && this.field_70170_p.field_73012_v.nextInt(10) != 0) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.getInvulTime() > 0) {
            for (j = 0; j < 15; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.DRIP_LAVA, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(15.0f);
            }
        } else {
            int i;
            super.func_70619_bc();
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(20) == 0 && this.field_70173_aa % 20 == 0) {
                EntityGhast blazeminion = new EntityGhast(this.field_70170_p);
                blazeminion.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), (IEntityLivingData)null);
                blazeminion.func_82149_j((Entity)this);
                double d1 = blazeminion.field_70165_t - this.field_70165_t;
                double d0 = blazeminion.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                blazeminion.func_70653_a((Entity)this, 2.0f, d1, d0);
                this.field_70170_p.func_72838_d((Entity)blazeminion);
            }
            block1: for (i = 1; i < 3; ++i) {
                int i1;
                if (this.field_70173_aa < this.field_82223_h[i - 1]) continue;
                this.field_82223_h[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int k2 = i - 1;
                    int l2 = this.field_82224_i[i - 1];
                    this.field_82224_i[k2] = this.field_82224_i[i - 1] + 1;
                    if (l2 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.field_82224_i[i - 1] = 0;
                    }
                }
                if ((i1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(i1);
                    if (entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 4096.0 && this.func_70685_l(entity)) {
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity, false);
                        this.field_82223_h[i - 1] = this.field_70173_aa + 60;
                        this.field_82224_i[i - 1] = 0;
                        continue;
                    }
                    this.func_82211_c(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0), Predicates.and((Predicate)attackEntitySelector, (Predicate)IEntitySelector.field_180132_d));
                for (int k1 = 0; k1 < 10 && !list.isEmpty(); ++k1) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase)) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue block1;
                            this.func_82211_c(i, entitylivingbase.func_145782_y());
                            continue block1;
                        }
                        this.func_82211_c(i, entitylivingbase.func_145782_y());
                        continue block1;
                    }
                    list.remove(entitylivingbase);
                }
            }
            if (this.func_70638_az() != null) {
                this.func_82211_c(0, this.func_70638_az().func_145782_y());
            } else {
                this.func_82211_c(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    i = MathHelper.func_76128_c((double)this.field_70163_u);
                    int i1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int j1 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        for (int i2 = -1; i2 <= 1; ++i2) {
                            for (int j = 0; j <= 3; ++j) {
                                int j2 = i1 + l1;
                                int k = i + j;
                                int l = j1 + i2;
                                Block block = this.field_70170_p.func_180495_p(new BlockPos(j2, k, l)).func_177230_c();
                                if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l)) || !this.canEntityDestroy(block, (IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l), (Entity)this)) continue;
                                flag = this.field_70170_p.func_175655_b(new BlockPos(j2, k, l), true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1012, new BlockPos((Entity)this), 0);
                    }
                }
            }
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(2.0f);
            }
        }
    }

    public boolean canEntityDestroy(Block block, IBlockAccess world, BlockPos pos, Entity entity) {
        return block != Blocks.field_150353_l && block != Blocks.field_150480_ab && block != Blocks.field_180401_cv && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI;
    }

    public void func_82206_m() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    public int func_70658_aO() {
        return 4;
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 3.25;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 0.5 : this.field_70163_u;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 3.25;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_, boolean scream) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t + p_82216_2_.field_70159_w * 5.0, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v + p_82216_2_.field_70179_y * 5.0, scream);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        if (p_82209_8_) {
            this.field_70170_p.func_180498_a((EntityPlayer)null, 1007, new BlockPos((Entity)this), 0);
        }
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1008, new BlockPos((Entity)this), 0);
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3;
        double d7 = p_82209_4_ - d4;
        double d8 = p_82209_6_ - d5;
        EntityGhastWitherFireball entitywitherskull = new EntityGhastWitherFireball(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
        entitywitherskull.field_92057_e = 3;
        entitywitherskull.field_70163_u = d4;
        entitywitherskull.field_70165_t = d3;
        entitywitherskull.field_70161_v = d5;
        this.field_70170_p.func_72838_d((Entity)entitywitherskull);
    }

    public void attackEntityWithRangedAttack(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.launchWitherSkullToEntity(0, p_82196_1_, true);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
            EntityGhast blazeminion = new EntityGhast(this.field_70170_p);
            blazeminion.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), (IEntityLivingData)null);
            blazeminion.func_82149_j((Entity)this);
            double d1 = blazeminion.field_70165_t - this.field_70165_t;
            double d0 = blazeminion.field_70161_v - this.field_70161_v;
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            blazeminion.func_70653_a((Entity)this, 2.0f, d1, d0);
            this.field_70170_p.func_72838_d((Entity)blazeminion);
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source.func_76346_g() instanceof EntityGhastWither)) {
            Entity entity;
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.isArmored() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            entity = source.func_76346_g();
            if (entity != null && !(entity instanceof EntityPlayer) && (entity instanceof EntityGhast || entity instanceof EntityGhastWither)) {
                return false;
            }
            if ("fireball".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer) {
                super.func_70097_a(source, 250.0f);
                ((EntityPlayer)source.func_76346_g()).func_71029_a((StatBase)AchievementList.field_76028_y);
                return true;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.field_82224_i.length) {
                int n = i++;
                this.field_82224_i[n] = this.field_82224_i[n] + 3;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        int j = 1 + this.field_70146_Z.nextInt(3 + p_70628_2_);
        for (k = 0; k < j + p_70628_2_; ++k) {
            this.func_145779_a(Items.field_151061_bv, 1);
        }
        for (k = 0; k < j + 1 + p_70628_2_; ++k) {
            this.func_145779_a(Items.field_151079_bi, 1);
        }
        EntityItem entityitem = this.func_145779_a(Items.field_151156_bN, 1);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
            }
        }
    }

    protected float func_70647_i() {
        return super.func_70647_i() - 0.2f;
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(900.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return this.field_70180_af.func_75679_c(17 + p_82203_1_);
    }

    public void func_82211_c(int p_82211_1_, int p_82211_2_) {
        this.field_70180_af.func_75692_b(17 + p_82211_1_, (Object)p_82211_2_);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public void func_70078_a(Entity entityIn) {
        this.field_70154_o = null;
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    protected void func_180433_a(double p_180433_1_, boolean p_180433_3_, Block p_180433_4_, BlockPos p_180433_5_) {
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                float f2 = 0.91f;
                if (this.field_70122_E) {
                    f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                float f3 = 0.16277136f / (f2 * f2 * f2);
                this.func_70060_a(p_70612_1_, p_70612_2_, this.field_70122_E ? 0.1f * f3 : 0.02f);
                f2 = 0.91f;
                if (this.field_70122_E) {
                    f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f2;
                this.field_70181_x *= (double)f2;
                this.field_70179_y *= (double)f2;
            } else if (this.func_180799_ab()) {
                float f2 = 0.91f;
                if (this.field_70122_E) {
                    f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                float f3 = 0.16277136f / (f2 * f2 * f2);
                this.func_70060_a(p_70612_1_, p_70612_2_, this.field_70122_E ? 0.1f * f3 : 0.02f);
                f2 = 0.91f;
                if (this.field_70122_E) {
                    f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f2;
                this.field_70181_x *= (double)f2;
                this.field_70179_y *= (double)f2;
            } else {
                float f2 = 0.91f;
                if (this.field_70122_E) {
                    f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                float f3 = 0.16277136f / (f2 * f2 * f2);
                this.func_70060_a(p_70612_1_, p_70612_2_, this.field_70122_E ? 0.1f * f3 : 0.02f);
                f2 = 0.91f;
                if (this.field_70122_E) {
                    f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f2;
                this.field_70181_x *= (double)f2;
                this.field_70179_y *= (double)f2;
            }
        } else {
            super.func_70612_e(p_70612_1_, p_70612_2_);
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    class GhastMoveHelper
    extends EntityMoveHelper {
        private EntityGhastWither field_179927_g;
        private int field_179928_h;
        private static final String __OBFID = "CL_00002216";

        public GhastMoveHelper() {
            super((EntityLiving)EntityGhastWither.this);
            this.field_179927_g = EntityGhastWither.this;
        }

        public void func_75641_c() {
            if (this.field_75643_f) {
                double d0 = this.field_75646_b - this.field_179927_g.field_70165_t;
                double d1 = this.field_75647_c - this.field_179927_g.field_70163_u;
                double d2 = this.field_75644_d - this.field_179927_g.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.field_179928_h-- <= 0) {
                    this.field_179928_h += this.field_179927_g.func_70681_au().nextInt(5) + 2;
                    if (this.func_179926_b(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.field_179927_g.field_70159_w += d0 / d3 * 0.15;
                        this.field_179927_g.field_70181_x += d1 / d3 * 0.15;
                        this.field_179927_g.field_70179_y += d2 / d3 * 0.15;
                    } else {
                        this.field_75643_f = false;
                    }
                }
            }
        }

        private boolean func_179926_b(double p_179926_1_, double p_179926_3_, double p_179926_5_, double p_179926_7_) {
            double d4 = (p_179926_1_ - this.field_179927_g.field_70165_t) / p_179926_7_;
            double d5 = (p_179926_3_ - this.field_179927_g.field_70163_u) / p_179926_7_;
            double d6 = (p_179926_5_ - this.field_179927_g.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.field_179927_g.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.field_179927_g.field_70170_p.func_72945_a((Entity)this.field_179927_g, axisalignedbb = axisalignedbb.func_72317_d(d4, d5, d6)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class AIRandomFly
    extends EntityAIBase {
        private EntityGhastWither field_179454_a;

        public AIRandomFly() {
            this.field_179454_a = EntityGhastWither.this;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.field_179454_a.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.field_179454_a.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.field_179454_a.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.field_179454_a.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.field_179454_a.func_70681_au();
            if (this.field_179454_a.func_70638_az() != null) {
                EntityLivingBase entitylivingbase = this.field_179454_a.func_70638_az();
                double d0 = entitylivingbase.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d1 = this.field_179454_a.isArmored() ? entitylivingbase.field_70163_u + 2.0 : entitylivingbase.field_70163_u + 24.0 + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d2 = entitylivingbase.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                this.field_179454_a.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            } else {
                double d0 = this.field_179454_a.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d1 = this.field_179454_a.isArmored() ? this.field_179454_a.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 2.0f) : this.field_179454_a.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d2 = this.field_179454_a.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                this.field_179454_a.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            }
        }
    }

    class AILookAround
    extends EntityAIBase {
        private EntityGhastWither field_179472_a;

        public AILookAround() {
            this.field_179472_a = EntityGhastWither.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.field_179472_a.func_70638_az() == null) {
                this.field_179472_a.field_70761_aq = this.field_179472_a.field_70177_z = -((float)Math.atan2(this.field_179472_a.field_70159_w, this.field_179472_a.field_70179_y)) * 180.0f / (float)Math.PI;
            } else {
                EntityLivingBase entitylivingbase = this.field_179472_a.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.field_179472_a) < d0 * d0) {
                    this.field_179472_a.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, 30.0f);
                }
            }
        }
    }

    class AIFireballAttack
    extends EntityAIBase {
        private EntityGhastWither field_179470_b;
        public int field_179471_a;

        AIFireballAttack() {
            this.field_179470_b = EntityGhastWither.this;
        }

        public boolean func_75250_a() {
            return this.field_179470_b.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.field_179471_a = 0;
        }

        public void func_75251_c() {
            this.field_179470_b.func_175454_a(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.field_179470_b.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.field_179470_b) < d0 * d0 && this.field_179470_b.func_70685_l((Entity)entitylivingbase)) {
                World world = this.field_179470_b.field_70170_p;
                ++this.field_179471_a;
                if (this.field_179471_a == 10) {
                    world.func_180498_a((EntityPlayer)null, 1007, new BlockPos((Entity)this.field_179470_b), 0);
                }
                if (this.field_179471_a == 20) {
                    this.field_179470_b.attackEntityWithRangedAttack(entitylivingbase, 0.0f);
                    this.field_179471_a = -40;
                }
            } else if (this.field_179471_a > 0) {
                --this.field_179471_a;
            }
            this.field_179470_b.func_175454_a(this.field_179471_a > 10);
        }
    }
}

