/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.wither;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.wither.EntityAINearestWitherAttackTarget;
import net.minecraft.entity.witherskulls.EntityMettalicSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDiamondWither
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob {
    private float[] field_82220_d = new float[2];
    private float[] field_82221_e = new float[2];
    private float[] field_82217_f = new float[2];
    private float[] field_82218_g = new float[2];
    private int[] field_82223_h = new int[2];
    private int[] field_82224_i = new int[2];
    private int blockBreakCounter;
    private static final Predicate attackEntitySelector = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_180027_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD;
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };

    public EntityDiamondWither(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(0.9f, 3.5f);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestWitherAttackTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, attackEntitySelector));
        this.field_70728_aV = 1000;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
    }

    protected String func_70639_aQ() {
        this.func_85030_a("mob.wither.idle", this.func_70599_aP(), this.func_70647_i() + 0.1f);
        return "mob.wither.idle";
    }

    protected String func_70621_aR() {
        return "mob.wither.hurt";
    }

    protected String func_70673_aS() {
        return "mob.wither.death";
    }

    protected float func_70647_i() {
        return super.func_70647_i() - 0.2f;
    }

    public void func_70636_d() {
        int j;
        int i;
        double d5;
        double d1;
        double d3;
        Entity entity;
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            double d0;
            if (this.field_70163_u < entity.field_70163_u || !this.isArmored() && this.field_70163_u < entity.field_70163_u + 4.0) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.5 - this.field_70181_x) * 0.5;
            }
            if ((d3 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70161_v - this.field_70161_v) * d1) > 9.0) {
                d5 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += (d0 / d5 * 0.5 - this.field_70159_w) * 0.5;
                this.field_70179_y += (d1 / d5 * 0.5 - this.field_70179_y) * 0.5;
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0) {
            this.field_70177_z = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (i = 0; i < 2; ++i) {
            int j2 = this.getWatchedTargetId(i + 1);
            Entity entity1 = null;
            if (j2 > 0) {
                entity1 = this.field_70170_p.func_73045_a(j2);
            }
            if (entity1 != null) {
                d1 = this.func_82214_u(i + 1);
                d3 = this.func_82208_v(i + 1);
                d5 = this.func_82213_w(i + 1);
                double d6 = entity1.field_70165_t - d1;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d3;
                double d8 = entity1.field_70161_v - d5;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d7, d9) * 180.0 / Math.PI));
                this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], f1, 40.0f);
                this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], f, 10.0f);
                continue;
            }
            this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], this.field_70761_aq, 10.0f);
        }
        boolean flag = this.isArmored();
        for (j = 0; j < 3; ++j) {
            double d10 = this.func_82214_u(j);
            double d2 = this.func_82208_v(j);
            double d4 = this.func_82213_w(j);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0, new int[0]);
            if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5, new int[]{133});
        }
        if (this.getInvulTime() > 0) {
            for (j = 0; j < 15; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[]{42});
            }
        }
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(50.0f);
            }
        } else {
            int i1;
            int i;
            super.func_70619_bc();
            block0: for (i = 1; i < 3; ++i) {
                if (this.field_70173_aa < this.field_82223_h[i - 1]) continue;
                this.field_82223_h[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int k2 = i - 1;
                    int l2 = this.field_82224_i[i - 1];
                    this.field_82224_i[k2] = this.field_82224_i[i - 1] + 1;
                    if (l2 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.field_82224_i[i - 1] = 0;
                    }
                }
                if ((i1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(i1);
                    if (entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 900.0 && this.func_70685_l(entity)) {
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.field_82223_h[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                        this.field_82224_i[i - 1] = 0;
                        continue;
                    }
                    this.func_82211_c(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), Predicates.and((Predicate)attackEntitySelector, (Predicate)IEntitySelector.field_180132_d));
                for (int k1 = 0; k1 < 10 && !list.isEmpty(); ++k1) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase)) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue block0;
                            this.func_82211_c(i, entitylivingbase.func_145782_y());
                            continue block0;
                        }
                        this.func_82211_c(i, entitylivingbase.func_145782_y());
                        continue block0;
                    }
                    list.remove(entitylivingbase);
                }
            }
            if (this.func_70638_az() != null) {
                this.func_82211_c(0, this.func_70638_az().func_145782_y());
            } else {
                this.func_82211_c(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    i = MathHelper.func_76128_c((double)this.field_70163_u);
                    i1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int j1 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        for (int i2 = -1; i2 <= 1; ++i2) {
                            for (int j = 0; j <= 3; ++j) {
                                int j2 = i1 + l1;
                                int k = i + j;
                                int l = j1 + i2;
                                Block block = this.field_70170_p.func_180495_p(new BlockPos(j2, k, l)).func_177230_c();
                                if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l)) || !this.canEntityDestroy(block, (IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l), (Entity)this)) continue;
                                flag = this.field_70170_p.func_175655_b(new BlockPos(j2, k, l), true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1012, new BlockPos((Entity)this), 0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(2.0f);
            }
        }
    }

    public boolean canEntityDestroy(Block block, IBlockAccess world, BlockPos pos, Entity entity) {
        return block != Blocks.field_150484_ah && block != Blocks.field_150482_ag && block != Blocks.field_180401_cv && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI;
    }

    public void func_82206_m() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    public int func_70658_aO() {
        return 18;
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.25;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 2.95 : this.field_70163_u + 2.4;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.25;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        this.func_85030_a("random.anvil_land", 3.0f, this.func_70647_i() - this.field_70146_Z.nextFloat() * 0.9f);
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3;
        double d7 = p_82209_4_ - d4;
        double d8 = p_82209_6_ - d5;
        EntityMettalicSkull entitywitherskull = new EntityMettalicSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
        entitywitherskull.setSkullType(2);
        entitywitherskull.field_70163_u = d4;
        entitywitherskull.field_70165_t = d3;
        entitywitherskull.field_70161_v = d5;
        this.field_70170_p.func_72838_d((Entity)entitywitherskull);
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.launchWitherSkullToEntity(0, p_82196_1_);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76379_h && source != DamageSource.field_82728_o && source != DamageSource.field_82729_p && source != DamageSource.field_76369_e && source != DamageSource.field_76368_d && !(source.func_76346_g() instanceof EntityDiamondWither)) {
            Entity entity;
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.isArmored() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            entity = source.func_76346_g();
            if (entity != null && !(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.field_82224_i.length) {
                int n = i++;
                this.field_82224_i[n] = this.field_82224_i[n] + 3;
            }
            this.func_85030_a("dig.stone", 3.0f, this.func_70647_i() - 0.6f);
            if (!source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)source.func_76364_f();
                if (!source.func_94541_c()) {
                    entitylivingbase.func_70097_a(DamageSource.func_92087_a((Entity)this), 5.0f);
                }
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        this.func_145779_a(Items.field_151045_i, 128);
        EntityItem entityitem = this.func_145779_a(Items.field_151156_bN, 1);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
        Calendar calendar = Calendar.getInstance();
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                if (calendar.get(2) + 1 != 10 || calendar.get(5) != 31) continue;
                entityplayer.func_70691_i(5.0f);
            }
        }
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2400.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return this.field_70180_af.func_75679_c(17 + p_82203_1_);
    }

    public void func_82211_c(int p_82211_1_, int p_82211_2_) {
        this.field_70180_af.func_75692_b(17 + p_82211_1_, (Object)p_82211_2_);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70078_a(Entity entityIn) {
        this.field_70154_o = null;
    }

    protected float func_70599_aP() {
        return 3.0f;
    }
}

