/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.wither;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.wither.EntityAINearestWitherAttackTarget;
import net.minecraft.entity.wither.EntityFriendlyWither;
import net.minecraft.entity.wither.EntityWitherGirl;
import net.minecraft.entity.wither.EntityWitherGirlPink;
import net.minecraft.entity.wither.EntityWitherGirlVoid;
import net.minecraft.entity.witherskulls.EntityAirSkull;
import net.minecraft.entity.witherskulls.EntityEarthSkull;
import net.minecraft.entity.witherskulls.EntityFireSkull;
import net.minecraft.entity.witherskulls.EntityIceSkull;
import net.minecraft.entity.witherskulls.EntityLightningSkull;
import net.minecraft.entity.witherskulls.EntityMagmaSkull;
import net.minecraft.entity.witherskulls.EntityWaterSkull;
import net.minecraft.entity.witherskulls.EntityWitherDragonProjectile;
import net.minecraft.entity.witherskulls.EntityWitherSkullAvatar;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAvatarWither
extends EntityGolem
implements IBossDisplayData,
IRangedAttackMob,
IMob {
    private float[] field_82220_d = new float[2];
    private float[] field_82221_e = new float[2];
    private float[] field_82217_f = new float[2];
    private float[] field_82218_g = new float[2];
    private int[] field_82223_h = new int[2];
    private int[] field_82224_i = new int[2];
    private int blockBreakCounter;
    private int deathTicks;
    private static final Predicate attackEntitySelector = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_180027_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD;
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };

    public EntityAvatarWither(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(3.0f, 10.55655f);
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        this.field_70155_l = 16.0;
        this.field_70145_X = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 1, 100.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestWitherAttackTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, attackEntitySelector));
        this.field_70728_aV = 500000;
        this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
    }

    protected String func_70639_aQ() {
        this.func_85030_a("mowithers:AirWitherIdle", this.func_70599_aP(), this.func_70647_i());
        this.func_85030_a("mowithers:EarthWitherIdle", this.func_70599_aP(), this.func_70647_i());
        this.func_85030_a("mob.wither.idle", this.func_70599_aP(), this.func_70647_i() - 0.25f);
        this.func_85030_a("mowithers:WaterWitherIdle", this.func_70599_aP(), this.func_70647_i());
        this.func_85030_a("mowithers:WaterWitherIdle", this.func_70599_aP(), this.func_70647_i() - 0.3f);
        this.func_85030_a("mowithers:AirWitherIdle", this.func_70599_aP(), this.func_70647_i() - 0.1f);
        this.func_85030_a("mob.wither.idle", this.func_70599_aP(), this.func_70647_i() - 0.4f);
        this.func_85030_a("mowithers:LightningWitherIdle", this.func_70599_aP(), this.func_70647_i());
        return "mowithers:VoidWitherIdle";
    }

    protected String func_70621_aR() {
        this.func_85030_a("mowithers:AirWitherHurt", this.func_70599_aP(), this.func_70647_i());
        this.func_85030_a("mowithers:EarthWitherHurt", this.func_70599_aP(), this.func_70647_i());
        this.func_85030_a("mob.wither.hurt", this.func_70599_aP(), this.func_70647_i() - 0.25f);
        this.func_85030_a("mowithers:WaterWitherHurt", this.func_70599_aP(), this.func_70647_i());
        this.func_85030_a("mowithers:WaterWitherHurt", this.func_70599_aP(), this.func_70647_i() - 0.3f);
        this.func_85030_a("mowithers:AirWitherHurt", this.func_70599_aP(), this.func_70647_i() - 0.1f);
        this.func_85030_a("mob.wither.hurt", this.func_70599_aP(), this.func_70647_i() - 0.4f);
        this.func_85030_a("mowithers:LightningWitherHurt", this.func_70599_aP(), this.func_70647_i());
        return "mowithers:VoidWitherHurt";
    }

    protected String func_70673_aS() {
        this.func_85030_a("mowithers:AirWitherDeath", this.func_70599_aP(), this.func_70647_i());
        this.func_85030_a("mowithers:EarthWitherDeath", this.func_70599_aP(), this.func_70647_i());
        this.func_85030_a("mob.wither.death", this.func_70599_aP(), this.func_70647_i() - 0.25f);
        this.func_85030_a("mowithers:WaterWitherDeath", this.func_70599_aP(), this.func_70647_i());
        this.func_85030_a("mowithers:WaterWitherDeath", this.func_70599_aP(), this.func_70647_i() - 0.3f);
        this.func_85030_a("mowithers:AirWitherDeath", this.func_70599_aP(), this.func_70647_i() - 0.1f);
        this.func_85030_a("mob.wither.death", this.func_70599_aP(), this.func_70647_i() - 0.4f);
        this.func_85030_a("mowithers:LightningWitherDeath", this.func_70599_aP(), this.func_70647_i());
        return "mowithers:VoidWitherDeath";
    }

    public boolean func_70027_ad() {
        return true;
    }

    public void func_70636_d() {
        int i;
        double d1;
        Entity entity;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72911_I() && this.field_70170_p.func_175710_j(new BlockPos((Entity)this)) && this.field_70146_Z.nextInt(40) == 0) {
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - 0.5, this.field_70163_u + 10.5, this.field_70161_v - 0.5));
        }
        if (this.func_70638_az() == null) {
            this.field_70181_x *= 0.0;
        }
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            this.func_70625_a(entity, 180.0f, 180.0f);
            double d0 = entity.field_70165_t - this.field_70165_t;
            d1 = entity.field_70163_u - this.field_70163_u;
            double d2 = entity.field_70161_v - this.field_70161_v;
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            if (d3 > 9.0) {
                double d5 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += d0 / d5 * 0.9 - this.field_70159_w;
                this.field_70181_x += d1 / d5 * 0.9 - this.field_70181_x;
                this.field_70179_y += d2 / d5 * 0.9 - this.field_70179_y;
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.0) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() * 6.0 - 3.0), this.field_70163_u + 6.0 + (this.field_70146_Z.nextDouble() * 12.0 - 6.0), this.field_70161_v + (this.field_70146_Z.nextDouble() * 6.0 - 3.0), (double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), -this.field_70181_x * 3.1415927410125732 / 180.0, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f))), new int[0]);
            }
            this.field_70177_z = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (i = 0; i < 2; ++i) {
            int j = this.getWatchedTargetId(i + 1);
            Entity entity1 = null;
            if (j > 0) {
                entity1 = this.field_70170_p.func_73045_a(j);
            }
            if (entity1 != null) {
                d1 = this.func_82214_u(i + 1);
                double d3 = this.func_82208_v(i + 1);
                double d5 = this.func_82213_w(i + 1);
                double d6 = entity1.field_70165_t - d1;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d3;
                double d8 = entity1.field_70161_v - d5;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d7, d9) * 180.0 / Math.PI));
                this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], f1, 40.0f);
                this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], f, 10.0f);
                continue;
            }
            this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], this.field_70761_aq, 10.0f);
            if (!(this.func_110143_aJ() <= 0.0f)) continue;
            this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], this.field_70761_aq + (this.field_70146_Z.nextFloat() * 60.0f - 30.0f), 60.0f);
            this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], this.field_70146_Z.nextFloat() * 60.0f - 30.0f, 60.0f);
        }
        for (int y = 0; y < 5; ++y) {
            double d4;
            double d2;
            double d10;
            int j;
            boolean flag = this.isArmored();
            for (j = 0; j < 3; ++j) {
                d10 = this.func_82214_u(j);
                d2 = this.func_82208_v(j);
                d4 = this.func_82213_w(j);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, d10 + this.field_70146_Z.nextGaussian(), d2 + this.field_70146_Z.nextGaussian(), d4 + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[0]);
                if (this.field_70170_p.field_73012_v.nextInt(10) == 0) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                }
                if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.getInvulTime() > 0) {
                for (j = 0; j < 3; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + 4.0 + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + 4.0 + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.25, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + 4.0 + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.25, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[]{3});
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + 4.0 + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.25, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.DRIP_WATER, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + 4.0 + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.25, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                }
            }
            for (j = 0; j < 3; ++j) {
                d10 = this.func_82214_u(j);
                d2 = this.func_82208_v(j);
                d4 = this.func_82213_w(j);
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, d10 + this.field_70146_Z.nextGaussian(), d2 + this.field_70146_Z.nextGaussian(), d4 + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[]{3});
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[]{3});
                if (!flag && this.field_70170_p.field_73012_v.nextInt(20) != 0) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.DRIP_LAVA, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.DRIP_LAVA, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.getInvulTime() > 0) {
                for (j = 0; j < 3; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            for (j = 0; j < 3; ++j) {
                d10 = this.func_82214_u(j);
                d2 = this.func_82208_v(j);
                d4 = this.func_82213_w(j);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d10 + this.field_70146_Z.nextGaussian(), d2 + this.field_70146_Z.nextGaussian(), d4 + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                if (!flag && this.field_70170_p.field_73012_v.nextInt(10) != 0) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, d10 + this.field_70146_Z.nextGaussian(), d2 + this.field_70146_Z.nextGaussian(), d4 + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.getInvulTime() > 0) {
                for (j = 0; j < 3; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            for (j = 0; j < 3; ++j) {
                d10 = this.func_82214_u(j);
                d2 = this.func_82208_v(j);
                d4 = this.func_82213_w(j);
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, d10 + this.field_70146_Z.nextGaussian(), d2 + this.field_70146_Z.nextGaussian(), d4 + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                if (!flag && this.field_70170_p.field_73012_v.nextInt(20) != 0) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.getInvulTime() <= 0) continue;
            for (j = 0; j < 3; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.getInvulTime() > 0) {
            this.func_82142_c(true);
            this.field_70170_p.func_72877_b(this.field_70170_p.func_72820_D() + 1000L);
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0));
            if (list != null && !list.isEmpty()) {
                for (int i111 = 0; i111 < list.size(); ++i111) {
                    Entity entity2 = (Entity)list.get(i111);
                    if (entity2 == null || !(entity2 instanceof EntityLivingBase)) continue;
                    entity2.field_70159_w += (double)((float)(Math.random() * 0.1 - 0.05));
                    entity2.field_70181_x += (double)((float)(Math.random() * 0.1 - 0.05));
                    entity2.field_70179_y += (double)((float)(Math.random() * 0.1 - 0.05));
                    ((EntityLivingBase)entity2).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 20, 3));
                    ((EntityLivingBase)entity2).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 20, 3));
                    Entity tmp2783_2781 = entity2;
                    tmp2783_2781.field_70125_A += (float)(Math.random() * 4.0 - 2.0);
                    Entity tmp2808_2806 = entity2;
                    tmp2808_2806.field_70177_z += (float)(Math.random() * 4.0 - 2.0);
                    if (!entity2.field_70122_E || this.field_70146_Z.nextInt(5) != 0) continue;
                    entity2.field_70181_x = 0.5;
                    entity2.func_70097_a(DamageSource.field_76379_h, 1.0f);
                }
            }
        }
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 1, 100.0f));
                this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
                this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, attackEntitySelector));
                this.func_82142_c(false);
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 64.0f, false, false);
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
                List list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0));
                if (list111 != null && !list111.isEmpty() && this.field_70146_Z.nextInt(20) == 0) {
                    for (int i111 = 0; i111 < list111.size(); ++i111) {
                        Entity entity = (Entity)list111.get(i111);
                        if (entity == null || !(entity instanceof EntityLivingBase)) continue;
                        entity.func_70015_d(300);
                    }
                }
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 1 == 0) {
                this.func_70624_b(null);
                this.func_70691_i(100.0f);
            }
        } else {
            int i1;
            int i;
            Entity entity;
            super.func_70619_bc();
            List list1 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
            if (list1 != null && !list1.isEmpty()) {
                for (int i2 = 0; i2 < list1.size(); ++i2) {
                    double d5;
                    double d4;
                    double d3;
                    double d2;
                    entity = (Entity)list1.get(i2);
                    if (entity != null && (entity instanceof EntityItem || entity instanceof EntityFishHook || entity instanceof EntityArrow || entity instanceof EntityXPOrb || entity instanceof EntityTNTPrimed || entity instanceof EntityMinecart || entity instanceof EntityBoat)) {
                        d2 = this.field_70165_t - entity.field_70165_t;
                        d3 = this.field_70163_u + 2.0 - entity.field_70163_u;
                        d4 = this.field_70161_v - entity.field_70161_v;
                        d5 = d2 * d2 + d3 * d3 + d4 * d4;
                        entity.func_70024_g(d2 / d5 * 3.0, d3 / d5 * 3.0, d4 / d5 * 3.0);
                    }
                    if (entity == null || !(entity instanceof EntityLivingBase) && !(entity instanceof EntityDragonPart) || entity instanceof EntityAvatarWither || entity instanceof EntityWitherGirl || entity instanceof EntityWitherGirlVoid || entity instanceof EntityFriendlyWither || entity instanceof EntityWitherGirlPink) continue;
                    if (entity instanceof EntityPlayer) {
                        if (((EntityPlayer)entity).field_71075_bZ.field_75102_a) continue;
                        entity.func_70097_a(DamageSource.func_94539_a(null), 4.0f);
                        d2 = this.field_70165_t - entity.field_70165_t;
                        d3 = this.field_70163_u + 2.0 - entity.field_70163_u;
                        d4 = this.field_70161_v - entity.field_70161_v;
                        d5 = d2 * d2 + d3 * d3 + d4 * d4;
                        entity.func_70024_g(d2 / d5 * 1.5, d3 / d5 * 1.5, d4 / d5 * 1.5);
                        continue;
                    }
                    entity.func_70097_a(DamageSource.func_94539_a(null), 4.0f);
                    d2 = this.field_70165_t - entity.field_70165_t;
                    d3 = this.field_70163_u + 3.0 - entity.field_70163_u;
                    d4 = this.field_70161_v - entity.field_70161_v;
                    d5 = d2 * d2 + d3 * d3 + d4 * d4;
                    entity.func_70024_g(d2 / d5 * 2.5, d3 / d5 * 2.5, d4 / d5 * 2.5);
                    if (!(this.func_70068_e(entity) <= 36.0)) continue;
                    this.func_70652_k(entity);
                }
            }
            if (this.field_70170_p.field_73012_v.nextInt(120) == 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, !this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            }
            if (this.field_70170_p.field_73012_v.nextInt(300) == 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 16.0f, false, false);
                for (i = 0; i < 2 + this.field_70146_Z.nextInt(14); ++i) {
                    this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
                }
            }
            for (i = 1; i < 3; ++i) {
                if (this.field_70173_aa < this.field_82223_h[i - 1]) continue;
                this.field_82223_h[i - 1] = this.field_70173_aa + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                    int k2 = i - 1;
                    int l2 = this.field_82224_i[i - 1];
                    this.field_82224_i[k2] = this.field_82224_i[i - 1] + 1;
                    if (l2 > 15) {
                        float f = 16.0f;
                        float f1 = 2.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.field_82224_i[i - 1] = 0;
                        this.field_70170_p.func_72885_a((Entity)this, this.func_82214_u(i + 1), this.func_82208_v(i + 1) + 1.0, this.func_82213_w(i + 1), 2.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    }
                }
                if ((i1 = this.getWatchedTargetId(i)) > 0) {
                    entity = this.field_70170_p.func_73045_a(i1);
                    if (entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 22500.0) {
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.field_82223_h[i - 1] = this.field_70173_aa + 1;
                        this.field_82224_i[i - 1] = 0;
                        continue;
                    }
                    this.func_82211_c(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(150.0, 150.0, 150.0), Predicates.and((Predicate)attackEntitySelector, (Predicate)IEntitySelector.field_180132_d));
                for (int k1 = 0; k1 < 2 && !list.isEmpty(); ++k1) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S()) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (!((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                                this.func_82211_c(i, entitylivingbase.func_145782_y());
                            }
                        } else {
                            this.func_82211_c(i, entitylivingbase.func_145782_y());
                        }
                    }
                    list.remove(entitylivingbase);
                }
            }
            if (this.func_70638_az() != null) {
                this.func_82211_c(0, this.func_70638_az().func_145782_y());
            } else {
                this.func_82211_c(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    i = MathHelper.func_76128_c((double)this.field_70163_u);
                    i1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int j1 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int l1 = -15; l1 <= 15; ++l1) {
                        for (int i2 = -15; i2 <= 15; ++i2) {
                            for (int j = -15; j <= 15; ++j) {
                                int j2 = i1 + l1;
                                int k = i + j;
                                int l = j1 + i2;
                                Block block = this.field_70170_p.func_180495_p(new BlockPos(j2, k, l)).func_177230_c();
                                if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l)) || !this.canEntityDestroy(block, (IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l), (Entity)this)) continue;
                                boolean should = true;
                                if (block.func_149688_o() == Material.field_151578_c || block.func_149688_o() == Material.field_151577_b || block == Blocks.field_150351_n || block == Blocks.field_150424_aL) {
                                    should = false;
                                }
                                if (block == Blocks.field_150348_b || block == Blocks.field_150347_e) {
                                    should = this.field_70146_Z.nextInt(20) == 0;
                                }
                                this.field_70170_p.func_180498_a((EntityPlayer)null, 1012, new BlockPos((Entity)this), 0);
                                this.field_70170_p.func_175655_b(new BlockPos(j2, k, l), should);
                            }
                        }
                    }
                }
            }
            if (this.blockBreakCounter <= 0 && this.func_70638_az() != null) {
                this.blockBreakCounter = 6;
            }
            if (this.field_70173_aa % 1 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    public boolean canEntityDestroy(Block block, IBlockAccess world, BlockPos pos, Entity entity) {
        return block != Blocks.field_180401_cv && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI;
    }

    public void func_82206_m() {
        this.setInvulTime(1440);
        this.func_70606_j(this.func_110138_aP() / 50.0f);
    }

    public void func_70110_aj() {
    }

    public int func_70658_aO() {
        return 24;
    }

    protected void func_70609_aI() {
        List list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(128.0, 128.0, 128.0));
        if (list111 != null && !list111.isEmpty()) {
            for (int i111 = 0; i111 < list111.size(); ++i111) {
                Entity entity = (Entity)list111.get(i111);
                if (entity == null || !(entity instanceof EntityWitherDragonProjectile)) continue;
                double d1 = entity.field_70165_t - this.field_70165_t;
                double d2 = entity.field_70161_v - this.field_70161_v;
                double d3 = entity.field_70161_v - this.field_70161_v;
                double d4 = d1 * d1 + d2 * d2 + d3 * d3;
                double d5 = MathHelper.func_76133_a((double)d3);
                entity.field_70159_w += (d1 / d5 * 0.5 - entity.field_70159_w) * 0.5;
                entity.field_70181_x += (d2 / d5 * 0.5 - entity.field_70159_w) * 0.5;
                entity.field_70179_y += (d3 / d5 * 0.5 - entity.field_70179_y) * 0.5;
            }
        }
        this.field_70761_aq = this.field_70759_as + (this.field_70146_Z.nextFloat() * 16.0f - 8.0f);
        this.field_70177_z = 0.0f;
        this.field_70759_as = 0.0f;
        this.field_70125_A = this.field_70146_Z.nextFloat() * 90.0f - 45.0f;
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        if (player != null) {
            player.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + 15.0, this.field_70177_z - 180.0f, -15.0f);
        }
        ++this.deathTicks;
        if (this.field_70181_x < 0.0) {
            this.field_70181_x = 0.0;
        }
        if (this.deathTicks >= 240 && this.deathTicks <= 300) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 32.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 32.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 32.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + (double)f1, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks == 1) {
                this.func_85030_a(this.func_70673_aS(), 10000.0f, 1.0f);
                this.func_85030_a(this.func_70673_aS(), 10000.0f, 1.0f);
                this.func_85030_a(this.func_70673_aS(), 10000.0f, 1.0f);
                this.func_85030_a(this.func_70673_aS(), 10000.0f, 1.0f);
                this.func_85030_a(this.func_70673_aS(), 10000.0f, 1.0f);
                this.func_85030_a(this.func_70673_aS(), 10000.0f, 1.0f);
                this.func_85030_a(this.func_70673_aS(), 10000.0f, 1.0f);
                this.func_85030_a(this.func_70673_aS(), 10000.0f, 1.0f);
                this.field_70170_p.func_175669_a(1018, new BlockPos((Entity)this), 0);
            }
            if (this.deathTicks % 10 == 0 && this.deathTicks < 280) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - 0.5, this.field_70163_u + 10.5, this.field_70161_v - 0.5));
            }
        }
        this.func_70091_d(0.0, 0.2, 0.0);
        if (this.deathTicks == 300 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 1000000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v, j));
            }
            this.func_70099_a(new ItemStack(Blocks.field_150380_bt, 1), 12.0f);
            this.func_70099_a(new ItemStack((Block)Blocks.field_150461_bJ, 1), 12.0f);
            Item it = null;
            Block bl = null;
            Iterator ilist = Item.field_150901_e.iterator();
            int icount = 0;
            while (ilist.hasNext()) {
                it = (Item)ilist.next();
                if (it == null) continue;
                ++icount;
            }
            int j2 = 0;
            while (j2 < 128) {
                ilist = Item.field_150901_e.iterator();
                for (int k = 1 + this.field_70146_Z.nextInt(icount); k > 0 && ilist.hasNext(); --k) {
                    it = (Item)ilist.next();
                }
                if (it == null) continue;
                ++j2;
                EntityItem var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, this.field_70163_u + 12.0 + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, new ItemStack(it, 1, 0));
                this.field_70170_p.func_72838_d((Entity)var3);
            }
            Iterator blist = Block.field_149771_c.iterator();
            int bcount = 0;
            while (blist.hasNext()) {
                bl = (Block)blist.next();
                if (bl == null) continue;
                ++bcount;
            }
            int j3 = 0;
            while (j3 < 128) {
                blist = Block.field_149771_c.iterator();
                for (int k = 1 + this.field_70146_Z.nextInt(bcount); k > 0 && blist.hasNext(); --k) {
                    bl = (Block)blist.next();
                }
                if (bl == null) continue;
                ++j3;
                EntityItem var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, this.field_70163_u + 12.0 + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, new ItemStack(Item.func_150898_a((Block)bl), 1, 0));
                this.field_70170_p.func_72838_d((Entity)var3);
            }
            this.func_70106_y();
        }
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 3.25;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 9.0 : this.field_70163_u + 7.5;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 3.25;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.1f);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1009, new BlockPos((Entity)this), 0);
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3 + this.field_70146_Z.nextGaussian() * 3.0;
        double d7 = p_82209_4_ - d4 + this.field_70146_Z.nextGaussian() * 3.0;
        double d8 = p_82209_6_ - d5 + this.field_70146_Z.nextGaussian() * 3.0;
        if (this.field_70146_Z.nextInt(50) == 0) {
            d6 = p_82209_2_ - d3;
            d7 = p_82209_4_ - d4;
            d8 = p_82209_6_ - d5;
            EntityWitherSkullAvatar skull = new EntityWitherSkullAvatar(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
            skull.field_70163_u = d4;
            skull.field_70165_t = d3;
            skull.field_70161_v = d5;
            this.field_70170_p.func_72838_d((Entity)skull);
        } else {
            switch (this.field_70146_Z.nextInt(7)) {
                case 0: {
                    EntityAirSkull entitywitherskull = new EntityAirSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
                    entitywitherskull.field_70163_u = d4;
                    entitywitherskull.field_70165_t = d3;
                    entitywitherskull.field_70161_v = d5;
                    this.field_70170_p.func_72838_d((Entity)entitywitherskull);
                    break;
                }
                case 1: {
                    EntityEarthSkull entitywitherskull = new EntityEarthSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
                    if (p_82209_8_) {
                        entitywitherskull.func_82343_e(true);
                    }
                    ((EntityFireball)entitywitherskull).field_70163_u = d4;
                    ((EntityFireball)entitywitherskull).field_70165_t = d3;
                    ((EntityFireball)entitywitherskull).field_70161_v = d5;
                    this.field_70170_p.func_72838_d((Entity)entitywitherskull);
                    break;
                }
                case 2: {
                    EntityFireSkull entitywitherskull = new EntityFireSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
                    if (p_82209_8_) {
                        entitywitherskull.func_82343_e(true);
                    }
                    ((EntityFireball)entitywitherskull).field_70163_u = d4;
                    ((EntityFireball)entitywitherskull).field_70165_t = d3;
                    ((EntityFireball)entitywitherskull).field_70161_v = d5;
                    this.field_70170_p.func_72838_d((Entity)entitywitherskull);
                    break;
                }
                case 3: {
                    EntityWaterSkull entitywitherskull = new EntityWaterSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
                    if (p_82209_8_) {
                        entitywitherskull.func_82343_e(true);
                    }
                    ((EntityFireball)entitywitherskull).field_70163_u = d4;
                    ((EntityFireball)entitywitherskull).field_70165_t = d3;
                    ((EntityFireball)entitywitherskull).field_70161_v = d5;
                    this.field_70170_p.func_72838_d((Entity)entitywitherskull);
                    break;
                }
                case 4: {
                    EntityIceSkull entitywitherskull = new EntityIceSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
                    if (p_82209_8_) {
                        entitywitherskull.func_82343_e(true);
                    }
                    ((EntityFireball)entitywitherskull).field_70163_u = d4;
                    ((EntityFireball)entitywitherskull).field_70165_t = d3;
                    ((EntityFireball)entitywitherskull).field_70161_v = d5;
                    this.field_70170_p.func_72838_d((Entity)entitywitherskull);
                    break;
                }
                case 5: {
                    this.func_85030_a("ambient.cave.cave", 100.0f, 2.0f);
                    this.func_85030_a("ambient.weather.thunder", 5.0f, 2.0f);
                    EntityLightningSkull entitywitherskull = new EntityLightningSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
                    if (p_82209_8_) {
                        entitywitherskull.func_82343_e(true);
                    }
                    ((EntityFireball)entitywitherskull).field_70163_u = d4;
                    ((EntityFireball)entitywitherskull).field_70165_t = d3;
                    ((EntityFireball)entitywitherskull).field_70161_v = d5;
                    this.field_70170_p.func_72838_d((Entity)entitywitherskull);
                    break;
                }
                case 6: {
                    EntityMagmaSkull entitywitherskull = new EntityMagmaSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
                    if (p_82209_8_) {
                        entitywitherskull.func_82343_e(true);
                    }
                    ((EntityFireball)entitywitherskull).field_70163_u = d4;
                    ((EntityFireball)entitywitherskull).field_70165_t = d3;
                    ((EntityFireball)entitywitherskull).field_70161_v = d5;
                    this.field_70170_p.func_72838_d((Entity)entitywitherskull);
                }
            }
        }
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.launchWitherSkullToEntity(0, p_82196_1_);
        this.launchWitherSkullToEntity(0, p_82196_1_);
        this.launchWitherSkullToEntity(0, p_82196_1_);
        this.launchWitherSkullToEntity(0, p_82196_1_);
        p_82196_1_.field_70172_ad = 0;
        p_82196_1_.func_70097_a(DamageSource.func_94539_a(null), 1.0f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source == DamageSource.field_180137_b) {
            this.func_70691_i(amount);
            if (this.func_110139_bj() < 6000.0f) {
                this.func_110149_m(this.func_110139_bj() + amount);
            }
            return false;
        }
        if (source != DamageSource.field_76380_i && source != DamageSource.field_76369_e && source != DamageSource.field_76368_d && source != DamageSource.field_76366_f && source != DamageSource.field_82728_o && source != DamageSource.field_82729_p && source != DamageSource.field_76372_a && source != DamageSource.field_76370_b && source != DamageSource.field_76371_c && source != DamageSource.field_82727_n && source != DamageSource.field_76367_g && source != DamageSource.field_76379_h && !(source.func_76346_g() instanceof EntityAvatarWither)) {
            Entity entity;
            if (this.getInvulTime() > 0) {
                return false;
            }
            if (this.isArmored() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            entity = source.func_76346_g();
            if (entity != null && !(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            this.blockBreakCounter = 1;
            int i = 0;
            while (i < this.field_82224_i.length) {
                int n = i++;
                this.field_82224_i[n] = this.field_82224_i[n] + 20;
            }
            if (this.field_70170_p.field_73012_v.nextInt(20) == 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        EntityItem entityitem = this.func_145779_a(Items.field_151156_bN, 64);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_150964_J);
            }
        }
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return this.field_70180_af.func_75679_c(17 + p_82203_1_);
    }

    public void func_82211_c(int p_82211_1_, int p_82211_2_) {
        this.field_70180_af.func_75692_b(17 + p_82211_1_, (Object)p_82211_2_);
    }

    public boolean isArmored() {
        return true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70078_a(Entity entityIn) {
        this.field_70154_o = null;
    }

    protected float func_70599_aP() {
        return 10000.0f;
    }
}

