/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.wither;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import net.minecraft.MoWithers.MoWithersAchievments;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.wither.EntityAINearestWitherAttackTarget;
import net.minecraft.entity.wither.EntityAvatarWither;
import net.minecraft.entity.wither.EntityEarthWither;
import net.minecraft.entity.wither.EntityFireWither;
import net.minecraft.entity.wither.EntityFriendlyWither;
import net.minecraft.entity.wither.EntityHurricaneWither;
import net.minecraft.entity.wither.EntityWaterWither;
import net.minecraft.entity.wither.EntityWitherGirl;
import net.minecraft.entity.wither.EntityWitherGirlPink;
import net.minecraft.entity.wither.EntityWitherGirlVoid;
import net.minecraft.entity.witherskulls.EntityAirSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAirWither
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob {
    private float[] field_82220_d = new float[2];
    private float[] field_82221_e = new float[2];
    private float[] field_82217_f = new float[2];
    private float[] field_82218_g = new float[2];
    private int[] field_82223_h = new int[2];
    private int[] field_82224_i = new int[2];
    private int blockBreakCounter;
    private boolean water;
    private boolean fire;
    private boolean earth;
    private static final Predicate attackEntitySelector = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_180027_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD;
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };
    private static final Predicate withersUnit = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityEarthWither && ((EntityEarthWither)p_180027_1_).canConjoin() || p_180027_1_ instanceof EntityFireWither && ((EntityFireWither)p_180027_1_).canConjoin() || p_180027_1_ instanceof EntityWaterWither && ((EntityWaterWither)p_180027_1_).canConjoin();
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };

    public EntityAirWither(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(0.9f, 3.5f);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 40, 100.0f));
        this.field_70765_h = new AirWitherMoveHelper();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestWitherAttackTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, attackEntitySelector));
        this.field_70728_aV = 500;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
        if (this.canConjoin()) {
            tagCompound.func_74757_a("Unite", this.canConjoin());
        }
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
        this.shouldConjoin(tagCompund.func_74767_n("Unite"));
    }

    protected String func_70639_aQ() {
        return "mowithers:AirWitherIdle";
    }

    protected String func_70621_aR() {
        return "mowithers:AirWitherHurt";
    }

    protected String func_70673_aS() {
        return "mowithers:AirWitherDeath";
    }

    public void shouldConjoin(boolean p_94061_1_) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(p_94061_1_ ? 1 : 0)));
    }

    public boolean canConjoin() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.func_71045_bC();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151048_u) {
            this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
            this.shouldConjoin(true);
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        double d4;
        int j;
        int i;
        Entity entity;
        List list11;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0));
        if (list != null && !list.isEmpty() && this.canConjoin()) {
            this.func_70624_b(null);
            for (int i1 = 0; i1 < list.size(); ++i1) {
                Entity entity2 = (Entity)list.get(i1);
                if (entity2 != null && entity2 instanceof EntityEarthWither && ((EntityEarthWither)entity2).canConjoin()) {
                    ((EntityEarthWither)entity2).func_70624_b((EntityLivingBase)this);
                }
                if (entity2 != null && entity2 instanceof EntityFireWither && ((EntityFireWither)entity2).canConjoin()) {
                    ((EntityFireWither)entity2).func_70624_b((EntityLivingBase)this);
                }
                if (entity2 == null || !(entity2 instanceof EntityWaterWither) || !((EntityWaterWither)entity2).canConjoin()) continue;
                ((EntityWaterWither)entity2).func_70624_b((EntityLivingBase)this);
            }
        }
        if ((list11 = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ(), Predicates.and((Predicate[])new Predicate[]{withersUnit}))) != null && !list11.isEmpty() && this.canConjoin()) {
            for (int i3 = 0; i3 < list11.size(); ++i3) {
                Entity entity3 = (Entity)list11.get(i3);
                if (entity3 != null && entity3 instanceof EntityEarthWither && ((EntityEarthWither)entity3).canConjoin()) {
                    this.earth = true;
                    this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
                    entity3.func_70106_y();
                }
                if (entity3 != null && entity3 instanceof EntityFireWither && ((EntityFireWither)entity3).canConjoin()) {
                    this.fire = true;
                    this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
                    entity3.func_70106_y();
                }
                if (entity3 != null && entity3 instanceof EntityWaterWither && ((EntityWaterWither)entity3).canConjoin()) {
                    this.water = true;
                    this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
                    entity3.func_70106_y();
                }
                if (!this.water || !this.earth || !this.fire) continue;
                EntityAvatarWither entityavatar = new EntityAvatarWither(this.field_70170_p);
                entityavatar.func_82149_j((Entity)this);
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_72838_d((Entity)entityavatar);
                this.func_70106_y();
                entityavatar.func_82206_m();
                entityavatar.func_70091_d(this.field_70159_w, this.field_70181_x + 0.5, this.field_70179_y);
                for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                }
            }
        }
        if (this.isArmored()) {
            this.field_70159_w *= 0.75;
            this.field_70181_x *= 0.75;
            this.field_70179_y *= 0.75;
        }
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && this.func_110143_aJ() > 0.0f && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            this.func_70625_a(entity, 180.0f, 180.0f);
            double d0 = entity.field_70165_t - this.field_70165_t;
            double d1 = entity.field_70163_u - this.field_70163_u;
            double d2 = entity.field_70161_v - this.field_70161_v;
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            if (d3 > 9.0) {
                double d5 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += d0 / d5 * 0.99 - this.field_70159_w;
                this.field_70181_x += d1 / d5 * 0.99 - this.field_70181_x;
                this.field_70179_y += d2 / d5 * 0.99 - this.field_70179_y;
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0) {
            int i2;
            for (i2 = 0; i2 < 2; ++i2) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + (double)this.func_70047_e() + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5), (double)MathHelper.func_76126_a((float)(this.field_70759_as * (float)Math.PI / 180.0f)), -this.field_70181_x * 3.1415927410125732 / 180.0, (double)(-MathHelper.func_76134_b((float)(this.field_70759_as * (float)Math.PI / 180.0f))), new int[0]);
            }
            for (i2 = 0; i2 < 4; ++i2) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 2.0 + (this.field_70146_Z.nextDouble() * 4.0 - 2.0), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5), (double)MathHelper.func_76126_a((float)(this.field_70761_aq * (float)Math.PI / 180.0f)), -this.field_70181_x * 3.1415927410125732 / 180.0, (double)(-MathHelper.func_76134_b((float)(this.field_70761_aq * (float)Math.PI / 180.0f))), new int[0]);
            }
            this.field_70761_aq = this.field_70177_z = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (i = 0; i < 2; ++i) {
            int j2 = this.getWatchedTargetId(i + 1);
            Entity entity1 = null;
            if (j2 > 0) {
                entity1 = this.field_70170_p.func_73045_a(j2);
            }
            if (entity1 != null) {
                double d1 = this.func_82214_u(i + 1);
                double d3 = this.func_82208_v(i + 1);
                double d5 = this.func_82213_w(i + 1);
                double d6 = entity1.field_70165_t - d1;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d3;
                double d8 = entity1.field_70161_v - d5;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d7, d9) * 180.0 / Math.PI));
                this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], f1, 40.0f);
                this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], f, 10.0f);
                continue;
            }
            this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], this.field_70761_aq, 10.0f);
        }
        boolean flag = this.isArmored();
        for (j = 0; j < 3; ++j) {
            double d10 = this.func_82214_u(j);
            double d2 = this.func_82208_v(j);
            d4 = this.func_82213_w(j);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.3, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, d10 + this.field_70146_Z.nextGaussian() * 0.1 / 2.0, d2 + this.field_70146_Z.nextGaussian() * 0.1, d4 + this.field_70146_Z.nextGaussian() * 0.1 / 2.0, 0.0, 0.0, 0.0, new int[0]);
            if (this.field_70170_p.field_73012_v.nextInt(10) == 0) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
            }
            if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.getInvulTime() > 0) {
            for (j = 0; j < 15; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.canConjoin()) {
            for (j = 0; j < 5; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.earth) {
            for (j = 0; j < 15; ++j) {
                double d10 = this.func_82214_u(j);
                double d2 = this.func_82208_v(j);
                d4 = this.func_82213_w(j);
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, d10 + this.field_70146_Z.nextGaussian(), d2 + this.field_70146_Z.nextGaussian(), d4 + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[]{3});
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[]{3});
                if (!flag && this.field_70170_p.field_73012_v.nextInt(20) != 0) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.DRIP_LAVA, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.DRIP_LAVA, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.getInvulTime() > 0) {
                for (j = 0; j < 15; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        if (this.fire) {
            for (j = 0; j < 15; ++j) {
                double d10 = this.func_82214_u(j);
                double d2 = this.func_82208_v(j);
                d4 = this.func_82213_w(j);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d10 + this.field_70146_Z.nextGaussian(), d2 + this.field_70146_Z.nextGaussian(), d4 + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                if (!flag && this.field_70170_p.field_73012_v.nextInt(10) != 0) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, d10 + this.field_70146_Z.nextGaussian(), d2 + this.field_70146_Z.nextGaussian(), d4 + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.getInvulTime() > 0) {
                for (j = 0; j < 15; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        if (this.water) {
            for (j = 0; j < 15; ++j) {
                double d10 = this.func_82214_u(j);
                double d2 = this.func_82208_v(j);
                d4 = this.func_82213_w(j);
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, d10 + this.field_70146_Z.nextGaussian(), d2 + this.field_70146_Z.nextGaussian(), d4 + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                if (!flag && this.field_70170_p.field_73012_v.nextInt(20) != 0) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.getInvulTime() > 0) {
                for (j = 0; j < 15; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.6, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 0.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
                List list111 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
                if (list111 != null && !list111.isEmpty()) {
                    for (int i111 = 0; i111 < list111.size(); ++i111) {
                        Entity entity = (Entity)list111.get(i111);
                        if (entity == null || !(entity instanceof EntityLivingBase)) continue;
                        entity.field_70181_x = 1.0;
                        entity.func_70097_a(DamageSource.field_76368_d, 10.0f);
                    }
                }
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(30.0f);
            }
        } else {
            int i;
            super.func_70619_bc();
            List list1 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
            if (list1 != null && !list1.isEmpty() && !this.canConjoin() && this.field_70180_af.func_75683_a(15) == 0) {
                for (int i2 = 0; i2 < list1.size(); ++i2) {
                    double d5;
                    double d4;
                    double d3;
                    double d2;
                    Entity entity = (Entity)list1.get(i2);
                    if (entity != null && (entity instanceof EntityItem || entity instanceof EntityFishHook || entity instanceof EntityArrow || entity instanceof EntityXPOrb || entity instanceof EntityTNTPrimed || entity instanceof EntityMinecart || entity instanceof EntityBoat)) {
                        d2 = this.field_70165_t - entity.field_70165_t;
                        d3 = this.field_70163_u + 2.0 - entity.field_70163_u;
                        d4 = this.field_70161_v - entity.field_70161_v;
                        d5 = d2 * d2 + d3 * d3 + d4 * d4;
                        entity.func_70024_g(d2 / d5 * 3.0, d3 / d5 * 3.0, d4 / d5 * 3.0);
                    }
                    if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof IBossDisplayData || entity instanceof EntityHurricaneWither || entity instanceof EntityAirWither || entity instanceof EntityWitherGirl || entity instanceof EntityWitherGirlVoid || entity instanceof EntityFriendlyWither || entity instanceof EntityWitherGirlPink) continue;
                    if (entity instanceof EntityPlayer) {
                        if (((EntityPlayer)entity).field_71075_bZ.field_75102_a || ((EntityPlayer)entity).field_71075_bZ.field_75101_c) continue;
                        entity.func_70097_a(DamageSource.field_76368_d, 1.0f);
                        d2 = this.field_70165_t - entity.field_70165_t;
                        d3 = this.field_70163_u + 2.0 - entity.field_70163_u;
                        d4 = this.field_70161_v - entity.field_70161_v;
                        d5 = d2 * d2 + d3 * d3 + d4 * d4;
                        entity.func_70024_g(d2 / d5 * 1.5, d3 / d5 * 1.5, d4 / d5 * 1.5);
                        continue;
                    }
                    if (entity instanceof EntityDragon || entity instanceof EntityDragonPart) {
                        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.field_70170_p.func_72890_a((Entity)this, -1.0)), 5.0f);
                    }
                    entity.func_70097_a(DamageSource.field_76368_d, 1.0f);
                    d2 = this.field_70165_t - entity.field_70165_t;
                    d3 = this.field_70163_u + 3.0 - entity.field_70163_u;
                    d4 = this.field_70161_v - entity.field_70161_v;
                    d5 = d2 * d2 + d3 * d3 + d4 * d4;
                    entity.func_70024_g(d2 / d5 * 2.5, d3 / d5 * 2.5, d4 / d5 * 2.5);
                    if (!(this.func_70068_e(entity) <= 36.0)) continue;
                    this.func_70652_k(entity);
                }
            }
            block2: for (i = 1; i < 3; ++i) {
                int i1;
                if (this.field_70173_aa < this.field_82223_h[i - 1]) continue;
                this.field_82223_h[i - 1] = this.field_70173_aa + this.field_70146_Z.nextInt(2);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int k2 = i - 1;
                    int l2 = this.field_82224_i[i - 1];
                    this.field_82224_i[k2] = this.field_82224_i[i - 1] + 1;
                    if (l2 > 15) {
                        float f = 20.0f;
                        float f1 = 10.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.field_82224_i[i - 1] = 0;
                    }
                }
                if ((i1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(i1);
                    if (entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 10000.0) {
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.field_82223_h[i - 1] = this.field_70173_aa + 40;
                        this.field_82224_i[i - 1] = 0;
                        continue;
                    }
                    this.func_82211_c(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(100.0, 100.0, 100.0), Predicates.and((Predicate)attackEntitySelector, (Predicate)IEntitySelector.field_180132_d));
                for (int k1 = 0; k1 < 64 && !list.isEmpty(); ++k1) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S()) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue block2;
                            this.func_82211_c(i, entitylivingbase.func_145782_y());
                            continue block2;
                        }
                        this.func_82211_c(i, entitylivingbase.func_145782_y());
                        continue block2;
                    }
                    list.remove(entitylivingbase);
                }
            }
            if (this.func_70638_az() != null) {
                this.func_82211_c(0, this.func_70638_az().func_145782_y());
            } else {
                this.func_82211_c(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    i = MathHelper.func_76128_c((double)this.field_70163_u);
                    int i1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int j1 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        for (int i2 = -1; i2 <= 1; ++i2) {
                            for (int j = 0; j <= 3; ++j) {
                                int j2 = i1 + l1;
                                int k = i + j;
                                int l = j1 + i2;
                                Block block = this.field_70170_p.func_180495_p(new BlockPos(j2, k, l)).func_177230_c();
                                if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l)) || !this.canEntityDestroy(block, (IBlockAccess)this.field_70170_p, new BlockPos(j2, k, l), (Entity)this)) continue;
                                flag = this.field_70170_p.func_175655_b(new BlockPos(j2, k, l), true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1012, new BlockPos((Entity)this), 0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    public boolean canEntityDestroy(Block block, IBlockAccess world, BlockPos pos, Entity entity) {
        return block != Blocks.field_180401_cv && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI;
    }

    public void func_82206_m() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    public int func_70658_aO() {
        return 1;
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 3.0 : this.field_70163_u + 2.2;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e(), p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3;
        double d7 = p_82209_4_ - d4;
        double d8 = p_82209_6_ - d5;
        EntityAirSkull entitywitherskull = new EntityAirSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
        entitywitherskull.field_70163_u = d4;
        entitywitherskull.field_70165_t = d3;
        entitywitherskull.field_70161_v = d5;
        this.field_70170_p.func_72838_d((Entity)entitywitherskull);
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        if (!this.canConjoin()) {
            this.launchWitherSkullToEntity(0, p_82196_1_);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_82728_o && source != DamageSource.field_82729_p && source != DamageSource.field_76379_h && !(source.func_76346_g() instanceof EntityAirWither)) {
            Entity entity;
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.isArmored() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            entity = source.func_76346_g();
            if (entity != null && !(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.field_82224_i.length) {
                int n = i++;
                this.field_82224_i[n] = this.field_82224_i[n] + 3;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        int j = 4 + this.field_70146_Z.nextInt(17 + p_70628_2_);
        for (k = 0; k < j + 1 + p_70628_2_; ++k) {
            this.func_145779_a(Items.field_151008_G, 1);
        }
        for (k = 0; k < j + 4 + p_70628_2_; ++k) {
            this.func_145779_a(Items.field_151121_aF, 1);
        }
        EntityItem entityitem = this.func_145779_a(Items.field_151156_bN, 1);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_150964_J);
                entityplayer.func_71029_a((StatBase)MoWithersAchievments.achievementKillAirWither);
            }
        }
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return this.field_70180_af.func_75679_c(17 + p_82203_1_);
    }

    public void func_82211_c(int p_82211_1_, int p_82211_2_) {
        this.field_70180_af.func_75692_b(17 + p_82211_1_, (Object)p_82211_2_);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70078_a(Entity entityIn) {
        this.field_70154_o = null;
    }

    protected float func_70599_aP() {
        return 3.0f;
    }

    protected void func_180433_a(double p_180433_1_, boolean p_180433_3_, Block p_180433_4_, BlockPos p_180433_5_) {
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.func_70090_H()) {
            this.func_70060_a(p_70612_1_, p_70612_2_, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_70060_a(p_70612_1_, p_70612_2_, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            this.func_70060_a(p_70612_1_, p_70612_2_, this.field_70122_E ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
            if (this.func_110143_aJ() <= 0.0f) {
                this.field_70181_x += (double)1.2f;
            }
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    class AirWitherMoveHelper
    extends EntityMoveHelper {
        private EntityAirWither airwither;
        private int field_179928_h;

        public AirWitherMoveHelper() {
            super((EntityLiving)EntityAirWither.this);
            this.airwither = EntityAirWither.this;
        }

        public void func_75641_c() {
            if (this.field_75643_f) {
                double d0 = this.field_75646_b - this.airwither.field_70165_t;
                double d1 = this.field_75647_c - this.airwither.field_70163_u;
                double d2 = this.field_75644_d - this.airwither.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.field_179928_h-- <= 0) {
                    this.field_179928_h += this.airwither.func_70681_au().nextInt(10) + 30;
                    if (this.func_179926_b(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.airwither.field_70159_w += d0 / d3 * 0.75;
                        this.airwither.field_70181_x += d0 / d3 * 0.75;
                        this.airwither.field_70179_y += d2 / d3 * 0.75;
                        this.airwither.func_70671_ap().func_75650_a(this.field_75646_b, this.field_75647_c, this.field_75644_d, 180.0f, 60.0f);
                    } else {
                        this.field_75643_f = false;
                    }
                }
            }
        }

        private boolean func_179926_b(double p_179926_1_, double p_179926_3_, double p_179926_5_, double p_179926_7_) {
            return this.airwither.func_70638_az() == null;
        }
    }

    class AIRandomFly
    extends EntityAIBase {
        private EntityAirWither field_179454_a;

        public AIRandomFly() {
            this.field_179454_a = EntityAirWither.this;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.field_179454_a.func_70605_aq();
            if (!entitymovehelper.func_75640_a() || this.field_179454_a.func_70638_az() == null) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.field_179454_a.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.field_179454_a.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.field_179454_a.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.field_179454_a.func_70681_au();
            double d0 = this.field_179454_a.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.field_179454_a.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.field_179454_a.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.field_179454_a.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }
}

