/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.MoWithers.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.WeightedRandom;

public class GreaterDungeonHooks {
    private static ArrayList<DungeonMob> dungeonMobs = new ArrayList();

    public static float addDungeonMob(String name, int rarity) {
        if (rarity <= 0) {
            throw new IllegalArgumentException("Rarity must be greater then zero");
        }
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            return mob.field_76292_a += rarity;
        }
        dungeonMobs.add(new DungeonMob(rarity, name));
        return rarity;
    }

    public static int removeDungeonMob(String name) {
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            dungeonMobs.remove((Object)mob);
            return mob.field_76292_a;
        }
        return 0;
    }

    public static String getRandomDungeonMob(Random rand) {
        DungeonMob mob = (DungeonMob)WeightedRandom.func_76271_a((Random)rand, dungeonMobs);
        if (mob == null) {
            return "";
        }
        return mob.type;
    }

    static {
        GreaterDungeonHooks.addDungeonMob("Skeleton", 100);
        GreaterDungeonHooks.addDungeonMob("Creeper", 100);
        GreaterDungeonHooks.addDungeonMob("Enderman", 100);
        GreaterDungeonHooks.addDungeonMob("CaveSpider", 100);
    }

    public static class DungeonMob
    extends WeightedRandom.Item {
        public String type;

        public DungeonMob(int weight, String type) {
            super(weight);
            this.type = type;
        }

        public boolean equals(Object target) {
            return target instanceof DungeonMob && this.type.equals(((DungeonMob)((Object)target)).type);
        }
    }
}

