/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.world.dungeon.util;

import com.legacy.aether.server.world.dungeon.util.PositionData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class AetherDungeon
extends WorldGenerator {
    protected final Random random = new Random();
    public int chance;
    public IBlockState airState = Blocks.field_150350_a.func_176223_P();
    public IBlockState blockState;
    public IBlockState extraBlockState;
    public boolean replaceAir;
    public boolean replaceSolid;

    public void setBlocks(IBlockState blockState) {
        this.blockState = blockState;
        this.extraBlockState = null;
        this.chance = 0;
    }

    public void setBlocks(IBlockState blockState, IBlockState extraBlockState, int chances) {
        this.blockState = blockState;
        this.extraBlockState = extraBlockState;
        this.chance = chances;
        if (this.chance < 1) {
            this.chance = 1;
        }
    }

    public void addLineX(World world, Random rand, PositionData pos, int radius) {
        for (int lineX = pos.getX(); lineX < pos.getX() + radius; ++lineX) {
            BlockPos newPos = new BlockPos(lineX, pos.getY(), pos.getZ());
            Block block = world.func_180495_p(newPos).func_177230_c();
            if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
            if (this.chance == 0) {
                this.func_175903_a(world, newPos, this.blockState);
                return;
            }
            if (rand.nextInt(this.chance) == 0) {
                this.func_175903_a(world, newPos, this.extraBlockState);
                continue;
            }
            this.func_175903_a(world, newPos, this.blockState);
        }
    }

    public void addLineY(World world, Random rand, PositionData pos, int radius) {
        for (int lineY = pos.getY(); lineY < pos.getY() + radius; ++lineY) {
            BlockPos newPos = new BlockPos(pos.getX(), lineY, pos.getZ());
            Block block = world.func_180495_p(newPos).func_177230_c();
            if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
            if (this.chance == 0) {
                this.func_175903_a(world, newPos, this.blockState);
                return;
            }
            if (rand.nextInt(this.chance) == 0) {
                this.func_175903_a(world, newPos, this.extraBlockState);
                continue;
            }
            this.func_175903_a(world, newPos, this.blockState);
        }
    }

    public void addLineZ(World world, Random rand, PositionData pos, int radius) {
        for (int lineZ = pos.getZ(); lineZ < pos.getZ() + radius; ++lineZ) {
            BlockPos newPos = new BlockPos(pos.getX(), pos.getY(), lineZ);
            Block block = world.func_180495_p(newPos).func_177230_c();
            if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
            if (this.chance == 0) {
                this.func_175903_a(world, newPos, this.blockState);
                return;
            }
            if (rand.nextInt(this.chance) == 0) {
                this.func_175903_a(world, newPos, this.extraBlockState);
                continue;
            }
            this.func_175903_a(world, newPos, this.blockState);
        }
    }

    public void addPlaneX(World world, Random rand, PositionData pos, PositionData radius) {
        for (int lineY = pos.getY(); lineY < pos.getY() + radius.getY(); ++lineY) {
            for (int lineZ = pos.getZ(); lineZ < pos.getZ() + radius.getZ(); ++lineZ) {
                BlockPos newPos = new BlockPos(pos.getX(), lineY, lineZ);
                Block block = world.func_180495_p(newPos).func_177230_c();
                if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
                if (this.chance == 0) {
                    this.func_175903_a(world, newPos, this.blockState);
                    return;
                }
                if (rand.nextInt(this.chance) == 0) {
                    this.func_175903_a(world, newPos, this.extraBlockState);
                    continue;
                }
                this.func_175903_a(world, newPos, this.blockState);
            }
        }
    }

    public void addPlaneY(World world, Random rand, PositionData pos, PositionData radius) {
        for (int lineX = pos.getX(); lineX < pos.getX() + radius.getX(); ++lineX) {
            for (int lineZ = pos.getZ(); lineZ < pos.getZ() + radius.getZ(); ++lineZ) {
                BlockPos newPos = new BlockPos(lineX, pos.getY(), lineZ);
                Block block = world.func_180495_p(newPos).func_177230_c();
                if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
                if (this.chance == 0) {
                    this.func_175903_a(world, newPos, this.blockState);
                    return;
                }
                if (rand.nextInt(this.chance) == 0) {
                    this.func_175903_a(world, newPos, this.extraBlockState);
                    continue;
                }
                this.func_175903_a(world, newPos, this.blockState);
            }
        }
    }

    public void addPlaneZ(World world, Random rand, PositionData pos, PositionData radius) {
        for (int lineX = pos.getX(); lineX < pos.getX() + radius.getX(); ++lineX) {
            for (int lineY = pos.getY(); lineY < pos.getY() + radius.getY(); ++lineY) {
                BlockPos newPos = new BlockPos(lineX, lineY, pos.getZ());
                Block block = world.func_180495_p(newPos).func_177230_c();
                if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
                if (this.chance == 0) {
                    this.func_175903_a(world, newPos, this.blockState);
                    return;
                }
                if (rand.nextInt(this.chance) == 0) {
                    this.func_175903_a(world, newPos, this.extraBlockState);
                    continue;
                }
                this.func_175903_a(world, newPos, this.blockState);
            }
        }
    }

    public void addHollowBox(World world, Random rand, PositionData pos, PositionData radius) {
        IBlockState temp1 = this.blockState;
        IBlockState temp2 = this.extraBlockState;
        this.setBlocks(this.airState, this.airState, this.chance);
        this.addSolidBox(world, rand, pos, radius);
        this.setBlocks(temp1, temp2, this.chance);
        this.addPlaneY(world, rand, pos, radius);
        this.addPlaneY(world, rand, new PositionData(pos.getX(), pos.getY() + (radius.getY() - 1), pos.getZ()), radius);
        this.addPlaneX(world, rand, pos, radius);
        this.addPlaneX(world, rand, new PositionData(pos.getX() + (radius.getX() - 1), pos.getY(), pos.getZ()), radius);
        this.addPlaneZ(world, rand, pos, radius);
        this.addPlaneZ(world, rand, new PositionData(pos.getX(), pos.getY(), pos.getZ() + (radius.getZ() - 1)), radius);
    }

    public void addSquareTube(World world, Random rand, PositionData pos, PositionData radius, int angel) {
        IBlockState temp1 = this.blockState;
        IBlockState temp2 = this.extraBlockState;
        this.setBlocks(this.airState, this.airState, this.chance);
        this.addSolidBox(world, rand, pos, radius);
        this.setBlocks(temp1, temp2, this.chance);
        if (angel == 0 || angel == 2) {
            this.addPlaneY(world, rand, pos, radius);
            this.addPlaneY(world, rand, new PositionData(pos.getX(), pos.getY() + (radius.getY() - 1), pos.getZ()), radius);
        }
        if (angel == 1 || angel == 2) {
            this.addPlaneX(world, rand, pos, radius);
            this.addPlaneX(world, rand, new PositionData(pos.getX() + (radius.getX() - 1), pos.getY(), pos.getZ()), radius);
        }
        if (angel == 0 || angel == 1) {
            this.addPlaneZ(world, rand, pos, radius);
            this.addPlaneZ(world, rand, new PositionData(pos.getX(), pos.getY(), pos.getZ() + (radius.getZ() - 1)), radius);
        }
    }

    public void addSolidBox(World world, Random rand, PositionData pos, PositionData radius) {
        for (int lineX = pos.getX(); lineX < pos.getX() + radius.getX(); ++lineX) {
            for (int lineY = pos.getY(); lineY < pos.getY() + radius.getY(); ++lineY) {
                for (int lineZ = pos.getZ(); lineZ < pos.getZ() + radius.getZ(); ++lineZ) {
                    BlockPos newPos = new BlockPos(lineX, lineY, lineZ);
                    Block block = world.func_180495_p(newPos).func_177230_c();
                    if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
                    if (this.chance == 0) {
                        this.func_175903_a(world, newPos, this.blockState);
                        return;
                    }
                    if (rand.nextInt(this.chance) == 0) {
                        this.func_175903_a(world, newPos, this.extraBlockState);
                        continue;
                    }
                    this.func_175903_a(world, newPos, this.blockState);
                }
            }
        }
    }

    public boolean isBoxSolid(World world, PositionData pos, PositionData radius) {
        boolean flag = true;
        for (int lineX = pos.getX(); lineX < pos.getX() + radius.getX(); ++lineX) {
            for (int lineY = pos.getY(); lineY < pos.getY() + radius.getY(); ++lineY) {
                for (int lineZ = pos.getZ(); lineZ < pos.getZ() + radius.getZ(); ++lineZ) {
                    if (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(lineX, lineY, lineZ)).func_177230_c() != Blocks.field_150350_a) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    public boolean isBoxEmpty(World world, PositionData pos, PositionData radius) {
        boolean flag = true;
        for (int lineX = pos.getX(); lineX < pos.getX() + radius.getX(); ++lineX) {
            for (int lineY = pos.getY(); lineY < pos.getY() + radius.getY(); ++lineY) {
                for (int lineZ = pos.getZ(); lineZ < pos.getZ() + radius.getZ(); ++lineZ) {
                    if (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(lineX, lineY, lineZ)).func_177230_c() == Blocks.field_150350_a) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    protected void setBlock(World world, Random random, BlockPos pos, IBlockState state, IBlockState extraState, int chance) {
        if (random.nextInt(chance) == 0) {
            this.func_175903_a(world, pos, extraState);
        } else {
            this.func_175903_a(world, pos, state);
        }
    }
}

