/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.world.dungeon;

import com.legacy.aether.server.blocks.BlocksAether;
import com.legacy.aether.server.blocks.dungeon.BlockDungeonBase;
import com.legacy.aether.server.blocks.util.EnumStoneType;
import com.legacy.aether.server.entities.bosses.sun_spirit.EntitySunSpirit;
import com.legacy.aether.server.items.ItemsAether;
import com.legacy.aether.server.world.dungeon.util.AetherDungeon;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GoldenDungeon
extends AetherDungeon {
    public int xoff;
    public int yoff;
    public int zoff;
    public int rad;
    public int truey;

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        return this.generate(world, random, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 24);
    }

    public boolean generate(World world, Random random, int x, int y, int z, int r) {
        r = (int)Math.floor((double)r * 0.8);
        int wid = (int)Math.sqrt(r * r / 2);
        for (int j = 4; j > -5; --j) {
            int a = wid;
            if (j >= 3 || j <= -3) {
                --a;
            }
            if (j == 4 || j == -4) {
                --a;
            }
            for (int i = -a; i <= a; ++i) {
                for (int k = -a; k <= a; ++k) {
                    if (j == 4) {
                        this.setBlock(world, random, new BlockPos(x + i, y + j, z + k), this.getWallBase(), this.getCeilingBase(), 10);
                        continue;
                    }
                    if (j > -4) {
                        if (i == a || -i == a || k == a || -k == a) {
                            this.setBlock(world, random, new BlockPos(x + i, y + j, z + k), this.getWallBase(), this.getCeilingBase(), 10);
                            continue;
                        }
                        world.func_175656_a(new BlockPos(x + i, y + j, z + k), Blocks.field_150350_a.func_176223_P());
                        if (j != -2 || i != a - 1 && -i != a - 1 && k != a - 1 && -k != a - 1 || i % 3 == 0 || k % 3 != 0) continue;
                        continue;
                    }
                    this.setBlock(world, random, new BlockPos(x + i, y + j, z + k), this.getWallBase(), this.getCeilingBase(), 10);
                    if (i != a - 2 && -i != a - 2 || k != a - 2 && -k != a - 2) continue;
                    this.func_175903_a(world, new BlockPos(x + i, y + j + 1, z + k), Blocks.field_150424_aL.func_176223_P());
                    this.func_175903_a(world, new BlockPos(x + i, y + j + 2, z + k), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
        int direction = random.nextInt(4);
        for (int i = wid; i < wid + 32; ++i) {
            boolean flag = false;
            for (int j = -3; j < 2; ++j) {
                for (int k = -3; k < 4; ++k) {
                    int b;
                    int a;
                    if (direction / 2 == 0) {
                        a = i;
                        b = k;
                    } else {
                        a = k;
                        b = i;
                    }
                    if (direction % 2 == 0) {
                        a = -a;
                        b = -b;
                    }
                    if (!BlocksAether.isGood(world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x + a, y + j, z + b)))) {
                        flag = true;
                        if (j == -3) {
                            this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), BlocksAether.holystone.func_176223_P(), BlocksAether.mossy_holystone.func_176223_P(), 5);
                        } else if (j < 1) {
                            if (i == wid) {
                                if (k < 2 && k > -2 && j < 0) {
                                    this.func_175903_a(world, new BlockPos(x + a, y + j, z + b), Blocks.field_150350_a.func_176223_P());
                                } else {
                                    this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), this.getWallBase(), this.getCeilingBase(), 10);
                                }
                            } else if (k == 3 || k == -3) {
                                this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), BlocksAether.holystone.func_176223_P(), BlocksAether.mossy_holystone.func_176223_P(), 5);
                            } else {
                                this.func_175903_a(world, new BlockPos(x + a, y + j, z + b), Blocks.field_150350_a.func_176223_P());
                                if (j == -1 && (k == 2 || k == -2) && (i - wid - 2) % 3 == 0) {
                                    // empty if block
                                }
                            }
                        } else if (i == wid) {
                            this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), this.getWallBase(), this.getCeilingBase(), 5);
                        } else {
                            this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), BlocksAether.holystone.func_176223_P(), BlocksAether.mossy_holystone.func_176223_P(), 5);
                        }
                    }
                    a = -a;
                    b = -b;
                    if (i >= wid + 6) continue;
                    if (j == -3) {
                        this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), this.getWallBase(), this.getCeilingBase(), 10);
                        continue;
                    }
                    if (j < 1) {
                        if (i == wid) {
                            if (k < 2 && k > -2 && j < 0) {
                                this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), this.getWallBase(), this.getCeilingBase(), 10);
                                continue;
                            }
                            this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), this.getWallBase(), this.getCeilingBase(), 10);
                            continue;
                        }
                        if (i == wid + 5) {
                            this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), this.getWallBase(), this.getCeilingBase(), 10);
                            continue;
                        }
                        if (i == wid + 4 && k == 0 && j == -2) {
                            world.func_175656_a(new BlockPos(x + a, y + j, z + b), BlocksAether.treasure_chest.func_176223_P());
                            continue;
                        }
                        if (k == 3 || k == -3) {
                            this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), this.getWallBase(), this.getCeilingBase(), 10);
                            continue;
                        }
                        world.func_175656_a(new BlockPos(x + a, y + j, z + b), Blocks.field_150350_a.func_176223_P());
                        if (j != -1 || k != 2 && k != -2 || (i - wid - 2) % 3 != 0) continue;
                        continue;
                    }
                    this.setBlock(world, random, new BlockPos(x + a, y + j, z + b), this.getWallBase(), this.getCeilingBase(), 10);
                }
            }
            if (!flag) break;
        }
        EntitySunSpirit boss = new EntitySunSpirit(world, x, y - 1, z, direction);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)boss);
        }
        return true;
    }

    public static ItemStack getGoldLoot(Random random) {
        int item = random.nextInt(9);
        switch (item) {
            case 0: {
                return new ItemStack(ItemsAether.iron_bubble);
            }
            case 1: {
                return new ItemStack(ItemsAether.vampire_blade);
            }
            case 2: {
                return new ItemStack(ItemsAether.pig_slayer);
            }
            case 3: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.phoenix_helmet);
                }
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.phoenix_leggings);
                }
                if (!random.nextBoolean()) break;
                return new ItemStack(ItemsAether.phoenix_chestplate);
            }
            case 4: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.phoenix_boots);
                }
                return new ItemStack(ItemsAether.phoenix_gloves);
            }
            case 5: {
                return new ItemStack(ItemsAether.life_shard);
            }
            case 6: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.gravitite_helmet);
                }
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.gravitite_leggings);
                }
                if (!random.nextBoolean()) break;
                return new ItemStack(ItemsAether.gravitite_chestplate);
            }
            case 7: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.gravitite_boots);
                }
                return new ItemStack(ItemsAether.gravitite_gloves);
            }
        }
        return new ItemStack(ItemsAether.obsidian_chestplate);
    }

    public IBlockState getCeilingBase() {
        return BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_hellfire));
    }

    public IBlockState getWallBase() {
        return BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Hellfire));
    }

    public IBlockState getFloorBase() {
        return Blocks.field_150446_ar.func_176223_P();
    }
}

