/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.world.biome;

import com.legacy.aether.server.AetherConfig;
import com.legacy.aether.server.blocks.BlocksAether;
import com.legacy.aether.server.blocks.util.EnumCloudType;
import com.legacy.aether.server.world.biome.decoration.AetherGenClouds;
import com.legacy.aether.server.world.biome.decoration.AetherGenFloatingIsland;
import com.legacy.aether.server.world.biome.decoration.AetherGenFoilage;
import com.legacy.aether.server.world.biome.decoration.AetherGenHolidayTree;
import com.legacy.aether.server.world.biome.decoration.AetherGenLiquids;
import com.legacy.aether.server.world.biome.decoration.AetherGenMinable;
import com.legacy.aether.server.world.biome.decoration.AetherGenOakTree;
import com.legacy.aether.server.world.biome.decoration.AetherGenQuicksoil;
import com.legacy.aether.server.world.biome.decoration.AetherGenSkyrootTree;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenerator;

public class AetherBiomeDecorator
extends BiomeDecorator {
    public World world;
    public Random rand;
    public Biome aetherBiome;
    public AetherGenClouds aerclouds = new AetherGenClouds();
    public AetherGenFoilage foilage = new AetherGenFoilage();
    public AetherGenMinable ores = new AetherGenMinable();
    public AetherGenSkyrootTree skyroot_tree = new AetherGenSkyrootTree(false);
    public AetherGenQuicksoil quicksoil_patches = new AetherGenQuicksoil();
    public AetherGenFloatingIsland crystal_island = new AetherGenFloatingIsland();
    public AetherGenLiquids liquid_overhang = new AetherGenLiquids();
    public AetherGenHolidayTree holiday_tree = new AetherGenHolidayTree();

    public void func_180292_a(World worldIn, Random random, Biome biome, BlockPos pos) {
        if (this.field_185425_a) {
            throw new RuntimeException("Already decorating");
        }
        this.field_180294_c = pos;
        this.world = worldIn;
        this.rand = random;
        this.aetherBiome = biome;
        this.func_150513_a(biome, worldIn, random);
        this.field_185425_a = false;
    }

    protected void func_150513_a(Biome biomeGenBaseIn, World worldIn, Random random) {
        if (this.shouldSpawn(37)) {
            this.crystal_island.func_180709_b(this.world, this.rand, this.field_180294_c.func_177982_a(this.nextInt(16), this.nextInt(64) + 32, this.nextInt(16)));
        }
        if (this.shouldSpawn(3)) {
            this.spawnOre(BlocksAether.aether_dirt.func_176223_P(), 32, 20, 128);
        }
        if (this.shouldSpawn(2)) {
            this.getTree().func_180709_b(this.world, this.rand, this.world.func_175645_m(this.field_180294_c.func_177982_a(this.nextInt(16) + 8, 0, this.nextInt(16) + 8)));
        }
        if (this.shouldSpawn(1)) {
            this.skyroot_tree.func_180709_b(this.world, this.rand, this.world.func_175645_m(this.field_180294_c.func_177982_a(this.nextInt(16), 0, this.nextInt(16))));
        }
        if (AetherConfig.shouldLoadHolidayContent() && this.shouldSpawn(15)) {
            this.holiday_tree.func_180709_b(this.world, this.rand, this.world.func_175645_m(this.field_180294_c.func_177982_a(this.nextInt(16) + 8, 0, this.nextInt(16) + 8)));
        }
        this.generateFoilage(BlocksAether.white_flower.func_176223_P());
        this.generateFoilage(BlocksAether.purple_flower.func_176223_P());
        this.spawnOre(BlocksAether.icestone.func_176223_P(), 16, 10, 128);
        this.spawnOre(BlocksAether.ambrosium_ore.func_176223_P(), 16, 15, 128);
        this.spawnOre(BlocksAether.zanite_ore.func_176223_P(), 8, 15, 64);
        this.spawnOre(BlocksAether.gravitite_ore.func_176223_P(), 6, 8, 40);
        this.generateClouds(EnumCloudType.Golden, 4, false, 50, this.nextInt(64) + 96);
        this.generateClouds(EnumCloudType.Blue, 8, false, 26, this.nextInt(64) + 32);
        this.generateClouds(EnumCloudType.Cold, 16, false, 14, this.nextInt(64) + 64);
        this.generateClouds(EnumCloudType.Cold, 64, true, 50, 0);
        BlockPos.MutableBlockPos mutedPos = new BlockPos.MutableBlockPos();
        if (this.shouldSpawn(10)) {
            for (int x = this.field_180294_c.func_177958_n(); x < this.field_180294_c.func_177958_n() + 16; ++x) {
                for (int z = this.field_180294_c.func_177952_p(); z < this.field_180294_c.func_177952_p() + 16; ++z) {
                    for (int n = 0; n < 48; ++n) {
                        mutedPos.func_181079_c(x, n, z);
                        if (this.world.func_180495_p((BlockPos)mutedPos).func_177230_c() != Blocks.field_150350_a || this.world.func_180495_p((BlockPos)mutedPos.func_181079_c(x, n + 1, z)).func_177230_c() != BlocksAether.aether_grass || this.world.func_180495_p((BlockPos)mutedPos.func_181079_c(x, n + 2, z)).func_177230_c() != Blocks.field_150350_a) continue;
                        new AetherGenQuicksoil().func_180709_b(this.world, this.rand, (BlockPos)mutedPos);
                        mutedPos.func_181079_c(x, n + 128, z);
                    }
                }
            }
        }
        this.generateFoilage(BlocksAether.berry_bush.func_176223_P());
    }

    public int nextInt(int max) {
        return this.rand.nextInt(max);
    }

    public boolean shouldSpawn(int chance) {
        return this.nextInt(chance) == 0;
    }

    public WorldGenerator getTree() {
        return this.shouldSpawn(20) ? new AetherGenOakTree() : new AetherGenSkyrootTree(true);
    }

    public void generateFoilage(IBlockState block) {
        this.foilage.setPlantBlock(block);
        for (int n = 0; n < 2; ++n) {
            this.foilage.func_180709_b(this.world, this.rand, this.field_180294_c.func_177982_a(this.nextInt(16) + 8, this.nextInt(128), this.nextInt(16) + 8));
        }
    }

    public void spawnOre(IBlockState state, int size, int chance, int y) {
        this.ores.setSize(size);
        this.ores.setBlock(state);
        for (int chances = 0; chances < chance; ++chances) {
            this.ores.func_180709_b(this.world, this.rand, this.field_180294_c.func_177982_a(this.nextInt(16), this.nextInt(y), this.nextInt(16)));
        }
    }

    public void generateClouds(EnumCloudType type, int size, boolean flat, int chance, int y) {
        if (this.shouldSpawn(chance)) {
            this.aerclouds.setCloudType(type);
            this.aerclouds.setCloudAmmount(size);
            this.aerclouds.setFlat(flat);
            this.aerclouds.func_180709_b(this.world, this.rand, this.field_180294_c.func_177982_a(this.nextInt(16), y, this.nextInt(16)));
        }
    }
}

