/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.tile_entities;

import com.legacy.aether.server.blocks.BlocksAether;
import com.legacy.aether.server.items.ItemsAether;
import com.legacy.aether.server.registry.AetherRegistry;
import com.legacy.aether.server.registry.objects.AetherFreezable;
import com.legacy.aether.server.tile_entities.util.AetherTileEntity;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFreezer
extends AetherTileEntity {
    public int freezeProgress = 0;
    public int freezeTime = 0;
    public int frozenTimeRemaining = 0;
    private ItemStack[] frozenItemStacks = new ItemStack[3];
    private AetherFreezable currentFreezable;

    public TileEntityFreezer() {
        super("freezer");
    }

    public void func_73660_a() {
        if (this.frozenTimeRemaining > 0) {
            --this.frozenTimeRemaining;
            if (this.currentFreezable != null) {
                this.freezeProgress = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c() == BlocksAether.icestone ? (this.freezeProgress += 2) : ++this.freezeProgress;
            }
        }
        if (this.currentFreezable != null && (this.frozenItemStacks[0] == null || this.frozenItemStacks[0].func_77973_b() != this.currentFreezable.getFreezableInput().func_77973_b())) {
            this.currentFreezable = null;
            this.freezeProgress = 0;
        }
        if (this.currentFreezable != null && this.freezeProgress >= this.currentFreezable.getTimeRequired()) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.frozenItemStacks[2] == null) {
                    this.func_70299_a(2, new ItemStack(this.currentFreezable.getFrozenResult().func_77973_b(), 1, this.currentFreezable.getFrozenResult().func_77952_i()));
                } else {
                    this.func_70299_a(2, new ItemStack(this.currentFreezable.getFrozenResult().func_77973_b(), this.func_70301_a((int)2).field_77994_a + 1, this.currentFreezable.getFrozenResult().func_77952_i()));
                }
                if (this.frozenItemStacks[0].func_77973_b() == ItemsAether.skyroot_bucket && this.frozenItemStacks[0].func_77952_i() == 1) {
                    this.func_70299_a(0, new ItemStack(ItemsAether.skyroot_bucket));
                } else if (this.frozenItemStacks[0].func_77973_b() == Items.field_151131_as || this.frozenItemStacks[0].func_77973_b() == Items.field_151129_at) {
                    this.func_70299_a(0, new ItemStack(Items.field_151133_ar));
                } else {
                    this.func_70298_a(0, 1);
                }
            }
            this.freezeProgress = 0;
        }
        if (this.frozenTimeRemaining <= 0 && this.currentFreezable != null && this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() == Item.func_150898_a((Block)BlocksAether.icestone)) {
            this.frozenTimeRemaining += 500;
            if (!this.field_145850_b.field_72995_K) {
                this.func_70298_a(1, 1);
            }
        }
        if (this.currentFreezable == null) {
            ItemStack itemstack = this.func_70301_a(0);
            for (int i = 0; i < AetherRegistry.getFreezableSize(); ++i) {
                AetherFreezable freezable = AetherRegistry.getFreezable(i);
                if (itemstack == null || freezable == null || itemstack.func_77973_b() != freezable.getFreezableInput().func_77973_b() || itemstack.func_77952_i() != freezable.getFreezableInput().func_77952_i()) continue;
                if (this.frozenItemStacks[2] == null) {
                    this.currentFreezable = freezable;
                    this.freezeTime = this.currentFreezable.getTimeRequired();
                    continue;
                }
                if (this.frozenItemStacks[2].func_77973_b() != freezable.getFrozenResult().func_77973_b() || freezable.getFreezableInput().func_77976_d() <= this.frozenItemStacks[2].field_77994_a) continue;
                this.currentFreezable = freezable;
                this.freezeTime = this.currentFreezable.getTimeRequired();
            }
        }
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnchantmentProgressScaled(int i) {
        if (this.freezeTime == 0) {
            return 0;
        }
        return this.freezeProgress * i / this.freezeTime;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnchantmentTimeRemaining(int i) {
        return this.frozenTimeRemaining * i / 500;
    }

    public boolean isBurning() {
        return this.frozenTimeRemaining > 0;
    }

    @Override
    public int func_70302_i_() {
        return this.frozenItemStacks.length;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return this.frozenItemStacks[i];
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        if (this.frozenItemStacks[i] != null) {
            if (this.frozenItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.frozenItemStacks[i];
                this.frozenItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.frozenItemStacks[i].func_77979_a(j);
            if (this.frozenItemStacks[i].field_77994_a == 0) {
                this.frozenItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (this.frozenItemStacks[par1] != null) {
            ItemStack var2 = this.frozenItemStacks[par1];
            this.frozenItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        this.frozenItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public static boolean isItemFuel(ItemStack fuel) {
        return fuel.func_77973_b() == Item.func_150898_a((Block)BlocksAether.icestone);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_189515_b(var1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, var1);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.frozenItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.frozenItemStacks.length) continue;
            this.frozenItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.freezeProgress = nbttagcompound.func_74765_d("FreezeTime");
        this.freezeTime = nbttagcompound.func_74765_d("FrozenTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("FreezeTime", (short)this.freezeProgress);
        nbttagcompound.func_74777_a("FrozenTime", (short)this.freezeTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.frozenItemStacks.length; ++i) {
            if (this.frozenItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.frozenItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public boolean isValidSlotItem(int slot, ItemStack stackInSlot) {
        if (stackInSlot != null) {
            if (TileEntityFreezer.getFreezableResult(stackInSlot) != null) {
                return true;
            }
            if (slot == 1 && TileEntityFreezer.isItemFuel(stackInSlot)) {
                return true;
            }
        }
        return false;
    }

    public static ItemStack getFreezableResult(ItemStack stack) {
        for (AetherFreezable enchants : AetherRegistry.getFreezables()) {
            if (enchants.getFreezableInput().func_77973_b() != stack.func_77973_b()) continue;
            return enchants.getFrozenResult().func_77946_l();
        }
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        return nArray;
    }
}

