/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.tile_entities;

import com.legacy.aether.server.blocks.BlocksAether;
import com.legacy.aether.server.items.ItemsAether;
import com.legacy.aether.server.registry.AetherRegistry;
import com.legacy.aether.server.registry.objects.AetherEnchantment;
import com.legacy.aether.server.tile_entities.util.AetherTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEnchanter
extends AetherTileEntity {
    public int enchantmentProgress = 0;
    public int enchantmentTime = 0;
    public int enchantmentTimeRemaining = 0;
    private ItemStack[] enchantedItemStacks = new ItemStack[3];
    private AetherEnchantment currentEnchantment;

    public TileEntityEnchanter() {
        super("enchanter");
    }

    public void func_73660_a() {
        if (this.enchantmentTimeRemaining > 0) {
            --this.enchantmentTimeRemaining;
            if (this.currentEnchantment != null) {
                this.enchantmentProgress = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c() == BlocksAether.enchanted_gravitite ? (this.enchantmentProgress += 2) : ++this.enchantmentProgress;
            }
        }
        if (this.currentEnchantment != null && (this.enchantedItemStacks[0] == null || this.enchantedItemStacks[0].func_77973_b() != this.currentEnchantment.getEnchantmentInput().func_77973_b())) {
            this.currentEnchantment = null;
            this.enchantmentProgress = 0;
        }
        if (this.currentEnchantment != null && this.enchantmentProgress >= this.currentEnchantment.getTimeRequired()) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.enchantedItemStacks[2] == null) {
                    this.func_70299_a(2, new ItemStack(this.currentEnchantment.getEnchantedResult().func_77973_b(), 1, this.currentEnchantment.getEnchantedResult().func_77952_i()));
                } else {
                    this.func_70299_a(2, new ItemStack(this.currentEnchantment.getEnchantedResult().func_77973_b(), this.func_70301_a((int)2).field_77994_a + 1, this.currentEnchantment.getEnchantedResult().func_77952_i()));
                }
                this.func_70298_a(0, 1);
            }
            this.enchantmentProgress = 0;
        }
        if (this.enchantmentTimeRemaining <= 0 && this.currentEnchantment != null && this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() == ItemsAether.ambrosium_shard) {
            this.enchantmentTimeRemaining += 500;
            if (!this.field_145850_b.field_72995_K) {
                this.func_70298_a(1, 1);
            }
        }
        if (this.currentEnchantment == null) {
            ItemStack itemstack = this.func_70301_a(0);
            for (int i = 0; i < AetherRegistry.getEnchantmentSize(); ++i) {
                AetherEnchantment enchantment = AetherRegistry.getEnchantment(i);
                if (itemstack == null || enchantment == null || itemstack.func_77973_b() != enchantment.getEnchantmentInput().func_77973_b() || itemstack.func_77952_i() != enchantment.getEnchantmentInput().func_77952_i() && !itemstack.func_77984_f()) continue;
                if (this.enchantedItemStacks[2] == null) {
                    this.currentEnchantment = enchantment;
                    this.enchantmentTime = this.currentEnchantment.getTimeRequired();
                    continue;
                }
                if (this.enchantedItemStacks[2].func_77973_b() != enchantment.getEnchantedResult().func_77973_b() || enchantment.getEnchantmentInput().func_77976_d() <= this.enchantedItemStacks[2].field_77994_a) continue;
                this.currentEnchantment = enchantment;
                this.enchantmentTime = this.currentEnchantment.getTimeRequired();
            }
        }
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnchantmentProgressScaled(int i) {
        if (this.enchantmentTime == 0) {
            return 0;
        }
        return this.enchantmentProgress * i / this.enchantmentTime;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnchantmentTimeRemaining(int i) {
        return this.enchantmentTimeRemaining * i / 500;
    }

    public boolean isBurning() {
        return this.enchantmentTimeRemaining > 0;
    }

    @Override
    public int func_70302_i_() {
        return this.enchantedItemStacks.length;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return this.enchantedItemStacks[i];
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        if (this.enchantedItemStacks[i] != null) {
            if (this.enchantedItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.enchantedItemStacks[i];
                this.enchantedItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.enchantedItemStacks[i].func_77979_a(j);
            if (this.enchantedItemStacks[i].field_77994_a == 0) {
                this.enchantedItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (this.enchantedItemStacks[par1] != null) {
            ItemStack var2 = this.enchantedItemStacks[par1];
            this.enchantedItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        this.enchantedItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public static boolean isItemFuel(ItemStack fuel) {
        return fuel.func_77973_b() == ItemsAether.ambrosium_shard;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_189515_b(var1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, var1);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.enchantedItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.enchantedItemStacks.length) continue;
            this.enchantedItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.enchantmentProgress = nbttagcompound.func_74765_d("EnchantedTime");
        this.enchantmentTime = nbttagcompound.func_74765_d("EnchantTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("EnchantedTime", (short)this.enchantmentProgress);
        nbttagcompound.func_74777_a("EnchantTime", (short)this.enchantmentTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.enchantedItemStacks.length; ++i) {
            if (this.enchantedItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.enchantedItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public boolean isValidSlotItem(int slot, ItemStack stackInSlot) {
        if (slot == 2) {
            return false;
        }
        if (slot == 1 && TileEntityEnchanter.isItemFuel(stackInSlot)) {
            return true;
        }
        return slot == 0 && TileEntityEnchanter.getEnchantmentResult(stackInSlot) != null;
    }

    public static ItemStack getEnchantmentResult(ItemStack stack) {
        for (AetherEnchantment enchants : AetherRegistry.getEnchantables()) {
            if (enchants.getEnchantmentInput().func_77973_b() != stack.func_77973_b()) continue;
            return enchants.getEnchantedResult().func_77946_l();
        }
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        return nArray;
    }
}

