/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.player;

import com.legacy.aether.server.AetherConfig;
import com.legacy.aether.server.blocks.BlocksAether;
import com.legacy.aether.server.containers.inventory.InventoryAccessories;
import com.legacy.aether.server.entities.passive.EntityMiniCloud;
import com.legacy.aether.server.entities.passive.mountable.EntityParachute;
import com.legacy.aether.server.items.ItemsAether;
import com.legacy.aether.server.networking.AetherNetworkingManager;
import com.legacy.aether.server.networking.packets.PacketAccessory;
import com.legacy.aether.server.player.abilities.Ability;
import com.legacy.aether.server.player.abilities.AbilityAccessories;
import com.legacy.aether.server.player.abilities.AbilityArmor;
import com.legacy.aether.server.player.abilities.AbilityFlight;
import com.legacy.aether.server.player.abilities.AbilityRepulsion;
import com.legacy.aether.server.player.capability.PlayerAetherManager;
import com.legacy.aether.server.player.movement.AetherPoisonMovement;
import com.legacy.aether.server.player.perks.AetherRankings;
import com.legacy.aether.server.player.perks.util.DonatorMoaSkin;
import com.legacy.aether.server.registry.achievements.AchievementsAether;
import com.legacy.aether.server.world.TeleporterAether;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class PlayerAether {
    public EntityPlayer thePlayer;
    private UUID healthUUID = UUID.fromString("df6eabe7-6947-4a56-9099-002f90370706");
    private AttributeModifier healthModifier;
    public InventoryAccessories accessories;
    private AetherPoisonMovement poison;
    public float wingSinage;
    public EntityMiniCloud leftCloud;
    public EntityMiniCloud rightCloud;
    public Entity currentBoss;
    public Ability[] abilities;
    private boolean isJumping;
    private boolean isDonator;
    private float lifeShardsUsed;
    public float prevPortalAnimTime;
    public float portalAnimTime;
    public int timeInPortal;
    public int portalCooldown;
    public boolean hasTeleported = false;
    public boolean inPortal = false;
    private String cooldownName = "Hammer of Notch";
    private int cooldown;
    private int cooldownMax;
    public boolean shouldRenderHalo = true;
    public DonatorMoaSkin donatorMoaSkin;
    public List<Item> extendedReachItems = Arrays.asList(ItemsAether.valkyrie_shovel, ItemsAether.valkyrie_pickaxe, ItemsAether.valkyrie_axe);

    public PlayerAether() {
    }

    public PlayerAether(EntityPlayer player) {
        this.thePlayer = player;
        this.donatorMoaSkin = new DonatorMoaSkin();
        this.poison = new AetherPoisonMovement(this);
        this.accessories = new InventoryAccessories(this);
        this.abilities = new Ability[]{new AbilityArmor(this), new AbilityAccessories(this), new AbilityFlight(this), new AbilityRepulsion(this)};
    }

    public static PlayerAether get(EntityPlayer player) {
        return (PlayerAether)player.getCapability(PlayerAetherManager.AETHER_PLAYER, null);
    }

    public void onUpdate() {
        for (Ability ability : this.abilities) {
            if (!ability.isEnabled()) continue;
            ability.onUpdate();
        }
        this.poison.onUpdate();
        if (this.leftCloud != null && this.rightCloud != null && this.leftCloud.field_70128_L && this.rightCloud.field_70128_L) {
            this.leftCloud = new EntityMiniCloud(this.thePlayer.field_70170_p, this.thePlayer, 0);
            this.rightCloud = new EntityMiniCloud(this.thePlayer.field_70170_p, this.thePlayer, 1);
        }
        this.wingSinage = this.wingSinage > 6.283186f ? (this.wingSinage -= 6.283186f) : (this.wingSinage += 0.1f);
        if (this.currentBoss != null && (((EntityLiving)this.currentBoss).func_110143_aJ() <= 0.0f || this.currentBoss.field_70128_L || Math.sqrt(Math.pow(this.currentBoss.field_70165_t - this.thePlayer.field_70165_t, 2.0) + Math.pow(this.currentBoss.field_70163_u - this.thePlayer.field_70163_u, 2.0) + Math.pow(this.currentBoss.field_70161_v - this.thePlayer.field_70161_v, 2.0)) > 50.0)) {
            this.currentBoss = null;
        }
        boolean hasJumped = (Boolean)ReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)this.thePlayer, (String[])new String[]{"isJumping", "field_70703_bu"});
        this.setJumping(hasJumped);
        if (this.isInBlock(BlocksAether.aercloud)) {
            this.thePlayer.field_70143_R = 0.0f;
        }
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
        }
        if (this.thePlayer.field_70181_x < -2.0) {
            this.activateParachute();
        }
        if (this.thePlayer.field_71093_bK == AetherConfig.getAetherDimensionID()) {
            if (this.thePlayer.field_70163_u < -2.0) {
                this.thePlayer.func_184210_p();
                this.teleportPlayer(false);
                this.thePlayer.func_70634_a(this.thePlayer.field_70165_t, 256.0, this.thePlayer.field_70161_v);
            }
            this.thePlayer.func_71029_a((StatBase)AchievementsAether.enter_aether);
        }
        if (this.thePlayer.field_70170_p.field_72995_K) {
            this.prevPortalAnimTime = this.portalAnimTime;
            if (this.inPortal) {
                this.portalAnimTime += 0.0125f;
                this.inPortal = false;
            } else {
                if (this.portalAnimTime > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.portalAnimTime < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
        } else {
            if (this.inPortal) {
                int limit = this.thePlayer.func_82145_z();
                if (this.timeInPortal++ >= limit) {
                    this.timeInPortal = limit;
                    this.portalCooldown = this.thePlayer.func_82147_ab();
                    this.teleportPlayer(true);
                }
                this.inPortal = false;
            } else {
                if (this.timeInPortal > 0) {
                    this.timeInPortal -= 4;
                }
                if (this.timeInPortal < 0) {
                    this.timeInPortal = 0;
                }
                if (this.portalCooldown > 0) {
                    --this.portalCooldown;
                }
            }
            ((EntityPlayerMP)this.thePlayer).field_71134_c.setBlockReachDistance(this.getReach());
        }
    }

    public boolean onPlayerAttacked(DamageSource source) {
        return this.isWearingPhoenixSet() && source.func_76347_k();
    }

    public void onPlayerDeath() {
        if (!this.thePlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.accessories.dropAllItems();
        }
    }

    public void onPlayerRespawn() {
        this.refreshMaxHP();
        this.thePlayer.func_70606_j(this.thePlayer.func_110138_aP());
        this.updateAccessories();
    }

    public void onChangedDimension(int toDim, int fromDim) {
        this.updateAccessories();
    }

    public void saveNBTData(NBTTagCompound output) {
        if (AetherRankings.isRankedPlayer(this.thePlayer.func_110124_au())) {
            output.func_74757_a("halo", this.shouldRenderHalo);
        }
        output.func_74768_a("hammer_cooldown", this.cooldown);
        output.func_74778_a("notch_hammer_name", this.cooldownName);
        output.func_74768_a("max_hammer_cooldown", this.cooldownMax);
        output.func_74776_a("shards_used", this.lifeShardsUsed);
        output.func_74782_a("accessories", (NBTBase)this.accessories.writeToNBT(new NBTTagList()));
    }

    public void loadNBTData(NBTTagCompound input) {
        if (input.func_74764_b("halo")) {
            this.shouldRenderHalo = input.func_74767_n("halo");
        }
        this.cooldown = input.func_74762_e("hammer_cooldown");
        this.cooldownName = input.func_74779_i("notch_hammer_name");
        this.cooldownMax = input.func_74762_e("max_hammer_cooldown");
        this.lifeShardsUsed = input.func_74760_g("shards_used");
        this.accessories.readFromNBT(input.func_150295_c("accessories", 10));
    }

    public float getCurrentPlayerStrVsBlock(float original) {
        float f = original;
        if (this.wearingAccessory(ItemsAether.zanite_pendant)) {
            f *= 1.0f + (float)this.accessories.getStackFromItem(ItemsAether.zanite_pendant).func_77952_i() / ((float)this.accessories.getStackFromItem(ItemsAether.zanite_pendant).func_77958_k() * 3.0f);
        }
        if (this.wearingAccessory(ItemsAether.zanite_ring)) {
            f *= 1.0f + (float)this.accessories.getStackFromItem(ItemsAether.zanite_ring).func_77952_i() / ((float)this.accessories.getStackFromItem(ItemsAether.zanite_ring).func_77958_k() * 3.0f);
        }
        return f == original ? original : f + original;
    }

    public double getReach() {
        ItemStack stack = this.thePlayer.field_71071_by.func_70448_g();
        if (stack != null && this.extendedReachItems.contains(stack.func_77973_b())) {
            return 10.0;
        }
        return this.thePlayer.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
    }

    public boolean wearingAccessory(Item item) {
        for (int index = 0; index < 8; ++index) {
            if (this.getAccessoryStacks()[index] == null || this.getAccessoryStacks()[index].func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public int getAccessoryCount(Item item) {
        int count = 0;
        for (int index = 0; index < 8; ++index) {
            if (this.getAccessoryStacks()[index] == null || this.getAccessoryStacks()[index].func_77973_b() != item) continue;
            ++count;
        }
        return count;
    }

    public boolean wearingArmor(Item itemID) {
        for (int index = 0; index < 4; ++index) {
            if (this.thePlayer == null || this.thePlayer.field_71071_by.field_70460_b[index] == null || this.thePlayer.field_71071_by.field_70460_b[index].func_77973_b() != itemID) continue;
            return true;
        }
        return false;
    }

    public boolean isWearingZaniteSet() {
        return this.wearingArmor(ItemsAether.zanite_helmet) && this.wearingArmor(ItemsAether.zanite_chestplate) && this.wearingArmor(ItemsAether.zanite_leggings) && this.wearingArmor(ItemsAether.zanite_boots) && this.wearingAccessory(ItemsAether.zanite_gloves);
    }

    public boolean isWearingGravititeSet() {
        return this.wearingArmor(ItemsAether.gravitite_helmet) && this.wearingArmor(ItemsAether.gravitite_chestplate) && this.wearingArmor(ItemsAether.gravitite_leggings) && this.wearingArmor(ItemsAether.gravitite_boots) && this.wearingAccessory(ItemsAether.gravitite_gloves);
    }

    public boolean isWearingNeptuneSet() {
        return this.wearingArmor(ItemsAether.neptune_helmet) && this.wearingArmor(ItemsAether.neptune_chestplate) && this.wearingArmor(ItemsAether.neptune_leggings) && this.wearingArmor(ItemsAether.neptune_boots) && this.wearingAccessory(ItemsAether.neptune_gloves);
    }

    public boolean isWearingPhoenixSet() {
        return this.wearingArmor(ItemsAether.phoenix_helmet) && this.wearingArmor(ItemsAether.phoenix_chestplate) && this.wearingArmor(ItemsAether.phoenix_leggings) && this.wearingArmor(ItemsAether.phoenix_boots) && this.wearingAccessory(ItemsAether.phoenix_gloves);
    }

    public boolean isWearingValkyrieSet() {
        return this.wearingArmor(ItemsAether.valkyrie_helmet) && this.wearingArmor(ItemsAether.valkyrie_chestplate) && this.wearingArmor(ItemsAether.valkyrie_leggings) && this.wearingArmor(ItemsAether.valkyrie_boots) && this.wearingAccessory(ItemsAether.valkyrie_gloves);
    }

    public boolean isWearingObsidianSet() {
        return this.wearingArmor(ItemsAether.obsidian_helmet) && this.wearingArmor(ItemsAether.obsidian_chestplate) && this.wearingArmor(ItemsAether.obsidian_leggings) && this.wearingArmor(ItemsAether.obsidian_boots) && this.wearingAccessory(ItemsAether.obsidian_gloves);
    }

    public ItemStack[] getAccessoryStacks() {
        return this.accessories.stacks;
    }

    private void teleportPlayer(boolean shouldSpawnPortal) {
        if (this.thePlayer instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)this.thePlayer;
            PlayerList scm = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            int transferToID = player.field_71093_bK == AetherConfig.getAetherDimensionID() ? 0 : AetherConfig.getAetherDimensionID();
            scm.transferPlayerToDimension(player, transferToID, (Teleporter)new TeleporterAether(shouldSpawnPortal, FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(transferToID)));
        }
    }

    private void activateParachute() {
        EntityParachute parachute = null;
        if (this.thePlayer.field_71071_by.func_70431_c(new ItemStack(ItemsAether.cloud_parachute))) {
            parachute = new EntityParachute(this.thePlayer.field_70170_p, this.thePlayer, false);
            parachute.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
            this.thePlayer.field_70170_p.func_72838_d((Entity)parachute);
            this.thePlayer.field_71071_by.func_184437_d(new ItemStack(ItemsAether.cloud_parachute));
        } else if (this.thePlayer.field_71071_by.func_70431_c(new ItemStack(ItemsAether.golden_parachute))) {
            for (int i = 0; i < this.thePlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = this.thePlayer.field_71071_by.func_70301_a(i);
                if (itemstack == null || itemstack.func_77973_b() != ItemsAether.golden_parachute) continue;
                itemstack.func_77972_a(1, (EntityLivingBase)this.thePlayer);
                parachute = new EntityParachute(this.thePlayer.field_70170_p, this.thePlayer, true);
                parachute.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
                this.thePlayer.field_71071_by.func_70299_a(i, itemstack);
                this.thePlayer.field_70170_p.func_72838_d((Entity)parachute);
            }
        }
    }

    public boolean isInBlock(Block blockID) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.thePlayer.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)this.thePlayer.field_70163_u), z = MathHelper.func_76128_c((double)this.thePlayer.field_70161_v));
        return this.thePlayer.field_70170_p.func_180495_p(pos).func_177230_c() == blockID || this.thePlayer.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == blockID || this.thePlayer.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == blockID;
    }

    public void increaseMaxHP() {
        this.lifeShardsUsed += 2.0f;
        this.healthModifier = new AttributeModifier(this.healthUUID, "Aether Health Modifier", (double)this.lifeShardsUsed, 0);
        if (this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(this.healthUUID) != null) {
            this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(this.healthModifier);
        }
        this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.healthModifier);
    }

    public void refreshMaxHP() {
        this.healthModifier = new AttributeModifier(this.healthUUID, "Aether Health Modifier", (double)this.lifeShardsUsed, 0);
        if (this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(this.healthUUID) != null) {
            this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(this.healthModifier);
        }
        this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.healthModifier);
    }

    public float getExtraHealth() {
        return this.lifeShardsUsed;
    }

    public Entity getCurrentBoss() {
        return this.currentBoss;
    }

    public void setCurrentBoss(Entity currentBoss) {
        this.currentBoss = currentBoss;
    }

    public boolean setGeneralCooldown(int cooldown, String stackName) {
        if (this.cooldown == 0) {
            this.cooldown = cooldown;
            this.cooldownMax = cooldown;
            this.cooldownName = stackName;
            return true;
        }
        return false;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getCooldownMax() {
        return this.cooldownMax;
    }

    public String getCooldownName() {
        return this.cooldownName;
    }

    public AetherPoisonMovement poisonInstance() {
        return this.poison;
    }

    public void afflictPoison() {
        this.poison.afflictPoison();
    }

    public void attainCure(int time) {
        this.poison.curePoison(time);
    }

    public boolean isPoisoned() {
        return this.poison.poisonTime > 0;
    }

    public boolean isCured() {
        return this.poison.poisonTime < 0;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    public boolean isDonator() {
        return this.isDonator;
    }

    public void setDonator(boolean isDonator) {
        this.isDonator = isDonator;
    }

    public void setInPortal() {
        if (this.portalCooldown > 0) {
            this.portalCooldown = this.thePlayer.func_82147_ab();
        } else {
            this.inPortal = true;
        }
    }

    public void updateAccessories() {
        if (!this.thePlayer.field_70170_p.field_72995_K) {
            AetherNetworkingManager.sendToAll(new PacketAccessory(this));
        }
    }
}

