/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.items.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.legacy.aether.server.items.armor.ItemAetherArmor;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class ItemZaniteArmor
extends ItemAetherArmor {
    private final UUID ARMOR_RESISTANCE = UUID.fromString("d111114d-f592-4876-a2eb-26bbc974b0fd");
    private final int[][] damageReductionAmountArray = new int[][]{{1, 2, 3, 1}, {1, 4, 5, 2}, {2, 5, 6, 2}, {3, 6, 8, 3}, {4, 8, 10, 4}};

    public ItemZaniteArmor(EntityEquipmentSlot armorType, ItemArmor.ArmorMaterial material, String name, Item repair, int hex) {
        super(armorType, material, name, repair, hex);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(this.ARMOR_RESISTANCE, "Armor modifier", (double)this.calculateIncrease(stack), 0));
        }
        return multimap;
    }

    private float calculateIncrease(ItemStack tool) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
            if (this.isBetween(tool, 0, 32)) {
                return this.getDamageReductionAmount(4);
            }
            if (this.isBetween(tool, 33, 65)) {
                return this.getDamageReductionAmount(3);
            }
            if (this.isBetween(tool, 66, 98)) {
                return this.getDamageReductionAmount(2);
            }
            if (this.isBetween(tool, 99, 131)) {
                return this.getDamageReductionAmount(1);
            }
            if (this.isBetween(tool, 132, 165)) {
                return this.getDamageReductionAmount(0);
            }
        } else if (this.field_77881_a == EntityEquipmentSlot.CHEST) {
            if (this.isBetween(tool, 0, 47)) {
                return this.getDamageReductionAmount(4);
            }
            if (this.isBetween(tool, 48, 95)) {
                return this.getDamageReductionAmount(3);
            }
            if (this.isBetween(tool, 96, 143)) {
                return this.getDamageReductionAmount(2);
            }
            if (this.isBetween(tool, 144, 191)) {
                return this.getDamageReductionAmount(1);
            }
            if (this.isBetween(tool, 192, 240)) {
                return this.getDamageReductionAmount(0);
            }
        } else if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            if (this.isBetween(tool, 0, 44)) {
                return this.getDamageReductionAmount(4);
            }
            if (this.isBetween(tool, 45, 89)) {
                return this.getDamageReductionAmount(3);
            }
            if (this.isBetween(tool, 90, 134)) {
                return this.getDamageReductionAmount(2);
            }
            if (this.isBetween(tool, 135, 179)) {
                return this.getDamageReductionAmount(1);
            }
            if (this.isBetween(tool, 180, 225)) {
                return this.getDamageReductionAmount(0);
            }
        } else if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            if (this.isBetween(tool, 0, 38)) {
                return this.getDamageReductionAmount(4);
            }
            if (this.isBetween(tool, 39, 77)) {
                return this.getDamageReductionAmount(3);
            }
            if (this.isBetween(tool, 78, 116)) {
                return this.getDamageReductionAmount(2);
            }
            if (this.isBetween(tool, 117, 155)) {
                return this.getDamageReductionAmount(1);
            }
            if (this.isBetween(tool, 156, 195)) {
                return this.getDamageReductionAmount(0);
            }
        }
        return 0.0f;
    }

    public boolean isBetween(ItemStack tool, int max, int min) {
        int maxDamage;
        int origin = tool.func_77952_i();
        return origin <= (maxDamage = tool.func_77958_k()) - max && origin >= maxDamage - min;
    }

    public int getDamageReductionAmount(int level) {
        return this.damageReductionAmountArray[level][this.field_77881_a.func_188454_b()];
    }
}

