/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.entities.projectile.crystals;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityThunderBall
extends EntityFlying {
    public float[] sinage;
    public EntityLivingBase target;
    public boolean firstRun;
    public int life;
    public int lifeSpan;
    private static final float sponge = 57.295773f;

    public EntityThunderBall(World world) {
        super(world);
        this.life = this.lifeSpan = 200;
        this.firstRun = true;
        this.sinage = new float[3];
        this.field_70178_ae = true;
        this.func_70105_a(0.7f, 0.7f);
        for (int i = 0; i < 3; ++i) {
            this.sinage[i] = this.field_70146_Z.nextFloat() * 6.0f;
        }
    }

    public EntityThunderBall(World world, double x, double y, double z, EntityLivingBase player) {
        this(world);
        this.func_70107_b(x, y, z);
        this.target = player;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_70606_j(20.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.life;
        if (this.firstRun && this.target == null) {
            this.target = (EntityLivingBase)this.findPlayerToAttack();
            this.firstRun = false;
        }
        if (this.target == null || this.target.field_70128_L || this.target.func_110143_aJ() <= 0.0f) {
            this.field_70128_L = true;
        } else if (this.life <= 0) {
            EntityLightningBolt thunder = new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, false);
            this.field_70170_p.func_72838_d((Entity)thunder);
            this.field_70128_L = true;
        } else {
            this.updateAnims();
            this.func_70625_a((Entity)this.target, 10.0f, 10.0f);
            this.moveTowardsTarget((Entity)this.target, 0.02);
        }
    }

    public void moveTowardsTarget(Entity target, double speed) {
        double angle1 = this.field_70177_z / 57.295773f;
        this.field_70159_w -= Math.sin(angle1) * speed;
        this.field_70179_y += Math.cos(angle1) * speed;
        double a = target.field_70163_u - 0.75;
        this.field_70181_x = a < this.func_174813_aQ().field_72338_b - 0.5 ? (this.field_70181_x -= speed / 2.0) : (a > this.func_174813_aQ().field_72338_b + 0.5 ? (this.field_70181_x += speed / 2.0) : (this.field_70181_x += (a - this.func_174813_aQ().field_72338_b) * (speed / 2.0)));
        if (this.field_70122_E) {
            this.field_70122_E = false;
            this.field_70181_x = 0.1f;
        }
    }

    public void updateAnims() {
        for (int i = 0; i < 3; ++i) {
            int n = i;
            this.sinage[n] = this.sinage[n] + (0.3f + (float)i * 0.13f);
            if (!(this.sinage[i] > 6.283186f)) continue;
            int n2 = i;
            this.sinage[n2] = this.sinage[n2] - 6.283186f;
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("LifeLeft", (short)this.life);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.life = nbttagcompound.func_74765_d("LifeLeft");
    }

    public Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
        if (entityplayer != null && this.func_70685_l((Entity)entityplayer)) {
            return entityplayer;
        }
        return null;
    }

    public void func_70108_f(Entity entity) {
        boolean flag;
        super.func_70108_f(entity);
        if (entity != null && this.target != null && entity == this.target && (flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f))) {
            this.moveTowardsTarget(entity, -0.1);
        }
    }

    public boolean attackEntityFrom(Entity entity, float i) {
        if (entity != null) {
            this.moveTowardsTarget(entity, -0.15 - (double)i / 8.0);
            return true;
        }
        return false;
    }
}

