/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.entities.passive.mountable;

import com.legacy.aether.server.entities.util.EntitySaddleMount;
import com.legacy.aether.server.entities.util.MoaColor;
import com.legacy.aether.server.items.ItemMoaEgg;
import com.legacy.aether.server.items.ItemsAether;
import com.legacy.aether.server.registry.sounds.SoundsAether;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityMoa
extends EntitySaddleMount {
    public static final DataParameter<Integer> MOA_COLOR = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> REMAINING_JUMPS = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Byte> AMMOUNT_FEED = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Boolean> PLAYER_GROWN = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HUNGRY = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187198_h);
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    protected int maxJumps;
    protected int ticksOffGround;
    protected int ticksUntilFlap;
    protected int secsUntilFlying;
    protected int secsUntilWalking;
    protected int secsUntilHungry;
    protected int secsUntilEgg;

    public EntityMoa(World world) {
        super(world);
        this.initAI();
        this.func_70105_a(1.0f, 2.0f);
        this.field_70138_W = 1.0f;
        this.secsUntilEgg = this.getRandomEggTime();
    }

    public EntityMoa(World world, MoaColor color) {
        this(world);
        this.setColor(color);
    }

    public void func_70091_d(double x, double y, double z) {
        if (!this.isSitting()) {
            super.func_70091_d(x, y, z);
        } else {
            super.func_70091_d(0.0, y, 0.0);
        }
    }

    public int getRandomEggTime() {
        return 775 + this.field_70146_Z.nextInt(50);
    }

    public void initAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)0.3f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.25));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        MoaColor color = MoaColor.getRandomColor(this.field_70170_p);
        this.field_70180_af.func_187214_a(MOA_COLOR, (Object)color.ID);
        this.field_70180_af.func_187214_a(REMAINING_JUMPS, (Object)color.jumps);
        this.field_70180_af.func_187214_a(PLAYER_GROWN, (Object)false);
        this.field_70180_af.func_187214_a(AMMOUNT_FEED, (Object)0);
        this.field_70180_af.func_187214_a(HUNGRY, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean isSitting) {
        this.field_70180_af.func_187227_b(SITTING, (Object)isSitting);
    }

    public boolean isHungry() {
        return (Boolean)this.field_70180_af.func_187225_a(HUNGRY);
    }

    public void setHungry(boolean hungry) {
        this.field_70180_af.func_187227_b(HUNGRY, (Object)hungry);
    }

    public byte getAmountFed() {
        return (Byte)this.field_70180_af.func_187225_a(AMMOUNT_FEED);
    }

    public void setAmountFed(int amountFed) {
        this.field_70180_af.func_187227_b(AMMOUNT_FEED, (Object)((byte)amountFed));
    }

    public void increaseAmountFed(int amountFed) {
        this.setAmountFed(this.getAmountFed() + amountFed);
    }

    public boolean isPlayerGrown() {
        return (Boolean)this.field_70180_af.func_187225_a(PLAYER_GROWN);
    }

    public void setPlayerGrown(boolean playerGrown) {
        this.field_70180_af.func_187227_b(PLAYER_GROWN, (Object)playerGrown);
    }

    public int getMaxJumps() {
        return this.maxJumps;
    }

    public void setMaxJumps(int maxJumps) {
        this.maxJumps = maxJumps;
    }

    public int getRemainingJumps() {
        return (Integer)this.field_70180_af.func_187225_a(REMAINING_JUMPS);
    }

    public void setRemainingJumps(int jumps) {
        this.field_70180_af.func_187227_b(REMAINING_JUMPS, (Object)jumps);
    }

    public MoaColor getColor() {
        return MoaColor.getColor((Integer)this.field_70180_af.func_187225_a(MOA_COLOR));
    }

    public void setColor(MoaColor color) {
        this.field_70180_af.func_187227_b(MOA_COLOR, (Object)color.ID);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.setMaxJumps(this.getColor().jumps);
        if (this.field_70703_bu) {
            this.field_70181_x += (double)0.05f;
        }
        this.updateWingRotation();
        this.fall();
        if (this.secsUntilHungry > 0) {
            if (this.field_70173_aa % 20 == 0) {
                --this.secsUntilHungry;
            }
        } else if (!this.isHungry()) {
            this.setHungry(true);
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.func_184188_bt().isEmpty()) {
            if (this.secsUntilEgg > 0) {
                if (this.field_70173_aa % 20 == 0) {
                    --this.secsUntilEgg;
                }
            } else {
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_70099_a(ItemMoaEgg.getStackFromColor(this.getColor()), 0.0f);
                this.secsUntilEgg = this.getRandomEggTime();
            }
        }
        this.field_70143_R = 0.0f;
    }

    public void resetHunger() {
        if (!this.field_70170_p.field_72995_K) {
            this.setHungry(false);
        }
        this.secsUntilHungry = 40 + this.field_70146_Z.nextInt(40);
    }

    public void updateWingRotation() {
        boolean onGround;
        boolean bl = onGround = !this.field_70170_p.func_175623_d(new BlockPos((Entity)this).func_177977_b());
        if (!onGround) {
            if (this.ticksUntilFlap == 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187744_z, SoundCategory.NEUTRAL, 0.15f, MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.7f, (float)1.0f) + MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.0f, (float)0.3f));
                this.ticksUntilFlap = 11;
            } else {
                --this.ticksUntilFlap;
            }
        }
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + 0.2);
        this.destPos = EntityMoa.minMax(0.01f, 1.0f, this.destPos);
        if (onGround) {
            this.destPos = 0.0f;
        }
        this.wingRotation += 0.533f;
    }

    public static float minMax(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    @Override
    public void onMountedJump(float par1, float par2) {
        if (this.getRemainingJumps() > 0 && this.field_70181_x < 0.0) {
            if (!this.field_70122_E) {
                this.field_70181_x = 0.7;
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187744_z, SoundCategory.NEUTRAL, 0.15f, MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.7f, (float)1.0f) + MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.0f, (float)0.3f));
                if (!this.field_70170_p.field_72995_K) {
                    this.setRemainingJumps(this.getRemainingJumps() - 1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70656_aK();
                }
            } else {
                this.field_70181_x = 0.89;
            }
        }
    }

    @Override
    public float getMountedMoveSpeed() {
        return this.getColor().ID == 1 ? 0.6f : 0.3f;
    }

    public void setToAdult() {
        this.func_70873_a(0);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && this.isPlayerGrown()) {
            Item currentItem = stack.func_77973_b();
            if (this.func_70631_g_() && this.isHungry() && this.getAmountFed() < 3 && currentItem == ItemsAether.aechor_petal) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                this.increaseAmountFed(1);
                if (this.getAmountFed() >= 3) {
                    this.setToAdult();
                } else {
                    this.resetHunger();
                }
            }
            if (currentItem == ItemsAether.nature_staff) {
                stack.func_77972_a(2, (EntityLivingBase)player);
                this.setSitting(!this.isSitting());
                return true;
            }
        }
        return super.func_184645_a(player, hand, stack);
    }

    @Override
    public boolean canSaddle() {
        return !this.func_70631_g_() && this.isPlayerGrown();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("playerGrown", this.isPlayerGrown());
        nbt.func_74768_a("remainingJumps", this.getRemainingJumps());
        nbt.func_74768_a("color", this.getColor().ID);
        nbt.func_74774_a("amountFed", this.getAmountFed());
        nbt.func_74757_a("isHungry", this.isHungry());
        nbt.func_74757_a("isSitting", this.isSitting());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setPlayerGrown(nbt.func_74767_n("playerGrown"));
        this.setRemainingJumps(nbt.func_74762_e("remainingJumps"));
        this.setColor(MoaColor.getColor(nbt.func_74762_e("color")));
        this.setAmountFed(nbt.func_74771_c("amountFed"));
        this.setHungry(nbt.func_74767_n("isHungry"));
        this.setSitting(nbt.func_74767_n("isSitting"));
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.moa_say;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundsAether.moa_say;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.moa_say;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block par4) {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187709_dP, SoundCategory.NEUTRAL, 0.15f, 1.0f);
    }

    @Override
    protected void func_70628_a(boolean var1, int var2) {
        super.func_70628_a(var1, var2);
        this.func_145779_a(Items.field_151008_G, 3);
    }

    public void fall() {
        boolean blockBeneath;
        boolean bl = blockBeneath = !this.field_70170_p.func_175623_d(new BlockPos((Entity)this).func_177977_b());
        if (this.field_70181_x < 0.0 && !this.isRiderSneaking()) {
            this.field_70181_x *= 0.6;
        }
        if (blockBeneath) {
            this.setRemainingJumps(this.maxJumps);
        }
    }

    public void func_70664_aZ() {
        if (!this.isSitting() && this.func_184188_bt().isEmpty()) {
            super.func_70664_aZ();
        }
    }

    public double func_70042_X() {
        return 1.37;
    }

    public EntityAgeable func_90011_a(EntityAgeable matingAnimal) {
        return new EntityMoa(this.field_70170_p, this.getColor());
    }
}

