/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.entities.bosses.valkyrie_queen;

import com.legacy.aether.server.Aether;
import com.legacy.aether.server.blocks.BlocksAether;
import com.legacy.aether.server.blocks.dungeon.BlockDungeonBase;
import com.legacy.aether.server.blocks.util.EnumStoneType;
import com.legacy.aether.server.entities.ai.EntityAIAttackContinuously;
import com.legacy.aether.server.entities.ai.valkyrie_queen.ValkyrieQueenAIWander;
import com.legacy.aether.server.entities.projectile.crystals.EntityThunderBall;
import com.legacy.aether.server.entities.util.AetherNameGen;
import com.legacy.aether.server.items.ItemsAether;
import com.legacy.aether.server.player.PlayerAether;
import com.legacy.aether.server.registry.achievements.AchievementsAether;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class EntityValkyrieQueen
extends EntityMob {
    public static final DataParameter<String> VALKYRIE_NAME = EntityDataManager.func_187226_a(EntityValkyrieQueen.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Boolean> VALKYRIE_READY = EntityDataManager.func_187226_a(EntityValkyrieQueen.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIAttackContinuously enhancedCombat = new EntityAIAttackContinuously((EntityCreature)this, 0.65);
    public int angerLevel;
    public int timeLeft;
    public int timeUntilTeleport = this.field_70146_Z.nextInt(250);
    public int chatTime;
    public int dungeonX;
    public int dungeonY;
    public int dungeonZ;
    public int dungeonEntranceZ;
    public double safeX;
    public double safeY;
    public double safeZ;
    public float sinage;
    public double lastMotionY;

    public EntityValkyrieQueen(World world) {
        super(world);
        this.registerEntityAI();
        this.setBossName(AetherNameGen.valkGen());
        this.safeX = this.field_70165_t;
        this.safeY = this.field_70163_u;
        this.safeZ = this.field_70161_v;
    }

    public EntityValkyrieQueen(World world, double x, double y, double z) {
        this(world);
        this.safeX = this.field_70165_t = x;
        this.safeY = this.field_70163_u = y;
        this.safeZ = this.field_70161_v = z;
    }

    public void registerEntityAI() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.enhancedCombat);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new ValkyrieQueenAIWander(this, 0.5));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(28.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(13.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
        this.func_70606_j(500.0f);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70165_t = Math.floor(this.field_70165_t + 0.5);
        this.field_70163_u = Math.floor(this.field_70163_u + 0.5);
        this.field_70161_v = Math.floor(this.field_70161_v + 0.5);
        this.field_70180_af.func_187214_a(VALKYRIE_READY, (Object)false);
        this.field_70180_af.func_187214_a(VALKYRIE_NAME, (Object)AetherNameGen.valkGen());
    }

    public void swingArm() {
        if (!this.field_82175_bq) {
            this.field_82175_bq = true;
        }
    }

    private void becomeAngryAt(EntityLivingBase entity) {
        this.func_70624_b(entity);
        this.angerLevel = 200 + this.field_70146_Z.nextInt(200);
        for (int k = this.dungeonZ + 2; k < this.dungeonZ + 23; k += 7) {
            if (this.field_70170_p.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(this.dungeonX - 1, this.dungeonY, k)).func_177230_c() != Blocks.field_150350_a) continue;
            this.dungeonEntranceZ = k;
            this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX - 1, this.dungeonY, k), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), 2);
            this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX - 1, this.dungeonY, k + 1), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), 2);
            this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX - 1, this.dungeonY + 1, k + 1), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), 2);
            this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX - 1, this.dungeonY + 1, k), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), 2);
            return;
        }
    }

    public void setDungeon(int i, int j, int k) {
        this.dungeonX = i;
        this.dungeonY = j;
        this.dungeonZ = k;
    }

    private void unlockDoor() {
        IBlockState state = Blocks.field_150350_a.func_176223_P();
        this.field_70170_p.func_175656_a(new BlockPos(this.dungeonX - 1, this.dungeonY, this.dungeonEntranceZ), state);
        this.field_70170_p.func_175656_a(new BlockPos(this.dungeonX - 1, this.dungeonY, this.dungeonEntranceZ + 1), state);
        this.field_70170_p.func_175656_a(new BlockPos(this.dungeonX - 1, this.dungeonY + 1, this.dungeonEntranceZ + 1), state);
        this.field_70170_p.func_175656_a(new BlockPos(this.dungeonX - 1, this.dungeonY + 1, this.dungeonEntranceZ), state);
    }

    private void unlockTreasure() {
        IBlockState state = Blocks.field_150415_aT.func_176223_P();
        this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX + 16, this.dungeonY + 1, this.dungeonZ + 9), state.func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.SOUTH), 2);
        this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX + 17, this.dungeonY + 1, this.dungeonZ + 9), state.func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.SOUTH), 2);
        this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX + 16, this.dungeonY + 1, this.dungeonZ + 10), state.func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.NORTH), 2);
        this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX + 17, this.dungeonY + 1, this.dungeonZ + 10), state.func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.NORTH), 2);
        for (int x = this.dungeonX - 27; x < this.dungeonX + 30; ++x) {
            for (int y = this.dungeonY - 1; y < this.dungeonY + 22; ++y) {
                for (int z = this.dungeonZ - 6; z < this.dungeonZ + 26; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState block = this.field_70170_p.func_180495_p(pos);
                    if (block == BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic))) {
                        this.field_70170_p.func_180501_a(pos, BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), 2);
                    }
                    if (block == BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic))) {
                        this.field_70170_p.func_180501_a(pos, BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), 2);
                    }
                    if (block != BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic))) continue;
                    this.field_70170_p.func_180501_a(pos, BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 2);
                }
            }
        }
    }

    private void chatItUp(EntityPlayer player, String s) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.chatTime <= 0) {
            if (side.isClient()) {
                Aether.proxy.sendMessage(player, s);
            }
            this.chatTime = 60;
        }
    }

    public void makeHomeShot(int shots, EntityPlayer player) {
        for (int i = 0; i < shots; ++i) {
            EntityThunderBall e1 = new EntityThunderBall(this.field_70170_p, this.field_70165_t - this.field_70159_w / 2.0, this.field_70163_u, this.field_70161_v - this.field_70179_y / 2.0, (EntityLivingBase)player);
            if (this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_72838_d((Entity)e1);
        }
    }

    public boolean func_184645_a(EntityPlayer entityplayer, EnumHand hand, ItemStack itemstack) {
        this.func_70625_a((Entity)entityplayer, 180.0f, 180.0f);
        if (this.isBossReady()) {
            this.chatItUp(entityplayer, "If you wish to challenge me, strike at any time.");
        } else if (!this.isBossReady()) {
            if (itemstack != null && itemstack.func_77973_b() == ItemsAether.victory_medal && itemstack.field_77994_a >= 10) {
                itemstack.field_77994_a -= 10;
                if (itemstack.field_77994_a <= 0) {
                    itemstack.func_77972_a(2, (EntityLivingBase)entityplayer);
                    entityplayer.field_71071_by.func_70304_b(entityplayer.field_71071_by.field_70461_c);
                    this.chatTime = 0;
                    this.chatItUp(entityplayer, "Very well, attack me when you wish to begin.");
                    this.setBossReady(true);
                }
            } else {
                this.chatItUp(entityplayer, "Show me 10 victory medals, and I will fight you.");
            }
        }
        return true;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.isBossReady()) {
            this.field_70181_x *= 0.5;
            this.field_70701_bs = 0.0f;
            this.field_70702_br = 0.0f;
        } else {
            super.func_70030_z();
            if (this.func_70638_az() instanceof EntityPlayer) {
                if (this.timeUntilTeleport++ >= 450) {
                    if (this.field_70122_E && this.field_70146_Z.nextInt(10) == 0) {
                        this.makeHomeShot(1, (EntityPlayer)this.func_70638_az());
                    } else {
                        this.teleport(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 4);
                    }
                } else if (this.timeUntilTeleport < 446 && (this.field_70163_u <= 0.0 || this.field_70163_u <= this.safeY - 16.0)) {
                    this.timeUntilTeleport = 446;
                } else if (this.timeUntilTeleport % 5 == 0 && !this.func_70685_l((Entity)this.func_70638_az())) {
                    this.timeUntilTeleport += 100;
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
            this.unlockDoor();
            this.angerLevel = 0;
        }
        if (this.chatTime > 0) {
            --this.chatTime;
        }
    }

    public void func_70071_h_() {
        this.lastMotionY = this.field_70181_x;
        super.func_70071_h_();
        if (!this.field_70122_E && this.func_70638_az() != null && this.lastMotionY >= 0.0 && this.field_70181_x < 0.0 && this.func_70032_d((Entity)this.func_70638_az()) <= 16.0f && this.func_70685_l((Entity)this.func_70638_az())) {
            double a = this.func_70638_az().field_70165_t - this.field_70165_t;
            double b = this.func_70638_az().field_70161_v - this.field_70161_v;
            double angle = Math.atan2(a, b);
            this.field_70159_w = Math.sin(angle) * 0.25;
            this.field_70179_y = Math.cos(angle) * 0.25;
        }
        if (!this.field_70122_E && !this.func_70617_f_() && Math.abs(this.field_70181_x - this.lastMotionY) > 0.07 && Math.abs(this.field_70181_x - this.lastMotionY) < 0.09) {
            this.field_70181_x += (double)0.055f;
            if (this.field_70181_x < (double)-0.275f) {
                this.field_70181_x = -0.275f;
            }
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && (this.func_70638_az() != null || this.angerLevel > 0)) {
            this.angerLevel = 0;
            this.func_70624_b(null);
        }
        this.sinage = !this.field_70122_E ? (this.sinage += 0.75f) : (this.sinage += 0.15f);
        if (this.sinage > 6.283186f) {
            this.sinage -= 6.283186f;
        }
        if (this.func_110143_aJ() <= 0.0f || this.field_70128_L) {
            this.unlockDoor();
            this.unlockTreasure();
            if (this.func_70638_az() instanceof EntityPlayer) {
                this.chatItUp((EntityPlayer)this.func_70638_az(), "You are truly... a mighty warrior...");
                ((EntityPlayer)this.func_70638_az()).func_71029_a((StatBase)AchievementsAether.defeat_silver);
                PlayerAether.get((EntityPlayer)this.func_70638_az()).setCurrentBoss(null);
            }
            this.func_70656_aK();
            this.func_70106_y();
        }
        if (!this.otherDimension()) {
            --this.timeLeft;
            if (this.timeLeft <= 0) {
                this.func_70656_aK();
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("Anger", (short)this.angerLevel);
        nbttagcompound.func_74777_a("TimeLeft", (short)this.timeLeft);
        nbttagcompound.func_74757_a("Duel", this.isBossReady());
        nbttagcompound.func_74768_a("DungeonX", this.dungeonX);
        nbttagcompound.func_74768_a("DungeonY", this.dungeonY);
        nbttagcompound.func_74768_a("DungeonZ", this.dungeonZ);
        nbttagcompound.func_74768_a("DungeonEntranceZ", this.dungeonEntranceZ);
        nbttagcompound.func_74782_a("SafePos", (NBTBase)this.func_70087_a(new double[]{this.safeX, this.safeY, this.safeZ}));
        nbttagcompound.func_74778_a("BossName", this.getBossName());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.angerLevel = nbttagcompound.func_74765_d("Anger");
        this.timeLeft = nbttagcompound.func_74765_d("TimeLeft");
        this.setBossReady(nbttagcompound.func_74767_n("Duel"));
        this.dungeonX = nbttagcompound.func_74762_e("DungeonX");
        this.dungeonY = nbttagcompound.func_74762_e("DungeonY");
        this.dungeonZ = nbttagcompound.func_74762_e("DungeonZ");
        this.dungeonEntranceZ = nbttagcompound.func_74762_e("DungeonEntranceZ");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("SafePos", 10);
        this.setBossName(nbttagcompound.func_74779_i("BossName"));
        this.safeX = nbttaglist.func_150309_d(0);
        this.safeY = nbttaglist.func_150309_d(1);
        this.safeZ = nbttaglist.func_150309_d(2);
    }

    public boolean func_70097_a(DamageSource ds, float i) {
        if (ds.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ds.func_76346_g();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.func_70656_aK();
                this.chatItUp(player, "Sorry, I don't fight with weaklings.");
                return false;
            }
            if (!this.isBossReady()) {
                this.func_70656_aK();
                int pokey = this.field_70146_Z.nextInt(2);
                if (pokey == 2) {
                    this.chatItUp(player, "Sorry, I don't fight with weaklings.");
                } else {
                    this.chatItUp(player, "Try defeating some weaker valkyries first.");
                }
                return false;
            }
            PlayerAether playerAether = PlayerAether.get(player);
            if (playerAether != null) {
                boolean flag = true;
                if (!player.field_70128_L && flag) {
                    playerAether.setCurrentBoss((Entity)this);
                }
            }
            if (this.func_70638_az() == null) {
                this.chatTime = 0;
                this.chatItUp(player, "This will be your final battle!");
                if (ds.func_76346_g() instanceof EntityLivingBase) {
                    this.becomeAngryAt((EntityLivingBase)ds.func_76346_g());
                }
            } else {
                this.timeUntilTeleport += 60;
            }
        } else {
            this.func_70066_B();
            return false;
        }
        return super.func_70097_a(ds, i);
    }

    public boolean func_70652_k(Entity entity) {
        EntityPlayer player;
        boolean flag = false;
        this.swingArm();
        flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 7.0f);
        if (entity != null && this.func_70638_az() != null && entity == this.func_70638_az() && entity instanceof EntityPlayer && ((player = (EntityPlayer)entity).func_110143_aJ() <= 0.0f || player.field_70128_L)) {
            this.func_70624_b(null);
            this.chatTime = 0;
            this.angerLevel = 0;
            this.chatItUp(player, "As expected of a human.");
            this.unlockDoor();
        }
        return flag;
    }

    protected void func_70628_a(boolean var1, int var2) {
        this.func_70099_a(new ItemStack(ItemsAether.dungeon_key, 1, 1), 0.5f);
        this.func_145779_a(Items.field_151010_B, 1);
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.field_77994_a != 0 && stack.func_77973_b() != null) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            entityitem.func_184224_h(true);
            entityitem.func_174869_p();
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }

    public void func_180430_e(float f, float somethingidk) {
    }

    public void teleport(double x, double y, double z, int rad) {
        int a = this.field_70146_Z.nextInt(rad + 1);
        int b = this.field_70146_Z.nextInt(rad / 2);
        int c = rad - a;
        int newX = (int)Math.floor((x += (double)(a *= this.field_70146_Z.nextInt(2) * 2 - 1)) - 0.5);
        int newY = (int)Math.floor((y += (double)(b *= this.field_70146_Z.nextInt(2) * 2 - 1)) - 0.5);
        int newZ = (int)Math.floor((z += (double)(c *= this.field_70146_Z.nextInt(2) * 2 - 1)) - 0.5);
        boolean flag = false;
        for (int q = 0; q < 32 && !flag; ++q) {
            int i = newX + (this.field_70146_Z.nextInt(rad / 2) - this.field_70146_Z.nextInt(rad / 2));
            int j = newY + (this.field_70146_Z.nextInt(rad / 2) - this.field_70146_Z.nextInt(rad / 2));
            int k = newZ + (this.field_70146_Z.nextInt(rad / 2) - this.field_70146_Z.nextInt(rad / 2));
            if (j > 124 || j < 5 || !this.isAirySpace(i, j, k) || !this.isAirySpace(i, j + 1, k) || this.isAirySpace(i, j - 1, k) || i <= this.dungeonX || i >= this.dungeonX + 20 || j <= this.dungeonY || j >= this.dungeonY + 12 || k <= this.dungeonZ || k >= this.dungeonZ + 20) continue;
            newX = i;
            newY = j;
            newZ = k;
            flag = true;
        }
        if (!flag) {
            this.timeUntilTeleport -= this.field_70146_Z.nextInt(40) + 40;
            if (this.field_70163_u <= 0.0) {
                this.timeUntilTeleport = 446;
            }
        } else {
            this.func_70656_aK();
            this.enhancedCombat.func_75251_c();
            this.func_70107_b((double)newX + 0.5, (double)newY + 0.5, (double)newZ + 0.5);
            this.field_70703_bu = false;
            this.field_70761_aq = this.field_70146_Z.nextFloat() * 360.0f;
            this.timeUntilTeleport = this.field_70146_Z.nextInt(40);
            this.field_70177_z = 0.0f;
            this.field_70125_A = 0.0f;
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
            this.field_70181_x = this.field_70179_y = (double)0.0f;
            this.field_70159_w = this.field_70179_y;
        }
    }

    public boolean isAirySpace(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(x, y, z));
        return state == Blocks.field_150350_a || state.func_185890_d(this.field_70170_p, pos) == null;
    }

    public boolean otherDimension() {
        return true;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.field_70170_p.func_175699_k(new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v))) > 8 && this.field_70170_p.func_72829_c(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).size() == 0 && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public int getMedals(EntityPlayer entityplayer) {
        int medals = 0;
        for (ItemStack item : entityplayer.field_71071_by.field_70462_a) {
            if (item == null || item.func_77973_b() != ItemsAether.victory_medal) continue;
            medals += item.field_77994_a;
        }
        return medals;
    }

    protected SoundEvent func_184601_bQ() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public String getBossName() {
        return (String)this.field_70180_af.func_187225_a(VALKYRIE_NAME);
    }

    public void setBossName(String name) {
        this.field_70180_af.func_187227_b(VALKYRIE_NAME, (Object)name);
    }

    public String getBossTitle() {
        return this.getBossName() + ", the Valkyrie Queen";
    }

    public void setBossReady(boolean isReady) {
        this.field_70180_af.func_187227_b(VALKYRIE_READY, (Object)isReady);
    }

    public boolean isBossReady() {
        return (Boolean)this.field_70180_af.func_187225_a(VALKYRIE_READY);
    }
}

